/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.mservice.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITConstants;

public class NewSinsurTaskUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(NewSinsurTaskUpdateService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            List<Map<String, Object>> updateDataList = this.getUpdateDataList();
            this.updateSinsurTask(updateDataList);
        }
        return null;
    }

    private List<Map<String, Object>> getUpdateDataList() {
        ArrayList<Map<String, Object>> sinsurTaskParamList = new ArrayList<Map<String, Object>>(10);
        String selectSql = "select fid,fwelfarepayerid from t_hcsi_sinsurtask where fpushstatus is null or fpushstatus = '' or fpushstatus = ' '";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryUpdateSinsurTaskDataService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                HashMap<String, Long> param = new HashMap<String, Long>(2);
                Row row = dataSet.next();
                param.put("id", row.getLong("fid"));
                param.put("welfarePayerId", row.getLong("fwelfarepayerid"));
                sinsurTaskParamList.add(param);
            }
        }
        return sinsurTaskParamList;
    }

    private void updateSinsurTask(List<Map<String, Object>> updateDataList) {
        Set pushStatusSet;
        if (CollectionUtils.isEmpty(updateDataList)) {
            return;
        }
        Map<Long, Map> updateDataMap = updateDataList.stream().collect(Collectors.toMap(updateData -> (Long)updateData.get("id"), updateData -> updateData));
        StringBuilder taskIdCondition = new StringBuilder();
        taskIdCondition.append("select fsinsurtaskid,fpushstatus from t_hcsi_calperson where ");
        taskIdCondition.append("fsinsurtaskid in ");
        taskIdCondition.append(this.getPlaceHolderConditionSql(updateDataList.size()));
        List idList = updateDataList.stream().map(updateData -> (Long)updateData.get("id")).collect(Collectors.toList());
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryCalPersonDataService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)taskIdCondition.toString(), (Object[])idList.toArray());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long l = row.getLong("fsinsurtaskid");
                Map param = updateDataMap.get(l);
                pushStatusSet = (Set)param.computeIfAbsent("pushStatusSet", key -> new HashSet(4));
                String pushStatus = row.getString("fpushstatus");
                pushStatusSet.add(pushStatus);
                if (!"pushed".equals(pushStatus)) continue;
                param.put("pushCount", param.getOrDefault("pushCount", 0) + 1);
            }
        }
        String updateTaskSql = "update t_hcsi_sinsurtask set fpushstatus = ?, fpushcount = ? where fid = ?";
        ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>(updateDataList.size());
        for (Map map : updateDataList) {
            pushStatusSet = map.getOrDefault("pushStatusSet", new HashSet(0));
            Object[] updateParams = new Object[]{pushStatusSet.size() == 0 || pushStatusSet.size() == 1 && pushStatusSet.contains("notpush") ? "0" : (pushStatusSet.size() == 1 && pushStatusSet.contains("pushed") ? "2" : "1"), map.getOrDefault("pushCount", 0), map.get("id")};
            updateParamsList.add(updateParams);
        }
        HRDBUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateTaskSql, updateParamsList);
        long[] theoryIds = DB.genLongIds((String)"T_HCSI_TASKTHEORYPAYER", (int)updateDataList.size());
        long[] lArray = DB.genLongIds((String)"T_HCSI_TASKACTUALPAYER", (int)updateDataList.size());
        String theoryInsertSql = "insert into T_HCSI_TASKTHEORYPAYER(FPKID,FID,FBASEDATAID) VALUES(?,?,?)";
        String actualInsertSql = "insert into T_HCSI_TASKACTUALPAYER(FPKID,FID,FBASEDATAID) VALUES(?,?,?)";
        ArrayList<Object[]> theoryInsertParamsList = new ArrayList<Object[]>(updateDataList.size());
        ArrayList<Object[]> actualInsertParamsList = new ArrayList<Object[]>(updateDataList.size());
        int idIndex = 0;
        for (Map<String, Object> param : updateDataList) {
            Object[] theoryInsertParams = new Object[3];
            Object[] actualInsertParams = new Object[3];
            theoryInsertParams[0] = theoryIds[idIndex];
            actualInsertParams[0] = lArray[idIndex];
            Long taskId = (Long)param.get("id");
            theoryInsertParams[1] = taskId;
            actualInsertParams[1] = taskId;
            Long welfarePayerId = (Long)param.get("welfarePayerId");
            theoryInsertParams[2] = welfarePayerId;
            actualInsertParams[2] = welfarePayerId;
            theoryInsertParamsList.add(theoryInsertParams);
            actualInsertParamsList.add(actualInsertParams);
            ++idIndex;
        }
        HRDBUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)theoryInsertSql, theoryInsertParamsList);
        HRDBUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)actualInsertSql, actualInsertParamsList);
    }

    private String getPlaceHolderConditionSql(int count) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

