/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.mservice.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinSurFileNameUpdateService
implements IUpgradeService {
    private static final String fileSql = "select t1.fid,t1.fpersonid from t_hcsi_sinsurfile t1 where t1.fname = ' ' or t1.fname is null";
    private static final String personSql = "select t1.fid,t1.fname from t_hrpi_person t1 where t1.fid in (";
    private static final String updateSql = "update t_hcsi_sinsurfile set fname = ? where fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Map filePersonMap = (Map)HRDBUtil.query((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)fileSql, (Object[])new Object[0], resultSet -> {
            HashMap<Long, Long> result = new HashMap<Long, Long>(16);
            while (resultSet.next()) {
                result.put(resultSet.getLong("fid"), resultSet.getLong("fpersonid"));
            }
            return result;
        });
        if (CollectionUtils.isEmpty((Map)filePersonMap)) {
            return new UpgradeResult();
        }
        Collection personIds = filePersonMap.values();
        StringBuilder query = new StringBuilder(personSql);
        for (Long ignored : personIds) {
            query.append("?,");
        }
        query.deleteCharAt(query.length() - 1);
        query.append(')');
        Map personNameMap = (Map)HRDBUtil.query((DBRoute)new DBRoute("hr"), (String)query.toString(), (Object[])personIds.toArray(), resultSet -> {
            HashMap<Long, String> result = new HashMap<Long, String>(16);
            while (resultSet.next()) {
                result.put(resultSet.getLong("fid"), resultSet.getString("fname"));
            }
            return result;
        });
        ArrayList<Object[]> params = new ArrayList<Object[]>(filePersonMap.size());
        for (Map.Entry entry : filePersonMap.entrySet()) {
            Long fileId = (Long)entry.getKey();
            Long personId = (Long)entry.getValue();
            String name = (String)personNameMap.get(personId);
            if (SITStringUtils.isEmpty((String)name)) {
                name = " ";
            }
            params.add(new Object[]{name, fileId});
        }
        try (TXHandle tx = TX.required();){
            HRDBUtil.executeBatch((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)updateSql, params);
        }
        return new UpgradeResult();
    }
}

