/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.mservice.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITCollectionUtils;
import kd.sit.sitbp.common.util.SITDbUtil;

public class SinsurTaskOverlapDataUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SinsurTaskOverlapDataUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.deleteOverlapData("T_HCSI_TASKSINSURSTDCFG");
            this.deleteOverlapData("T_HCSI_SINSURTASKSTD");
            this.deleteOverlapData("T_HCSI_TASKTHEORYPAYER");
            this.deleteOverlapData("T_HCSI_TASKACTUALPAYER");
        }
        catch (Exception exception) {
            logger.error("\u793e\u4fdd\u8ba1\u7b97\u4efb\u52a1\u91cd\u53e0\u6570\u636e\u66f4\u65b0\u5931\u8d25", (Throwable)exception);
            result.setSuccess(false);
            result.setErrorInfo(exception.getMessage());
            result.setLog(exception.getMessage());
        }
        return result;
    }

    private void deleteOverlapData(String tableName) {
        String selectSql = "SELECT FPKID,FID,FBASEDATAID FROM " + tableName;
        HashMap<Long, Set> pkToBaseDataIdMap = new HashMap<Long, Set>(16);
        HashSet<Long> deletePkIdSet = new HashSet<Long>(16);
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryMultiDataService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long pkId = row.getLong("FPKID");
                Long id = row.getLong("FID");
                Long baseDataId = row.getLong("FBASEDATAID");
                Set baseDataIdSet = pkToBaseDataIdMap.computeIfAbsent(id, key -> new HashSet(16));
                if (baseDataIdSet.contains(baseDataId)) {
                    deletePkIdSet.add(pkId);
                    continue;
                }
                baseDataIdSet.add(baseDataId);
            }
        }
        if (CollectionUtils.isEmpty(deletePkIdSet)) {
            return;
        }
        ArrayList deletePkIdList = new ArrayList(deletePkIdSet);
        List partLists = SITCollectionUtils.splitList(deletePkIdList, (int)500);
        String deleteSql = "DELETE FROM %s where FPKID in ";
        deleteSql = String.format(Locale.ROOT, deleteSql, tableName);
        for (List partList : partLists) {
            SITDbUtil.execute((DBRoute)SITConstants.SIT_ROUTE, (String)(deleteSql + this.getPlaceHolderConditionSql(partList.size())), (Object[])partList.toArray());
        }
    }

    private String getPlaceHolderConditionSql(int count) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

