/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.mservice.update;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class SinsurTaskUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SinsurTaskUpdateService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            List<Long> sinsurTaskIdList = this.getUpdateData();
            if (CollectionUtils.isEmpty(sinsurTaskIdList)) {
                UpgradeResult upgradeResult = null;
                return upgradeResult;
            }
            List<Long> welfareTypeIdList = this.getAllChineseWelfareTypeIdList();
            if (CollectionUtils.isEmpty(welfareTypeIdList)) {
                UpgradeResult upgradeResult = null;
                return upgradeResult;
            }
            int insertCount = sinsurTaskIdList.size() * welfareTypeIdList.size();
            long[] pkIds = DB.genLongIds((String)"t_hcsi_taskwelfaretype", (int)insertCount);
            String insertSql = "insert into t_hcsi_taskwelfaretype(fpkid, fid, fbasedataid) values(?,?,?)";
            ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(insertCount);
            int idIndex = 0;
            for (Long sinsurTaskId : sinsurTaskIdList) {
                for (Long welfareTypeId : welfareTypeIdList) {
                    Object[] insertParam = new Object[]{pkIds[idIndex++], sinsurTaskId, welfareTypeId};
                    insertParamsList.add(insertParam);
                }
            }
            HRDBUtil.executeBatch((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)insertSql, insertParamsList);
        }
        return null;
    }

    private List<Long> getUpdateData() {
        ArrayList<Long> sinsurTaskIdList = new ArrayList<Long>(10);
        String selectSql = "select sst.fid from t_hcsi_sinsurtask sst where sst.fid not in (select twt.fid from t_hcsi_taskwelfaretype twt)";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryUpdateSinsurTaskDataService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                sinsurTaskIdList.add(row.getLong("fid"));
            }
        }
        return sinsurTaskIdList;
    }

    private List<Long> getAllChineseWelfareTypeIdList() {
        ArrayList<Long> welfareTypeIdList = new ArrayList<Long>(10);
        String selectSql = "select fid from t_sitbs_welfaretype where fcountryid = 1000001 and fstatus = 'C' and fenable = '1'";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryUpdateSinsurTaskDataService", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                welfareTypeIdList.add(row.getLong("fid"));
            }
        }
        return welfareTypeIdList;
    }
}

