/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.service.SinSurCalLaunchMsgHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.enums.ISocialOperationEnum;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class AbstractCalOperationList
extends AbstractListPlugin
implements SITBaseConstants,
SITEntityConstants {
    public static final String OP_LOCK_ERROR = "opLockError";
    public static final String TASK_IDS = "taskIds";
    public static final String TO_OP_TASK_IDS = "toOpTaskIds";
    public static final String IS_MUTEX_OP = "isMutexOp";

    protected Set<Enum<? extends ISocialOperationEnum>> operationMutexLockKey() {
        return new HashSet<Enum<? extends ISocialOperationEnum>>(16);
    }

    protected Set<Enum<? extends ISocialOperationEnum>> beforeOperationGetLockKey() {
        return new HashSet<Enum<? extends ISocialOperationEnum>>(16);
    }

    protected Enum<? extends ISocialOperationEnum> getISocialOperationEnum(String operateKey) {
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        String formId = ((IListView)this.getView()).getBillFormId();
        List<Long> taskIds = new ArrayList<Long>(10);
        ArrayList<String> msg = new ArrayList(10);
        Enum<? extends ISocialOperationEnum> socOperationEnum = this.getISocialOperationEnum(operateKey);
        if (this.beforeOperationGetLockKey().contains(socOperationEnum)) {
            ISocialOperationEnum operationEnum = (ISocialOperationEnum)socOperationEnum;
            Map<Object, Object> result = new HashMap(16);
            int totalNum = 0;
            if ("hcsi_calperson".equals(formId)) {
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
                taskIds.add(taskId);
                boolean isBatchOpCompleted = SocialInsuranceCalHelper.isBatchOpCompleted((OperateOption)option);
                if (!isBatchOpCompleted) {
                    result = this.addSocialTaskMutexLock(taskIds, socOperationEnum, false);
                    totalNum = 1;
                }
            } else if ("hcsi_sinsurtask".equals(formId)) {
                ListSelectedRowCollection listSelectedData = this.getSelectedRows();
                if (listSelectedData.isEmpty()) {
                    return;
                }
                taskIds = listSelectedData.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
                totalNum = taskIds.size();
                result = this.addSocialTaskMutexLock(taskIds, socOperationEnum, true);
                Iterator iterator = listSelectedData.iterator();
                HashSet<Long> idSet = new HashSet<Long>(taskIds);
                while (iterator.hasNext()) {
                    ListSelectedRow row = (ListSelectedRow)iterator.next();
                    if (idSet.contains(row.getPrimaryKeyValue())) continue;
                    iterator.remove();
                }
                formOperate.setListSelectedData(listSelectedData);
            } else {
                List curOpTaskIds = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(TO_OP_TASK_IDS));
                taskIds.addAll(curOpTaskIds);
                result = this.addSocialTaskMutexLock(taskIds, socOperationEnum, false);
                totalNum = curOpTaskIds.size();
            }
            Set entries = result.entrySet();
            msg = entries.stream().map(Map.Entry::getValue).collect(Collectors.toCollection(() -> new ArrayList(10)));
            if (CollectionUtils.isEmpty(taskIds)) {
                args.setCancel(true);
                this.showErrorMsg(msg, totalNum, 0, operationEnum.getOperationName());
            }
            option.setVariableValue(IS_MUTEX_OP, "1");
        }
        option.setVariableValue(OP_LOCK_ERROR, SerializationUtils.serializeToBase64(msg));
        option.setVariableValue(TASK_IDS, SerializationUtils.serializeToBase64(taskIds));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = args.getOperateKey();
        Enum<? extends ISocialOperationEnum> iSocialOperationEnum = this.getISocialOperationEnum(operateKey);
        if (iSocialOperationEnum == null) {
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        if (!"donothing_delete".equals(args.getOperateKey()) && this.operationMutexLockKey().contains(iSocialOperationEnum) || operationResult == null) {
            return;
        }
        ISocialOperationEnum operationEnum = (ISocialOperationEnum)iSocialOperationEnum;
        OperateOption option = formOperate.getOption();
        List taskIds = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(TASK_IDS));
        List msg = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(OP_LOCK_ERROR));
        operationResult.setSuccess(operationResult.isSuccess() && msg.isEmpty());
        List errorInfoList = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo info : errorInfoList) {
            msg.add(info.getMessage());
        }
        int successNum = operationResult.getSuccessPkIds().size();
        this.releaseSocialTaskMutexLock(taskIds, operateKey);
        if (msg.isEmpty()) {
            return;
        }
        operationResult.setShowMessage(false);
        this.showErrorMsg(msg, operationResult.getBillCount(), successNum, operationEnum.getOperationName());
    }

    protected Map<Long, String> addSocialTaskMutexLock(List<Long> taskIdList, Enum<? extends ISocialOperationEnum> iSocialOperationEnum, boolean isTaskForm) {
        String opKey = ((ISocialOperationEnum)iSocialOperationEnum).getOperationKey();
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        Iterator<Long> iterator = taskIdList.iterator();
        Map<Long, String> idNumberMap = AbstractCalOperationList.queryInsuranceTaskById(taskIdList);
        while (iterator.hasNext()) {
            Long taskId = iterator.next();
            BaseResult lockInfo = MutexServiceHelper.getMutexLockInfo((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)opKey);
            Set allLockKeys = MutexServiceHelper.getDataEntityNetCtrlOperate((String)"hcsi_sinsurtask");
            if (lockInfo.isSuccess()) {
                if (!allLockKeys.contains(((MutexLockInfo)lockInfo.getData()).getOpKey())) continue;
                String lockedOpName = this.getOperateName(((MutexLockInfo)lockInfo.getData()).getOpKey());
                String currOpName = this.getOperateName(opKey);
                String errorMessage = isTaskForm ? HCSIErrInfoEnum.CAL_TASK_LOCKED.getErrInfo(new Object[]{idNumberMap.get(taskId), lockedOpName, currOpName}) : HCSIErrInfoEnum.CAL_PERSON_TASK_LOCKED.getErrInfo(new Object[]{lockedOpName, currOpName});
                result.put(taskId, errorMessage);
                iterator.remove();
                continue;
            }
            if (!this.operationMutexLockKey().contains(iSocialOperationEnum)) continue;
            MutexServiceHelper.require((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)opKey);
        }
        return result;
    }

    protected boolean releaseSocialTaskMutexLock(List<Long> taskIdList, String opKey) {
        boolean isRelease = true;
        for (Long taskId : taskIdList) {
            BaseResult baseResult = MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)opKey);
            isRelease = baseResult.isSuccess() && isRelease;
        }
        return isRelease;
    }

    private void showErrorMsg(List<String> msg, int totalNum, int successNum, String opName) {
        if (totalNum == 1 && msg.size() == 1) {
            this.getView().showErrorNotification(msg.get(0));
            return;
        }
        String format = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c{1}\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"AbstractCalOperationList_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String title = MessageFormat.format(format, totalNum, opName, successNum, totalNum - successNum);
        this.getView().showForm(SITShowFormServiceHelper.getOperationResultParameter((String)opName, (String)title, msg));
    }

    private static Map<Long, String> queryInsuranceTaskById(List<Long> taskIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurtask");
        QFilter filter = new QFilter("id", "in", taskIdList);
        DynamicObjectCollection collection = helper.queryOriginalCollection("id,number", new QFilter[]{filter});
        return collection.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("number")));
    }

    protected void recordSuccessfulOpLog(SocialOperationEnum opEnum) {
        SITLogServiceHelper.addLog((String)"hcsi", (String)((IListView)this.getView()).getBillFormId(), (String)opEnum.getOperationName(), (String)HCSIErrInfoEnum.COMMON_OPERATE_SUCCESSFULLY.getErrInfo(new Object[]{opEnum.getOperationName()}));
    }

    protected void recordFailedOpLog(SocialOperationEnum opEnum) {
        SITLogServiceHelper.addLog((String)"hcsi", (String)((IListView)this.getView()).getBillFormId(), (String)opEnum.getOperationName(), (String)HCSIErrInfoEnum.COMMON_OPERATE_FAILED.getErrInfo(new Object[]{opEnum.getOperationName()}));
    }

    protected void initWaitCheckPageCache(String cacheUUID, int totalCount) {
        IHRAppCache appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
        appCache.put("totalCount", (Object)totalCount);
        appCache.put("successCount", (Object)0);
        appCache.put("failCount", (Object)0);
        appCache.put("hasCheckCert", (Object)Boolean.FALSE);
        appCache.put("pageId", (Object)this.getView().getPageId());
    }

    protected void openCalCheckWaitPage(String cacheUUID) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_calcheckwait");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcsi_calcheckwait"));
        showParameter.setCustomParam("cacheUUID", (Object)cacheUUID);
        this.getView().showForm(showParameter);
    }

    protected void showMessageAndCalProgress(String cacheUUID) {
        IHRAppCache appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
        Boolean isCheckCertFail = (Boolean)appCache.get("isCheckCertFail", Boolean.class);
        String calType = (String)appCache.get("calType", String.class);
        boolean isAdd = "2".equals(calType);
        this.showCheckCertInfo(appCache);
        if (Boolean.TRUE.equals(isCheckCertFail)) {
            return;
        }
        List calTaskIdList = (List)appCache.get("calTaskIdList", List.class);
        if (CollectionUtils.isEmpty((Collection)calTaskIdList)) {
            String entityNumber = "hcsi_sinsurtask";
            String opKey = "donothing_updatecal";
            if ("2".equals(calType)) {
                opKey = "donothing_launchcal";
            } else if ("5".equals(calType)) {
                entityNumber = "hcsi_calperson";
                opKey = SocialOperationEnum.OP_CAL_PERSON_RECAL.getOperationKey();
            }
            String operateName = MutexServiceHelper.getOperateName((String)entityNumber, (String)opKey);
            new SinSurCalLaunchMsgHelper().showMessage(cacheUUID, operateName, operateName, this.getView());
            return;
        }
        FormShowParameter formShowParameter = SocialInsuranceCalHelper.getLoadingCalProgressForm((String)cacheUUID, (boolean)isAdd);
        this.getView().showForm(formShowParameter);
    }

    private void showCheckCertInfo(IHRAppCache appCache) {
        Map resultMap = (Map)appCache.get("resultMap", Map.class);
        if (resultMap == null) {
            return;
        }
        String showMessageType = (String)resultMap.get("showMessageType");
        List messageList = (List)resultMap.get("messageList");
        if (CollectionUtils.isEmpty((Collection)messageList)) {
            return;
        }
        if (messageList.size() > 1) {
            FormShowParameter parameters = SITShowFormServiceHelper.getOperationResultParameter((String)HCSIErrInfoEnum.LAUNCH_CAL.getErrInfo(), (String)"", (List)messageList);
            this.getView().showForm(parameters);
        } else if ("1".equals(showMessageType)) {
            this.getView().showErrorNotification((String)messageList.get(0));
        } else {
            this.getView().showTipNotification((String)messageList.get(0));
        }
    }

    protected String getOperateName(String opKey) {
        return MutexServiceHelper.getOperateName((String)"hcsi_sinsurtask", (String)opKey);
    }
}

