/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalCheckThread;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.common.vo.LaunchCalculateVo;
import kd.sit.sitbp.business.datachanged.BizChangedHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class LaunchCalculatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String KEY_SINSURPERIOD = "sinsurperiod";
    private static final String KEY_WELFAREPAYER = "welfarepayer";
    private static final String OP_START_CAL = "donothing_startcal";
    private static final String CALLBACKID_CONTINUE_CLOSE = "cotinue_close";

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        long currUserId = RequestContext.get().getCurrUserId();
        String lastSelection = UserConfigServiceHelper.getSetting((long)currUserId, (String)"LaunchCalculatePluginLastSelection");
        if (StringUtils.isEmpty((String)lastSelection)) {
            List welfareTypeIdList = SocialInsuranceCalHelper.getAllChineseWelfareTypeIdList();
            this.setMultiPropValues("welfaretype", welfareTypeIdList);
        } else {
            LaunchCalculateVo launchCalculateVo = (LaunchCalculateVo)SerializationUtils.fromJsonString((String)lastSelection, LaunchCalculateVo.class);
            long periodId = launchCalculateVo.getPeriodId();
            if (periodId != 0L) {
                this.getModel().setValue(KEY_SINSURPERIOD, (Object)periodId);
            }
            List welfareTypeIdList = SocialInsuranceCalHelper.getChineseWelfareTypeIdList((Collection)launchCalculateVo.getWelfareTypes());
            this.setMultiPropValues("welfaretype", welfareTypeIdList);
            Set welfarePayers = launchCalculateVo.getWelfarePayers();
            if (!CollectionUtils.isEmpty((Collection)welfarePayers)) {
                QFilter filter = SocialInsuranceCalHelper.welfarePayerDataAuthFilter((String)"hcsi_sinsurtask");
                filter.and(new QFilter("id", "in", (Object)welfarePayers));
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
                Object[] payers = serviceHelper.queryOriginalArray("id", new QFilter[]{filter});
                if (!ArrayUtils.isEmpty((Object[])payers)) {
                    this.setMultiPropValues(KEY_WELFAREPAYER, Arrays.stream(payers).map(ele -> ele.getLong("id")).collect(Collectors.toList()));
                }
            }
        }
        this.getModel().updateCache();
    }

    private void setMultiPropValues(String propName, Collection<Long> propValues) {
        if (!CollectionUtils.isEmpty(propValues)) {
            DynamicObjectCollection welfareType = this.getModel().getDataEntity().getDynamicObjectCollection(propName);
            for (Long welfareTypeId : propValues) {
                welfareType.addNew().set("fbasedataid_id", (Object)welfareTypeId);
            }
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Button btnOk = (Button)this.getControl(BTN_OK);
        btnOk.addClickListener((ClickListener)this);
        Button btnCancel = (Button)this.getControl(BTN_CANCEL);
        btnCancel.addClickListener((ClickListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl(KEY_SINSURPERIOD);
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit welfarePayperEdit = (MulBasedataEdit)this.getControl(KEY_WELFAREPAYER);
        welfarePayperEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "sinsurperiod": {
                QFilter qFilter = new QFilter("periodtype", "=", (Object)1010L);
                param.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "welfarepayer": {
                SocialInsuranceCalHelper.setWelfarePayerF7Filter((ListShowParameter)param, (String)"hcsi_sinsurtask");
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btncancel": {
                String changeDesc;
                IDataModel dataModel = this.getModel();
                String string = changeDesc = dataModel.getDataChanged() ? dataModel.getChangeDesc() : null;
                if (SITStringUtils.isNotEmpty((String)changeDesc)) {
                    BizChangedHelper.showConfirm((AbstractFormPlugin)this, (String)changeDesc, (String)CALLBACKID_CONTINUE_CLOSE, null);
                    evt.setCancel(true);
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_OK.equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject periodDy = dataEntity.getDynamicObject(KEY_SINSURPERIOD);
            DynamicObjectCollection dyColl = dataEntity.getDynamicObjectCollection(KEY_WELFAREPAYER);
            if (HRObjectUtils.isEmpty((Object)periodDy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u793e\u4fdd\u671f\u95f4\u201d\u3002", (String)"LaunchCalculatePlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                return;
            }
            if (CollectionUtils.isEmpty((Collection)dyColl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u201d\u3002", (String)"LaunchCalculatePlugin_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation(OP_START_CAL);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_startcal": {
                Boolean setCancel = Boolean.FALSE;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject periodDy = dataEntity.getDynamicObject(KEY_SINSURPERIOD);
                DynamicObjectCollection dyColl = dataEntity.getDynamicObjectCollection(KEY_WELFAREPAYER);
                if (HRObjectUtils.isEmpty((Object)periodDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u793e\u4fdd\u671f\u95f4\u201d\u3002", (String)"LaunchCalculatePlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    setCancel = Boolean.TRUE;
                }
                if (CollectionUtils.isEmpty((Collection)dyColl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u201d\u3002", (String)"LaunchCalculatePlugin_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    setCancel = Boolean.TRUE;
                }
                if (!setCancel.booleanValue() && !SITPermissionServiceHelper.hasPerm((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)"2M770AGHBQTT")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u793e\u4fdd\u8ba1\u7b97\u201d\u53d1\u8d77\u8ba1\u7b97\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"LaunchCalculatePlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    setCancel = Boolean.TRUE;
                }
                if (setCancel.booleanValue()) {
                    args.setCancel(true);
                    return;
                }
                String cacheUUID = UUID.randomUUID().toString();
                long periodId = periodDy.getLong("id");
                List selectedInsuredCompanyIds = dyColl.stream().map(dyObj -> dyObj.getLong("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection welfareTypes = (DynamicObjectCollection)this.getModel().getValue("welfaretype");
                Set welfareTypeIdSet = welfareTypes.stream().map(welfareType -> welfareType.getLong("fbasedataid_id")).collect(Collectors.toSet());
                this.initCache(cacheUUID, selectedInsuredCompanyIds.size());
                ThreadPools.executeOnce((String)"sit-socialinsurancecalcheck", (Runnable)new SocialInsuranceCalCheckThread(cacheUUID, Long.valueOf(periodId), new HashSet(selectedInsuredCompanyIds), welfareTypeIdSet));
                HashMap<String, String> returnData = new HashMap<String, String>(1);
                returnData.put("cacheUUID", cacheUUID);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && CALLBACKID_CONTINUE_CLOSE.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
    }

    private void initCache(String cacheUUID, int totalCount) {
        IHRAppCache appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
        appCache.put("totalCount", (Object)totalCount);
        appCache.put("successCount", (Object)0);
        appCache.put("failCount", (Object)0);
        appCache.put("hasCheckCert", (Object)Boolean.FALSE);
        if (this.getView() != null && this.getView().getParentView() != null) {
            appCache.put("pageId", (Object)this.getView().getParentView().getPageId());
        }
    }
}

