/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.sit.hcsi.business.cal.service.SinSurCalLaunchMsgHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.entity.social.CalTaskProgressInfoDTO;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang.StringUtils;

public class LoadingCalculationPlugin
extends AbstractBasePlugIn
implements ProgresssListener {
    private static final String KEY_WELFAREPAYER_LABEL = "welfarepayerlabel";
    private static final String WAIT = "wait";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String KEY_PANEL_FINISH = "panelfinish";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";
    private static final String KEY_PROGRESSBARAP = "progressbarap";
    private static final String WIDTH = "960px";
    private static final String HEIGHT = "580px";
    private static final String BILL_FORM_ID = "hcsi_sinsurgendetailf7";
    private static final String BILL_LIST_F7 = "hcsi_sinsurgendetaillist";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String KEY_PANEL_HANDLING = "panelhandling";
    private static final String KEY_TIMELABEL = "timelabel";
    private static final String KEY_RECORDID = "recordId";
    private static final String KEY_CAL_TASK_PROGRESS = "CalTaskProgress_%s";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
        Button btnViewLaunchFail = (Button)this.getControl("btn_viewlaunchfail");
        btnViewLaunchFail.addClickListener((ClickListener)this);
        Button btnViewCalFail = (Button)this.getControl("btn_viewcalfail");
        btnViewCalFail.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PANEL_FINISH, BTN_CANCEL, "btn_viewlaunchfail", "btn_viewcalfail"});
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        CalTaskProgressInfoDTO calTaskProgressInfoDTO = this.getCalTaskProgressInfoDTO();
        this.setFormInfo(calTaskProgressInfoDTO, null);
    }

    public void afterBindData(EventObject event) {
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
            progressBar.setPercent(100);
            CalTaskProgressInfoDTO calTaskProgressInfoDTO = this.getCalTaskProgressInfoDTO();
            int fail = 0;
            if (calTaskProgressInfoDTO != null) {
                fail = calTaskProgressInfoDTO.getFail();
            }
            this.setFormInfo(calTaskProgressInfoDTO, null);
            this.setStopProgressFormInfo(fail);
            return;
        }
        this.startTask();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SITStringUtils.equals((String)progressKey, (String)KEY_PROGRESSBARAP)) {
            CalTaskProgressInfoDTO calTaskProgressInfoDTO = this.getCalTaskProgressInfoDTO();
            this.setFormInfo(calTaskProgressInfoDTO, progressEvent);
        }
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        switch (itemKey = itemControl.getKey()) {
            case "btn_viewcalfail": {
                ISITAppCache appCache = this.getAppCacheByRecordId();
                List reportIds = (List)appCache.get("reportIds", List.class);
                QFilter qFilter = new QFilter("sinsurgenrecord", "in", (Object)reportIds);
                ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)BILL_FORM_ID, (boolean)true);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setBillFormId(BILL_FORM_ID);
                formShowParameter.setFormId(BILL_LIST_F7);
                StyleCss css = new StyleCss();
                css.setWidth(WIDTH);
                css.setHeight(HEIGHT);
                formShowParameter.getOpenStyle().setInlineStyleCss(css);
                formShowParameter.setShowTitle(false);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5931\u8d25\u8be6\u60c5", (String)"LoadingCalculationPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                formShowParameter.setHasRight(true);
                formShowParameter.setLookUp(true);
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                formShowParameter.getListFilterParameter().setOrderBy("sinsurgenrecord asc");
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "btn_viewlaunchfail": {
                IHRAppCache taskAppCache = HRAppCache.get((String)("socialCalParam_" + this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID)));
                String recordId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID);
                String operateName = "2".equals(this.getAppCacheByRecordId().get("calType", String.class)) ? HCSIErrInfoEnum.LAUNCH_CAL.getErrInfo() : HCSIErrInfoEnum.UPDATE_PERSON_AND_CAL.getErrInfo();
                String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"LoadingCalculationPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                title = MessageFormat.format(title, taskAppCache.get("totalTaskCount", Integer.class), taskAppCache.get("successTaskCount", Integer.class), taskAppCache.get("failTaskCount", Integer.class));
                new SinSurCalLaunchMsgHelper().showMessage(recordId, operateName, title, this.getView());
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        CalTaskProgressInfoDTO calTaskProgressInfo = this.getCalTaskProgressInfoDTO();
        if (calTaskProgressInfo != null) {
            int status = calTaskProgressInfo.getStatus();
            String floatingTaskId = (String)this.getAppCacheByRecordId().get("floatingTaskId", String.class);
            if (StringUtils.isEmpty((String)floatingTaskId)) {
                return;
            }
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getView().getMainView(), floatingTaskId);
            Boolean isBackground = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBackground");
            if (status != 2) {
                if (isBackground == null) {
                    HRBackgroundTaskHelper.getInstance().showBaskgroundTask(floatingTaskId);
                }
            } else {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "COMPLETED");
                this.getAppCacheByRecordId().clear();
            }
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private CalTaskProgressInfoDTO getCalTaskProgressInfoDTO() {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID);
        ISITAppCache appCache = SITAppCache.get((String)recordId);
        return (CalTaskProgressInfoDTO)appCache.get(String.format(Locale.ROOT, KEY_CAL_TASK_PROGRESS, recordId), CalTaskProgressInfoDTO.class);
    }

    private ISITAppCache getAppCacheByRecordId() {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID);
        ISITAppCache appCache = SITAppCache.get((String)recordId);
        return appCache;
    }

    private void stopProgress(int fail, ProgressEvent progressEvent) {
        this.setStopProgressFormInfo(fail);
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
        this.updateParentView();
    }

    private void setStopProgressFormInfo(int fail) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_PANEL_HANDLING});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, KEY_PANEL_FINISH});
        if (fail > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_viewcalfail"});
        }
        if (new SinSurCalLaunchMsgHelper().hasMessage((String)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_viewlaunchfail"});
        }
        ISITAppCache appCache = SITAppCache.get((String)KEY_RECORDID);
        appCache.put("isFinish", (Object)"true");
    }

    private void setFormInfo(CalTaskProgressInfoDTO progressInfoDTO, ProgressEvent progressEvent) {
        int total = 0;
        int success = 0;
        int fail = 0;
        int status = 2;
        Date startTime = new Date();
        Date endTime = new Date();
        int welfareSize = 0;
        if (progressInfoDTO != null) {
            status = progressInfoDTO.getStatus();
            total = progressInfoDTO.getTotal();
            success = progressInfoDTO.getSuccess();
            fail = progressInfoDTO.getFail();
            startTime = progressInfoDTO.getStartTime();
            endTime = progressInfoDTO.getEndTime();
            welfareSize = progressInfoDTO.getTaskNum();
        } else if (progressEvent != null) {
            this.stopProgress(0, progressEvent);
        }
        int finish = success + fail;
        int wait = total - finish;
        if (wait < 0) {
            wait = 0;
        }
        Label labelWelfarePayer = (Label)this.getControl(KEY_WELFAREPAYER_LABEL);
        labelWelfarePayer.setText(String.valueOf(welfareSize));
        Label labelWait = (Label)this.getView().getControl(WAIT);
        labelWait.setText(String.valueOf(wait));
        Label labelSuccess = (Label)this.getView().getControl(SUCCESS);
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl(FAIL);
        labelFail.setText(String.valueOf(fail));
        Label labelTime = (Label)this.getView().getControl(KEY_TIMELABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SITDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u8017\u65f6{0}", (String)"LoadingCalculationPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), consumeTime);
        labelTime.setText(msg);
        int percentage = 0;
        Label labelPercentage = (Label)this.getView().getControl(PROGRESS_NUM_LABEL);
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            labelPercentage.setText("100");
            this.updateParentView();
            return;
        }
        if (status == 0) {
            labelPercentage.setText(String.valueOf(percentage));
            return;
        }
        if (status == 2 || total == finish) {
            percentage = 100;
            if (progressEvent != null) {
                this.stopProgress(fail, progressEvent);
            }
            labelPercentage.setText(String.valueOf(percentage));
        } else if (total > 0) {
            percentage = new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
            labelPercentage.setText(String.valueOf(percentage));
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        }
    }

    private void updateParentView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }
}

