/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.adjust.dynamic;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.hcsi.business.caladjust.constants.AdjustDataConstants;
import kd.sit.hcsi.business.caladjust.dto.AdjustDataDTO;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.helper.AdjustDataHelper;
import kd.sit.hcsi.business.caladjust.service.AdjustDataService;
import kd.sit.sitbp.business.servicehelper.SITMultithreadedQueryHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.SInsuranceInfoEnum;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SocInsuranceAdjustDataPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log logger = LogFactory.getLog(SocInsuranceAdjustDataPlugin.class);
    private static final String CLEAR_OP = "clear";
    private static final String ADD_OP = "donothing_add";
    private static final String IS_CREATE_DATA_FIRST = "is_create_data_first";
    private static final String SAVE_OP = "donothing_save";
    private static final String CLOSE_OP = "donothing_close";
    private static final String KEY_SEARCH = "searchap";
    public static final String OP_MUTEX_KEY = "only_one_operate";

    public void beforeBindData(EventObject event) {
        AdjustDataDTO adjustDataDTO = this.getAdjustDataDTOFromCustomParams();
        if (adjustDataDTO == null) {
            return;
        }
        AdjustDataDTO.updateInstance((AdjustDataDTO)adjustDataDTO);
        IFormView parentView = this.getView().getParentView();
        LinkedHashSet calPersonIdLinkedSet = adjustDataDTO.getSearchedCalPersonIdLinkedSet();
        Map itemAdjustDataMap = AdjustDataHelper.queryItemAdjustData((LinkedHashSet)calPersonIdLinkedSet, (Long)adjustDataDTO.getCalTaskId(), (String)parentView.getPageId());
        HashBasedTable personTable = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
        Table calPersonIdAndItemAndSrcTable = adjustDataDTO.getCalPersonIdAndItemAndSrcTable();
        for (Map.Entry entry : personTable.columnMap().entrySet()) {
            String itemIdStr = (String)entry.getKey();
            if (itemIdStr.contains("roundtype") || AdjustDataConstants.FIXED_COLUMN_SET.contains(itemIdStr) || SITStringUtils.equals((String)itemIdStr, (String)"validItemIdList")) continue;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                BigDecimal itemValue;
                entry2.setValue(0);
                Long personId = (Long)entry2.getKey();
                Map personItemValueMap = (Map)itemAdjustDataMap.get(personId);
                if (personItemValueMap == null || personItemValueMap.size() == 0 || (itemValue = (BigDecimal)personItemValueMap.get(Long.parseLong(itemIdStr))) == null) continue;
                entry2.setValue(itemValue);
                calPersonIdAndItemAndSrcTable.put((Object)personId, (Object)itemIdStr, (Object)Boolean.FALSE);
            }
        }
        AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)this.getView().getPageId());
        this.openTmpView();
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            AdjustDataDTO adjustDataDTO;
            String searchText = evt.getText();
            if (StringUtils.equals((CharSequence)searchText, (CharSequence)(adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)this.getView().getPageId())).getSearchText())) {
                return;
            }
            if (this.checkOpLocked()) {
                return;
            }
            adjustDataDTO.setSearchText(searchText);
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                DynamicObject[] calPersonDyArr;
                HashBasedTable calPersonIdAndDetailInfoBasedTable = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
                List calPersonIds = calPersonIdAndDetailInfoBasedTable.rowKeySet().stream().map(pkIdObj -> (Long)pkIdObj).collect(Collectors.toList());
                QFilter filter = new QFilter("filenumberdb", "match", (Object)searchText);
                filter.or("namedb", "match", (Object)searchText);
                filter.or("empnumberdb", "match", (Object)searchText);
                try {
                    calPersonDyArr = SITMultithreadedQueryHelper.getInstance().getData("hcsi_calperson", "id", calPersonIds, filter, "id desc");
                }
                catch (InterruptedException e) {
                    logger.error("SocInsuranceAdjustDataPlugin.search, error info: ", (Throwable)e);
                    calPersonDyArr = new DynamicObject[]{};
                }
                LinkedHashSet<Long> searchedCalPersonIdLinkedSet = new LinkedHashSet<Long>(16);
                for (DynamicObject calPersonDy : calPersonDyArr) {
                    searchedCalPersonIdLinkedSet.add(calPersonDy.getLong("id"));
                }
                adjustDataDTO.setSearchedCalPersonIdLinkedSet(searchedCalPersonIdLinkedSet);
            } else if (StringUtils.isBlank((CharSequence)searchText)) {
                adjustDataDTO.setSearchedCalPersonIdLinkedSet(null);
            }
            AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)this.getView().getPageId());
            this.openTmpView();
            this.clearOpLock();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (this.checkOpLocked()) {
            args.setCancel(true);
            return;
        }
        switch (formOperate.getOperateKey()) {
            case "clear": {
                this.showClearAdjustDataConfirm();
                this.clearOpLock();
                args.setCancel(true);
                break;
            }
            case "deleteentry": 
            case "donothing_add": {
                this.operateSubPage(formOperate.getOperateKey());
                this.clearOpLock();
                break;
            }
            case "donothing_save": {
                HashBasedTable preCalPersonIdAndDetailInfoBasedTable;
                if (!SITPermissionServiceHelper.hasPerm((String)"hcsi", (String)"hcsi_calperson", (String)"4715a0df000000ac")) {
                    this.getView().showErrorNotification(HCSIErrInfoEnum.ADJUST_DATA_WITHOUT_MODIFY_PERMISSION.getErrInfo());
                    args.setCancel(true);
                    this.clearOpLock();
                    return;
                }
                if (SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
                    args.setCancel(true);
                    this.clearOpLock();
                    return;
                }
                AdjustDataDTO currAdjustDataDTO = AdjustDataService.getAdjustDataDTOFromCache((String)this.getView().getPageId());
                Long calTaskId = currAdjustDataDTO.getCalTaskId();
                HashBasedTable currPersonIdAndDetailInfoBasedTable = currAdjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
                LinkedHashSet calPersonIdLinkedSet = currAdjustDataDTO.getSearchedCalPersonIdLinkedSet();
                ArrayList totalPersonIdList = new ArrayList(10);
                for (Object personId : calPersonIdLinkedSet) {
                    totalPersonIdList.add(personId);
                }
                AdjustDataDTO adjustDataDTOFromCustomParams = AdjustDataService.getAdjustDataDTOByCalPerson(totalPersonIdList, (Long)calTaskId, (boolean)false);
                if (currPersonIdAndDetailInfoBasedTable.isEmpty() || calTaskId == null || adjustDataDTOFromCustomParams == null || (preCalPersonIdAndDetailInfoBasedTable = adjustDataDTOFromCustomParams.getCalPersonIdAndDetailInfoBasedTable()).isEmpty()) break;
                for (String fixedColumn : AdjustDataConstants.FIXED_COLUMN_SET) {
                    if (SITStringUtils.equals((String)"memo", (String)fixedColumn)) continue;
                    currPersonIdAndDetailInfoBasedTable.columnMap().remove(fixedColumn);
                }
                Table calPersonIdAndItemAndSrcTable = adjustDataDTOFromCustomParams.getCalPersonIdAndItemAndSrcTable();
                Iterator iterator = currPersonIdAndDetailInfoBasedTable.cellSet().iterator();
                while (iterator.hasNext()) {
                    Table.Cell cell = (Table.Cell)iterator.next();
                    String columnKey = (String)cell.getColumnKey();
                    if (SITStringUtils.equals((String)"validItemIdList", (String)columnKey) || SITStringUtils.equals((String)"waitDeleteItemIdList", (String)columnKey) || SITStringUtils.equals((String)"memo", (String)columnKey)) continue;
                    if (String.valueOf(columnKey).contains("roundtype")) {
                        iterator.remove();
                        continue;
                    }
                    boolean isNull = Integer.valueOf(0).equals(cell.getValue());
                    Object preValue = preCalPersonIdAndDetailInfoBasedTable.get(cell.getRowKey(), (Object)columnKey);
                    if (preValue == null) {
                        if (!isNull) continue;
                        iterator.remove();
                        continue;
                    }
                    if (isNull && !Boolean.FALSE.equals(calPersonIdAndItemAndSrcTable.get(cell.getRowKey(), (Object)columnKey))) {
                        iterator.remove();
                        continue;
                    }
                    BigDecimal preBigDecVal = preValue instanceof Integer ? new BigDecimal(String.valueOf(preValue)) : (BigDecimal)preValue;
                    boolean valIsSame = new BigDecimal(String.valueOf(cell.getValue())).compareTo(preBigDecVal) == 0;
                    if (!valIsSame) continue;
                    iterator.remove();
                }
                logger.info("SocInsuranceAdjustDataPlugin.beforeDoOperation: begin to save data.");
                AdjustDataService.saveAdjustData((Long)calTaskId, (Table)currPersonIdAndDetailInfoBasedTable, (Table)preCalPersonIdAndDetailInfoBasedTable);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SocInsuranceAdjustDataPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                break;
            }
            case "donothing_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (callBackId.equals(SInsuranceInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode())) {
            this.getView().close();
        } else if (SITStringUtils.equals((String)CLEAR_OP, (String)callBackId)) {
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.operateSubPage(callBackId);
            } else {
                this.clearOpLock();
            }
        }
    }

    public void pageRelease(EventObject event) {
        IFormView childView = this.getChildView();
        if (childView != null) {
            childView.close();
        }
        AdjustDataService.clearCache((String)this.getView().getPageId());
    }

    private List<Object> getExistPersonIdList() {
        IPageCache pageCache = this.getView().getPageCache();
        String existPersonIdListStr = pageCache.get("existPersonIdList");
        if (SITStringUtils.isEmpty((String)existPersonIdListStr)) {
            List personIdList = (List)this.getView().getFormShowParameter().getCustomParam("personIdList");
            return personIdList;
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)existPersonIdListStr);
    }

    private void showClearAdjustDataConfirm() {
        IFormView childView = this.getChildView();
        if (childView == null) {
            return;
        }
        int[] currRowIndexArr = ((IClientViewProxy)childView.getService(IClientViewProxy.class)).getEntryState("entryentity").getSelectedRows();
        if (currRowIndexArr == null || currRowIndexArr.length == 0) {
            this.getView().showTipNotification(HCSIErrInfoEnum.CLEAR_ADJUST_DATA.getErrInfo());
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLEAR_OP, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u8c03\u6574\u6570\u636e\u540e\uff0c\u5bf9\u5e94\u7684\u9669\u79cd\u9879\u76ee\u7ed3\u679c\u5c06\u7f6e\u4e3a\u7a7a\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8c03\u6574\u6570\u636e\u5417\uff1f", (String)"SocInsuranceAdjustDataPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, options, ConfirmTypes.Default, confirmCallBacks);
    }

    private AdjustDataDTO getAdjustDataDTOFromCustomParams() {
        AdjustDataDTO adjustDataDTO;
        String adjustDataDTOStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams) || SITStringUtils.isEmpty((String)(adjustDataDTOStr = (String)customParams.get("hcsi_sinsurresultadj" + this.getView().getFormShowParameter().getParentPageId()))) || (adjustDataDTO = (AdjustDataDTO)SerializationUtils.deSerializeFromBase64((String)adjustDataDTOStr)) == null) {
            return null;
        }
        return adjustDataDTO;
    }

    private void openTmpView() {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setStatus(this.getView().getFormShowParameter().getStatus());
        OpenStyle openStyle = formShow.getOpenStyle();
        openStyle.setTargetKey("entitypanel");
        openStyle.setShowType(ShowType.InContainer);
        formShow.setFormId("hcsi_sinsurresultadjtmp");
        formShow.setParentPageId(this.getView().getPageId());
        formShow.setCustomParam("personIdList", this.getExistPersonIdList());
        String pageId = this.getView().getPageId();
        IFormView childView = this.getChildView();
        if (childView != null) {
            childView.close();
        }
        this.getPageCache().put(pageId, formShow.getPageId());
        this.getView().showForm(formShow);
    }

    private void operateSubPage(String opKey) {
        IFormView childView = this.getChildView();
        if (opKey == null || childView == null) {
            return;
        }
        childView.invokeOperation(opKey);
        this.getView().sendFormAction(childView);
    }

    private IFormView getChildView() {
        String pageId = this.getView().getPageId();
        String subPageId = this.getPageCache().get(pageId);
        if (subPageId != null) {
            return this.getView().getView(subPageId);
        }
        return null;
    }

    private boolean checkOpLocked() {
        if (Boolean.TRUE.toString().equals(this.getPageCache().get(OP_MUTEX_KEY))) {
            return true;
        }
        this.getPageCache().put(OP_MUTEX_KEY, Boolean.TRUE.toString());
        return false;
    }

    private void clearOpLock() {
        this.getPageCache().remove(OP_MUTEX_KEY);
    }
}

