/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.adjust.dynamic;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.Features;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.constants.AdjustDataConstants;
import kd.sit.hcsi.business.caladjust.dto.AdjustDataDTO;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.service.AdjustDataService;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.sitbp.business.dynamic.ContainerFactory;
import kd.sit.sitbp.business.dynamic.DynamicEntry;
import kd.sit.sitbp.business.dynamic.grid.DecimalFieldParamContainer;
import kd.sit.sitbp.business.dynamic.grid.EntryParamContainer;
import kd.sit.sitbp.business.dynamic.grid.EntryParamContainerBaseHelper;
import kd.sit.sitbp.business.dynamic.grid.TextFieldParamContainer;
import kd.sit.sitbp.common.enums.TruncationEnum;
import kd.sit.sitbp.common.util.SITGridUtils;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SocInsuranceAdjustDataTmpPlugin
extends AbstractFormPlugin
implements Consumer<BeforeF7ViewDetailEvent> {
    private static final Log LOGGER = LogFactory.getLog(SocInsuranceAdjustDataTmpPlugin.class);
    private static final Pattern PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");
    private static final String CLEAR_OP = "clear";
    private static final String ADD_OP = "donothing_add";
    private static final String ADD_PERSON_CALLBACK = "add_person_callback";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        this.initEntryGrid();
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("hcsi_sinsurfile");
        currency.addBeforeF7ViewDetailListener((Consumer)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metaArgs) {
        super.loadCustomControlMetas(metaArgs);
        FormShowParameter formShow = (FormShowParameter)metaArgs.getSource();
        EntryAp dynamicEntryAp = this.initEntryAp(formShow);
        if (dynamicEntryAp == null) {
            return;
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)dynamicEntryAp.createControl().get("columns"));
        metaArgs.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.toString()), new Object[0]);
        }
        EntityType entityType = (EntityType)newMainType.getAllEntities().get("entryentity");
        this.registerDynamicProps(entityType);
        args.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs args) {
        EntryGrid entryGrid;
        String key = args.getKey();
        if (HRStringUtils.equals((String)key, (String)"entryentity") && (entryGrid = this.createEntryControl()) != null) {
            args.setControl((Control)entryGrid);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShow = this.getView().getFormShowParameter();
        AdjustDataDTO adjustDataDTO = this.getAdjustDataDTO(formShow);
        if (adjustDataDTO == null) {
            return;
        }
        this.loadEntryData(adjustDataDTO);
        List personIdList = (List)formShow.getCustomParam("personIdList");
        this.cacheExistPersonIdList(personIdList);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        AdjustDataDTO adjustDataDTO;
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (HRArrayUtils.isNotEmpty((Object[])args.getChangeSet()) && (PATTERN.matcher(key).matches() || SITStringUtils.equals((String)"memo", (String)key)) && (adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)parentPageId)) != null) {
            adjustDataDTO = AdjustDataDTO.updateInstance((AdjustDataDTO)adjustDataDTO);
            HashBasedTable calPersonIdAndDetailInfoBasedTable = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
            LinkedHashMap itemInfoMap = adjustDataDTO.getDynamicFieldIdAndAttrMap();
            int currFocusRowIndex = args.getChangeSet()[0].getRowIndex();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Object selectPkValue = ((DynamicObject)entryEntity.get(currFocusRowIndex)).getPkValue();
            if (SITStringUtils.equals((String)"memo", (String)key)) {
                String memo = (String)args.getChangeSet()[0].getNewValue();
                if (SITStringUtils.isEmpty((String)memo)) {
                    memo = "";
                }
                calPersonIdAndDetailInfoBasedTable.put(selectPkValue, (Object)key, (Object)memo);
                AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)parentPageId);
            } else {
                BigDecimal currItemVal = (BigDecimal)args.getChangeSet()[0].getNewValue();
                Object roundStd = calPersonIdAndDetailInfoBasedTable.get(selectPkValue, (Object)(key + "roundtype" + "_1"));
                Object roundItem = calPersonIdAndDetailInfoBasedTable.get(selectPkValue, (Object)(key + "roundtype" + "_2"));
                Map itemMap = (Map)itemInfoMap.get(key);
                int scale = (Integer)itemMap.get("scale");
                LOGGER.info("SocInsuranceAdjustDataTmpPlugin.propertyChanged, itemId:{},round:{},scale:{}", new Object[]{key, roundStd, scale});
                BigDecimal bigDecimalValue = currItemVal != null ? (roundStd != null ? TruncationEnum.getBigDecimalValue((BigDecimal)currItemVal, (String)(roundStd + "")) : (roundItem != null ? currItemVal.setScale(scale, (Integer)roundItem) : currItemVal)) : currItemVal;
                this.getModel().beginInit();
                this.getModel().setValue(key, (Object)bigDecimalValue, currFocusRowIndex);
                this.getModel().endInit();
                if (selectPkValue != null) {
                    if (bigDecimalValue != null) {
                        calPersonIdAndDetailInfoBasedTable.put(selectPkValue, (Object)key, (Object)bigDecimalValue);
                    } else {
                        boolean isFromAdjustData = Boolean.FALSE.equals(adjustDataDTO.getCalPersonIdAndItemAndSrcTable().get(selectPkValue, (Object)key));
                        if (isFromAdjustData) {
                            ArrayList<String> waitDeleteItemIdList = (ArrayList<String>)calPersonIdAndDetailInfoBasedTable.get(selectPkValue, (Object)"waitDeleteItemIdList");
                            if (waitDeleteItemIdList == null) {
                                waitDeleteItemIdList = new ArrayList<String>(10);
                            }
                            waitDeleteItemIdList.add(key);
                            calPersonIdAndDetailInfoBasedTable.put(selectPkValue, (Object)"waitDeleteItemIdList", waitDeleteItemIdList);
                        }
                        calPersonIdAndDetailInfoBasedTable.put(selectPkValue, (Object)key, (Object)0);
                    }
                }
                this.getView().updateView(key, currFocusRowIndex);
                AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)parentPageId);
            }
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        BasedataEdit basedataEdit;
        Object source = beforeF7ViewDetailEvent.getSource();
        if (beforeF7ViewDetailEvent.getSource() instanceof BasedataEdit && "hcsi_sinsurfile".equals((basedataEdit = (BasedataEdit)source).getFieldKey())) {
            DynamicObject fileDyObj = new HRBaseServiceHelper("hcsi_sinsurfile").loadSingle(beforeF7ViewDetailEvent.getPkId());
            fileDyObj.set("status", (Object)"B");
            SinsurFileServiceHelper.openFileBase((DynamicObject)fileDyObj, (IFormView)this.getView(), (boolean)true);
            beforeF7ViewDetailEvent.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        int[] currRowIndexArr = null;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        AdjustDataDTO adjustDataDTO = null;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "clear": {
                this.clearOpLock();
                currRowIndexArr = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getSelectedRows();
                adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)parentPageId);
                if (adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable().isEmpty()) break;
                HashBasedTable calPersonIdAndDetailInfoBasedTable = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
                Table calPersonIdAndItemAndSrcTable = adjustDataDTO.getCalPersonIdAndItemAndSrcTable();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (int index : currRowIndexArr) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                    Object selectPkValue = dynamicObject.getPkValue();
                    Map cellMap = (Map)calPersonIdAndDetailInfoBasedTable.rowMap().get(selectPkValue);
                    LOGGER.info("SocInsuranceAdjustDataTmpPlugin.beforeDoOperation: current pkId is {}, cellMap is {}", dynamicObject.getPkValue(), (Object)(CollectionUtils.isEmpty((Map)cellMap) ? "null or empty" : "not empty."));
                    if (CollectionUtils.isEmpty((Map)cellMap)) continue;
                    HashSet allFieldIdSet = new HashSet(cellMap.keySet());
                    allFieldIdSet.removeIf(fieldKey -> SITStringUtils.equals((String)"validItemIdList", (String)fieldKey) || SITStringUtils.equals((String)"waitDeleteItemIdList", (String)fieldKey) || AdjustDataConstants.FIXED_COLUMN_SET.contains(fieldKey) || fieldKey.contains("roundtype"));
                    for (String itemFieldId : allFieldIdSet) {
                        cellMap.put(itemFieldId, 0);
                        this.getModel().setValue(itemFieldId, null, index);
                    }
                    allFieldIdSet.removeIf(key -> !Boolean.FALSE.equals(calPersonIdAndItemAndSrcTable.get(selectPkValue, key)));
                    cellMap.put("waitDeleteItemIdList", new ArrayList(allFieldIdSet));
                }
                AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)parentPageId);
                break;
            }
            case "deleteentry": {
                this.clearOpLock();
                adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)parentPageId);
                if (adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable().isEmpty()) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                currRowIndexArr = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getSelectedRows();
                if (currRowIndexArr != null) {
                    List<Object> personIdList = this.getExistPersonIdList();
                    for (int seq : currRowIndexArr) {
                        if (seq >= entryEntity.size()) continue;
                        Object personId = ((DynamicObject)entryEntity.get(seq)).getPkValue();
                        adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable().rowMap().remove(personId);
                        adjustDataDTO.getSearchedCalPersonIdLinkedSet().remove(personId);
                        personIdList.remove(personId);
                    }
                    this.cacheExistPersonIdList(personIdList);
                }
                AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)parentPageId);
                break;
            }
            case "donothing_add": {
                adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)parentPageId);
                this.openAddPersonF7(adjustDataDTO);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        switch (actionId) {
            case "add_person_callback": {
                if (SITListUtil.isEmpty((List)returnData)) {
                    return;
                }
                List personIdList = returnData.stream().map(single -> (Long)single.getPrimaryKeyValue()).collect(Collectors.toList());
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                AdjustDataDTO adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)parentPageId);
                LinkedHashSet personIdSet = adjustDataDTO.getSearchedCalPersonIdLinkedSet();
                int total = personIdList.size() + personIdSet.size();
                if (total > 1000) {
                    this.getView().showTipNotification(HCSIErrInfoEnum.ADJUST_DATA_SELECTED_CAL_PERSON_TO_BIG.getErrInfo());
                    break;
                }
                AdjustDataDTO addAdjustDataDTO = AdjustDataService.getAdjustDataDTOByCalPerson(personIdList, (Long)adjustDataDTO.getCalTaskId(), (boolean)false);
                this.mergeDataDto(adjustDataDTO, addAdjustDataDTO);
                AdjustDataService.updateAdjustDataDTOToCache((AdjustDataDTO)adjustDataDTO, (String)parentPageId);
                this.loadEntryData(adjustDataDTO);
                List<Object> existPersonIdList = this.getExistPersonIdList();
                existPersonIdList.addAll(personIdList);
                this.cacheExistPersonIdList(existPersonIdList);
                break;
            }
        }
    }

    private void mergeDataDto(AdjustDataDTO adjustDataDTO, AdjustDataDTO addAdjustDataDTO) {
        LinkedHashSet calPersonIdLinkedSet = addAdjustDataDTO.getSearchedCalPersonIdLinkedSet();
        LinkedHashMap fieldIdAndAttrMap = addAdjustDataDTO.getDynamicFieldIdAndAttrMap();
        HashBasedTable infoBasedTable = addAdjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
        adjustDataDTO.getSearchedCalPersonIdLinkedSet().addAll(calPersonIdLinkedSet);
        adjustDataDTO.getDynamicFieldIdAndAttrMap().putAll(fieldIdAndAttrMap);
        adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable().putAll((Table)infoBasedTable);
    }

    private void loadEntryData(AdjustDataDTO adjustDataDTO) {
        HashBasedTable calPersonIdAndDetailInfoBasedTable = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable();
        HashBasedTable<String, Object, DynamicObject> baseTypeInfoTable = this.getSocEntityInfoMap((HashBasedTable<Object, String, Object>)calPersonIdAndDetailInfoBasedTable);
        LinkedHashMap orderFieldIdAndAttr = adjustDataDTO.getDynamicFieldIdAndAttrMap();
        this.getModel().deleteEntryData("entryentity");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        LinkedHashMap<String, Set<Integer>> lockCellLinkedMap = new LinkedHashMap<String, Set<Integer>>(calPersonIdAndDetailInfoBasedTable.size());
        int index = 0;
        String searchText = adjustDataDTO.getSearchText();
        for (Map.Entry valuesLinkedEntry : calPersonIdAndDetailInfoBasedTable.rowMap().entrySet()) {
            if (SITStringUtils.isNotEmpty((String)searchText)) {
                boolean isMatch;
                String name = (String)((Map)valuesLinkedEntry.getValue()).get("name");
                String empNumber = (String)((Map)valuesLinkedEntry.getValue()).get("empnumber");
                String fileNumber = ((DynamicObject)baseTypeInfoTable.get((Object)"hcsi_sinsurfile", ((Map)valuesLinkedEntry.getValue()).get("hcsi_sinsurfile"))).getString("number");
                boolean bl = isMatch = SITStringUtils.isNotEmpty((String)fileNumber) && !fileNumber.contains(searchText) && SITStringUtils.isNotEmpty((String)name) && !name.contains(searchText) && SITStringUtils.isNotEmpty((String)empNumber) && !empNumber.contains(searchText);
                if (isMatch) continue;
            }
            DynamicObject newRow = rows.addNew();
            newRow.set("id", valuesLinkedEntry.getKey());
            LinkedHashSet allOrderFieldIdSet = new LinkedHashSet(AdjustDataConstants.FIXED_COLUMN_SET);
            allOrderFieldIdSet.addAll(orderFieldIdAndAttr.keySet());
            allOrderFieldIdSet.remove("hrpi_employee");
            List validItemIdList = (List)((Map)valuesLinkedEntry.getValue()).get("validItemIdList");
            List waitDeleteItemIdList = (List)((Map)valuesLinkedEntry.getValue()).get("waitDeleteItemIdList");
            LOGGER.info("SocInsuranceAdjustDataTmpPlugin.loadEntryData, validItemIdList:{}", (Object)validItemIdList);
            LOGGER.info("SocInsuranceAdjustDataTmpPlugin.loadEntryData, allOrderFieldIdSet:{}", allOrderFieldIdSet);
            for (String fieldKey : allOrderFieldIdSet) {
                Object cellValue = ((Map)valuesLinkedEntry.getValue()).get(fieldKey);
                if (!validItemIdList.contains(fieldKey) && !AdjustDataConstants.FIXED_COLUMN_SET.contains(fieldKey)) {
                    Set lockSeqSet = lockCellLinkedMap.computeIfAbsent(fieldKey, key -> new LinkedHashSet());
                    lockSeqSet.add(index);
                    continue;
                }
                if (!SITListUtil.isEmpty((List)waitDeleteItemIdList) && waitDeleteItemIdList.contains(fieldKey)) continue;
                if (PATTERN.matcher(fieldKey).matches()) {
                    int scale;
                    Map itemMap = (Map)orderFieldIdAndAttr.get(fieldKey);
                    int round = itemMap.get("round") == null ? 4 : (Integer)itemMap.get("round");
                    int n = scale = itemMap.get("scale") == null ? 2 : (Integer)itemMap.get("scale");
                    if (!(cellValue instanceof BigDecimal)) continue;
                    newRow.set(fieldKey, (Object)new BigDecimal(String.valueOf(cellValue)).setScale(scale, round));
                    continue;
                }
                if ("name".equals(fieldKey) || "empnumber".equals(fieldKey)) {
                    newRow.set(fieldKey, cellValue);
                    continue;
                }
                if (!AdjustDataConstants.FIXED_BASE_FILE_SET.contains(fieldKey)) continue;
                DynamicObject valDy = (DynamicObject)baseTypeInfoTable.get((Object)fieldKey, cellValue);
                newRow.set(fieldKey, (Object)valDy);
            }
            ++index;
        }
        this.lockCell(lockCellLinkedMap);
        this.getView().updateView("entryentity");
    }

    private void openAddPersonF7(AdjustDataDTO adjustDataDTO) {
        List<Object> personIdList = this.getExistPersonIdList();
        Long calTaskId = adjustDataDTO.getCalTaskId();
        ListShowParameter showParameter = this.setListShowParam(calTaskId);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("sinsurtask.id", "=", (Object)calTaskId));
        qFilters.add(new QFilter("calstatus", "=", (Object)"0"));
        qFilters.add(new QFilter("id", "not in", personIdList));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_PERSON_CALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected ListShowParameter setListShowParam(Long calTaskId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("hcsi_calperson");
        listShowParameter.setCaption(HCSIErrInfoEnum.ADJUST_DATA_ADD_CAL_PERSON_TITLE.getErrInfo());
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCustomParam("taskId", (Object)calTaskId);
        listShowParameter.setCustomParam("pageFrom", (Object)"adjustPage");
        return listShowParameter;
    }

    private void initEntryGrid() {
        EntryGrid grid = this.createEntryControl();
        EntryParamContainerBaseHelper.updateEntryGrid((IFormView)this.getView(), (EntryGrid)grid, (String)"entryentity");
        if (grid != null && grid.getSetRowDataConfig() != null) {
            grid.getSetRowDataConfig().setAddRowDisabled(true);
        }
    }

    private EntryGrid createEntryControl() {
        EntryAp entryAp = this.initEntryAp(this.getView().getFormShowParameter());
        if (entryAp == null) {
            LOGGER.error("SocInsuranceAdjustDataTmpPlugin.createEntryControl: entryAp is null");
            return null;
        }
        EntryGrid grid = new EntryGrid();
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        grid.setSplitPage(false);
        grid.getItems().clear();
        List controls = ((Container)entryAp.buildRuntimeControl()).getItems();
        if (controls != null && controls.size() > 0) {
            for (Control control : controls) {
                if (!"hcsi_sinsurfile".equals(control.getKey()) || !(control instanceof BasedataEdit)) continue;
                ((BasedataEdit)control).addBeforeF7ViewDetailListener((Consumer)this);
            }
        }
        grid.getItems().addAll(controls);
        this.getView().createControlIndex((List)Lists.newArrayList((Object[])new Control[]{grid}));
        grid.endInit();
        return grid;
    }

    public EntryAp initEntryAp(FormShowParameter formShow) {
        List<EntryParamContainer> entryParamContainers = this.getEntryParamContainers(formShow);
        if (entryParamContainers == null || entryParamContainers.isEmpty()) {
            LOGGER.info("SocInsuranceAdjustDataTmpPlugin.initEntryAp: entryParamContainers is null.");
            return null;
        }
        EntryAp entryAp = EntryParamContainerBaseHelper.createEntryAp((String)"entryentity");
        EntryParamContainerBaseHelper.createControlAp((EntryAp)entryAp, entryParamContainers);
        return entryAp;
    }

    private List<EntryParamContainer> getEntryParamContainers(FormShowParameter formShow) {
        AdjustDataDTO adjustDataDTO = this.getAdjustDataDTO(formShow);
        if (adjustDataDTO == null) {
            return null;
        }
        EntityMetadata entityMetadata = this.getEntityMetadata();
        List<DynamicEntry> dynamicEntries = SocInsuranceAdjustDataTmpPlugin.getFixedColumns();
        ArrayList<EntryParamContainer> entryParamContainers = new ArrayList<EntryParamContainer>(10);
        for (DynamicEntry dynamicEntry : dynamicEntries) {
            Features copyAndExport = this.getFeatures();
            EntryParamContainer entryParamContainer = ContainerFactory.createInstance((EntityMetadata)entityMetadata, (Features)copyAndExport, (DynamicEntry)dynamicEntry).createEntryParamContainer();
            if (entryParamContainer == null) continue;
            if (SITStringUtils.equals((String)"memo", (String)entryParamContainer.getKey())) {
                ((TextFieldParamContainer)entryParamContainer).setMaxLength(200);
            }
            entryParamContainers.add(entryParamContainer);
        }
        LinkedHashMap orderFieldIdAndNameLinkedMap = adjustDataDTO.getDynamicFieldIdAndAttrMap();
        Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        copyAndExport.setCopyable(true);
        copyAndExport.setExportable(true);
        for (Map.Entry itemEntry : orderFieldIdAndNameLinkedMap.entrySet()) {
            Map attrMap = (Map)itemEntry.getValue();
            String itemId = (String)itemEntry.getKey();
            String itemName = (String)attrMap.get("name");
            int scale = (Integer)attrMap.get("scale");
            DecimalFieldParamContainer amountField = SocInsuranceAdjustDataTmpPlugin.getDecimalFieldParamContainer(itemId, itemName, "180px", false, entityMetadata, copyAndExport, scale, "");
            entryParamContainers.add((EntryParamContainer)amountField);
        }
        return entryParamContainers;
    }

    private Features getFeatures() {
        Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        copyAndExport.setCopyable(true);
        copyAndExport.setExportable(true);
        return copyAndExport;
    }

    private EntityMetadata getEntityMetadata() {
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcsi_sinsurresultadjtmp", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
    }

    private static DecimalFieldParamContainer getDecimalFieldParamContainer(String key, String name, String width, boolean hide, EntityMetadata entityMetadata, Features features, int scale, String lock) {
        DecimalFieldParamContainer field = new DecimalFieldParamContainer();
        field.setKey(key);
        field.setName(name);
        field.setWidth(width);
        field.setZeroShow(true);
        field.setEnableNull(true);
        field.setScale(scale);
        field.setPrecision(13 + scale);
        field.setLock(lock);
        field.setTextAlign("right");
        if (hide) {
            field.setVisible("");
        }
        field.setEntityMetadata(entityMetadata);
        field.setFeatures(features);
        return field;
    }

    private void registerDynamicProps(EntityType entityType) {
        FormShowParameter formShow = this.getView().getFormShowParameter();
        List<EntryParamContainer> entryParamContainers = this.getEntryParamContainers(formShow);
        EntryParamContainerBaseHelper.registProp(entryParamContainers, (EntityType)entityType);
    }

    private AdjustDataDTO getAdjustDataDTO(FormShowParameter formShow) {
        AdjustDataDTO adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)formShow.getParentPageId());
        if (adjustDataDTO.getDynamicFieldIdAndAttrMap().isEmpty()) {
            return null;
        }
        return adjustDataDTO;
    }

    public static List<DynamicEntry> getFixedColumns() {
        ArrayList<DynamicEntry> dynamicEntryDTOs = new ArrayList<DynamicEntry>(10);
        dynamicEntryDTOs.add(DynamicEntry.BaseDataBuilder.createInstance().setDisplayProp("number").setViewDetail(true).setBaseEntityId("hcsi_sinsurfile").setKey("hcsi_sinsurfile").setName(HCSIErrInfoEnum.SOC_INSURANCE_FILE.getErrInfo()).setLock("new,edit,view,submit,audit").build());
        dynamicEntryDTOs.add(DynamicEntry.TextFieldBuilder.createInstance().setKey("name").setName(HCSIErrInfoEnum.ADJUST_DATA_NAME.getErrInfo()).setLock("new,edit,view,submit,audit").build());
        dynamicEntryDTOs.add(DynamicEntry.TextFieldBuilder.createInstance().setKey("empnumber").setName(HCSIErrInfoEnum.ADJUST_DATA_EMP_NUMBER.getErrInfo()).setLock("new,edit,view,submit,audit").build());
        dynamicEntryDTOs.add(DynamicEntry.BaseDataBuilder.createInstance().setDisplayProp("name").setBaseEntityId("sitbs_sinsurstd").setKey("sitbs_sinsurstd").setName(HCSIErrInfoEnum.COMMON_NAME_STD.getErrInfo()).setLock("new,edit,view,submit,audit").build());
        dynamicEntryDTOs.add(DynamicEntry.TextFieldBuilder.createInstance().setMaxLength(200).setKey("memo").setName(HCSIErrInfoEnum.COMMON_NAME_MEMO.getErrInfo()).setLock("").build());
        return dynamicEntryDTOs;
    }

    private HashBasedTable<String, Object, DynamicObject> getSocEntityInfoMap(HashBasedTable<Object, String, Object> calPersonIdAndDetailInfoBasedTable) {
        HashBasedTable baseTypeInfoTable = HashBasedTable.create();
        for (String entityName : AdjustDataConstants.FIXED_BASE_FILE_SET) {
            Object[] infoDyArr;
            Collection pkIdColl = calPersonIdAndDetailInfoBasedTable.column((Object)entityName).values();
            if (pkIdColl.isEmpty() || HRArrayUtils.isEmpty((Object[])(infoDyArr = BusinessDataServiceHelper.load((Object[])pkIdColl.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))))) continue;
            for (Object dynamicObject : infoDyArr) {
                baseTypeInfoTable.put((Object)entityName, dynamicObject.getPkValue(), dynamicObject);
            }
        }
        return baseTypeInfoTable;
    }

    private void lockCell(Map<String, Set<Integer>> lockCellLinkedMap) {
        Map<String, Set<Integer>> currLockCellLinkedMap;
        Map<String, Set<Integer>> map = currLockCellLinkedMap = lockCellLinkedMap == null ? this.getCellMap() : lockCellLinkedMap;
        if (currLockCellLinkedMap.isEmpty()) {
            return;
        }
        LinkedHashMap<String, int[]> lastLockCellLinkedMap = new LinkedHashMap<String, int[]>(currLockCellLinkedMap.size());
        for (Map.Entry<String, Set<Integer>> lockCellLinkedEntry : currLockCellLinkedMap.entrySet()) {
            if (lockCellLinkedEntry.getValue().isEmpty()) continue;
            int[] needLockRowsArr = lockCellLinkedEntry.getValue().stream().mapToInt(Integer::intValue).toArray();
            lastLockCellLinkedMap.put(lockCellLinkedEntry.getKey(), needLockRowsArr);
        }
        SITGridUtils.lockCell((IClientViewProxy)((IClientViewProxy)this.getView().getService(IClientViewProxy.class)), (String)"entryentity", lastLockCellLinkedMap, (boolean)true);
    }

    private Map<String, Set<Integer>> getCellMap() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        AdjustDataDTO adjustDataDTO = AdjustDataService.getAdjustDataDTO((String)this.getView().getFormShowParameter().getParentPageId());
        Map rowMap = adjustDataDTO.getCalPersonIdAndDetailInfoBasedTable().rowMap();
        LinkedHashMap<String, Set<Integer>> lockCellLinkedMap = new LinkedHashMap<String, Set<Integer>>(rowMap.size());
        for (DynamicObject entryRowDy : entryEntity) {
            Map currRowMap = (Map)rowMap.get(entryRowDy.getPkValue());
            for (IDataEntityProperty iDataEntityProperty : entryRowDy.getDynamicObjectType().getProperties()) {
                if (!PATTERN.matcher(iDataEntityProperty.getName()).matches() || currRowMap == null || currRowMap.containsKey(iDataEntityProperty.getName())) continue;
                Set seqSet = lockCellLinkedMap.computeIfAbsent(iDataEntityProperty.getName(), key -> new LinkedHashSet(16));
                int seq = entryRowDy.getInt("seq") - 1;
                if (seq < 0) continue;
                seqSet.add(seq);
            }
        }
        return lockCellLinkedMap;
    }

    private void clearOpLock() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getPageCache() != null) {
            parentView.getPageCache().remove("only_one_operate");
        }
    }

    private List<Object> getExistPersonIdList() {
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String existPersonIdListStr = pageCache.get("existPersonIdList");
        List<Object> personIdList = (ArrayList<Object>)SerializationUtils.deSerializeFromBase64((String)existPersonIdListStr);
        personIdList = personIdList != null ? personIdList.stream().distinct().collect(Collectors.toList()) : new ArrayList<Object>(0);
        return personIdList;
    }

    private void cacheExistPersonIdList(List<Object> personIdList) {
        personIdList = personIdList != null ? personIdList.stream().distinct().collect(Collectors.toList()) : new ArrayList<Object>(0);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        pageCache.put("existPersonIdList", SerializationUtils.serializeToBase64(personIdList));
    }
}

