/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.adjust.dynamic;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.mvc.form.FormView;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.sit.hcsi.business.caladjust.dto.AdjustDataDTO;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.helper.AdjustDataHelper;
import kd.sit.hcsi.business.caladjust.service.AdjustDataService;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.hcsi.formplugin.web.cal.adjust.dynamic.AdjustDataEntryGridControl;
import kd.sit.sitbp.business.dynamic.grid.DecimalFieldParamContainer;
import kd.sit.sitbp.business.dynamic.grid.EntryParamContainer;
import kd.sit.sitbp.business.dynamic.grid.EntryParamContainerBaseHelper;
import kd.sit.sitbp.business.dynamic.grid.TextFieldParamContainer;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang.StringUtils;

public class SocInsuranceAdjustDataViewPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String SYSTEM_TYPE = "sit-hcsi-formplugin";
    private static String FIXED_FIELD = "name,filenumber,empnumber";
    private static final String LOCK_STRING = "new,edit,view,submit,audit";
    private static final Log logger = LogFactory.getLog(SocInsuranceAdjustDataViewPlugin.class);
    private static final String OP_KEY_REFRESH = "donothing_refresh";
    private static final String OP_KEY_DELETE = "donothing_delete";
    private static final String OP_KEY_MODIFY = "donothing_modify";
    private static final String OP_KEY_EXPORT = "donothing_export";
    private static final String CALLBACK_DELETE = "callback_delete";
    private static final String CONFIRM_EXPORT_CALLBACK = "confirm_export_callback";
    private static final String LOCK_KEY = "donothing_adjustdetail";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        this.createAndReplaceEntryControl();
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        String pageId = this.getPersonPageId();
        AdjustDataHelper.cacheSearchText((String)searchText, (Long)this.getTaskId(), (String)pageId);
        AdjustDataHelper.loadGridData((Long)this.getTaskId(), (String)this.getPersonPageId(), (IDataModel)this.getModel(), (int)1, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache());
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metasArgs) {
        FormShowParameter formShowParam = (FormShowParameter)metasArgs.getSource();
        Long taskId = (Long)formShowParam.getCustomParam("taskId");
        String personPageId = (String)formShowParam.getCustomParam("personPageId");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formShowParam.getFormId(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map itemMap = AdjustDataHelper.getCacheItemMap((Long)taskId, (String)personPageId);
        EntryAp entryAp = SocInsuranceAdjustDataViewPlugin.createEntryAp(entityMetadata, itemMap);
        Object columns = entryAp.createControl().get("columns");
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)columns);
        metasArgs.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs eventArgs) {
        MainEntityType newMainType;
        MainEntityType oldMainType = eventArgs.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", e1.getMessage()), new Object[0]);
        }
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        Map itemMap = AdjustDataHelper.getCacheItemMap((Long)taskId, (String)personPageId);
        this.registerProp((EntryType)newMainType.getAllEntities().get("entryentity"), itemMap, taskId);
        try {
            newMainType = (MainEntityType)newMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", e1.getMessage()), new Object[0]);
        }
        eventArgs.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject eventObject) {
        AdjustDataHelper.loadGridData((Long)this.getTaskId(), (String)this.getPersonPageId(), (IDataModel)this.getModel(), (int)1, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache());
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (SITStringUtils.equals((String)key, (String)"entryentity")) {
            EntryGrid entryGrid = this.createEntryControl();
            args.setControl((Control)entryGrid);
        } else {
            this.initItemField(args, key);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_delete": 
            case "donothing_modify": 
            case "donothing_export": {
                boolean exist;
                boolean flag = this.checkAuthAndLock(operateKey, true);
                if (!flag) {
                    args.setCancel(true);
                }
                if (exist = this.checkDataExist(operateKey)) break;
                this.releaseLock(LOCK_KEY);
                args.setCancel(true);
                break;
            }
            case "donothing_refresh": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = args.getOperateKey()) {
            case "donothing_refresh": {
                this.refreshGridData();
                break;
            }
            case "donothing_delete": {
                this.showDeleteConfirm();
                break;
            }
            case "donothing_modify": {
                this.openAdjustDataView();
                break;
            }
            case "donothing_export": {
                this.doAdjExportData();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        switch (callBackId = event.getCallBackId()) {
            case "confirm_export_callback": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                AdjustDataService service = new AdjustDataService();
                service.exportAdjustData(this.getTaskId(), this.getPersonPageId(), this.getView(), new ArrayList(0));
                SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"SocInsuranceAdjustDataViewPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SocInsuranceAdjustDataViewPlugin_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                break;
            }
            case "callback_delete": {
                boolean flag;
                if (MessageBoxResult.Yes.equals((Object)event.getResult()) && (flag = this.checkAuthAndLock(OP_KEY_DELETE, false))) {
                    this.deleteAdjustData();
                    this.refreshGridData();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SocInsuranceAdjustDataViewPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"SocInsuranceAdjustDataViewPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SocInsuranceAdjustDataViewPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                this.releaseLock(LOCK_KEY);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hcsi_sinsurresultadj": {
                this.refreshGridData();
                this.releaseLock(LOCK_KEY);
                break;
            }
        }
    }

    public void pageRelease(EventObject eventObject) {
        this.releaseLock(LOCK_KEY);
        AdjustDataHelper.clearCache((Long)this.getTaskId(), (String)this.getPersonPageId());
    }

    private void releaseLock(String opKeyModify) {
        MutexServiceHelper.release((String)"hcsi_sinsurtask", (String)String.valueOf(this.getTaskId()), (String)opKeyModify);
    }

    private boolean checkDataExist(String operateKey) {
        if (!SITStringUtils.equals((String)operateKey, (String)OP_KEY_EXPORT)) {
            List<String> fielIdStrList = this.getSelectedIdList(true);
            if (SITListUtil.isEmpty(fielIdStrList)) {
                return false;
            }
            List fileIdList = fielIdStrList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
            int count = AdjustDataHelper.querySelectAdjustData((Long)this.getTaskId(), fileIdList);
            if (count == 0) {
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"SocInsuranceAdjustDataViewPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                String opkeyMsg = this.getOpMsg(operateKey);
                SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)opkeyMsg, (String)msg);
                return false;
            }
        }
        return true;
    }

    private void doAdjExportData() {
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        List<String> idStrList = this.getSelectedIdList(false);
        if (SITListUtil.isEmpty(idStrList)) {
            int dataSize = this.getDataSize(taskId, personPageId);
            if (dataSize == 0) {
                String noDataMsg = ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"SocInsuranceAdjustDataViewPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(noDataMsg);
                SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"SocInsuranceAdjustDataViewPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)noDataMsg);
            } else {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa{0}\u5f20\u8c03\u6574\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"SocInsuranceAdjustDataViewPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), dataSize);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_EXPORT_CALLBACK, (IFormPlugin)this));
            }
        } else {
            AdjustDataService service = new AdjustDataService();
            service.exportAdjustData(taskId, personPageId, this.getView(), idStrList);
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"SocInsuranceAdjustDataViewPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SocInsuranceAdjustDataViewPlugin_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        this.releaseLock(LOCK_KEY);
    }

    private int getDataSize(Long taskId, String personPageId) {
        String searchText = AdjustDataHelper.getCacheSearchText((Long)taskId, (String)personPageId);
        List personIds = AdjustDataHelper.getAdjustDataFileIdList((Long)taskId, new ArrayList(0));
        if (SITListUtil.isEmpty((List)personIds)) {
            return 0;
        }
        int dataSize = AdjustDataHelper.getCalPersonDyObjCount((List)personIds, (String)searchText, (Long)taskId);
        return dataSize;
    }

    private boolean checkAuthAndLock(String operateKey, boolean checkLock) {
        if (SITPermissionServiceHelper.checkCancelDataRight((IFormView)this.getView())) {
            return false;
        }
        String permission = SITStringUtils.equals((String)OP_KEY_EXPORT, (String)operateKey) ? "4730fc9f000004ae" : "4715a0df000000ac";
        if (!SITPermissionServiceHelper.hasPerm((String)"hcsi", (String)"hcsi_calperson", (String)permission)) {
            this.getView().showErrorNotification(HCSIErrInfoEnum.ADJUST_DATA_WITHOUT_MODIFY_PERMISSION.getErrInfo());
            String opkeyMsg = this.getOpMsg(operateKey);
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)opkeyMsg, (String)HCSIErrInfoEnum.ADJUST_DATA_WITHOUT_MODIFY_PERMISSION.getErrInfo());
            return false;
        }
        if (checkLock) {
            BaseResult lockInfo = MutexServiceHelper.getMutexLockInfo((String)"hcsi_sinsurtask", (String)String.valueOf(this.getTaskId()), (String)LOCK_KEY);
            if (lockInfo.isSuccess()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u793e\u4fdd\u8ba1\u7b97\u6b63\u5728\u8c03\u6574\u6570\u636e\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u6574\u6570\u636e\u64cd\u4f5c\u3002", (String)"SocInsuranceAdjustDataViewPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            MutexServiceHelper.require((String)"hcsi_sinsurtask", (String)String.valueOf(this.getTaskId()), (String)LOCK_KEY);
        }
        return true;
    }

    private String getOpMsg(String operateKey) {
        String opkeyMsg = SITStringUtils.equals((String)OP_KEY_DELETE, (String)operateKey) ? ResManager.loadKDString((String)"\u5220\u9664", (String)"SocInsuranceAdjustDataViewPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]) : (SITStringUtils.equals((String)OP_KEY_EXPORT, (String)operateKey) ? ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"SocInsuranceAdjustDataViewPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539", (String)"SocInsuranceAdjustDataViewPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        return opkeyMsg;
    }

    private void openAdjustDataView() {
        List<String> selectedFileIdList = this.getSelectedIdList(true);
        if (SITListUtil.isEmpty(selectedFileIdList)) {
            this.releaseLock(LOCK_KEY);
            return;
        }
        Long taskId = this.getTaskId();
        List personIdList = AdjustDataHelper.getPersonIdByFileId(selectedFileIdList, (Long)taskId);
        if (SITListUtil.isEmpty((List)personIdList)) {
            String errMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u72b6\u6001\u4e3a\u5df2\u8ba1\u7b97\u7684\u793e\u4fdd\u6863\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"SocInsuranceAdjustDataViewPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)ResManager.loadKDString((String)"\u4fee\u6539", (String)"SocInsuranceAdjustDataViewPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)errMsg);
            this.releaseLock(LOCK_KEY);
            return;
        }
        Map itemMap = AdjustDataHelper.getCacheItemMap((Long)taskId, (String)this.getPersonPageId());
        AdjustDataHelper.cacheItemMap((Map)itemMap, (Long)taskId, (String)this.getView().getPageId());
        AdjustDataDTO adjustDataDTO = AdjustDataService.getAdjustDataDTOByCalPerson((List)personIdList, (Long)taskId, (boolean)true);
        String adjustDataDTOStr = SerializationUtils.serializeToBase64((Object)adjustDataDTO);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("hcsi_sinsurresultadj" + this.getView().getPageId(), (Object)adjustDataDTOStr);
        showParameter.setCustomParam("personIdList", (Object)personIdList);
        showParameter.setFormId("hcsi_sinsurresultadj");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcsi_sinsurresultadj"));
        this.getView().showForm(showParameter);
        this.recordSuccessfulOpLog(SocialOperationEnum.OP_ADJUSTDETAIL);
    }

    protected void recordSuccessfulOpLog(SocialOperationEnum opEnum) {
        SITLogServiceHelper.addLog((String)"hcsi", (String)((FormView)this.getView()).getFormId(), (String)opEnum.getOperationName(), (String)HCSIErrInfoEnum.COMMON_OPERATE_SUCCESSFULLY.getErrInfo(new Object[]{opEnum.getOperationName()}));
    }

    private void showDeleteConfirm() {
        List<String> selectedFileIdList = this.getSelectedIdList(true);
        if (SITListUtil.isEmpty(selectedFileIdList)) {
            this.releaseLock(LOCK_KEY);
            return;
        }
        Long taskId = this.getTaskId();
        List fileIdList = selectedFileIdList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        DynamicObjectCollection validPersonList = AdjustDataHelper.getValidDeletePersonObjList(fileIdList, (Long)taskId);
        if (SITListUtil.isEmpty((List)validPersonList)) {
            String errMsg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u5220\u9664\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"SocInsuranceAdjustDataViewPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_viewadjustdata", (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"SocInsuranceAdjustDataViewPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)errMsg);
            this.releaseLock(LOCK_KEY);
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACK_DELETE, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u8c03\u6574\u6570\u636e\u540e\uff0c\u5bf9\u5e94\u7684\u9669\u79cd\u9879\u76ee\u7ed3\u679c\u5c06\u7f6e\u4e3a\u7a7a\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8c03\u6574\u6570\u636e\u5417\uff1f", (String)"SocInsuranceAdjustDataPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(msg, options, ConfirmTypes.Default, confirmCallBacks);
    }

    private void refreshGridData() {
        Long taskId = this.getTaskId();
        String personPageId = this.getView().getPageId();
        AdjustDataHelper.assembleAndCacheItemMap((Long)taskId, (String)personPageId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_viewadjustdata");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setCustomParam("personPageId", (Object)personPageId);
        showParameter.setCustomParam("taskId", (Object)taskId);
        this.getView().showForm(showParameter);
    }

    private void deleteAdjustData() {
        List<String> selectedFileIdList = this.getSelectedIdList(true);
        if (SITListUtil.isEmpty(selectedFileIdList)) {
            return;
        }
        AdjustDataHelper.deleteAdjustData((Long)this.getTaskId(), selectedFileIdList);
    }

    private List<String> getSelectedIdList(boolean needWarn) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0 && needWarn) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SocInsuranceAdjustDataViewPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return new ArrayList<String>(0);
        }
        ArrayList<String> idList = new ArrayList<String>(10);
        Integer pageIndex = grid.getEntryState().getCurrentPageIndex();
        int pageRow = grid.getPageRow();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int startRowIndex = (pageIndex - 1) * pageRow;
        for (int selectIndex : selectRows) {
            int index = selectIndex - startRowIndex;
            if (index >= entryEntity.size()) continue;
            DynamicObject entryObj = (DynamicObject)entryEntity.get(index);
            idList.add(entryObj.get("idstr") + "");
        }
        return idList;
    }

    private void initItemField(OnGetControlArgs args, String key) {
        Map itemMap = AdjustDataHelper.getCacheItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        if (itemMap == null) {
            return;
        }
        String itemId = key.substring(4);
        if (!itemMap.containsKey(Long.parseLong(itemId))) {
            return;
        }
        AmountEdit field = new AmountEdit();
        field.setFieldKey(key);
        field.setEntryKey("entryentity");
        field.setEntryControlKey("entryentity");
        field.setView(this.getView());
        field.setKey(key);
        field.setModel(this.getView().getModel());
        args.setControl((Control)field);
    }

    private int getPageRow() {
        Map settingMap;
        Object pageRows;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"entrygridrowconfig_hcsi_viewadjustdata_entryentity");
        if (SITStringUtils.isNotEmpty((String)setting) && (pageRows = (settingMap = (Map)JSONObject.parseObject((String)setting, Map.class)).get("PageRows")) != null) {
            return Integer.parseInt(pageRows + "");
        }
        return grid.getPageRow();
    }

    private void registerProp(EntryType entryType, Map<Long, Map<String, Object>> itemMap, Long taskId) {
        List<EntryParamContainer> params = SocInsuranceAdjustDataViewPlugin.createEntryBuildParam(null, itemMap);
        EntryParamContainerBaseHelper.registProp(params, (EntityType)entryType);
    }

    private void createAndReplaceEntryControl() {
        Container entryParentAp;
        this.getPageCache().put("BOS.setRowDataByNumberDisable", Boolean.TRUE.toString());
        EntryGrid grid = this.createEntryControl();
        if (grid.getSetRowDataConfig() != null) {
            grid.getSetRowDataConfig().setDisabled(true);
        }
        if ((entryParentAp = (Container)SocInsuranceAdjustDataViewPlugin.findControl(((Container)this.getView().getRootControl()).getItems(), "advconchildpanelap")) == null) {
            return;
        }
        List subItems = entryParentAp.getItems();
        int index = this.findControlIndex(subItems, "entryentity");
        if (index >= 0) {
            subItems.set(index, grid);
        }
        this.getView().createControlIndex(grid.getItems());
    }

    private int findControlIndex(List<Control> controls, String key) {
        int index = -1;
        for (int i = 0; i < controls.size(); ++i) {
            String target = controls.get(i).getKey();
            if (!StringUtils.equals((String)target, (String)key)) continue;
            index = i;
            break;
        }
        return index;
    }

    private EntryGrid createEntryControl() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hcsi_viewadjustdata", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = AdjustDataHelper.getCacheItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        EntryAp entryAp = SocInsuranceAdjustDataViewPlugin.createEntryAp(entityMetadata, salaryItemMap);
        AdjustDataEntryGridControl grid = new AdjustDataEntryGridControl();
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        grid.setSplitPage(true);
        grid.getItems().clear();
        grid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex((List)Lists.newArrayList((Object[])new Control[]{grid}));
        grid.endInit();
        return grid;
    }

    public static EntryAp createEntryAp(EntityMetadata entityMetadata, Map<Long, Map<String, Object>> salaryItemMap) {
        List<EntryParamContainer> params = SocInsuranceAdjustDataViewPlugin.createEntryBuildParam(entityMetadata, salaryItemMap);
        EntryAp entryAp = EntryParamContainerBaseHelper.createEntryAp((String)"entryentity");
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setShowSeq(true);
        entryAp.setShowGridConfig(true);
        entryAp.setSplitPage(true);
        return EntryParamContainerBaseHelper.createControlAp((EntryAp)entryAp, params);
    }

    private static List<EntryParamContainer> createEntryBuildParam(EntityMetadata entityMetadata, Map<Long, Map<String, Object>> salaryItemMap) {
        Features copyAndExport = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        copyAndExport.setCopyable(true);
        copyAndExport.setExportable(true);
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        SocInsuranceAdjustDataViewPlugin.addFixedField(entityMetadata, copyAndExport, allContainer);
        SocInsuranceAdjustDataViewPlugin.addItemField(entityMetadata, copyAndExport, allContainer, salaryItemMap);
        return allContainer;
    }

    private static void addItemField(EntityMetadata entityMetadata, Features copyAndExport, List<EntryParamContainer> allContainer, Map<Long, Map<String, Object>> itemMap) {
        if (itemMap == null || itemMap.size() == 0) {
            return;
        }
        for (Map.Entry<Long, Map<String, Object>> itemEntry : itemMap.entrySet()) {
            String itemId = "key_" + itemEntry.getKey();
            Map<String, Object> itemData = itemEntry.getValue();
            String itemName = itemData.get("itemName").toString();
            int scale = (Integer)itemData.get("scale");
            DecimalFieldParamContainer amountField = SocInsuranceAdjustDataViewPlugin.getDecimalFieldParamContainer(itemId, itemName, "180px", false, entityMetadata, copyAndExport, scale, LOCK_STRING);
            allContainer.add((EntryParamContainer)amountField);
        }
    }

    private static DecimalFieldParamContainer getDecimalFieldParamContainer(String key, String name, String width, boolean hide, EntityMetadata entityMetadata, Features features, int scale, String lock) {
        DecimalFieldParamContainer field = new DecimalFieldParamContainer();
        field.setKey(key);
        field.setName(name);
        field.setWidth(width);
        field.setZeroShow(true);
        field.setEnableNull(true);
        field.setScale(scale);
        field.setPrecision(13 + scale);
        field.setLock(lock);
        field.setTextAlign("right");
        if (hide) {
            field.setVisible("");
        }
        field.setEntityMetadata(entityMetadata);
        field.setFeatures(features);
        return field;
    }

    private static void addFixedField(EntityMetadata entityMetadata, Features copyAndExport, List<EntryParamContainer> allContainer) {
        TextFieldParamContainer id = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("idstr", "idstr", "180px", true, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)id);
        TextFieldParamContainer personId = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("personid", "personid", "180px", true, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)personId);
        String numberStr = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"SocInsuranceAdjustDataViewPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        TextFieldParamContainer fileNumber = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("filenumber", numberStr, "180px", false, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)fileNumber);
        String nameStr = ResManager.loadKDString((String)"\u59d3\u540d", (String)"SocInsuranceAdjustDataViewPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        TextFieldParamContainer name = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("name", nameStr, "180px", false, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)name);
        String empNumberStr = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SocInsuranceAdjustDataViewPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        TextFieldParamContainer empNumber = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("empnumber", empNumberStr, "180px", false, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)empNumber);
        String sinsurstdStr = ResManager.loadKDString((String)"\u53c2\u4fdd\u6807\u51c6", (String)"SocInsuranceAdjustDataViewPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        TextFieldParamContainer sinsurstd = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("sinsurstd", sinsurstdStr, "180px", false, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)sinsurstd);
        String statusStr = ResManager.loadKDString((String)"\u72b6\u6001", (String)"SocInsuranceAdjustDataViewPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        TextFieldParamContainer status = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("status", statusStr, "180px", false, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)status);
        String memoStr = ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SocInsuranceAdjustDataViewPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        TextFieldParamContainer memo = SocInsuranceAdjustDataViewPlugin.getTextFieldParamContainer("memo", memoStr, "180px", false, entityMetadata, copyAndExport, LOCK_STRING, 200);
        allContainer.add((EntryParamContainer)memo);
    }

    private static TextFieldParamContainer getTextFieldParamContainer(String key, String name, String width, boolean hide, EntityMetadata entityMetadata, Features copyAndExport, String lock, int dataLength) {
        TextFieldParamContainer field = new TextFieldParamContainer();
        field.setKey(key);
        field.setName(name);
        field.setWidth(width);
        field.setLock(lock);
        field.setMaxLength(dataLength);
        if (FIXED_FIELD.contains(key)) {
            field.setFixed(true);
        }
        if (hide) {
            field.setVisible("");
        }
        field.setEntityMetadata(entityMetadata);
        field.setFeatures(copyAndExport);
        return field;
    }

    public static Control findControl(List<Control> controls, String key) {
        for (Control control : controls) {
            Control subResult;
            String target = control.getKey();
            if (StringUtils.equals((String)target, (String)key)) {
                return control;
            }
            if (!(control instanceof Container) || (subResult = SocInsuranceAdjustDataViewPlugin.findControl(((Container)control).getItems(), key)) == null) continue;
            return subResult;
        }
        return null;
    }

    private Long getTaskId() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("taskId");
        this.getPageCache().put("taskId", taskId + "");
        return taskId;
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }

    private String getPersonPageId() {
        String personPage = this.getPageCache().get("personPageId");
        if (SITStringUtils.isEmpty((String)personPage)) {
            FormShowParameter formShowParameter = this.getFormShowParameter();
            String personPageId = (String)formShowParameter.getCustomParam("personPageId");
            this.getPageCache().put("personPageId", personPageId);
            return personPageId;
        }
        return personPage;
    }
}

