/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.adjust.export;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.expt.common.plugin.AfterInitContextArgs;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.BeforeQueryPrimaryKeysEventArgs;
import kd.hr.expt.common.plugin.BeforeShowConfirmMessageEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.sit.hcsi.business.caladjust.constants.AdjustDataConstants;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.service.AdjustDataService;
import kd.sit.hcsi.common.vo.InsuranceItemVo;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import org.apache.poi.ss.usermodel.CellStyle;

public class SInsurAdjustDataHRExportPlugin
implements HRExportPlugin {
    private static final Log log = LogFactory.getLog(SInsurAdjustDataHRExportPlugin.class);

    public void beforeShowConfirmMessage(BeforeShowConfirmMessageEventArgs args) {
        long startTime = System.currentTimeMillis();
        log.info("SInsurAdjustDataHRExportPlugin.beforeShowConfirmMessage: progress start.");
        Map extParamMap = AdjustDataService.getExtParams((String)args.getPageId(), (String)"export_adjustdata");
        if (!extParamMap.isEmpty()) {
            String extParams = SerializationUtils.serializeToBase64((Object)extParamMap);
            args.setExtParams(extParams);
        }
        IListView calPersonListView = (IListView)SessionManager.getCurrent().getViewNoPlugin(args.getPageId());
        String billNum = null;
        if (calPersonListView != null) {
            IPageCache pageCache = calPersonListView.getPageCache();
            if (pageCache != null) {
                String key = "export_adjustdatabillNum";
                billNum = pageCache.get(key);
            }
            args.setEntityNameDesc(HCSIErrInfoEnum.ADJUST_DATA_OPERATE_NAME.getErrInfo());
            args.setTips(HCSIErrInfoEnum.ADJUST_DATA_EXPORT_ENTITY_NAME_DES.getErrInfo(new Object[]{billNum}));
        }
        log.info("SInsurAdjustDataHRExportPlugin.beforeShowConfirmMessage: progress end and it cost {} millisecond", (Object)(System.currentTimeMillis() - startTime));
    }

    public void afterInitContext(AfterInitContextArgs args) {
        args.setSerialModel(Boolean.TRUE);
    }

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        long startTime = System.currentTimeMillis();
        log.info("SInsurAdjustDataHRExportPlugin.beforeShowConfirmMessage: progress start.");
        Map extParamMap = AdjustDataService.getExtParamMap((AbstractEventArgs)args);
        Map itemInfoMap = extParamMap.getOrDefault("itemInfoMap", Collections.emptyMap());
        if (extParamMap.isEmpty() || itemInfoMap.isEmpty()) {
            return;
        }
        List headerWriterFormats = args.getHeaderWriterFormats();
        headerWriterFormats.forEach(header -> {
            Map properties = header.getProperties();
            List fields = header.getFields();
            AdjustDataService.createExcelDynamicColumn((Map)itemInfoMap, (List)fields, (Map)properties);
            if (!CollectionUtils.isEmpty((Collection)header.getNext())) {
                header.getNext().forEach(exportHeaderWriterFormat -> exportHeaderWriterFormat.setStartColNumber(exportHeaderWriterFormat.getStartColNumber() + 2));
            }
        });
        log.info("SInsurAdjustDataHRExportPlugin.beforeCreateHeaderColumn: progress end and it cost {} millisecond", (Object)(System.currentTimeMillis() - startTime));
    }

    public void beforeQueryPrimaryKeys(BeforeQueryPrimaryKeysEventArgs args) {
        long startTime = System.currentTimeMillis();
        log.info("SInsurAdjustDataHRExportPlugin.beforeShowConfirmMessage: progress start.");
        QFilter[] qFilters = args.getqFilters();
        ArrayList<Object> filters = null;
        filters = qFilters != null ? new ArrayList<QFilter>(Arrays.asList(qFilters)) : new ArrayList(10);
        filters.add(this.getAuthorizedFilter());
        filters.add(new QFilter("calstatus", "=", (Object)"0"));
        filters.add(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        args.setqFilters(filters.toArray(new QFilter[0]));
        log.info("SInsurAdjustDataHRExportPlugin.beforeQueryPrimaryKeys: progress end and it cost {} millisecond", (Object)(System.currentTimeMillis() - startTime));
    }

    public void afterQueryData(AfterQueryDataEventArgs args) {
        long startTime = System.currentTimeMillis();
        log.info("SInsurAdjustDataHRExportPlugin.beforeShowConfirmMessage: progress start.");
        ArrayList dataList = args.getDataList();
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        dataList = new ArrayList(dataList);
        Set calPersonIds = dataList.stream().map(calPersonDy -> calPersonDy.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", calPersonIds);
        filter.and(this.getAuthorizedFilter());
        DynamicObjectCollection authorizedCalPersonDys = new HRBaseServiceHelper("hcsi_calperson").queryOriginalCollection("id", filter.toArray());
        if (authorizedCalPersonDys == null || authorizedCalPersonDys.isEmpty()) {
            dataList.clear();
            args.setDataList(dataList);
            return;
        }
        Set authorizedCalPersonIds = authorizedCalPersonDys.stream().map(calPersonDy -> calPersonDy.getLong("id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> removeCalPersonDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject calPersonDy2 : dataList) {
            boolean isInvalid;
            boolean bl = isInvalid = !authorizedCalPersonIds.contains(calPersonDy2.getLong("id")) || !"0".equals(calPersonDy2.getString("calstatus")) || !calPersonDy2.getBoolean("isadjust");
            if (isInvalid) {
                removeCalPersonDys.add(calPersonDy2);
                continue;
            }
            DynamicObjectCollection entryEntity = calPersonDy2.getDynamicObjectCollection("entryentity");
            entryEntity.removeIf(entry -> !AdjustDataConstants.ADJUST_DATA_SRC.contains(entry.getString("datasrc")));
            if (!entryEntity.isEmpty()) continue;
            removeCalPersonDys.add(calPersonDy2);
        }
        dataList.removeAll(removeCalPersonDys);
        args.setDataList(dataList);
        log.info("SInsurAdjustDataHRExportPlugin.afterQueryData: progress end and it cost {} millisecond", (Object)(System.currentTimeMillis() - startTime));
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        boolean isInvalid;
        long startTime = System.currentTimeMillis();
        log.info("SInsurAdjustDataHRExportPlugin.beforeShowConfirmMessage: progress start.");
        super.beforeWriteData(args);
        List tplDataRows = args.getTplDataRows();
        Map extParamMap = AdjustDataService.getExtParamMap((AbstractEventArgs)args);
        Long taskId = (Long)extParamMap.get("taskId");
        boolean bl = isInvalid = tplDataRows == null || tplDataRows.isEmpty() || taskId == null || args.getRowDataPkIds() == null;
        if (isInvalid) {
            if (tplDataRows != null) {
                tplDataRows.clear();
            }
            return;
        }
        Map<String, InsuranceItemVo> itemInfoMap = extParamMap.getOrDefault("itemInfoMap", Collections.emptyMap());
        Collection<Map<String, Object>> values = ((Map)tplDataRows.get(0)).values();
        Map<String, CellStyle> itemStyleMap = this.initItemStyleMap(args, itemInfoMap, values);
        HashSet calPersonIds = new HashSet(64);
        args.getRowDataPkIds().values().stream().map(mapItem -> mapItem.get("hcsi_calperson")).forEach(val -> {
            if (val instanceof Long) {
                calPersonIds.add((Long)val);
            } else if (val instanceof Collection) {
                calPersonIds.addAll((Collection)val);
            }
        });
        Map allItemVoMap = extParamMap.getOrDefault("itemInfoMap", Collections.emptyMap());
        String selectCalPersonInfo = "sinsurfilev.boid";
        DynamicObjectCollection calPeronInfos = HRBaseServiceHelper.create((String)"hcsi_calperson").queryOriginalCollection(selectCalPersonInfo, new QFilter("id", "in", calPersonIds).toArray());
        Map<String, BigDecimal> calPersonItemInfoMap = Collections.emptyMap();
        HashMap<String, String> sinsurFileNumberAndRefMemo = new HashMap<String, String>(Collections.emptyMap());
        if (calPeronInfos != null && calPeronInfos.size() > 0) {
            calPersonItemInfoMap = new HashMap(calPeronInfos.size());
            Set sinsurFileBoIds = calPeronInfos.stream().map(calPeronDy -> calPeronDy.getLong("sinsurfilev.boid")).collect(Collectors.toSet());
            QFilter filter = new QFilter("sinsurtask.id", "=", (Object)taskId);
            filter.and("sinsurfile.id", "in", sinsurFileBoIds);
            DynamicObjectCollection adjustData = HRBaseServiceHelper.create((String)"hcsi_sinsuradjdata").queryOriginalCollection("sinsurfile.id,sinsurfile.number,insuranceitem.number,adjvalue", filter.toArray());
            if (adjustData != null && adjustData.size() > 0) {
                for (DynamicObject detailAdjustData : adjustData) {
                    String fileNumber = detailAdjustData.getString("sinsurfile.number");
                    String insuranceItemNumber = detailAdjustData.getString("insuranceitem.number");
                    BigDecimal itemVal = detailAdjustData.getBigDecimal("adjvalue");
                    if (itemVal == null) continue;
                    if (itemVal.compareTo(BigDecimal.ZERO) == 0) {
                        itemVal = BigDecimal.ZERO;
                    }
                    calPersonItemInfoMap.put(fileNumber + "," + insuranceItemNumber, itemVal);
                }
            }
            String fields = "sinsurfile.id,sinsurfile.number,memo";
            DynamicObject[] adjDataDys = HRBaseServiceHelper.create((String)"hcsi_sinsuradjrec").query(fields, new QFilter[]{filter});
            if (adjDataDys != null && adjDataDys.length > 0) {
                sinsurFileNumberAndRefMemo = new HashMap(adjDataDys.length);
                for (DynamicObject adjDataDy : adjDataDys) {
                    String sinsurFileNumber = adjDataDy.getString("sinsurfile.number");
                    if (sinsurFileNumber == null) continue;
                    sinsurFileNumberAndRefMemo.put(sinsurFileNumber, adjDataDy.getString("memo"));
                }
            }
        }
        AdjustDataService.rebuildExportedData((List)tplDataRows, allItemVoMap, calPersonItemInfoMap, sinsurFileNumberAndRefMemo, itemStyleMap);
        log.info("SInsurAdjustDataHRExportPlugin.beforeWriteData: progress end and it cost {} millisecond", (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<String, CellStyle> initItemStyleMap(BeforeWriteDataEventArgs args, Map<String, InsuranceItemVo> itemInfoMap, Collection<Map<String, Object>> values) {
        HashMap<String, CellStyle> itemStyleMap = new HashMap<String, CellStyle>(16);
        for (Map<String, Object> itemMap : values) {
            CellStyle style;
            String columnNumber = (String)itemMap.get("key");
            InsuranceItemVo insuranceItemVo = itemInfoMap.get(columnNumber);
            if (insuranceItemVo == null || (style = (CellStyle)itemMap.get("style")) == null || args.getSheetStyle() == null) continue;
            Integer scale = insuranceItemVo.getScale();
            scale = scale == null ? Integer.valueOf(0) : scale;
            String format = "0";
            StringBuilder subFormat = new StringBuilder("0.");
            for (int i = 1; i <= scale; ++i) {
                subFormat.append('0');
            }
            if (scale > 0) {
                format = subFormat.toString();
            }
            CellStyle newStyle = args.getSheetStyle().buildNewStyle4Format(style, true, format);
            itemStyleMap.put(columnNumber, newStyle);
        }
        return itemStyleMap;
    }

    private QFilter getAuthorizedFilter() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        List exportAdjustDataFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)"export_adjustdata");
        if (exportAdjustDataFilter == null) {
            filter = new QFilter("1", "!=", (Object)1);
        } else {
            exportAdjustDataFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        return filter;
    }
}

