/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.adjust.imported;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterImportCompleteArgs;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.AfterTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.service.AdjustDataService;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.hcsi.formplugin.web.cal.adjust.imported.IgnoreDataRulePermValidator;
import kd.sit.hcsi.formplugin.web.cal.adjust.imported.SInsurAdjustDataValidator;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;

public class SInsurAdjustDataHRImportPlugin
implements HRImportPlugin {
    private static final Log log = LogFactory.getLog(SInsurAdjustDataHRImportPlugin.class);
    private static final String ADJUST_DATA_OP_KEY = SocialOperationEnum.OP_IMPORT_ADJUSTDATA.getOperationKey();

    public void afterLoadStartPage(AfterLoadStartPageEventArgs args) {
        Map extParamMap = AdjustDataService.getExtParams((String)args.getPageId(), (String)ADJUST_DATA_OP_KEY);
        if (!extParamMap.isEmpty()) {
            String extParams = SerializationUtils.serializeToBase64((Object)extParamMap);
            args.setExtParams(extParams);
        }
    }

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        Map itemInfoMap = AdjustDataService.getSInsuranceItemDys((AbstractEventArgs)args);
        if (itemInfoMap.isEmpty()) {
            return;
        }
        List headerWriterFormats = args.getHeaderWriterFormats();
        headerWriterFormats.forEach(header -> {
            Map properties = header.getProperties();
            List fields = header.getFields();
            AdjustDataService.createExcelDynamicColumn((Map)itemInfoMap, (List)fields, (Map)properties);
            if (!CollectionUtils.isEmpty((Collection)header.getNext())) {
                header.getNext().forEach(exportHeaderWriterFormat -> exportHeaderWriterFormat.setStartColNumber(exportHeaderWriterFormat.getStartColNumber() + 2));
            }
        });
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        Set ignoreValidateFields = AdjustDataService.getItemInfoMap(null).keySet();
        HashMap ignoreValidateMap = new HashMap(1);
        ignoreValidateMap.put("hcsi_calperson", new ArrayList(ignoreValidateFields));
        args.setIgnoreValidateMap(ignoreValidateMap);
    }

    public void afterTemplateValidate(AfterTemplateValidateEventArgs args) {
        Map entityFields = args.getEntityFields();
        Collection fields = entityFields.getOrDefault("hcsi_calperson", Collections.emptyList());
        LinkedHashSet lastFields = new LinkedHashSet(fields.size());
        Set repeatedFields = fields.stream().filter(field -> !lastFields.add(field)).collect(Collectors.toCollection(LinkedHashSet::new));
        String repeatedFieldStr = String.join((CharSequence)HCSIErrInfoEnum.COMMON_CHINA_COMMA.getErrInfo(), repeatedFields);
        if (repeatedFieldStr.length() > 0) {
            args.setErrorMsg(HCSIErrInfoEnum.ADJUST_DATA_IMPORT_FIELD_REPEATED.getErrInfo(new Object[]{repeatedFieldStr}));
        }
    }

    public void afterInitContext(AfterInitContextArgs args) {
        String parentPageId = (String)AdjustDataService.getExtParamMap((AbstractEventArgs)args).get("parentPageId");
        if (parentPageId == null) {
            return;
        }
        try {
            ISITAppCache importAdjustDataCache = SITAppCache.get((String)(parentPageId + "isImportAdjustData"));
            importAdjustDataCache.put("isImportAdjustData", (Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            log.error("SInsurAdjustDataHRImportPlugin.afterDoOperation: get importAdjustDataCache error and info is ", (Throwable)ex);
        }
        args.setSubmitOP("donothing_import_adjust_data");
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        Map extParamMap = AdjustDataService.getExtParamMap((AbstractEventArgs)args);
        args.setValidator(ValidatorEnum.DATA_RULE_PERM_VALIDATOR, (AbstractValidateHandler)new IgnoreDataRulePermValidator());
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new SInsurAdjustDataValidator(extParamMap));
    }

    public void beforeLoadEntity(BeforeLoadEntityEventArgs args) {
        Object taskId = AdjustDataService.getExtParamMap((AbstractEventArgs)args).get("taskId");
        QFilter filter = new QFilter("sinsurtask", "=", taskId);
        args.getCommonFilters().add(filter);
    }

    public void afterImportComplete(AfterImportCompleteArgs args) {
        this.releaseMutexLock((AbstractEventArgs)args);
        String parentPageId = (String)AdjustDataService.getExtParamMap((AbstractEventArgs)args).get("parentPageId");
        IFormView calPersonListView = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        if (calPersonListView != null) {
            calPersonListView.invokeOperation("refresh");
        }
        log.info("SInsurAdjustDataHRImportPlugin.afterImportComplete: begin.");
    }

    private void releaseMutexLock(AbstractEventArgs args) {
        Map extParamMap = AdjustDataService.getExtParamMap((AbstractEventArgs)args);
        Object taskId = extParamMap.get("taskId");
        String parentPageId = (String)extParamMap.get("parentPageId");
        log.info("SInsurAdjustDataHRImportPlugin.releaseMutexLock: begin.");
        if (parentPageId != null) {
            try {
                ISITAppCache importAdjustDataCache = SITAppCache.get((String)(parentPageId + "isImportAdjustData"));
                importAdjustDataCache.remove("isImportAdjustData");
                if (Boolean.TRUE.equals(importAdjustDataCache.get("importTaskRunBack", Boolean.class))) {
                    MutexServiceHelper.releaseForce((String)"hcsi_sinsurtask", (String)String.valueOf(taskId), (String)ADJUST_DATA_OP_KEY);
                    importAdjustDataCache.clear();
                    log.info("SInsurAdjustDataHRImportPlugin.releaseMutexLock: end.");
                }
            }
            catch (Exception ex) {
                log.error("SInsurAdjustDataHRImportPlugin.releaseMutexLock: releaseMutexLock error and info is ", (Throwable)ex);
            }
        }
    }
}

