/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.adjust.imported;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.sit.hcsi.business.cal.service.InsuranceStandardService;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.caladjust.service.AdjustDataService;
import kd.sit.hcsi.common.vo.InsuranceItemVo;
import kd.sit.sitbp.business.servicehelper.SITMultithreadedQueryHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.TruncationEnum;
import kd.sit.sitbp.common.model.Pair;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SInsurAdjustDataValidator
extends AbstractValidateHandler {
    private static final Log log = LogFactory.getLog(SInsurAdjustDataValidator.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private ImportLog logger;
    private Collection<Long> insurStdVIds;
    private Long taskId;
    private Map<String, InsuranceItemVo> itemInfoMap;

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> billDataList, ImportLog logger) {
        this.logger = logger;
        this.savaAdjustData(billDataList);
    }

    public SInsurAdjustDataValidator(Map<String, Object> extParamMap) {
        this.insurStdVIds = extParamMap.getOrDefault("insuredStandardVIds", Collections.emptyList());
        this.itemInfoMap = extParamMap.getOrDefault("itemInfoMap", Collections.emptyMap());
        this.taskId = (Long)extParamMap.get("taskId");
    }

    public void savaAdjustData(List<ImportBillData> billDataList) {
        Table stdIdAndInsurItemIdAndRoundTypeInStdTable = InsuranceStandardService.getInsuranceStandardBy(this.insurStdVIds, null);
        Set sInsurFileNumberSet = billDataList.stream().map(SInsurAdjustDataValidator::getSInsurFileNumber).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        HashBasedTable calPersonIdAndDetailInfoInDbBasedTable = HashBasedTable.create((int)billDataList.size(), (int)16);
        HashBasedTable calPersonIdAndDetailInfoInExcelBasedTable = HashBasedTable.create((int)billDataList.size(), (int)16);
        HashMap<String, Long> sInsurFileNumberAndCalPersonIdMap = new HashMap<String, Long>(billDataList.size());
        AdjustDataService.getCalPersonInfo((Long)this.getTaskId(), sInsurFileNumberSet, (Table)calPersonIdAndDetailInfoInDbBasedTable, sInsurFileNumberAndCalPersonIdMap, (Table)stdIdAndInsurItemIdAndRoundTypeInStdTable);
        List authorizedCalPersonQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)"47150e89000000ac");
        log.info("SInsurAdjustDataValidator.savaAdjustData: authorizedCalPersonQFilters info is \"{}\"", CollectionUtils.isEmpty((Collection)authorizedCalPersonQFilters) ? null : ((QFilter)authorizedCalPersonQFilters.get(0)).toString());
        Set<Long> authorizedCalPersonSet = new HashSet<Long>(0);
        if (authorizedCalPersonQFilters != null && authorizedCalPersonQFilters.size() > 0) {
            List calPersonIds = calPersonIdAndDetailInfoInDbBasedTable.rowKeySet().stream().map(id -> (Long)id).collect(Collectors.toList());
            try {
                DynamicObject[] calPersonDys = SITMultithreadedQueryHelper.getInstance().getData("hcsi_calperson", "id", calPersonIds, (QFilter)authorizedCalPersonQFilters.get(0), "id desc");
                authorizedCalPersonSet = Arrays.stream(calPersonDys).map(calPersonDy -> calPersonDy.getLong("id")).collect(Collectors.toSet());
            }
            catch (InterruptedException ex) {
                log.error("SInsurAdjustDataValidator.savaAdjustData: ", (Throwable)ex);
            }
        }
        for (ImportBillData billData : billDataList) {
            this.checkAndCollectData(billData, authorizedCalPersonSet, (Table<Object, String, Object>)calPersonIdAndDetailInfoInDbBasedTable, sInsurFileNumberAndCalPersonIdMap, (Table<Object, String, Object>)calPersonIdAndDetailInfoInExcelBasedTable);
            ConcurrentHashMap errorInfos = this.getLogger().getRowErrors();
            if (errorInfos == null || !errorInfos.getOrDefault(billData.getSheetName(), new ConcurrentHashMap(0)).containsKey(billData.getStartIndex())) continue;
            log.info("SInsurAdjustDataValidator.savaAdjustData: current error bill data is {}", (Object)JSONObject.toJSONString((Object)this.getEntityData(billData)));
        }
        log.info("SInsurAdjustDataValidator.savaAdjustData: begin to save data.");
        AdjustDataService.saveAdjustData((Long)this.getTaskId(), (Table)calPersonIdAndDetailInfoInExcelBasedTable, (Table)calPersonIdAndDetailInfoInDbBasedTable);
    }

    private void checkAndCollectData(ImportBillData billData, Set<Long> authorizedCalPersonSet, Table<Object, String, Object> calPersonIdAndDetailInfoInDbBasedTable, Map<String, Long> sInsurFileNumberAndCalPersonIdMap, Table<Object, String, Object> calPersonIdAndDetailInfoInExcelBasedTable) {
        boolean isMemoInvalid;
        Map<String, Object> itemInfo;
        Map<String, InsuranceItemVo> lastValidItems;
        boolean isLastItemInValid;
        Pair<Long, String> calPersonIdAndRefFileNumber = this.checkFileAndGetCalPersonIdAndRefFileNumber(billData, authorizedCalPersonSet, calPersonIdAndDetailInfoInDbBasedTable, sInsurFileNumberAndCalPersonIdMap);
        if (calPersonIdAndRefFileNumber == null) {
            log.info("SInsurAdjustDataValidator.checkAndCollectData, calPersonIdAndRefFileNumber is empty.");
            return;
        }
        boolean isItemInvalid = false;
        HashBasedTable tmpCalPersonIdAndDetailInfoBasedTable = HashBasedTable.create();
        JSONObject jsonData = this.getEntityData(billData);
        String memo = jsonData.getString("memo");
        boolean isMemoOutRange = false;
        boolean currLineEmpty = SITStringUtils.isEmpty((String)memo);
        if (!currLineEmpty) {
            if ((memo = memo.trim()).length() > 200) {
                isMemoOutRange = true;
            } else {
                tmpCalPersonIdAndDetailInfoBasedTable.put(calPersonIdAndRefFileNumber.getKey(), (Object)"memo", (Object)memo);
                currLineEmpty = false;
            }
        }
        if (isLastItemInValid = this.checkLastItemAndGetData(billData, calPersonIdAndDetailInfoInExcelBasedTable, (Table<Object, String, Object>)tmpCalPersonIdAndDetailInfoBasedTable, isMemoOutRange, currLineEmpty, lastValidItems = this.checkAndGetValidItems(billData, itemInfo = calPersonIdAndDetailInfoInDbBasedTable.rowMap().getOrDefault(calPersonIdAndRefFileNumber.getKey(), Collections.emptyMap()), isMemoInvalid = isMemoOutRange || currLineEmpty))) {
            return;
        }
        LinkedHashMap<HCSIErrInfoEnum, StringJoiner> errFieldMap = new LinkedHashMap<HCSIErrInfoEnum, StringJoiner>(16);
        for (InsuranceItemVo insuranceItemVo : lastValidItems.values()) {
            String itemIdStr = String.valueOf(insuranceItemVo.getId());
            String currItemVal = jsonData.getString(insuranceItemVo.getNumber());
            if (currItemVal != null) {
                currItemVal = currItemVal.replaceAll(",", "");
            }
            Object preVal = itemInfo.get(itemIdStr);
            if (StringUtils.isEmpty((CharSequence)currItemVal) || preVal == null) continue;
            boolean isTmplInvalid = this.isInvalidNumerical(currItemVal, insuranceItemVo.getName(), errFieldMap);
            if (isTmplInvalid) {
                isItemInvalid = true;
                continue;
            }
            currLineEmpty = false;
            BigDecimal insurItemVal = new BigDecimal(currItemVal);
            if (isItemInvalid) continue;
            Object roundTypeVal = itemInfo.get(itemIdStr + "roundtype");
            BigDecimal bigDecimalValue = roundTypeVal != null ? TruncationEnum.getBigDecimalValue((BigDecimal)insurItemVal, (String)String.valueOf(roundTypeVal)) : insurItemVal.setScale((int)insuranceItemVo.getScale(), insuranceItemVo.getRound());
            String isNull = itemIdStr + "isnull";
            boolean preValIsNull = Boolean.TRUE.equals(itemInfo.get(isNull));
            if (!preValIsNull && bigDecimalValue.compareTo((BigDecimal)preVal) == 0) continue;
            tmpCalPersonIdAndDetailInfoBasedTable.put(calPersonIdAndRefFileNumber.getKey(), (Object)itemIdStr, (Object)bigDecimalValue);
        }
        boolean lastInfoInvalid = this.checkAndGetLastInfo(billData, isItemInvalid, (Table<Object, String, Object>)tmpCalPersonIdAndDetailInfoBasedTable, isMemoOutRange, currLineEmpty, errFieldMap);
        if (lastInfoInvalid) {
            return;
        }
        calPersonIdAndDetailInfoInExcelBasedTable.putAll((Table)tmpCalPersonIdAndDetailInfoBasedTable);
    }

    private Pair<Long, String> checkFileAndGetCalPersonIdAndRefFileNumber(ImportBillData billData, Set<Long> authorizedCalPersonSet, Table<Object, String, Object> calPersonIdAndDetailInfoInDbBasedTable, Map<String, Long> sInsurFileNumberAndCalPersonIdMap) {
        Optional<String> sInsurFileNumberOp = SInsurAdjustDataValidator.getSInsurFileNumber(billData);
        Long calPersonId = null;
        String sInsurFileNumber = null;
        if (sInsurFileNumberOp.isPresent()) {
            sInsurFileNumber = sInsurFileNumberOp.get();
            calPersonId = sInsurFileNumberAndCalPersonIdMap.get(sInsurFileNumber);
            if (calPersonId == null) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.IMPORT_ADJUST_DATA_FILE_ERROR.getErrInfo());
                return null;
            }
            if (!calPersonIdAndDetailInfoInDbBasedTable.containsRow((Object)calPersonId)) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.IMPORT_ITEM_DATA_SRC_ERROR.getErrInfo());
                return null;
            }
            if (!authorizedCalPersonSet.contains(calPersonId)) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.ADJUST_DATA_IMPORT_WITHOUT_PERMISSION.getErrInfo());
                return null;
            }
        }
        if (calPersonId != null && sInsurFileNumber != null) {
            return new Pair((Object)calPersonId, (Object)sInsurFileNumber);
        }
        return null;
    }

    private Map<String, InsuranceItemVo> checkAndGetValidItems(ImportBillData billData, Map<String, Object> itemInfo, boolean isMemoInvalid) {
        HashMap<String, InsuranceItemVo> validItems = new HashMap<String, InsuranceItemVo>(this.getItemInfoMap());
        Map<String, InsuranceItemVo> lastValidItems = validItems.values().stream().collect(Collectors.toMap(itemVo -> String.valueOf(itemVo.getId()), itemVo -> itemVo, (oldVal, newVal) -> oldVal));
        lastValidItems.keySet().retainAll(itemInfo.keySet());
        if (lastValidItems.isEmpty()) {
            if (!isMemoInvalid) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.IMPORT_ADJUST_DATA_ITEM_INVALID.getErrInfo());
            }
            return Collections.emptyMap();
        }
        JSONObject jsonData = this.getEntityData(billData);
        lastValidItems.entrySet().removeIf(entry -> entry == null || entry.getValue() == null || !jsonData.containsKey((Object)((InsuranceItemVo)entry.getValue()).getNumber()));
        return lastValidItems;
    }

    public boolean isInvalidNumerical(String insurItemVal, String itemName, Map<HCSIErrInfoEnum, StringJoiner> errFieldMap) {
        if (insurItemVal == null || !NUMBER_PATTERN.matcher(insurItemVal).matches()) {
            this.recordErrField(errFieldMap, HCSIErrInfoEnum.ADJUST_DATA_IMPORT_DATA_IS_NOT_NUMERICAL, itemName);
            return true;
        }
        String[] split = insurItemVal.split("\\.");
        if (split[0].length() > 13) {
            this.recordErrField(errFieldMap, HCSIErrInfoEnum.ADJUST_DATA_IMPORT_DATA_OUT_OF_RANGE, itemName);
            return true;
        }
        if (split.length == 2 && split[1].length() > 10) {
            this.recordErrField(errFieldMap, HCSIErrInfoEnum.ADJUST_DATA_IMPORT_DATA_OUT_OF_RANGE, itemName);
            return true;
        }
        return false;
    }

    private void loggerErrInfo(ImportBillData billData, String errInfo) {
        this.getLogger().writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errInfo);
    }

    private void recordErrField(Map<HCSIErrInfoEnum, StringJoiner> errFieldMap, HCSIErrInfoEnum hcsiErrInfoEnum, String itemName) {
        errFieldMap.computeIfAbsent(hcsiErrInfoEnum, key -> new StringJoiner(HCSIErrInfoEnum.COMMON_CHINA_COMMA.getErrInfo())).add(itemName);
    }

    public ImportLog getLogger() {
        return this.logger;
    }

    public Collection<Long> getInsurStdVIds() {
        return this.insurStdVIds;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public Map<String, InsuranceItemVo> getItemInfoMap() {
        return this.itemInfoMap;
    }

    public JSONObject getEntityData(ImportBillData billData) {
        if (billData == null || billData.getData() == null || billData.getData().getJSONObject("hcsi_calperson") == null) {
            return new JSONObject();
        }
        return billData.getData().getJSONObject("hcsi_calperson");
    }

    public static Optional<String> getSInsurFileNumber(ImportBillData billData) {
        return Optional.ofNullable(billData).map(ImportBillData::getData).map(data -> data.getJSONObject("hcsi_calperson")).map(json -> json.getString("filenumberdb"));
    }

    private boolean checkLastItemAndGetData(ImportBillData billData, Table<Object, String, Object> calPersonIdAndDetailInfoInExcelBasedTable, Table<Object, String, Object> tmpCalPersonIdAndDetailInfoBasedTable, boolean isMemoOutRange, boolean currLineEmpty, Map<String, InsuranceItemVo> lastValidItems) {
        if (lastValidItems.isEmpty()) {
            if (isMemoOutRange) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.ADJUST_DATA_IMPORT_MEMO_OUT_OF_RANGE.getErrInfo(new Object[]{200}));
            } else if (!currLineEmpty && !isMemoOutRange) {
                calPersonIdAndDetailInfoInExcelBasedTable.putAll(tmpCalPersonIdAndDetailInfoBasedTable);
            } else if (currLineEmpty) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.IMPORT_ADJUST_DATA_ITEM_VALUE_EMPTY.getErrInfo());
            }
            log.info("SInsurAdjustDataValidator.checkAndCollectData, lastValidItems: {}", lastValidItems);
            return true;
        }
        return false;
    }

    private boolean checkAndGetLastInfo(ImportBillData billData, boolean isItemInvalid, Table<Object, String, Object> tmpCalPersonIdAndDetailInfoBasedTable, boolean isMemoOutRange, boolean currLineEmpty, Map<HCSIErrInfoEnum, StringJoiner> errFieldMap) {
        if (isItemInvalid || currLineEmpty || isMemoOutRange) {
            tmpCalPersonIdAndDetailInfoBasedTable.clear();
            if (isMemoOutRange) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.ADJUST_DATA_IMPORT_MEMO_OUT_OF_RANGE.getErrInfo(new Object[]{200}));
            }
            if (isItemInvalid) {
                for (Map.Entry<HCSIErrInfoEnum, StringJoiner> subEntry : errFieldMap.entrySet()) {
                    this.loggerErrInfo(billData, subEntry.getKey().getErrInfo(new Object[]{subEntry.getValue().toString()}));
                }
            } else if (!isMemoOutRange && currLineEmpty) {
                this.loggerErrInfo(billData, HCSIErrInfoEnum.IMPORT_ADJUST_DATA_ITEM_VALUE_EMPTY.getErrInfo());
            }
            log.info("SInsurAdjustDataValidator.checkAndCollectData, isItemInvalid or currLineEmpty: {}", (Object)JSONObject.toJSONString((Object)this.getEntityData(billData)));
            return true;
        }
        return false;
    }
}

