/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SummaryToField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SumDataLoadOnFirstSetEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.entity.cal.InsuredStandard;
import kd.sdk.sit.hcsi.formplugin.cal.detail.ICalPersonListAutoSumPlugin;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.service.DisplaySchemeService;
import kd.sit.hcsi.business.cal.service.SocialDetailResultService;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.helper.qfilter.UpdateQFilterHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.tab.UpdateTabNameHelper;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.model.SitEntityTypeBillList;
import kd.sit.sitbp.common.util.SITStringUtils;

public class CalPersonBaseTplList
extends AbstractListPlugin {
    private final Log log = LogFactory.getLog(CalPersonBaseTplList.class);
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String CURRENCY_KEY = "salarydetailcurrency_c";
    private SitEntityTypeBillList billList;
    private IFormView pageView;

    public void sumDataLoadOnFirstSet(SumDataLoadOnFirstSetEvent args) {
        if (!this.isFromAdjustPage().booleanValue() && this.getIsAutoSum()) {
            args.setSumDataLoadOnFirst(true);
        }
    }

    private boolean getIsAutoSum() {
        ICalPersonListAutoSumPlugin defaultPlugin = new ICalPersonListAutoSumPlugin(){

            public boolean isAutoSum() {
                return false;
            }
        };
        AtomicBoolean isAutoSum = new AtomicBoolean(false);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)defaultPlugin, ICalPersonListAutoSumPlugin.class, (String)"kd.sdk.sit.hcsi.formplugin.cal.detail.ICalPersonListAutoSumPlugin#isAutoSum", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            isAutoSum.set(proxy.isAutoSum());
            return null;
        });
        return isAutoSum.get();
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"periodname", "welfarename"});
    }

    public void beforeBindData(EventObject evt) {
        String formId;
        super.beforeBindData(evt);
        Long displaySchId = this.getDisplaySchemaId();
        if (displaySchId != null) {
            HashMap<String, String> paramMap = new HashMap<String, String>(1);
            paramMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiLl8xZVhPV285NiB7XG4gICBkaXNwbGF5Om5vbmU7XG59XG4ifQ");
            this.getView().updateControlMetadata(KEY_BILL_LIST_AP, paramMap);
        }
        if (HRStringUtils.equals((String)"hcsi_calpersonlist", (String)(formId = this.getView().getFormShowParameter().getFormId()))) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Label welfarLable = (Label)this.getControl("welfarename");
            Label periodLable = (Label)this.getControl("periodname");
            Label taskNumberLable = (Label)this.getControl("tasknumber");
            welfarLable.setText((String)customParams.get("welfarename"));
            periodLable.setText((String)customParams.get("periodname"));
            taskNumberLable.setText((String)customParams.get("tasknumber"));
            UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)((String)customParams.get("tasknumber")));
        }
    }

    public void getEntityType(GetEntityTypeEventArgs event) {
        super.getEntityType(event);
        event.setNewEntityType(this.getEntityType());
    }

    public void onGetControl(OnGetControlArgs event) {
        super.onGetControl(event);
        String key = event.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            event.setControl((Control)customControl);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        String appNumber = AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getAppId());
        Optional permOrgsOpt = SITPermissionServiceHelper.getPermOrgsOpt((String)"31", (String)appNumber, (String)"hcsi_sinsurtask", (String)"47150e89000000ac");
        Optional permOrgs = SITPermissionServiceHelper.getPermOrgsOpt((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)"47150e89000000ac");
        switch (fieldName) {
            case "welfarepayer.name": 
            case "welfarepayer.id": 
            case "sinsurfilev.welfarepayertheory.name": 
            case "sinsurfilev.welfarepayertheory.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("org", "in", orgs)));
                break;
            }
            case "sinsurstdv.name": 
            case "sinsurstdv.id": {
                permOrgsOpt.ifPresent(orgIds -> filters.add(SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_sinsurstd", (List)orgIds, (boolean)true)));
                break;
            }
            case "empgroup.name": 
            case "empgroup.id": {
                List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
                QFilter empGroupFilter = new QFilter("id", "in", (Object)empgoupIds);
                filters.add(empGroupFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "periodname": {
                String periodId = (String)this.getView().getFormShowParameter().getCustomParam("periodid");
                this.viewBaseData("sitbs_sinsurperiod", Long.parseLong(periodId), "sitbs_sinsurperiod");
                break;
            }
            case "welfarename": {
                String welfareId = (String)this.getView().getFormShowParameter().getCustomParam("welfareid");
                this.viewBaseData("sitbs_welfarepayer", Long.parseLong(welfareId), "sitbs_welfarepayer");
                break;
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        this.log.info("beforeCreateListColumns begin");
        long startTime = System.currentTimeMillis();
        Long displaySchId = this.getDisplaySchemaId();
        String orderBy = "sinsurfilev.number asc";
        Set freezeColSet = null;
        List<IListColumn> newColumns = null;
        if (displaySchId == null) {
            newColumns = this.loadCalResultDetailInfo(columns);
            freezeColSet = new HashSet<String>(16);
            freezeColSet.add("filenumberdb");
            freezeColSet.add("namedb");
            freezeColSet.add("empnumberdb");
            freezeColSet.add("sinsurperiod.name");
        } else {
            UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"hcsi_calperson");
            Map resultMap = DisplaySchemeService.getDisplaySchemaInfoListFromCacheOrDB((Long)displaySchId, (IFormView)this.getView());
            String order = (String)resultMap.get("orderBy");
            if (SITStringUtils.isNotEmpty((String)order)) {
                orderBy = order;
            }
            if ((freezeColSet = (Set)resultMap.get("freezeColSet")) == null) {
                freezeColSet = new HashSet(0);
            }
            newColumns = this.loadDisplaySchColumn(columns, resultMap);
        }
        args.setListColumns(newColumns);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        billList.setOrderBy(orderBy);
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("beforeCreateListColumns end,cost time {}", (Object)costTime);
        this.log.info("freezeCol = {},billId = {},order by = {}", new Object[]{freezeColSet.toString(), this.getCurrentEntity(), orderBy});
        for (IListColumn iListColumn : args.getListColumns()) {
            String listFieldKey = iListColumn.getListFieldKey();
            if (!freezeColSet.contains(listFieldKey)) continue;
            iListColumn.setFixed(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.log.info("beforeCreateListDataProvider begin");
        long startTime = System.currentTimeMillis();
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CalDetailResultLoadDataImpl());
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("beforeCreateListDataProvider end,cost time {}", (Object)costTime);
    }

    public void setFilter(SetFilterEvent event) {
        UpdateQFilterHelper.updateQFilter((List)event.getQFilters(), (String)"sinsurstdv.id", (String)"sinsurstdv.name", (String)"sitbs_sinsurstd");
        Long taskId = this.getSInsurTaskId();
        QFilter filter = new QFilter("sinsurtask", "=", (Object)taskId);
        QFilter authorizedDataRuleQFilter = SocialInsuranceCalHelper.getAuthorizedDataRuleQFilterOf((String)"hcsi_calperson", (String)"4");
        filter.and(authorizedDataRuleQFilter);
        event.getQFilters().add(filter);
        event.setOrderBy(this.getOrderBy());
    }

    private String getOrderBy() {
        String orderBy = "sinsurfilev.number asc";
        Long displaySchId = this.getDisplaySchemaId();
        if (displaySchId == null) {
            return orderBy;
        }
        Map resultMap = DisplaySchemeService.getDisplaySchemaInfoListFromCacheOrDB((Long)displaySchId, (IFormView)this.getView());
        String order = (String)resultMap.get("orderBy");
        if (SITStringUtils.isNotEmpty((String)order)) {
            orderBy = order;
        }
        this.log.info("order by = {}", (Object)orderBy);
        return orderBy;
    }

    private List<InsuredStandard> getInsuredStandardList() {
        this.log.info("CalPersonBaseTplList.getInsuredStandardList: start getInsuredStandardList");
        long startTime = System.currentTimeMillis();
        List dataList = SocialInsuranceCalHelper.getInsuranceItemAndCombinedItemInfoGroupByTask((Long)this.getSInsurTaskId(), (boolean)true);
        this.log.info("CalPersonBaseTplList.getInsuredStandardList: getInsuredStandardList finish,cost:{} ms", (Object)(System.currentTimeMillis() - startTime));
        return dataList;
    }

    protected String getCurrentEntity() {
        return ((ListView)this.getView()).getBillFormId();
    }

    private void setHigLightColor(Map<Integer, Set<String>> resultCoverMap, String highlightColor) {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(resultCoverMap.size());
        for (Map.Entry<Integer, Set<String>> entry : resultCoverMap.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            for (String columnKey : entry.getValue()) {
                CellStyle cs = new CellStyle();
                cs.setFieldKey(columnKey);
                cs.setForeColor(highlightColor);
                cs.setRow(entry.getKey().intValue());
                cellStyleList.add(cs);
            }
        }
        billList.setCellStyle(cellStyleList);
    }

    private MainEntityType getEntityType() {
        EntityMetadataCache.getDataEntityTypeNoCache((String)this.getCurrentEntity());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getCurrentEntity());
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            this.log.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        long startTime = System.currentTimeMillis();
        Long displaySchId = this.getDisplaySchemaId();
        List<InsuredStandard> insuredStandardList = null;
        if (displaySchId == null) {
            insuredStandardList = this.getInsuredStandardList();
        } else {
            Map resultMap = DisplaySchemeService.getDisplaySchemaInfoListFromCacheOrDB((Long)displaySchId, (IFormView)this.getView());
            List insuranceItemList = (List)resultMap.get("insuranceItemList");
            List sumItemList = (List)resultMap.get("sumItemList");
            insuredStandardList = new ArrayList<InsuredStandard>(10);
            insuredStandardList.addAll(insuranceItemList);
            insuredStandardList.addAll(sumItemList);
        }
        this.pageView = this.getView();
        long endTime = System.currentTimeMillis();
        this.log.info("getEntityType insuredStandardList use time: {}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        this.addItemProp(insuredStandardList, (DynamicObjectType)mainEntityType);
        endTime = System.currentTimeMillis();
        this.log.info("getEntityType addItemProp use time: {}", (Object)(endTime - startTime));
        return mainEntityType;
    }

    private BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new SitEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId(this.getCurrentEntity());
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        long startTime = System.currentTimeMillis();
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        long endTime = System.currentTimeMillis();
        this.log.info("createBillList replaceBillList use time:" + (endTime - startTime));
        return this.billList;
    }

    private Long getDisplaySchemaId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("displaySchId");
    }

    private Long getSInsurTaskId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
    }

    private Boolean isFromAdjustPage() {
        String pageFrom = (String)this.getView().getFormShowParameter().getCustomParam("pageFrom");
        return "adjustPage".equals(pageFrom);
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private void addItemProp(List<InsuredStandard> insuredStandardList, DynamicObjectType mainEntityType) {
        if (insuredStandardList == null || insuredStandardList.size() == 0) {
            return;
        }
        for (InsuredStandard insuredStandard : insuredStandardList) {
            TextProp property;
            Long insuredItemId = insuredStandard.getInsuredItemId();
            String insuredItemName = insuredStandard.getInsuredItemName();
            Long dataTypeId = insuredStandard.getDataTypeId();
            int dataLength = insuredStandard.getDataLength();
            int scale = insuredStandard.getScale();
            String columnKey = String.valueOf(insuredItemId);
            if (dataTypeId.equals(SitDataTypeEnum.TEXT.getId())) {
                property = this.getTextProp(dataLength, insuredItemName, columnKey);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (dataTypeId.equals(SitDataTypeEnum.NUMBER.getId()) || dataTypeId.equals(SitDataTypeEnum.AMOUNT.getId())) {
                property = this.getDecimalProp(scale, insuredItemName, columnKey);
                SummaryToField summaryToField = new SummaryToField();
                summaryToField.setFieldId(columnKey);
                summaryToField.setFieldKey(columnKey);
                summaryToField.setFieldName(insuredItemName);
                summaryToField.setSumType(1);
                property.setSummaryToField(summaryToField);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (!dataTypeId.equals(SitDataTypeEnum.DATE.getId())) continue;
            property = new DateProp();
            property.setName(columnKey);
            property.setDisplayName(new LocaleString(insuredItemName));
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    private List<IListColumn> loadCalResultDetailInfo(List<IListColumn> columns) {
        long startTime = System.currentTimeMillis();
        List<InsuredStandard> insuredStandardList = this.getInsuredStandardList();
        this.addItemColumn(insuredStandardList, columns);
        long endTime = System.currentTimeMillis();
        this.log.info("CalPersonBaseTplList.loadCalResultDetailInfo addItemColumn use time: {}", (Object)(endTime - startTime));
        return columns;
    }

    private ListColumn createListColumn(String key, String caption) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        return col;
    }

    private void addItemColumn(List<InsuredStandard> insuredStandardList, List<IListColumn> columns) {
        IListColumn column = null;
        for (InsuredStandard insuredStandard : insuredStandardList) {
            column = this.addItemColumn(insuredStandard);
            if (column == null) continue;
            columns.add(column);
        }
    }

    private IListColumn addItemColumn(InsuredStandard insuredStandard) {
        if (insuredStandard == null) {
            return null;
        }
        Long insuredItemId = insuredStandard.getInsuredItemId();
        String insuredItemName = insuredStandard.getInsuredItemName();
        Long dataTypeId = insuredStandard.getDataTypeId();
        String columnKey = String.valueOf(insuredItemId);
        if (dataTypeId.equals(SitDataTypeEnum.NUMBER.getId()) || dataTypeId.equals(SitDataTypeEnum.AMOUNT.getId())) {
            return this.getDecimalListColumn(insuredItemName, columnKey);
        }
        return this.createListColumn(columnKey, insuredItemName);
    }

    private DecimalListColumn getDecimalListColumn(String name, String columnKey) {
        DecimalListColumn decimalCol = new DecimalListColumn();
        decimalCol.setCaption(new LocaleString(name));
        decimalCol.setKey(columnKey);
        decimalCol.setListFieldKey(columnKey);
        decimalCol.setZeroShow(true);
        decimalCol.setSummary(1);
        return decimalCol;
    }

    private AmountProp getAmountProp(int scale, String name, String columnKey) {
        AmountProp property = new AmountProp();
        property.setName(columnKey);
        property.setDisplayName(new LocaleString(name));
        property.setPrecision(23);
        property.setScale(scale);
        property.setZeroShow(true);
        property.setEnableNull(true);
        property.setControlPropName(CURRENCY_KEY);
        return property;
    }

    private DecimalProp getDecimalProp(int scale, String name, String columnKey) {
        DecimalProp property = new DecimalProp();
        property.setName(columnKey);
        property.setDisplayName(new LocaleString(name));
        property.setPrecision(23);
        property.setScale(scale);
        property.setZeroShow(true);
        property.setEnableNull(true);
        return property;
    }

    private TextProp getTextProp(int dataLength, String name, String columnKey) {
        TextProp property = new TextProp();
        property.setName(columnKey);
        property.setDisplayName(new LocaleString(name));
        property.setMaxLenth(dataLength);
        return property;
    }

    private List<IListColumn> loadDisplaySchColumn(List<IListColumn> columns, Map<String, Object> resultMap) {
        ArrayList<IListColumn> newColumnList = new ArrayList<IListColumn>(10);
        Map<String, IListColumn> columnMap = columns.stream().collect(Collectors.toMap(IListColumnConfig::getListFieldKey, obj -> obj));
        if (columnMap.get("fseq") != null) {
            newColumnList.add(columnMap.get("fseq"));
        }
        List insuranceItemList = (List)resultMap.get("insuranceItemList");
        Map<String, InsuredStandard> insuranceItemMap = insuranceItemList.stream().collect(Collectors.toMap(InsuredStandard::getInsuredItemName, obj -> obj, (key1, key2) -> key1));
        List sumItemList = (List)resultMap.get("sumItemList");
        Map<String, InsuredStandard> sumItemMap = sumItemList.stream().collect(Collectors.toMap(InsuredStandard::getInsuredItemName, obj -> obj, (key1, key2) -> key1));
        List schInfoDataList = (List)resultMap.get("schInfoDataList");
        Object column = null;
        String showName = null;
        for (Map schInfoMap : schInfoDataList) {
            column = columnMap.get(schInfoMap.get("field"));
            showName = (String)schInfoMap.get("showname");
            if (column != null) {
                if (SITStringUtils.isNotEmpty((String)showName)) {
                    column.setCaption(new LocaleString(showName));
                }
                newColumnList.add((IListColumn)column);
                continue;
            }
            column = "3".equals(schInfoMap.get("fieldtype")) ? this.addItemColumn(insuranceItemMap.get(schInfoMap.get("fieldname"))) : ("4".equals(schInfoMap.get("fieldtype")) ? this.addItemColumn(sumItemMap.get(schInfoMap.get("fieldname"))) : this.createListColumn((String)schInfoMap.get("field"), (String)schInfoMap.get("fieldname")));
            if (column == null) continue;
            if (SITStringUtils.isNotEmpty((String)showName)) {
                column.setCaption(new LocaleString(showName));
            }
            newColumnList.add((IListColumn)column);
        }
        int seq = 0;
        for (IListColumn tempCol : newColumnList) {
            tempCol.setSeq(seq);
            ++seq;
        }
        return newColumnList;
    }

    private void viewBaseData(String formId, long pkId, String premItemEntity) {
        String opName = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"SocialInsuranceTaskList_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        if (this.checkPermission("47150e89000000ac", premItemEntity)) {
            this.showBaseDataPage(formId, pkId);
        } else {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)premItemEntity);
            String entityName = mainEntityType.getDisplayName().getLocaleValue();
            String msg = SITPermissionServiceHelper.getNoPermTips((String)String.format("%s%s", entityName, opName));
            this.getView().showMessage(msg);
        }
    }

    private void showBaseDataPage(String formId, long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private boolean checkPermission(String permItemId, String entryName) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return SITPermissionServiceHelper.hasPerm((long)userId, (String)"2AXKDRPJUQ77", (String)entryName, (String)permItemId);
    }

    public class CalDetailResultLoadDataImpl
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection detailDataCol = super.getData(start, limit);
            if (this.getQueryBuilder().isSelectedAllRows()) {
                return detailDataCol;
            }
            Long displaySchId = CalPersonBaseTplList.this.getDisplaySchemaId();
            ArrayList<InsuredStandard> insuredStandardList = null;
            String highlightColor = null;
            long startTime = System.currentTimeMillis();
            if (displaySchId == null) {
                insuredStandardList = CalPersonBaseTplList.this.getInsuredStandardList();
            } else {
                Map resultMap = DisplaySchemeService.getDisplaySchemaInfoListFromCacheOrDB((Long)displaySchId, (IFormView)CalPersonBaseTplList.this.pageView);
                List insuranceItemList = (List)resultMap.get("insuranceItemList");
                List sumItemList = (List)resultMap.get("sumItemList");
                insuredStandardList = new ArrayList<InsuredStandard>(10);
                insuredStandardList.addAll(insuranceItemList);
                insuredStandardList.addAll(sumItemList);
                highlightColor = (String)resultMap.get("highlightColor");
            }
            CalPersonBaseTplList.this.log.info("get item finish,cost:{} ms", (Object)(System.currentTimeMillis() - startTime));
            CalPersonBaseTplList.this.addItemProp(insuredStandardList, detailDataCol.getDynamicObjectType());
            HashMap resultCoverMap = new HashMap(detailDataCol.size());
            SocialDetailResultService.getInstance().inputDetailResultToDetailCol(detailDataCol, insuredStandardList, CalPersonBaseTplList.this.getCurrentEntity(), resultCoverMap);
            if (!CalPersonBaseTplList.this.isFromAdjustPage().booleanValue()) {
                this.setSumFields(insuredStandardList);
            }
            if (SITStringUtils.isNotEmpty((String)highlightColor)) {
                CalPersonBaseTplList.this.setHigLightColor(resultCoverMap, highlightColor);
            }
            return detailDataCol;
        }

        public List<SummaryResult> getSummaryResults() {
            SummaryResult summaryResult;
            NumberPrecision numberPrecision;
            List summaryResults = super.getSummaryResults();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(this.getQFilters());
            Long displaySchId = CalPersonBaseTplList.this.getDisplaySchemaId();
            ArrayList insuredStandardList = null;
            if (displaySchId == null) {
                insuredStandardList = CalPersonBaseTplList.this.getInsuredStandardList();
            } else {
                Map resultMap = DisplaySchemeService.getDisplaySchemaInfoListFromCacheOrDB((Long)displaySchId, (IFormView)CalPersonBaseTplList.this.pageView);
                List insuranceItemList = (List)resultMap.get("insuranceItemList");
                List sumItemList = (List)resultMap.get("sumItemList");
                insuredStandardList = new ArrayList(10);
                insuredStandardList.addAll(insuranceItemList);
                insuredStandardList.addAll(sumItemList);
            }
            ArrayList<Long> itemIds = new ArrayList<Long>(10);
            ArrayList<Long> sumLineitemIds = new ArrayList<Long>(10);
            for (InsuredStandard insuredStandard : insuredStandardList) {
                Long dataTypeId = insuredStandard.getDataTypeId();
                Long insuredItemId = insuredStandard.getInsuredItemId();
                if (!dataTypeId.equals(SitDataTypeEnum.AMOUNT.getId())) continue;
                if (SITStringUtils.equals((String)insuredStandard.getType(), (String)"2")) {
                    sumLineitemIds.add(insuredItemId);
                    continue;
                }
                itemIds.add(insuredItemId);
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_sumitem");
            DynamicObjectCollection sumItems = helper.queryOriginalCollection("id,entryentity.insuranceitem.id", new QFilter("id", "in", sumLineitemIds).toArray());
            Map<Long, List<DynamicObject>> sumItemMap = sumItems.stream().collect(Collectors.groupingBy(item -> item.getLong("id")));
            for (DynamicObject sumItem : sumItems) {
                itemIds.add(sumItem.getLong("entryentity.insuranceitem.id"));
            }
            qFilters.add(new QFilter("entryentity.insuranceitem.id", "in", itemIds));
            Map resultMap = SocialDetailResultService.getInstance().getSumValue(qFilters);
            HashSet<String> hasValueSummarySet = new HashSet<String>(insuredStandardList.size());
            for (Map.Entry entry : resultMap.entrySet()) {
                numberPrecision = new NumberPrecision();
                numberPrecision.setResult((BigDecimal)entry.getValue());
                numberPrecision.setPrecision(2);
                summaryResult = new SummaryResult(String.valueOf(entry.getKey()), null, 1);
                summaryResult.setNumberPrecision(numberPrecision);
                summaryResults.add(summaryResult);
                hasValueSummarySet.add(String.valueOf(entry.getKey()));
            }
            for (Map.Entry<Object, Object> entry : sumItemMap.entrySet()) {
                List items = (List)entry.getValue();
                BigDecimal value = BigDecimal.ZERO;
                for (DynamicObject item2 : items) {
                    BigDecimal itemValue = (BigDecimal)resultMap.get(item2.getLong("entryentity.insuranceitem.id"));
                    if (itemValue == null) continue;
                    value = value.add(itemValue);
                }
                NumberPrecision numberPrecision2 = new NumberPrecision();
                numberPrecision2.setResult(value);
                numberPrecision2.setPrecision(2);
                SummaryResult summaryResult2 = new SummaryResult(String.valueOf(entry.getKey()), null, 1);
                summaryResult2.setNumberPrecision(numberPrecision2);
                summaryResults.add(summaryResult2);
                hasValueSummarySet.add(String.valueOf(entry.getKey()));
            }
            for (InsuredStandard insuredStandard : insuredStandardList) {
                if (SitDataTypeEnum.AMOUNT.getId() != insuredStandard.getDataTypeId().longValue() || hasValueSummarySet.contains(String.valueOf(insuredStandard.getInsuredItemId()))) continue;
                numberPrecision = new NumberPrecision();
                numberPrecision.setResult(new BigDecimal("0.00"));
                numberPrecision.setPrecision(2);
                summaryResult = new SummaryResult(String.valueOf(insuredStandard.getInsuredItemId()), null, 1);
                summaryResult.setNumberPrecision(numberPrecision);
                summaryResults.add(summaryResult);
            }
            return summaryResults;
        }

        private void setSumFields(List<InsuredStandard> insuredStandardList) {
            ArrayList<ListField> listFields = new ArrayList<ListField>(10);
            for (InsuredStandard insuredStandard : insuredStandardList) {
                Long dataTypeId = insuredStandard.getDataTypeId();
                Long insuredItemId = insuredStandard.getInsuredItemId();
                String columnKey = String.valueOf(insuredItemId);
                if (!dataTypeId.equals(SitDataTypeEnum.AMOUNT.getId())) continue;
                ListField field = new ListField();
                field.setKey(columnKey);
                field.setListFieldKey(columnKey);
                field.setSummary(1);
                field.setFieldName(insuredStandard.getInsuredItemName());
                field.setListFieldKey(columnKey);
                listFields.add(field);
            }
            this.getQueryBuilder().setSumFields(listFields);
        }
    }
}

