/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.detail;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.scheme.helper.DisplaySchemeHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;

public class DisplaySchemeEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String KEY_ADD_FIELD = "addfield";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_BTNORDER = "btnorder";
    private static final String KEY_MOVETO = "moveto";
    private static final String KEY_MOVEUP = "moveup";
    private static final String KEY_MOVEDOWN = "movedown";
    private static final String KEY_ISHIGHLIGHT = "ishighlight";
    private static final String KEY_ISFREEZE = "isfreeze";
    private static final String KEY_PRIORITY = "priority";
    private static final String KEY_ISHIDE = "ishide";
    private static final String KEY_ORDER = "order";
    private static final String KEY_ORG = "org";
    private static final String KEY_HIGHLIGHTCOLOR = "highlightcolor";
    private static final String KEY_ADDFIELD_CLOSE = "addfieldclose";
    private static final String KEY_FIELDENTRY = "entryentity";
    private static final String SIT_HCSI_FORM_PLUGIN = "sit-hcsi-formplugin";
    private static final String MOVE_TO_CLOSED_LABEL = "movetoclosed";
    private static final String CALLBACK_SORTFIELD = "callbacksortfield";
    private static final String KEY_ISDEFAULT = "isdefaulttpl";
    private static final String CHANGE_DEFAULTTPL = "change_defaulttpl";
    private static final String KEY_WELFAREPAYER = "welfarepayer";
    private static final String CALLBACK_CHANGEORG = "changeorg";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit matchFetchItem = (BasedataEdit)this.getView().getControl(KEY_WELFAREPAYER);
        matchFetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String controlKey;
        super.itemClick(evt);
        switch (controlKey = evt.getItemKey()) {
            case "addfield": {
                this.openAddFieldView();
                break;
            }
            case "moveto": {
                this.openMoveToPage();
                break;
            }
            case "btnorder": {
                this.openFieldSortView();
                break;
            }
            case "moveup": {
                this.rowMoved(KEY_MOVEUP);
                break;
            }
            case "movedown": {
                this.rowMoved(KEY_MOVEDOWN);
                break;
            }
            case "delete": {
                this.resetEntryPriority();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                boolean flag;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_FIELDENTRY);
                if (SITListUtil.isEmpty((List)entryEntity)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u793e\u4fdd\u663e\u793a\u65b9\u6848\u8bbe\u7f6e\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DisplaySchemeEdit_4", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                RefObject afterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(opKey, afterConfirm) || !(flag = this.checkHasDefault(opKey))) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "ishighlight": {
                this.initHighLightColor();
                break;
            }
            case "isfreeze": {
                this.changeFreeze(args);
                break;
            }
            case "ishide": {
                int rowIndex = args.getChangeSet()[0].getRowIndex();
                this.setHideForOne(rowIndex);
                break;
            }
            case "org": {
                DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
                Object pkValue = 0L;
                if (oldValue != null) {
                    pkValue = oldValue.getPkValue();
                }
                this.showOrgChangeConfirm(pkValue);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.initHighLightColor();
        this.initOrg();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"DisplaySchemeEdit_6", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        String fieldKey = event.getProperty().getName();
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        List filterList = listFilterParameter.getQFilters();
        if (SITStringUtils.equals((String)KEY_WELFAREPAYER, (String)fieldKey)) {
            QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
            filterList.add(orgFilter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "save": 
            case "submit": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String number = dataEntity.getString("number");
                Long id = dataEntity.getLong("id");
                Long orgId = dataEntity.getLong("org.id");
                List<Long> welfareIdList = this.getWelfareIdList(dataEntity, orgId);
                DisplaySchemeHelper.cleanDefaultTpl((Long)id, (String)number, (Long)orgId, welfareIdList);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(callBackId, "true");
                this.getView().invokeOperation(callBackId, operateOption);
                break;
            }
            case "changeorg": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().setValue(KEY_WELFAREPAYER, null);
                    this.cleanFieldEntrySumitem(this.getModel().getDataEntity().getLong("org.id"));
                    break;
                }
                String customValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().beginInit();
                this.getModel().setValue(KEY_ORG, (Object)Long.parseLong(customValue));
                this.getView().updateView(KEY_ORG);
                this.getModel().endInit();
                break;
            }
        }
    }

    private void cleanFieldEntrySumitem(long orgId) {
        List sumItemNumberList = DisplaySchemeHelper.querySumitemNumberList((Long)orgId);
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity(KEY_FIELDENTRY);
        if (SITListUtil.isEmpty((List)fieldEntry)) {
            return;
        }
        ArrayList<Integer> waitDeleteList = new ArrayList<Integer>(10);
        for (int i = 0; i < fieldEntry.size(); ++i) {
            if (!SITStringUtils.equals((String)((DynamicObject)fieldEntry.get(i)).getString("fieldtype"), (String)"4") || sumItemNumberList.contains(((DynamicObject)fieldEntry.get(i)).getString("field"))) continue;
            waitDeleteList.add(i);
        }
        int[] dataIndexs = waitDeleteList.stream().mapToInt(Number::intValue).toArray();
        this.getModel().deleteEntryRows(KEY_FIELDENTRY, dataIndexs);
        this.getModel().updateEntryCache(fieldEntry);
        this.getView().updateView(KEY_FIELDENTRY);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        IFormView view = this.getView();
        switch (actionId) {
            case "movetoclosed": {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int[] rowIndexs = proxy.getEntryState(KEY_FIELDENTRY).getSelectedRows();
                Map data = (Map)event.getReturnData();
                this.setCalSchemeViewMove(data, rowIndexs);
                break;
            }
            case "addfieldclose": {
                this.addFieldToEntry(event);
                break;
            }
            case "callbacksortfield": {
                this.setCalSchemeViewSortColumn((Map)returnData, view);
                break;
            }
        }
    }

    private void resetEntryPriority() {
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity(KEY_FIELDENTRY);
        if (SITListUtil.isEmpty((List)fieldEntry)) {
            return;
        }
        List fieldList = fieldEntry.stream().filter(single -> single.getInt(KEY_PRIORITY) > 0).collect(Collectors.toList());
        fieldList.sort(Comparator.comparing(single -> single.getInt(KEY_PRIORITY)));
        for (int i = 0; i < fieldList.size(); ++i) {
            ((DynamicObject)fieldList.get(i)).set(KEY_PRIORITY, (Object)(i + 1));
        }
        this.getView().updateView(KEY_FIELDENTRY);
    }

    private void initOrg() {
        long orgId;
        this.getModel().beginInit();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        DynamicObject data = this.getModel().getDataEntity();
        long existOrgId = data.getLong("org.id");
        if (OperationStatus.ADDNEW != parameter.getStatus() || existOrgId != 0L) {
            return;
        }
        String orgIdStr = (String)parameter.getCustomParam("SELECT_ORG_ID");
        if (orgIdStr == null) {
            long currUserId = RequestContext.get().getCurrUserId();
            long userOrgId = RequestContext.get().getOrgId();
            List userHasPermOrgs = SITPermissionServiceHelper.getUserHasPermOrgs((Long)currUserId);
            orgId = userHasPermOrgs.contains(userOrgId) ? userOrgId : 0L;
        } else {
            orgId = Long.parseLong(orgIdStr);
        }
        this.getModel().setValue(KEY_ORG, (Object)orgId);
        this.getModel().endInit();
    }

    private void setCalSchemeViewMove(Map<String, Object> returnData, int[] rowIndexs) {
        DynamicObject dy;
        DynamicObjectCollection dyEntryEntity;
        int entryEntitysize;
        IFormView view = this.getView();
        Object rowNumberObj = returnData.get("rownumber");
        if (rowNumberObj == null) {
            return;
        }
        int rowNumber = Integer.parseInt(rowNumberObj.toString());
        if (rowNumber > (entryEntitysize = (dyEntryEntity = view.getModel().getEntryEntity(KEY_FIELDENTRY)).size())) {
            dy = (DynamicObject)dyEntryEntity.get(entryEntitysize - 1);
            rowNumber = entryEntitysize;
        } else {
            dy = (DynamicObject)dyEntryEntity.get(rowNumber - 1);
        }
        boolean flag = dy.getBoolean(KEY_ISFREEZE);
        ((DynamicObject)dyEntryEntity.get(rowIndexs[0])).set(KEY_ISFREEZE, (Object)flag);
        if (flag) {
            ((DynamicObject)dyEntryEntity.get(rowIndexs[0])).set(KEY_ISHIDE, (Object)Boolean.FALSE);
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < entryEntitysize; ++i) {
            linkedList.add(i);
        }
        linkedList.remove(rowIndexs[0]);
        linkedList.add(rowNumber - 1, rowIndexs[0]);
        int[] indexs = new int[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            indexs[i] = (Integer)linkedList.get(i);
        }
        this.setColumnInfo(dyEntryEntity, indexs);
        view.updateView(KEY_FIELDENTRY);
        EntryGrid grid = (EntryGrid)view.getControl(KEY_FIELDENTRY);
        grid.selectRows(rowNumber - 1, true);
    }

    private void setColumnInfo(DynamicObjectCollection entryEntity, int[] indexs) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_displayscheme");
        DynamicObject displaySchDynamicObject = helper.generateEmptyDynamicObject();
        DynamicObjectCollection displaySchemeEntryDyCollection = displaySchDynamicObject.getDynamicObjectCollection(KEY_FIELDENTRY);
        for (int index : indexs) {
            DynamicObject fieldEntryDy = (DynamicObject)entryEntity.get(index);
            DynamicObject calEntryDynamicObject = helper.generateEmptyEntryDynamicObject(KEY_FIELDENTRY);
            calEntryDynamicObject.set("seq", (Object)(displaySchemeEntryDyCollection.size() + 1));
            calEntryDynamicObject.set("fieldname", fieldEntryDy.get("fieldname"));
            calEntryDynamicObject.set("field", fieldEntryDy.get("field"));
            calEntryDynamicObject.set("fieldtype", fieldEntryDy.get("fieldtype"));
            calEntryDynamicObject.set("showname", fieldEntryDy.get("showname"));
            calEntryDynamicObject.set(KEY_ISFREEZE, fieldEntryDy.get(KEY_ISFREEZE));
            calEntryDynamicObject.set(KEY_ORDER, fieldEntryDy.get(KEY_ORDER));
            calEntryDynamicObject.set(KEY_PRIORITY, fieldEntryDy.get(KEY_PRIORITY));
            calEntryDynamicObject.set(KEY_ISHIDE, fieldEntryDy.get(KEY_ISHIDE));
            displaySchemeEntryDyCollection.add((Object)calEntryDynamicObject);
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            ((DynamicObject)entryEntity.get(i)).set("fieldname", ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get("fieldname"));
            ((DynamicObject)entryEntity.get(i)).set("field", ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get("field"));
            ((DynamicObject)entryEntity.get(i)).set("fieldtype", ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get("fieldtype"));
            ((DynamicObject)entryEntity.get(i)).set("showname", ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get("showname"));
            ((DynamicObject)entryEntity.get(i)).set(KEY_ISFREEZE, ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get(KEY_ISFREEZE));
            ((DynamicObject)entryEntity.get(i)).set(KEY_ORDER, ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get(KEY_ORDER));
            ((DynamicObject)entryEntity.get(i)).set(KEY_PRIORITY, ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get(KEY_PRIORITY));
            ((DynamicObject)entryEntity.get(i)).set(KEY_ISHIDE, ((DynamicObject)displaySchemeEntryDyCollection.get(i)).get(KEY_ISHIDE));
        }
    }

    private void showOrgChangeConfirm(Object oldValue) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u53c2\u4fdd\u5355\u4f4d\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"DisplaySchemeEdit_5", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_CHANGEORG, (IFormPlugin)this), new HashMap(2), oldValue.toString());
    }

    private void rowMoved(String key) {
        block8: {
            int index;
            DynamicObjectCollection doc;
            block9: {
                int index2;
                doc = this.getModel().getEntryEntity(KEY_FIELDENTRY);
                if (doc == null || doc.isEmpty()) break block8;
                if (!KEY_MOVEUP.equals(key)) break block9;
                int firstIndex = this.getModel().getEntryCurrentRowIndex(KEY_FIELDENTRY);
                if (firstIndex < 0) {
                    return;
                }
                int size = -1;
                for (index2 = 0; index2 < doc.size(); ++index2) {
                    DynamicObject obj = (DynamicObject)doc.get(index2);
                    if (!Boolean.TRUE.equals(obj.get(KEY_ISFREEZE))) continue;
                    size = index2;
                }
                this.getModel().beginInit();
                if (size > 1) {
                    this.getModel().setValue(KEY_ISHIDE, (Object)Boolean.FALSE, size - 1);
                }
                for (index2 = 0; index2 <= size; ++index2) {
                    if (!Boolean.FALSE.equals(this.getModel().getValue(KEY_ISFREEZE, index2))) continue;
                    this.getModel().setValue(KEY_ISFREEZE, (Object)Boolean.TRUE, index2);
                }
                this.getModel().endInit();
                for (index2 = 0; index2 <= size; ++index2) {
                    this.getView().updateView(KEY_ISHIDE, index2);
                    this.getView().updateView(KEY_ISFREEZE, index2);
                }
                break block8;
            }
            if (!KEY_MOVEDOWN.equals(key)) break block8;
            int firstIndex = 0;
            int size = doc.size();
            for (index = size - 1; index >= 0; --index) {
                DynamicObject obj = (DynamicObject)doc.get(index);
                if (!Boolean.FALSE.equals(obj.get(KEY_ISFREEZE))) continue;
                firstIndex = index;
            }
            this.getModel().beginInit();
            for (index = size - 1; index > firstIndex; --index) {
                if (!Boolean.TRUE.equals(this.getModel().getValue(KEY_ISFREEZE, index))) continue;
                this.getModel().setValue(KEY_ISFREEZE, (Object)Boolean.FALSE, index);
            }
            this.getModel().endInit();
            for (index = size - 1; index >= firstIndex; --index) {
                this.getView().updateView(KEY_ISFREEZE, index);
            }
        }
    }

    private boolean checkHasDefault(String opKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean newValue = dataEntity.getBoolean(KEY_ISDEFAULT);
        if (newValue.booleanValue()) {
            Long orgId = dataEntity.getLong("org.id");
            Long id = dataEntity.getLong("id");
            String number = dataEntity.getString("number");
            List<Long> welfareIdList = this.getWelfareIdList(dataEntity, orgId);
            if (SITListUtil.isEmpty(welfareIdList)) {
                return false;
            }
            int count = DisplaySchemeHelper.countDefaultTpl((Long)id, (String)number, (long)orgId, welfareIdList);
            if (count > 0) {
                this.showResetDefaultTplConfirm(opKey);
                return true;
            }
        }
        return false;
    }

    private List<Long> getWelfareIdList(DynamicObject dataEntity, Long orgId) {
        MulBasedataDynamicObjectCollection welfarepayerObjs = (MulBasedataDynamicObjectCollection)dataEntity.get(KEY_WELFAREPAYER);
        if (orgId == null || SITListUtil.isEmpty((List)welfarepayerObjs)) {
            return new ArrayList<Long>(0);
        }
        List<Long> welfareIdList = welfarepayerObjs.stream().map(single -> single.getLong("fbasedataid_id")).collect(Collectors.toList());
        return welfareIdList;
    }

    private void showResetDefaultTplConfirm(String opKey) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(opKey, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u53c2\u4fdd\u5355\u4f4d\u90e8\u5206\u6216\u5168\u90e8\u5df2\u5b58\u5728\u9ed8\u8ba4\u6a21\u677f\uff0c\u662f\u5426\u786e\u8ba4\u5168\u90e8\u66ff\u6362\u6210\u5f53\u524d\u6a21\u677f\uff1f", (String)"DisplaySchemeEdit_3", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]);
        this.getView().showConfirm(msg, options, ConfirmTypes.Default, confirmCallBacks);
    }

    private void changeFreeze(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        boolean newValue = (Boolean)changeData[0].getNewValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_FIELDENTRY);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(KEY_FIELDENTRY).getSelectedRows();
        int rowIndex = rowIndexs[0];
        if (newValue) {
            for (int i = 0; i < rowIndex; ++i) {
                ((DynamicObject)entryEntity.get(i + 1)).set(KEY_ISHIDE, (Object)Boolean.FALSE);
                ((DynamicObject)entryEntity.get(i)).set(KEY_ISFREEZE, (Object)Boolean.TRUE);
            }
        } else {
            for (int i = entryEntity.size() - 1; i > rowIndex; --i) {
                ((DynamicObject)entryEntity.get(i)).set(KEY_ISFREEZE, (Object)Boolean.FALSE);
            }
        }
        this.getView().updateView(KEY_FIELDENTRY);
    }

    private void setHideForOne(int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_FIELDENTRY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
        if (dynamicObject.getInt(KEY_PRIORITY) != 0) {
            int sortPriority = dynamicObject.getInt(KEY_PRIORITY);
            for (DynamicObject entry : entryEntity) {
                if (entry.getInt(KEY_PRIORITY) <= sortPriority) continue;
                entry.set(KEY_PRIORITY, (Object)(entry.getInt(KEY_PRIORITY) - 1));
            }
        }
        dynamicObject.set(KEY_ISFREEZE, (Object)Boolean.FALSE);
        dynamicObject.set(KEY_ORDER, (Object)0);
        dynamicObject.set(KEY_PRIORITY, (Object)0);
        this.getView().updateView(KEY_FIELDENTRY);
    }

    private void openMoveToPage() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_FIELDENTRY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DisplaySchemeEdit_0", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DisplaySchemeEdit_1", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemmoveto");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5230", (String)"DisplaySchemeEdit_2", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MOVE_TO_CLOSED_LABEL));
        this.getView().showForm(showParameter);
    }

    private void addFieldToEntry(ClosedCallBackEvent event) {
        DynamicObjectCollection fieldDatas = (DynamicObjectCollection)event.getReturnData();
        if (fieldDatas == null || fieldDatas.size() == 0) {
            return;
        }
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(KEY_FIELDENTRY);
        Map existFieldDyMap = entryEntities.stream().collect(Collectors.toMap(v1 -> v1.getString("field"), Function.identity()));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(KEY_FIELDENTRY);
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("fieldname", new Object[0]);
        setter.addField("field", new Object[0]);
        setter.addField("fieldtype", new Object[0]);
        setter.addField("showname", new Object[0]);
        setter.addField(KEY_ISFREEZE, new Object[0]);
        setter.addField(KEY_ORDER, new Object[0]);
        setter.addField(KEY_PRIORITY, new Object[0]);
        setter.addField(KEY_ISHIDE, new Object[0]);
        for (DynamicObject fieldData : fieldDatas) {
            String field = fieldData.getString("field");
            String fieldType = fieldData.getString("fieldtype");
            DynamicObject fieldDyObj = (DynamicObject)existFieldDyMap.get(field);
            String showName = fieldDyObj != null ? fieldDyObj.getString("showname") : "";
            boolean isfreeze = fieldDyObj != null ? fieldDyObj.getBoolean(KEY_ISFREEZE) : false;
            String order = fieldDyObj != null ? fieldDyObj.getString(KEY_ORDER) : "0";
            String priority = fieldDyObj != null ? fieldDyObj.getString(KEY_PRIORITY) : "0";
            boolean ishide = fieldDyObj != null ? fieldDyObj.getBoolean(KEY_ISHIDE) : false;
            setter.addRow(new Object[]{fieldData.getString("fieldname"), field, fieldType, showName, isfreeze, order, priority, ishide});
        }
        model.batchCreateNewEntryRow(KEY_FIELDENTRY, setter);
        model.endInit();
        this.getView().updateView(KEY_FIELDENTRY);
    }

    public void setCalSchemeViewSortColumn(Map<String, Object> returnData, IFormView view) {
        DynamicObjectCollection sortEntryEntity = (DynamicObjectCollection)returnData.get("sortEntryEntity");
        if (sortEntryEntity == null) {
            return;
        }
        HashMap<String, DynamicObject> sortColumnMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject sortDynamicObject : sortEntryEntity) {
            String key = sortDynamicObject.getString("fieldkey");
            sortColumnMap.put(key, sortDynamicObject);
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_FIELDENTRY);
        for (DynamicObject dynamicObject : entryEntity) {
            int sort;
            String field = dynamicObject.getString("field");
            DynamicObject sortDynamicObject = (DynamicObject)sortColumnMap.get(field);
            if (sortDynamicObject != null) {
                dynamicObject.set(KEY_ORDER, (Object)sortDynamicObject.getInt("sort"));
                dynamicObject.set(KEY_PRIORITY, (Object)sortDynamicObject.getString("sortpriority"));
                dynamicObject.set(KEY_ISHIDE, (Object)Boolean.FALSE);
            }
            if ((sort = dynamicObject.getInt(KEY_ORDER)) == 0 || sortColumnMap.containsKey(field)) continue;
            dynamicObject.set(KEY_ORDER, (Object)0);
            dynamicObject.set(KEY_PRIORITY, (Object)0);
        }
        view.updateView(KEY_FIELDENTRY);
    }

    private void openFieldSortView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_fieldsort");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("orgId", (Object)this.getModel().getDataEntity().getLong("org.id"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_SORTFIELD);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openAddFieldView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_displayschitem");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("orgId", (Object)this.getModel().getDataEntity().getLong("org.id"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ADDFIELD_CLOSE));
        this.getView().showForm(showParameter);
    }

    private void initHighLightColor() {
        Boolean isHighLight = (Boolean)this.getModel().getValue(KEY_ISHIGHLIGHT);
        FieldEdit control = (FieldEdit)this.getControl(KEY_HIGHLIGHTCOLOR);
        if (isHighLight.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_HIGHLIGHTCOLOR});
            control.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_HIGHLIGHTCOLOR});
            control.setMustInput(false);
            this.getModel().setValue(KEY_HIGHLIGHTCOLOR, null);
        }
    }
}

