/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.detail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.scheme.dto.RptDisplayColumnEntity;
import kd.sit.hcsi.business.scheme.helper.DisplaySchemeHelper;
import kd.sit.hcsi.business.scheme.service.AbsDisplayScmService;
import kd.sit.hcsi.formplugin.web.declare.scheme.DclDisplaySchemeHandler;
import kd.sit.hcsi.formplugin.web.declare.scheme.common.IDisplaySchemeHandler;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.util.SITStringUtils;

public class DisplaySchemeSelectFieldPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String ENTRY_SEARCH_LABEL = "columnsearchap";
    private static final String TREE_SEARCH_LABEL = "treesearchap";
    private static final String OK_BTN = "btnsave";
    private static final String KEY_OPT_MOVETO = "donothing_moveto";
    private static final String SIT_HCSI_FORM_PLUGIN = "sit-hcsi-formplugin";
    private static final String KEY_OPT_ADDITEM = "donothing_addfield";
    private static final String KEY_OPT_REMOVEITEM = "donothing_removefield";
    private static final String KEY_FIELDSELECTENTRY = "fieldselectentry";
    private static final String MOVE_TO_CLOSED_LABEL = "movetoclosed";
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String CACHE_ROOT_NODE = "CACHE_ROOT_NODE";
    private static final String CACHE_TREE = "CACHE_TREE_DATA";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search formSearch = (Search)this.getView().getControl(ENTRY_SEARCH_LABEL);
        formSearch.addEnterListener((SearchEnterListener)this);
        Search treeSearch = (Search)this.getView().getControl(TREE_SEARCH_LABEL);
        treeSearch.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{OK_BTN});
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        Search search = (Search)event.getSource();
        String key = search.getKey();
        if (SITStringUtils.equals((String)key, (String)TREE_SEARCH_LABEL)) {
            AbsDisplayScmService.searchTreeNode((String)searchText, (IFormView)this.getView(), (boolean)true);
            this.selectNeededNodesInFieldTree(false);
        } else if (SITStringUtils.equals((String)key, (String)ENTRY_SEARCH_LABEL)) {
            AbsDisplayScmService.searchFieldName((String)searchText, (IFormView)this.getView(), (String)KEY_FIELDSELECTENTRY, (String)"fieldname");
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.buildFieldTree();
        this.getView().updateView(KEY_TREEVIEW);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String optKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (optKey = formOperate.getOperateKey()) {
            case "donothing_moveto": {
                this.openMoveToPage(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "donothing_addfield": {
                this.addField();
                break;
            }
            case "donothing_removefield": {
                this.removeItem();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "btnsave": {
                this.btnOkClickEvent();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "movetoclosed": {
                this.moveToClosedEvent(evt);
                break;
            }
        }
    }

    protected void selectNeededNodesInFieldTree(boolean clean) {
        Map<String, TreeNode> nodeMap = this.getNodeMap();
        List<TreeNode> checkNodes = this.getAllCheckNodes(nodeMap);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        if (clean && !CollectionUtils.isEmpty(nodeMap)) {
            treeView.uncheckNodes(new ArrayList<String>(nodeMap.keySet()));
        }
        if (!CollectionUtils.isEmpty(checkNodes)) {
            treeView.checkNodes(checkNodes);
        }
    }

    protected List<TreeNode> getAllCheckNodes(Map<String, TreeNode> nodeMap) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_FIELDSELECTENTRY);
        Map<String, TreeNode> currNodeMap = nodeMap == null ? this.getNodeMap() : nodeMap;
        return entryEntity.stream().map(entry -> entry.getString("field")).map(currNodeMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void addField() {
        IFormView formView = this.getView();
        TreeView treeView = (TreeView)formView.getControl(KEY_TREEVIEW);
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            formView.showTipNotification(HCSIErrInfoEnum.COMMON_SELECT_DATA_FIRST.getErrInfo());
            return;
        }
        Map<String, TreeNode> nodeMap = this.getNodeMap();
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(KEY_FIELDSELECTENTRY);
        List entryNodeIdList = entryEntities.stream().map(single -> single.getString("treenodeid")).collect(Collectors.toList());
        int entrySeq = entryEntities.size();
        for (String selectNodeId : selectNodeIds) {
            TreeNode selectNode = nodeMap.get(selectNodeId);
            if (selectNode == null || !HRStringUtils.isNotEmpty((String)selectNode.getParentid()) || !selectNode.isLeaf() || entryNodeIdList.contains(selectNodeId)) continue;
            RptDisplayColumnEntity rowData = (RptDisplayColumnEntity)selectNode.getData();
            DynamicObject entry = entryEntities.addNew();
            entry.set("seq", (Object)entrySeq++);
            entry.set("fieldname", (Object)rowData.getFieldTreeNodeText());
            entry.set("field", (Object)rowData.getFieldValue());
            entry.set("treenodeid", (Object)selectNodeId);
            entry.set("fieldtype", (Object)rowData.getFieldSourceType());
        }
        this.getView().updateView(KEY_FIELDSELECTENTRY);
    }

    private void addNode(List<TreeNode> nodes, TreeNode treeNode, Map<String, TreeNode> nodeMap) {
        nodes.add(treeNode);
        String parentId = treeNode.getParentid();
        if (SITStringUtils.isNotEmpty((String)parentId)) {
            this.addNode(nodes, nodeMap.get(parentId), nodeMap);
        }
    }

    private Map<String, TreeNode> getNodeMap() {
        SITPageCache pageCache = new SITPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get(CACHE_TREE, String.class);
        return (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
    }

    private void buildFieldTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        List<RptDisplayColumnEntity> treeData = this.getHandler().getLeftTreeDataList("1020_S");
        if (!this.validTreeDataList(treeData)) {
            throw new IllegalArgumentException("DisplaySchemeSelectFieldPlugin.buildBillTreeNodes, data build error,treeData = " + treeData);
        }
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("orgId") + "");
        List itemNodesData = DisplaySchemeHelper.queryItemNodeList((Long)orgId);
        treeData.addAll(itemNodesData);
        List<TreeNode> rootNodes = this.convertToTreeNode(treeData, null);
        SITPageCache pageCache = new SITPageCache(this.getView());
        Map<String, TreeNode> treeNodeMap = this.getTreeNodeMap(rootNodes);
        pageCache.put(CACHE_TREE, (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        pageCache.put(CACHE_ROOT_NODE, (Object)SerializationUtils.serializeToBase64(rootNodes));
        treeView.addNodes(rootNodes);
        DynamicObjectCollection entryEntity = this.getView().getParentView().getModel().getEntryEntity("entryentity");
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            Object field = dynamicObject.get("field");
            TreeNode treeNode = treeNodeMap.get(field);
            if (treeNode == null) continue;
            checkNodes.add(treeNode);
        }
        treeView.checkNodes(checkNodes);
        if (checkNodes.size() > 0) {
            this.addField();
        }
    }

    private boolean validTreeDataList(List<RptDisplayColumnEntity> treeData) {
        HashSet<String> validSet = new HashSet<String>();
        return this.doCheckTreeDataList(treeData, validSet);
    }

    private boolean doCheckTreeDataList(List<RptDisplayColumnEntity> treeData, Set<String> validSet) {
        if (CollectionUtils.isEmpty(treeData)) {
            return true;
        }
        for (RptDisplayColumnEntity data : treeData) {
            if (!validSet.add(data.getFieldValue())) {
                return false;
            }
            if (this.doCheckTreeDataList(data.getChildren(), validSet)) continue;
            return false;
        }
        return true;
    }

    private Map<String, TreeNode> getTreeNodeMap(List<TreeNode> rootNodes) {
        HashMap<String, TreeNode> result = new HashMap<String, TreeNode>(16);
        if (CollectionUtils.isEmpty(rootNodes)) {
            return result;
        }
        for (TreeNode treeNode : rootNodes) {
            result.put(treeNode.getId(), treeNode);
            List children = treeNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            result.putAll(this.getTreeNodeMap(treeNode.getChildren()));
        }
        return result;
    }

    private List<TreeNode> convertToTreeNode(List<RptDisplayColumnEntity> treeData, String parentId) {
        if (CollectionUtils.isEmpty(treeData)) {
            return null;
        }
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (RptDisplayColumnEntity entity : treeData) {
            TreeNode treeNode = new TreeNode();
            treeNode.setData((Object)entity);
            treeNode.setId(entity.getFieldValue());
            treeNode.setText(entity.getFieldTreeNodeText());
            treeNode.setLeaf(!entity.hasChild());
            treeNode.setChildren(this.convertToTreeNode(entity.getChildren(), entity.getFieldValue()));
            if (!HRStringUtils.isEmpty((String)parentId)) {
                treeNode.setParentid(parentId);
            }
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private IDisplaySchemeHandler getHandler() {
        return new DclDisplaySchemeHandler(this.getView());
    }

    public void moveToClosedEvent(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        String clickStatus = (String)returnData.get("clickStatus");
        if (!SITStringUtils.equals((String)"ok", (String)clickStatus)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_FIELDSELECTENTRY);
        int[] rows = entryGrid.getSelectRows();
        int oldRow = rows[0];
        int newRow = (Integer)returnData.get("rownumber");
        IDataModel model = this.getModel();
        DynamicObjectCollection datas = model.getEntryEntity(KEY_FIELDSELECTENTRY);
        int size = datas.size();
        if (--newRow > size - 1) {
            newRow = size - 1;
        }
        if (oldRow == newRow) {
            return;
        }
        DynamicObject oldObj = (DynamicObject)datas.get(oldRow);
        model.deleteEntryRow(KEY_FIELDSELECTENTRY, oldRow);
        model.createNewEntryRow(KEY_FIELDSELECTENTRY, newRow, oldObj);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_FIELDSELECTENTRY);
        grid.selectRows(newRow, true);
    }

    public void btnOkClickEvent() {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(KEY_FIELDSELECTENTRY);
        if (entryDatas == null || entryDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9879\u76ee\u518d\u786e\u5b9a\u3002", (String)"DisplaySchemeSelectFieldPlugin_4", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)entryDatas);
        this.getView().close();
    }

    public void removeItem() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_FIELDSELECTENTRY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DisplaySchemeSelectFieldPlugin_3", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(KEY_FIELDSELECTENTRY, rows);
        this.selectNeededNodesInFieldTree(true);
    }

    public void openMoveToPage(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_FIELDSELECTENTRY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DisplaySchemeSelectFieldPlugin_0", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DisplaySchemeSelectFieldPlugin_1", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemmoveto");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5230", (String)"DisplaySchemeSelectFieldPlugin_2", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MOVE_TO_CLOSED_LABEL));
        this.getView().showForm(showParameter);
    }
}

