/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.detail;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.hcsi.business.scheme.dto.RptDisplayColumnEntity;
import kd.sit.hcsi.business.scheme.dto.RptDisplayFieldEntity;
import kd.sit.hcsi.business.scheme.helper.DisplaySchemeHelper;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;

public class DisplaySchemeSortFieldPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener,
TreeNodeCheckListener {
    private static final Log logger = LogFactory.getLog(DisplaySchemeSortFieldPlugin.class);
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ROOT = "root";
    private static final String KEY_PRIORITY = "sortpriority";
    private static final String KEY_FIELD_NAME = "fieldname";
    private static final String KEY_FIELD_KEY = "fieldkey";
    private static final String KEY_SORT = "sort";
    private static final String TREE_NODE = "treeNode";
    private static final String SEARCH_TEXT = "searchText";
    private static final String FIELD_TYPE_ITEM = "3";
    private static final String SIT_HCSI_FORM_PLUGIN = "sit-hcsi-formplugin";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        this.addClickListeners(new String[]{"btn_add"});
        this.addClickListeners(new String[]{"btn_remove"});
        this.addClickListeners(new String[]{"btn_confirm"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        DynamicObjectCollection entryEntity = this.getParentEntryEntity();
        if (entryEntity == null) {
            return;
        }
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("orgId") + "");
        Set<String> itemCodeSet = this.assembleItemCodeSet(orgId);
        ArrayList<String> sortList = new ArrayList<String>();
        for (DynamicObject dynamicObject : entryEntity) {
            String sort = dynamicObject.getString("order");
            String fieldKey = dynamicObject.getString("field");
            if (!SITStringUtils.isNotEmpty((String)sort) || "0".equals(sort)) continue;
            sortList.add(fieldKey);
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.setMulti(true);
        String text = "";
        List<TreeNode> treeNodeList = this.buildTree(itemCodeSet, entryEntity, text, sortList, Boolean.FALSE);
        String treeNodeStr = SerializationUtils.serializeToBase64(treeNodeList);
        this.getPageCache().put(TREE_NODE, treeNodeStr);
        this.getPageCache().put(SEARCH_TEXT, text);
        this.buildTable(entryEntity);
    }

    private Set<String> assembleItemCodeSet(Long orgId) {
        List insuranceItemList = DisplaySchemeHelper.queryInsuranceItemList();
        List sumItemList = DisplaySchemeHelper.querySumItemList((Long)orgId);
        HashSet<String> itemCodeSet = new HashSet<String>(16);
        if (!SITListUtil.isEmpty((List)insuranceItemList)) {
            for (RptDisplayColumnEntity insurance : insuranceItemList) {
                List itemList = insurance.getChildren();
                if (SITListUtil.isEmpty((List)itemList)) continue;
                itemCodeSet.addAll(itemList.stream().map(RptDisplayFieldEntity::getFieldValue).collect(Collectors.toSet()));
            }
        }
        if (!SITListUtil.isEmpty((List)sumItemList)) {
            itemCodeSet.addAll(sumItemList.stream().map(RptDisplayFieldEntity::getFieldValue).collect(Collectors.toSet()));
        }
        return itemCodeSet;
    }

    private void buildTable(DynamicObjectCollection entryEntity) {
        int newSize = 0;
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : entryEntity) {
            String priority = dynamicObject.getString("priority");
            if (!SITStringUtils.isNotEmpty((String)priority) || "0".equals(priority)) continue;
            ++newSize;
            resultMap.put(priority, dynamicObject);
        }
        if (newSize == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, newSize);
        int index = 0;
        for (int i = 1; i <= 5; ++i) {
            DynamicObject dynamicObject = (DynamicObject)resultMap.get(String.valueOf(i));
            if (dynamicObject == null) continue;
            String fieldKey = dynamicObject.getString("field");
            this.getModel().setValue(KEY_FIELD_KEY, (Object)fieldKey, index);
            this.getModel().setValue(KEY_FIELD_NAME, (Object)dynamicObject.getString(KEY_FIELD_NAME), index);
            this.getModel().setValue(KEY_PRIORITY, (Object)(index + 1), index);
            this.getModel().setValue(KEY_SORT, (Object)dynamicObject.getString("order"), index);
            ++index;
        }
    }

    private List<TreeNode> buildTree(Set<String> itemCodeSet, DynamicObjectCollection fieldEntry, String text, List<String> sortList, Boolean isSearch) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        treeView.addNode(this.getRootNode());
        treeView.setMulti(true);
        treeView.setRootVisible(true);
        treeView.expand(KEY_ROOT);
        treeView.setDraggable(true);
        treeView.setDroppable(true);
        if (text.isEmpty()) {
            for (int i = 0; i < fieldEntry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)fieldEntry.get(i);
                String field = dynamicObject.getString("field");
                if (sortList.contains(field) || itemCodeSet.contains(field)) continue;
                nodes.add(new TreeNode(KEY_ROOT, field, dynamicObject.getString(KEY_FIELD_NAME)));
            }
        } else {
            boolean flag = false;
            for (int i = 0; i < fieldEntry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)fieldEntry.get(i);
                String field = dynamicObject.getString("field");
                String fieldname = dynamicObject.getString(KEY_FIELD_NAME);
                if (!fieldname.contains(text) || sortList.contains(field)) continue;
                nodes.add(new TreeNode(KEY_ROOT, field, dynamicObject.getString(KEY_FIELD_NAME)));
                flag = true;
            }
            if (!flag && isSearch.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"DisplaySchemeSortFieldPlugin_1", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            }
        }
        treeView.addNodes(nodes);
        return nodes;
    }

    private TreeNode getRootNode() {
        TreeNode root = new TreeNode("", KEY_ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"DisplaySchemeSortFieldPlugin_2", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        return root;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        switch (key) {
            case "btn_add": {
                this.checkIsNeedAddSortColumn(entryentity);
                break;
            }
            case "btn_remove": {
                this.removeSortColumn(entryentity);
                break;
            }
            case "btn_confirm": {
                this.saveSortColumn(entryentity);
                break;
            }
        }
    }

    private void saveSortColumn(DynamicObjectCollection entryEntity) {
        HashMap<String, DynamicObjectCollection> sortColumnMap = new HashMap<String, DynamicObjectCollection>();
        sortColumnMap.put("sortEntryEntity", entryEntity);
        this.getView().setReturnData(sortColumnMap);
        this.getView().close();
    }

    private void removeSortColumn(DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            int seq = dynamicObject.getInt("seq");
            dynamicObject.set(KEY_PRIORITY, (Object)seq);
        }
        this.rebuildLeftTree(Boolean.FALSE);
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void checkIsNeedAddSortColumn(DynamicObjectCollection entryEntity) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        List selectedNodesList = tree.getTreeState().getSelectedNodes();
        ArrayList<Map<String, Object>> resultNodesList = new ArrayList<Map<String, Object>>();
        for (Map selectedNodes : selectedNodesList) {
            String id = (String)selectedNodes.get("id");
            if (KEY_ROOT.equals(id)) continue;
            resultNodesList.add(selectedNodes);
        }
        int selectSize = resultNodesList.size();
        if (selectSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DisplaySchemeSortFieldPlugin_3", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int cunt = model.getEntryRowCount(KEY_ENTRYENTITY);
        int totalSize = cunt + selectSize;
        if (totalSize > 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6027\u80fd\uff0c\u53ef\u9009\u62e95\u4e2a\u4ee5\u5185\u7684\u5b57\u6bb5\u4f5c\u4e3a\u6392\u5e8f\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DisplaySchemeSortFieldPlugin_4", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.addSortEntryRow(entryEntity, resultNodesList, model, cunt);
        this.rebuildLeftTree(Boolean.FALSE);
    }

    private void addSortEntryRow(DynamicObjectCollection entryEntity, List<Map<String, Object>> resultNodesList, AbstractFormDataModel model, int cunt) {
        List existFieldList = entryEntity.stream().map(single -> single.getString(KEY_FIELD_KEY)).collect(Collectors.toList());
        int newSize = 0;
        for (Map<String, Object> selectedNodes : resultNodesList) {
            String fieldKey = (String)selectedNodes.get("id");
            if (existFieldList.contains(fieldKey)) continue;
            ++newSize;
        }
        if (newSize == 0) {
            return;
        }
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, newSize);
        int tag = 0;
        for (Map<String, Object> selectedNodes : resultNodesList) {
            String fieldKey = (String)selectedNodes.get("id");
            String fieldName = (String)selectedNodes.get("text");
            if (existFieldList.contains(fieldKey)) continue;
            this.getModel().setValue(KEY_FIELD_KEY, (Object)fieldKey, cunt + tag);
            this.getModel().setValue(KEY_FIELD_NAME, (Object)fieldName, cunt + tag);
            this.getModel().setValue(KEY_SORT, (Object)"1", cunt + tag);
            this.getModel().setValue(KEY_PRIORITY, (Object)(cunt + tag + 1), cunt + tag);
            ++tag;
        }
        this.getView().sendFormAction(this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("moveentryup".equals(opKey) || "moveentrydown".equals(opKey)) {
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
            for (DynamicObject dynamicObject : entryEntity) {
                int seq = dynamicObject.getInt("seq");
                dynamicObject.set(KEY_PRIORITY, (Object)seq);
            }
            entryEntity.size();
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().updateView(KEY_PRIORITY, i);
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        String text = evt.getText();
        DynamicObjectCollection entryEntity = this.getParentEntryEntity();
        if (entryEntity == null) {
            return;
        }
        DynamicObjectCollection rightEntryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<String> sortList = new ArrayList<String>();
        for (DynamicObject dynamicObject : rightEntryEntity) {
            String key = dynamicObject.getString(KEY_FIELD_KEY);
            sortList.add(key);
        }
        this.updateTreeNodeCache(entryEntity, sortList, text, Boolean.TRUE);
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        Object nodeId = event.getNodeId();
        if (KEY_ROOT.equals(nodeId)) {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            String treeNodeStr = this.getPageCache().get(TREE_NODE);
            Boolean flag = event.getChecked();
            try {
                List treeNodeList = (List)SerializationUtils.deSerializeFromBase64((String)treeNodeStr);
                if (flag.booleanValue()) {
                    treeView.checkNodes(treeNodeList);
                } else {
                    treeView.uncheckNodes(treeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList()));
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DisplaySchemeSortFieldPlugin_5", (String)SIT_HCSI_FORM_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private DynamicObjectCollection getParentEntryEntity() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        IDataModel model = parentView.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return null;
        }
        return entryEntity;
    }

    private void rebuildLeftTree(Boolean isSearch) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        DynamicObjectCollection entryEntity = this.getParentEntryEntity();
        if (entryEntity == null) {
            return;
        }
        DynamicObjectCollection rightEntryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<String> sortList = new ArrayList<String>();
        for (DynamicObject dynamicObject : rightEntryEntity) {
            String fieldKey = dynamicObject.getString(KEY_FIELD_KEY);
            sortList.add(fieldKey);
        }
        String text = this.getPageCache().get(SEARCH_TEXT);
        this.updateTreeNodeCache(entryEntity, sortList, text, isSearch);
    }

    private void updateTreeNodeCache(DynamicObjectCollection entryEntity, List<String> sortList, String text, Boolean isSearch) {
        TreeView treeView1 = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView1.setMulti(true);
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("orgId") + "");
        Set<String> itemCodeSet = this.assembleItemCodeSet(orgId);
        List<TreeNode> treeNodeList = this.buildTree(itemCodeSet, entryEntity, text, sortList, isSearch);
        String treeNodeStr = SerializationUtils.serializeToBase64(treeNodeList);
        this.getPageCache().put(TREE_NODE, treeNodeStr);
        this.getPageCache().put(SEARCH_TEXT, text);
    }
}

