/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.task;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;

public class CalCheckWaitPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(CalCheckWaitPlugin.class);

    public void initialize() {
        super.initialize();
        ProgressBar calCheckWaitProcess = (ProgressBar)this.getControl("waitprogress");
        calCheckWaitProcess.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        int progress = progressEvent.getProgress();
        log.info("onProgress:{}", (Object)progress);
        String cacheUUID = (String)this.getView().getFormShowParameter().getCustomParam("cacheUUID");
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)"waitprogress")) {
            this.queryAndSetProgressDetails(progressEvent, cacheUUID);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        ProgressBar calCheckWaitProcess = (ProgressBar)this.getControl("waitprogress");
        calCheckWaitProcess.start();
        calCheckWaitProcess.setPercent(0);
    }

    private void queryAndSetProgressDetails(ProgressEvent progressEvent, String cacheUUID) {
        IHRAppCache appCache = HRAppCache.get((String)("socialCalParam_" + cacheUUID));
        Boolean isCheckCertFail = (Boolean)appCache.get("isCheckCertFail", Boolean.class);
        if (Boolean.TRUE.equals(isCheckCertFail)) {
            progressEvent.setProgress(100);
            HashMap<String, String> backData = new HashMap<String, String>(1);
            backData.put("cacheUUID", cacheUUID);
            this.getView().returnDataToParent(backData);
            this.getView().close();
            return;
        }
        boolean isAdd = "2".equals(appCache.get("calType", String.class));
        Boolean hasCheckCert = (Boolean)appCache.get("hasCheckCert", Boolean.class);
        if (isAdd && Boolean.FALSE.equals(hasCheckCert)) {
            return;
        }
        int successCount = (Integer)appCache.get("successCount", Integer.class);
        int failCount = (Integer)appCache.get("failCount", Integer.class);
        int totalCount = (Integer)appCache.get("totalCount", Integer.class);
        int percentage = isAdd ? 50 * (successCount + failCount) / totalCount + 50 : (successCount + failCount) * 100 / totalCount;
        progressEvent.setProgress(percentage);
        if (percentage >= 100) {
            HashMap<String, String> backData = new HashMap<String, String>(1);
            backData.put("cacheUUID", cacheUUID);
            this.getView().returnDataToParent(backData);
            this.getView().close();
        }
    }
}

