/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.task;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;

public class InsuranceTaskConfirmPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String DONOTHING_OK = "donothing_ok";
    private static final String KEY_SINSURPERIOD = "sinsurperiod";
    private static final String KEY_WELFAREPAYER = "welfarepayer";
    private static final String PERMISSION_HRQXX0455 = "2M772PSQF9=L";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl(KEY_SINSURPERIOD);
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit welfarePayperEdit = (MulBasedataEdit)this.getControl(KEY_WELFAREPAYER);
        welfarePayperEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "sinsurperiod": {
                QFilter qFilter = new QFilter("periodtype", "=", (Object)1010L);
                param.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "welfarepayer": {
                SocialInsuranceCalHelper.setWelfarePayerF7Filter((ListShowParameter)param, (String)"hcsi_sinsurtask");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (DONOTHING_OK.equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject periodDy = dataEntity.getDynamicObject(KEY_SINSURPERIOD);
            DynamicObjectCollection dyColl = dataEntity.getDynamicObjectCollection(KEY_WELFAREPAYER);
            if (HRObjectUtils.isEmpty((Object)periodDy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u793e\u4fdd\u671f\u95f4\u201d\u3002", (String)"InsuranceTaskConfirmPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            }
            if (CollectionUtils.isEmpty((Collection)dyColl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u201d\u3002", (String)"InsuranceTaskConfirmPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            }
            if (!SITPermissionServiceHelper.hasPerm((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)PERMISSION_HRQXX0455)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u793e\u4fdd\u8ba1\u7b97\u201d\u7684\u201c\u5bfc\u51fa\u793e\u4fdd\u660e\u7ec6\u201d\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"InsuranceTaskConfirmPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)periodDy) || CollectionUtils.isEmpty((Collection)dyColl) || !SITPermissionServiceHelper.hasPerm((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)PERMISSION_HRQXX0455) || SITPermissionServiceHelper.checkCancelDataRight((IFormView)this.getView())) {
                args.setCancel(true);
                return;
            }
            HashSet<Long> welfarePayerIds = new HashSet<Long>(16);
            long periodId = periodDy.getLong("id");
            for (DynamicObject dyObj : dyColl) {
                welfarePayerIds.add(dyObj.getLong("fbasedataid_id"));
            }
            HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("hcsi_sinsurtask");
            QFilter qFilter = new QFilter(KEY_WELFAREPAYER, "in", welfarePayerIds);
            qFilter.and(KEY_SINSURPERIOD, "=", (Object)periodId);
            DynamicObjectCollection taskDys = taskHelper.queryOriginalCollection("id", qFilter.toArray());
            List taskIds = taskDys.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
            if (taskIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u793e\u4fdd\u671f\u95f4\u548c\u53c2\u4fdd\u5355\u4f4d\u6ca1\u6709\u5bf9\u5e94\u7684\u793e\u4fdd\u660e\u7ec6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53c2\u6570\u3002", (String)"InsuranceTaskConfirmPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap<String, String> returnData = new HashMap<String, String>(1);
            returnData.put("taskIds", SerializationUtils.serializeToBase64(taskIds));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

