/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.SocialInsuranceUpdateCalCheckThread;
import kd.sit.hcsi.business.cal.export.SocialDetailDownLoadTask;
import kd.sit.hcsi.business.cal.service.DisplaySchemeService;
import kd.sit.hcsi.business.cal.service.SocialInsuranceCalService;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.push.CalResultPushHelper;
import kd.sit.hcsi.business.sdk.KDSocInsuranceSdkHelper;
import kd.sit.hcsi.common.enums.ISocialOperationEnum;
import kd.sit.hcsi.common.enums.SocialOperationEnum;
import kd.sit.hcsi.formplugin.web.cal.AbstractCalOperationList;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.helper.qfilter.UpdateQFilterHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;

public class SocialInsuranceTaskList
extends AbstractCalOperationList {
    private Log logger = LogFactory.getLog(SocialInsuranceTaskList.class);
    private static final String EXPORT_CALLBACK_ID = "export_callback_id";
    private static final String CONFIRM_CALBACKID_CLOSETASK = "confirm_calbackid_closetask";
    private static final String IS_CONFIRM_CLOSE = "isConfirmClose";
    private static final String IS_CONFIRM_DELETE_TSAK = "isConfirmDeleteTask";

    public void setFilter(SetFilterEvent event) {
        UpdateQFilterHelper.updateQFilter((List)event.getQFilters(), (String)"mulsinsurstd.fbasedataid.id", (String)"mulsinsurstd.fbasedataid.name", (String)"sitbs_sinsurstd");
        if (!SITPermissionServiceHelper.isSuperUser()) {
            HasPermOrgResult hasPermOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)"47150e89000000ac");
            if (hasPermOrgResult.hasAllOrgPerm()) {
                return;
            }
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("welfarepayer.org", "in", (Object)hasPermOrgs);
            event.getQFilters().add(orgFilter);
            Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)"2AXKDRPJUQ77", (String)"sitbs_welfarepayer", (String)"47150e89000000ac");
            if (countryIds == null) {
                return;
            }
            QFilter countryFilter = new QFilter("welfarepayer.country", "in", (Object)countryIds);
            event.getQFilters().add(countryFilter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("number".equals(fieldName)) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long taskId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
            ListShowParameter showParameter = SocialInsuranceCalHelper.getCalTableListForm((Long)taskId);
            if (showParameter == null) {
                return;
            }
            if (showParameter.getCustomParam("displaySchId") != null) {
                UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"hcsi_calperson");
            }
            String appId = this.getView().getFormShowParameter().getCheckRightAppId();
            String pageId = this.getView().getPageId() + appId + "hcsi_calperson" + taskId;
            showParameter.setPageId(pageId);
            this.logger.info("SocialInsuranceTaskList.billListHyperLinkClick: begin to open detail.");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public Set<Enum<? extends ISocialOperationEnum>> operationMutexLockKey() {
        Set<Enum<? extends ISocialOperationEnum>> operationMutexLockKey = super.operationMutexLockKey();
        operationMutexLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_EXPORTDETAIL);
        operationMutexLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_PUSH);
        operationMutexLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_UNPUSH);
        operationMutexLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_UPDATECAL);
        return operationMutexLockKey;
    }

    @Override
    public Set<Enum<? extends ISocialOperationEnum>> beforeOperationGetLockKey() {
        Set<Enum<? extends ISocialOperationEnum>> operationGetLockKey = super.beforeOperationGetLockKey();
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_EXPORTDETAIL);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_AUDIT);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_UNAUDIT);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_PUSH);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_UNPUSH);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_UPDATECAL);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_CANCEL);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_DELETE_TASK);
        operationGetLockKey.add((Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_CLOSE);
        return operationGetLockKey;
    }

    @Override
    public Enum<? extends ISocialOperationEnum> getISocialOperationEnum(String operateKey) {
        return ISocialOperationEnum.getSocialOperationEnum(Collections.singletonList(SocialOperationEnum.class), (String)operateKey);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List fastFilterColumns = args.getCommonFilterColumns();
        fastFilterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"welfarepayer.org.name")) {
                filterColumn.setDefaultValue(null);
            }
        });
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        Optional permOrgs = SITPermissionServiceHelper.getPermOrgsOpt((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)"47150e89000000ac");
        switch (fieldName) {
            case "welfarepayer.name": 
            case "welfarepayer.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("org", "in", orgs)));
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        String appNumber = AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getAppId());
        Optional permOrgsOpt = SITPermissionServiceHelper.getPermOrgsOpt((String)"31", (String)appNumber, (String)"hcsi_sinsurtask", (String)"47150e89000000ac");
        Optional permOrgs = SITPermissionServiceHelper.getPermOrgsOpt((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurtask", (String)"47150e89000000ac");
        switch (fieldName) {
            case "welfarepayer.name": 
            case "welfarepayer.id": 
            case "actualwelfarepayer.fbasedataid.name": 
            case "actualwelfarepayer.fbasedataid.id": 
            case "theorywelfarepayer.fbasedataid.name": 
            case "theorywelfarepayer.fbasedataid.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("org", "in", orgs)));
                break;
            }
            case "mulsinsurstd.fbasedataid.name": 
            case "mulsinsurstd.fbasedataid.id": {
                permOrgsOpt.ifPresent(orgIds -> filters.add(SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_sinsurstd", (List)orgIds, (boolean)true)));
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String recordId = UUID.randomUUID().toString();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IFormView view = this.getView();
        String isMutexOp = formOperate.getOption().getVariableValue("isMutexOp", "0");
        List afterMutexCheckTaskIds = SocialInsuranceCalHelper.getIdsBySelectedRows((ListSelectedRowCollection)formOperate.getListSelectedData());
        if ("1".equals(isMutexOp) && CollectionUtils.isEmpty((Collection)afterMutexCheckTaskIds)) {
            return;
        }
        switch (operateKey) {
            case "donothing_audit": {
                args.setCancel(true);
                SocialInsuranceCalService service = new SocialInsuranceCalService();
                service.auditOrUnauditInSinsurTask(afterMutexCheckTaskIds, view, SocialOperationEnum.OP_AUDIT, recordId);
                this.recordSuccessfulOpLog(SocialOperationEnum.OP_AUDIT);
                break;
            }
            case "donothing_unaudit": {
                args.setCancel(true);
                SocialInsuranceCalService service = new SocialInsuranceCalService();
                service.auditOrUnauditInSinsurTask(afterMutexCheckTaskIds, view, SocialOperationEnum.OP_UNAUDIT, recordId);
                this.recordSuccessfulOpLog(SocialOperationEnum.OP_UNAUDIT);
                break;
            }
            case "donothing_exportdetail": {
                args.setCancel(true);
                if (CollectionUtils.isEmpty((Collection)afterMutexCheckTaskIds)) {
                    this.getExportForm();
                    break;
                }
                this.exportSocialDetail(afterMutexCheckTaskIds);
                break;
            }
            case "donothing_updatecal": {
                formOperate.getOption().setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                formOperate.getOption().setVariableValue("batchop_batchsize", "0");
                formOperate.getOption().setVariableValue("bos_skip_op_batch", Boolean.TRUE.toString());
                break;
            }
            case "donothing_close": {
                formOperate.getOption().setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                if (formOperate.getOption().tryGetVariableValue(IS_CONFIRM_CLOSE, new RefObject())) {
                    if (SessionManager.getCurrent().getFormShowParameter(this.getView().getPageId()).isCancelDataRight()) {
                        this.getView().getFormShowParameter().setCancelDataRight(true);
                        this.getView().showConfirm(HCSIErrInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(HCSIErrInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode()));
                        this.recordFailedOpLog(SocialOperationEnum.OP_CLOSE);
                        args.setCancel(true);
                    }
                    this.recordSuccessfulOpLog(SocialOperationEnum.OP_CLOSE);
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684%s\u6761\u793e\u4fdd\u4efb\u52a1\u5173\u95ed\u540e\u5c06\u4e0d\u80fd\u518d\u8fdb\u884c\u8ba1\u7b97\u6216\u91cd\u65b0\u8ba1\u7b97\u64cd\u4f5c\uff0c\u786e\u5b9a\u8981\u5173\u95ed\u5417\uff1f", (String)"SocialInsuranceTaskList_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(String.format(Locale.ROOT, msg, afterMutexCheckTaskIds.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALBACKID_CLOSETASK));
                args.setCancel(true);
                break;
            }
            case "donothing_deletetask": {
                formOperate.getOption().setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                if (formOperate.getOption().tryGetVariableValue(IS_CONFIRM_DELETE_TSAK, new RefObject())) {
                    if (SessionManager.getCurrent().getFormShowParameter(this.getView().getPageId()).isCancelDataRight()) {
                        this.getView().getFormShowParameter().setCancelDataRight(true);
                        this.getView().showConfirm(HCSIErrInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(HCSIErrInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode()));
                        this.recordFailedOpLog(SocialOperationEnum.OP_DELETE_TASK);
                        args.setCancel(true);
                    }
                    this.recordSuccessfulOpLog(SocialOperationEnum.OP_DELETE_TASK);
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"SocialInsuranceTaskList_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(String.format(Locale.ROOT, msg, afterMutexCheckTaskIds.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_deletetask"));
                args.setCancel(true);
                break;
            }
            case "donothing_viewcalreport": {
                args.setCancel(true);
                SocialInsuranceCalHelper.viewAllCalReport((IFormView)view);
                break;
            }
            case "donothing_push": {
                args.setCancel(true);
                HRBaseServiceHelper calPersonHelper = new HRBaseServiceHelper("hcsi_calperson");
                int count = calPersonHelper.count("hcsi_calperson", this.getPushPersonFilterByTasks("1", afterMutexCheckTaskIds).toArray());
                if (count < 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u5185\uff0c\u4e0d\u5b58\u5728\u53ef\u63a8\u9001\u81f3\u7b97\u85aa\u7684\u793e\u4fdd\u660e\u7ec6\u6570\u636e\u3002", (String)"SocialInsuranceTaskList_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    this.releaseSocialTaskMutexLock(afterMutexCheckTaskIds, "donothing_push");
                    break;
                }
                FormShowParameter pushStartForm = CalResultPushHelper.getPushStartForm((List)afterMutexCheckTaskIds);
                pushStartForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcsi_pushstart"));
                pushStartForm.setCustomParam("taskIds", (Object)JSON.toJSONString((Object)afterMutexCheckTaskIds));
                this.getView().showForm(pushStartForm);
                break;
            }
            case "donothing_unpush": {
                args.setCancel(true);
                this.doPushOrUnPush("2", afterMutexCheckTaskIds, null, null);
                break;
            }
            case "donothing_viewpushlog": {
                args.setCancel(true);
                ListShowParameter pushLogListForm = CalResultPushHelper.getPushLogListForm();
                this.getView().showForm((FormShowParameter)pushLogListForm);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        List successPkIds = operationResult == null || operationResult.getSuccessPkIds() == null ? Collections.emptyList() : operationResult.getSuccessPkIds();
        switch (operateKey) {
            case "donothing_launchcal": {
                if (!args.getOperationResult().isSuccess()) break;
                FormShowParameter formShowParameter = SocialInsuranceCalHelper.getLaunchCalForm();
                this.getView().showForm(formShowParameter);
                break;
            }
            case "donothing_close": {
                List taskIds = (List)SerializationUtils.deSerializeFromBase64((String)formOperate.getOption().getVariableValue("taskIds"));
                if (CollectionUtils.isEmpty((Collection)taskIds)) break;
                taskIds = SocialInsuranceCalHelper.getIdsBySelectedRows((ListSelectedRowCollection)formOperate.getListSelectedData());
                this.getView().invokeOperation("refresh");
                this.releaseSocialTaskMutexLock(taskIds, "donothing_close");
                break;
            }
            case "donothing_cancel": {
                List taskIds = (List)SerializationUtils.deSerializeFromBase64((String)formOperate.getOption().getVariableValue("taskIds"));
                if (CollectionUtils.isEmpty((Collection)taskIds)) break;
                taskIds = SocialInsuranceCalHelper.getIdsBySelectedRows((ListSelectedRowCollection)formOperate.getListSelectedData());
                this.getView().invokeOperation("refresh");
                this.releaseSocialTaskMutexLock(taskIds, "donothing_cancel");
                break;
            }
            case "donothing_deletetask": {
                List taskIds = (List)SerializationUtils.deSerializeFromBase64((String)formOperate.getOption().getVariableValue("taskIds"));
                if (CollectionUtils.isEmpty((Collection)taskIds)) break;
                taskIds = SocialInsuranceCalHelper.getIdsBySelectedRows((ListSelectedRowCollection)formOperate.getListSelectedData());
                this.getView().invokeOperation("refresh");
                this.releaseSocialTaskMutexLock(taskIds, "donothing_deletetask");
                break;
            }
            case "donothing_updatecal": {
                List taskIds = (List)SerializationUtils.deSerializeFromBase64((String)formOperate.getOption().getVariableValue("taskIds"));
                if (CollectionUtils.isEmpty((Collection)taskIds)) break;
                List afterMutexCheckTaskIds = SocialInsuranceCalHelper.getIdsBySelectedRows((ListSelectedRowCollection)formOperate.getListSelectedData());
                ArrayList<Long> expiredTaskIds = new ArrayList<Long>(afterMutexCheckTaskIds);
                expiredTaskIds.removeAll(successPkIds);
                if (expiredTaskIds.size() > 0) {
                    this.releaseSocialTaskMutexLock(expiredTaskIds, "donothing_updatecal");
                }
                if (successPkIds.size() == 0) break;
                String cacheUUID = UUID.randomUUID().toString();
                this.initWaitCheckPageCache(cacheUUID, successPkIds.size());
                ThreadPools.executeOnce((String)"sit-socialupdatecalcheck", (Runnable)new SocialInsuranceUpdateCalCheckThread(cacheUUID, afterMutexCheckTaskIds));
                this.openCalCheckWaitPage(cacheUUID);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "confirm_calbackid_closetask": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                OperateOption closeOp = OperateOption.create();
                closeOp.setVariableValue(IS_CONFIRM_CLOSE, "true");
                this.getView().invokeOperation("donothing_close", closeOp);
                break;
            }
            case "donothing_deletetask": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                OperateOption deleteTaskOp = OperateOption.create();
                deleteTaskOp.setVariableValue(IS_CONFIRM_DELETE_TSAK, "true");
                this.getView().invokeOperation("donothing_deletetask", deleteTaskOp);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        String opKey = "";
        Long userId = RequestContext.get().getCurrUserId();
        Map returnData = (Map)event.getReturnData();
        switch (actionId) {
            case "launchcal_callback_id": {
                if (returnData == null) break;
                this.openCalCheckWaitPage((String)returnData.get("cacheUUID"));
                break;
            }
            case "hcsi_calcheckwait": {
                if (returnData == null) break;
                String cacheUUID = (String)returnData.get("cacheUUID");
                this.showMessageAndCalProgress(cacheUUID);
                break;
            }
            case "audit_progress_callback_id": {
                IFormView view = this.getView();
                String userCacheKey = String.format(Locale.ROOT, "openResultWindowsParam_%s", userId);
                ISITAppCache userAppCache = SITAppCache.get((String)userCacheKey);
                Map failFileNumbers = (Map)userAppCache.get("failFileNumbers", Map.class);
                opKey = (String)userAppCache.get("opKey", String.class);
                int fileNum = (Integer)userAppCache.get("fileNum", Integer.class);
                List taskIds = (List)userAppCache.get("taskIds", List.class);
                this.releaseSocialTaskMutexLock(taskIds, opKey);
                this.getView().invokeOperation("refresh");
                SocialInsuranceCalService service = new SocialInsuranceCalService();
                service.openResultWindows(view, failFileNumbers, opKey, fileNum);
                break;
            }
            case "cal_progress_callback_id": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "export_callback_id": {
                if (returnData == null) break;
                List taskIds = (List)SerializationUtils.deSerializeFromBase64((String)((String)returnData.get("taskIds")));
                this.addSocialTaskMutexLock(taskIds, (Enum<? extends ISocialOperationEnum>)SocialOperationEnum.OP_EXPORTDETAIL, true);
                this.exportSocialDetail(taskIds);
                break;
            }
            case "hcsi_pushstart": {
                if (returnData == null) break;
                List pushTaskIds = JSON.parseArray((String)((String)returnData.get("dataIds")), Long.class);
                String withholddate = (String)returnData.get("withholddate");
                String withholdtype = (String)returnData.get("withholdtype");
                this.doPushOrUnPush("1", pushTaskIds, withholdtype, withholddate);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSocialDetail(List<Long> socialTaskIds) {
        long beginTime = System.currentTimeMillis();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcsi_calperson");
        LinkedHashMap<Long, List> detailIdGroupByTaskId = new LinkedHashMap<Long, List>(socialTaskIds.size());
        ArrayList<Long> emptyTaskIds = new ArrayList<Long>(10);
        HashMap<String, Long> socialTaskDisSchRelMap = new HashMap<String, Long>(socialTaskIds.size());
        LinkedHashMap<Long, String> taskIdAndCostTimeMap = new LinkedHashMap<Long, String>(socialTaskIds.size());
        for (Long socialTaskId : socialTaskIds) {
            long beginBatchTime = System.currentTimeMillis();
            String orderBy = "sinsurfilev.number asc";
            String selectFields = "id";
            Long displaySchId = DisplaySchemeService.getDisplaySchemaIdByTaskId((Long)socialTaskId);
            if (displaySchId != null) {
                Set orderByFieldSet;
                socialTaskDisSchRelMap.put(String.valueOf(socialTaskId), displaySchId);
                Map resultMap = DisplaySchemeService.getDisplaySchemaDataById((Long)displaySchId, null);
                String order = (String)resultMap.get("orderBy");
                if (SITStringUtils.isNotEmpty((String)order)) {
                    orderBy = order;
                }
                if ((orderByFieldSet = (Set)resultMap.get("orderByFieldSet")) != null && orderByFieldSet.size() > 0) {
                    selectFields = selectFields + ',' + SITListUtil.join((Set)orderByFieldSet, (String)",");
                }
            }
            QFilter filter = new QFilter("sinsurtask", "=", (Object)socialTaskId);
            QFilter authorizedDataRuleQFilter = SocialInsuranceCalHelper.getAuthorizedDataRuleQFilterOf((String)"hcsi_calperson", (String)"4");
            filter.and(authorizedDataRuleQFilter);
            DynamicObjectCollection query = serviceHelper.queryOriginalCollection(selectFields, filter.toArray(), orderBy);
            if (!CollectionUtils.isEmpty((Collection)query)) {
                List detailIds = query.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
                detailIdGroupByTaskId.put(socialTaskId, detailIds);
            } else {
                emptyTaskIds.add(socialTaskId);
            }
            String costTime = System.currentTimeMillis() - beginBatchTime + "ms";
            taskIdAndCostTimeMap.put(socialTaskId, costTime);
        }
        this.logger.info("SocialInsuranceTaskList.exportSocialDetailquery, calPerson cost time : {}", (Object)JSONObject.toJSONString(taskIdAndCostTimeMap));
        if (socialTaskIds.size() == emptyTaskIds.size()) {
            this.releaseSocialTaskMutexLock(socialTaskIds, "donothing_exportdetail");
            this.getView().showTipNotification(HCSIErrInfoEnum.CAL_TASK_EXPORT_ALL_EMPTY.getErrInfo());
            this.recordFailedOpLog(SocialOperationEnum.OP_EXPORTDETAIL);
            return;
        }
        SocialDetailDownLoadTask task = new SocialDetailDownLoadTask(new ArrayList(detailIdGroupByTaskId.keySet()), this.getView(), socialTaskDisSchRelMap);
        try {
            detailIdGroupByTaskId.forEach((key, val) -> task.addData(String.valueOf(key), 500, val, 1));
            BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
            this.logger.info(" export SocialDetail cost time : {}", (Object)(System.currentTimeMillis() - beginTime));
            if (!execute.isSuccess()) {
                this.showErrorMsg(execute, ResManager.loadKDString((String)"\u5bfc\u51fa\u793e\u4fdd\u660e\u7ec6", (String)"SocialInsuranceTaskList_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            }
            this.recordSuccessfulOpLog(SocialOperationEnum.OP_EXPORTDETAIL);
        }
        finally {
            task.closeTask();
        }
    }

    private void showErrorMsg(BatchResult<?> result, String opString) {
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opString, (String)result.getMessage());
        this.getView().showTipNotification(result.getMessage());
    }

    private void getExportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcsi_sintaskconfirm");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack("kd.sit.hcsi.formplugin.web.cal.task.SocialInsuranceTaskList", EXPORT_CALLBACK_ID));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u793e\u4fdd\u660e\u7ec6", (String)"SocialInsuranceTaskList_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void doPushOrUnPush(String pushType, List<Long> taskIds, String withholdtype, String withholddate) {
        HRBaseServiceHelper calPersonHelper = new HRBaseServiceHelper("hcsi_calperson");
        QFilter filter = this.getPushPersonFilterByTasks(pushType, taskIds);
        DynamicObject[] couldPushDatas = calPersonHelper.query("id,pushstatus,pushlog,batchid", filter.toArray());
        if (couldPushDatas == null || couldPushDatas.length == 0) {
            if (SITStringUtils.equals((String)pushType, (String)"1")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u5185\uff0c\u4e0d\u5b58\u5728\u53ef\u63a8\u9001\u81f3\u7b97\u85aa\u7684\u793e\u4fdd\u660e\u7ec6\u6570\u636e\u3002", (String)"SocialInsuranceTaskList_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                this.releaseSocialTaskMutexLock(taskIds, "donothing_push");
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u5185\uff0c\u4e0d\u5b58\u5728\u53ef\u64a4\u56de\u63a8\u9001\u7684\u793e\u4fdd\u660e\u7ec6\u6570\u636e\u3002", (String)"SocialInsuranceTaskList_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                this.releaseSocialTaskMutexLock(taskIds, "donothing_unpush");
            }
        } else {
            KDSocInsuranceSdkHelper.pushSocInsuranceToSalary(taskIds, (DynamicObject[])couldPushDatas, (String)pushType, (String)"hcsi_sinsurtask", (String)withholdtype, (String)withholddate);
            if (SITStringUtils.equals((String)pushType, (String)"1")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u53d1\u8d77\u63a8\u9001\u3002", (String)"SocialInsuranceTaskList_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u53d1\u8d77\u64a4\u56de\u3002", (String)"SocialInsuranceTaskList_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private QFilter getPushPersonFilterByTasks(String pushType, List<Long> taskIds) {
        QFilter filter = new QFilter("sinsurtask", "in", taskIds);
        String operateKey = null;
        if (SITStringUtils.equals((String)pushType, (String)"1")) {
            operateKey = "donothing_push";
            filter.and("pushstatus", "=", (Object)"notpush");
            filter.and("calstatus", "=", (Object)"2");
        } else if (SITStringUtils.equals((String)pushType, (String)"2")) {
            operateKey = "donothing_unpush";
            filter.and("pushstatus", "=", (Object)"pushed");
        } else {
            filter = new QFilter("1", "!=", (Object)1);
        }
        List authorizedDataRuleQFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_calperson", (String)operateKey);
        if (authorizedDataRuleQFilter != null) {
            authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        } else {
            filter = new QFilter("1", "!=", (Object)1);
        }
        return filter;
    }
}

