/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.cal.task;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.sit.hcsi.business.cal.SocialTaskAuditProgressDTO;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SocialTaskAuditEdit
extends AbstractBasePlugIn
implements ProgresssListener {
    private static final String KEY_AUDIT_PROGRESS_BAR = "auditprogressbar";
    private static final String KEY_RECORDID = "recordId";
    private static final String KEY_SOCIAL_TASK_AUDIT_PROGRESS = "SocialTaskAuditProgress_%s";
    private static final String KEY_TASK_NUM = "tasknum";
    private static final String KEY_FILE_NUM = "filenum";
    private static final String KEY_SUCCESS_NUM = "successnum";
    private static final String KEY_FAIL_NUM = "failnum";
    private static final String KEY_TODO_NUM = "todonum";
    private static final String KEY_SCHEDULE_NUM = "schedulenum";
    private static final String KEY_PERCENT_NUM = "percentnum";
    private static final String BTN_OK = "btn_ok";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_AUDIT_PROGRESS_BAR);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        Label title = (Label)this.getView().getControl("titlelabel");
        SocialTaskAuditProgressDTO socialTaskAuditProgressDTO = this.getSocialTaskAuditProgressDTO();
        String opKey = socialTaskAuditProgressDTO.getOpKey();
        String msg = "";
        msg = SITStringUtils.equals((String)opKey, (String)"donothing_audit") ? ResManager.loadKDString((String)"\u793e\u4fdd\u8ba1\u7b97\u5ba1\u6838\u770b\u677f", (String)"SocialTaskAuditPlugin_0", (String)"sit-hcsi-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u793e\u4fdd\u8ba1\u7b97\u53cd\u5ba1\u6838\u770b\u677f", (String)"SocialTaskAuditPlugin_1", (String)"sit-hcsi-business", (Object[])new Object[0]);
        title.setText(msg);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.startTask();
    }

    public void afterBindData(EventObject event) {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_AUDIT_PROGRESS_BAR);
        progressBar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SITStringUtils.equals((String)progressKey, (String)KEY_AUDIT_PROGRESS_BAR)) {
            this.queryAndSetProgressDetails(progressEvent);
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_AUDIT_PROGRESS_BAR);
        progressBar.start();
        SocialTaskAuditProgressDTO socialTaskAuditProgressDTO = this.getSocialTaskAuditProgressDTO();
        if (socialTaskAuditProgressDTO == null) {
            return;
        }
        int taskNum = socialTaskAuditProgressDTO.getTaskNum();
        Label taskLabel = (Label)this.getControl(KEY_TASK_NUM);
        taskLabel.setText(String.valueOf(taskNum));
        Integer fileNum = socialTaskAuditProgressDTO.getFileNum();
        Label fileLabel = (Label)this.getControl(KEY_FILE_NUM);
        fileLabel.setText(String.valueOf(fileNum));
        Label labelWait = (Label)this.getView().getControl(KEY_TODO_NUM);
        labelWait.setText(String.valueOf(fileNum));
        Label labelSuccess = (Label)this.getView().getControl(KEY_SUCCESS_NUM);
        labelSuccess.setText("0");
        Label labelFail = (Label)this.getView().getControl(KEY_FAIL_NUM);
        labelFail.setText("0");
        Label timeLabel = (Label)this.getView().getControl(KEY_SCHEDULE_NUM);
        String consumeTime = SITDateTimeUtils.getConsumeTime((Date)socialTaskAuditProgressDTO.getStartTime());
        timeLabel.setText(consumeTime);
    }

    private void queryAndSetProgressDetails(ProgressEvent progressEvent) {
        SocialTaskAuditProgressDTO socialTaskAuditProgressDTO = this.getSocialTaskAuditProgressDTO();
        if (socialTaskAuditProgressDTO == null) {
            this.stopProgress(progressEvent);
            return;
        }
        int status = socialTaskAuditProgressDTO.getStatus();
        Integer fileNum = socialTaskAuditProgressDTO.getFileNum();
        Integer successNum = socialTaskAuditProgressDTO.getSuccess();
        Integer failNum = socialTaskAuditProgressDTO.getFail();
        Integer finishNum = successNum + failNum;
        Integer todoNum = fileNum - finishNum;
        Date startTime = socialTaskAuditProgressDTO.getStartTime();
        Label labelSuccess = (Label)this.getView().getControl(KEY_SUCCESS_NUM);
        labelSuccess.setText(String.valueOf(successNum));
        Label labelFail = (Label)this.getView().getControl(KEY_FAIL_NUM);
        labelFail.setText(String.valueOf(failNum));
        Label labelWait = (Label)this.getView().getControl(KEY_TODO_NUM);
        labelWait.setText(String.valueOf(todoNum));
        Label labelTime = (Label)this.getView().getControl(KEY_SCHEDULE_NUM);
        String consumeTime = SITDateTimeUtils.getConsumeTime((Date)startTime);
        labelTime.setText(consumeTime);
        int percentage = 0;
        Label labelPercentage = (Label)this.getView().getControl(KEY_PERCENT_NUM);
        if (status == 0) {
            labelPercentage.setText("0");
            return;
        }
        if (status == 2 || fileNum.equals(finishNum)) {
            percentage = 100;
            this.stopProgress(progressEvent);
            labelPercentage.setText("100");
            this.getView().close();
        } else if (fileNum > 0) {
            percentage = new BigDecimal(String.valueOf(finishNum)).divide(new BigDecimal(String.valueOf(fileNum)), 2, 1).multiply(new BigDecimal("100")).intValue();
            labelPercentage.setText(String.valueOf(percentage));
        }
        progressEvent.setProgress(percentage);
    }

    private ISITAppCache getAppCacheByRecordId() {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID);
        ISITAppCache appCache = SITAppCache.get((String)recordId);
        return appCache;
    }

    private SocialTaskAuditProgressDTO getSocialTaskAuditProgressDTO() {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID);
        ISITAppCache appCache = SITAppCache.get((String)recordId);
        return (SocialTaskAuditProgressDTO)appCache.get(String.format(Locale.ROOT, KEY_SOCIAL_TASK_AUDIT_PROGRESS, recordId), SocialTaskAuditProgressDTO.class);
    }

    private void stopProgress(ProgressEvent progressEvent) {
        ISITAppCache appCache = SITAppCache.get((String)KEY_RECORDID);
        appCache.put("isFinish", (Object)"true");
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
    }

    public void beforeClosed(BeforeClosedEvent event) {
        int status;
        SocialTaskAuditProgressDTO socialTaskAuditProgressDTO = this.getSocialTaskAuditProgressDTO();
        if (socialTaskAuditProgressDTO != null && (status = socialTaskAuditProgressDTO.getStatus().intValue()) == 2) {
            this.getAppCacheByRecordId().clear();
        }
    }
}

