/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.calbase;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.sit.sitbp.business.basecal.BaseCalHelper;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class BaseCalProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_TOTALLABEL = "totallabel";
    private static final String WAIT = "wait";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String KEY_PANEL_FINISH = "panelfinish";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";
    private static final String KEY_PROGRESSBARAP = "progressbarap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CLOSE = "btnclose";
    private static final String KEY_PANEL_HANDLING = "panelhandling";
    private static final String KEY_TIMELABEL = "timelabel";
    private static final String KEY_RECORDID = "recordId";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PANEL_FINISH, BTN_CLOSE});
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        DynamicObject record = this.getRecord();
        this.setFormInfo(record, null);
    }

    public void afterBindData(EventObject event) {
        this.startTask();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SITStringUtils.equals((String)progressKey, (String)KEY_PROGRESSBARAP)) {
            DynamicObject record = this.getRecord();
            this.setFormInfo(record, progressEvent);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        DynamicObject record = this.getRecord();
        if (record != null) {
            Date endtime = record.getDate("endtime");
            String floatingTaskId = (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid");
            HashMap<String, Long> params = new HashMap<String, Long>(16);
            params.put(KEY_RECORDID, record.getLong("id"));
            if (SITStringUtils.isEmpty((String)floatingTaskId) && endtime == null) {
                HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
                String ballName = ResManager.loadKDString((String)"\u57fa\u6570\u8ba1\u7b97{0}", (String)"BaseCalProgressPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[]{record.getString("number")});
                String bgTaskId = instance.createBaskgroundTask("sit_hcsi_basecal", ballName, true, this.getView().getMainView().getPageId(), this.getView().getParentView().getPageId(), params);
                instance.showBaskgroundTask(bgTaskId);
            } else if (SITStringUtils.isNotEmpty((String)floatingTaskId) && endtime != null) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "COMPLETED");
            }
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private DynamicObject getRecord() {
        Long recordId = (Long)this.getView().getFormShowParameter().getCustomParam(KEY_RECORDID);
        DynamicObject record = BaseCalHelper.queryRecord((Long)recordId);
        return record;
    }

    private void stopProgress() {
        this.setStopProgressFormInfo();
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        bar.setPercent(100);
        bar.stop();
        this.updateParentView();
    }

    private void setStopProgressFormInfo() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_PANEL_HANDLING});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE, KEY_PANEL_FINISH});
    }

    private void setFormInfo(DynamicObject record, ProgressEvent progressEvent) {
        int total = 0;
        int success = 0;
        int fail = 0;
        Date startTime = new Date();
        Date endTime = new Date();
        if (record != null) {
            total = record.getInt("total");
            success = record.getInt(SUCCESS);
            fail = record.getInt(FAIL);
            startTime = record.getDate("starttime");
            endTime = record.getDate("endtime");
        } else if (progressEvent != null) {
            this.stopProgress();
        }
        int finish = success + fail;
        int wait = total - finish;
        if (wait < 0) {
            wait = 0;
        }
        Label totalLabel = (Label)this.getControl(KEY_TOTALLABEL);
        totalLabel.setText(String.valueOf(total));
        Label labelWait = (Label)this.getView().getControl(WAIT);
        labelWait.setText(String.valueOf(wait));
        Label labelSuccess = (Label)this.getView().getControl(SUCCESS);
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl(FAIL);
        labelFail.setText(String.valueOf(fail));
        Label labelTime = (Label)this.getView().getControl(KEY_TIMELABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SITDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u8017\u65f6{0}", (String)"LoadingCalculationPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), consumeTime);
        labelTime.setText(msg);
        int percentage = 0;
        Label labelPercentage = (Label)this.getView().getControl(PROGRESS_NUM_LABEL);
        if (total > 0) {
            percentage = new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
            labelPercentage.setText(String.valueOf(percentage));
        }
        if (percentage >= 100) {
            this.stopProgress();
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        }
    }

    private void updateParentView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }
}

