/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.calbase;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.cal.mq.BatchSocialBaseCalPublisher;
import kd.sit.sitbp.business.basecal.BaseCalHelper;
import kd.sit.sitbp.business.datachanged.BizChangedHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class GenBasePrePagePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String RANGE_COMPANY = "bycompany";
    public static final String KEY_WELFAREPAYERS = "welfarepayers";
    public static final String KEY_SINSURFILES = "sinsurfiles";
    public static final String NEW_OR_CHANGGE_STD = "0";
    public static final String KEY_SINSURSTD = "sinsurstd";
    public static final String DONOTHING_CAL = "donothing_cal";
    private static final String CALLBACKID_CONTINUE_CLOSE = "continue_close";
    public static final String KEY_CALTYPE = "caltype";
    public static final String KEY_RANGETYPE = "rangetype";
    public static final String KEY_SINSURTYPES = "sinsurtypes";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit edit = (MulBasedataEdit)this.getView().getControl(KEY_WELFAREPAYERS);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit fileMulBasedataEdit = (MulBasedataEdit)this.getView().getControl(KEY_SINSURFILES);
        fileMulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit sinsurtypeEdit = (MulBasedataEdit)this.getView().getControl(KEY_SINSURTYPES);
        sinsurtypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sinsurstdEdit = (BasedataEdit)this.getView().getControl(KEY_SINSURSTD);
        sinsurstdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.setRangtypeVisable();
        this.setSinsurStdVisable();
    }

    private void setSinsurStdVisable() {
        boolean isChangeStd = this.isChangeStd();
        BasedataEdit sinsurstdContorl = (BasedataEdit)this.getControl(KEY_SINSURSTD);
        sinsurstdContorl.setMustInput(isChangeStd);
        this.getView().setVisible(Boolean.valueOf(isChangeStd), new String[]{KEY_SINSURSTD});
    }

    private boolean isChangeStd() {
        String caltype = this.getModel().getDataEntity().getString(KEY_CALTYPE);
        return SITStringUtils.equals((String)NEW_OR_CHANGGE_STD, (String)caltype);
    }

    private void setRangtypeVisable() {
        boolean isByCompany = this.isByCompany();
        MulBasedataEdit welfarepayeContorl = (MulBasedataEdit)this.getControl(KEY_WELFAREPAYERS);
        MulBasedataEdit sinsurfileContorl = (MulBasedataEdit)this.getControl(KEY_SINSURFILES);
        welfarepayeContorl.setMustInput(isByCompany);
        sinsurfileContorl.setMustInput(!isByCompany);
        this.getView().setVisible(Boolean.valueOf(isByCompany), new String[]{KEY_WELFAREPAYERS});
        this.getView().setVisible(Boolean.valueOf(!isByCompany), new String[]{KEY_SINSURFILES});
    }

    private boolean isByCompany() {
        String rangetype = this.getModel().getDataEntity().getString(KEY_RANGETYPE);
        return SITStringUtils.equals((String)RANGE_COMPANY, (String)rangetype);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        switch (fieldKey) {
            case "welfarepayers": {
                customQFilters.add(new QFilter("basecalrule.id", "is not null", (Object)""));
                customQFilters.add(new QFilter("basecalrule.id", "!=", (Object)0L));
                if (SITPermissionServiceHelper.isSuperUser()) break;
                QFilter dataRuleForBdProp = SITPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"welfarepayer", (String)"4==10P+LJ/DJ");
                HasPermOrgResult hasPermOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"4==10P+LJ/DJ");
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    customQFilters.add(new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
                }
                if (dataRuleForBdProp == null) break;
                customQFilters.add(dataRuleForBdProp);
                break;
            }
            case "sinsurfiles": {
                QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                if (this.isChangeStd()) {
                    qFilter.and("status", "in", Arrays.asList("A", "C"));
                    beforeF7SelectEvent.getFormShowParameter().setCustomParam("f7type", (Object)"1");
                } else {
                    qFilter.and("status", "=", (Object)"C");
                }
                customQFilters.add(qFilter);
                this.addFileAuthorFilter(qFilter);
                break;
            }
            case "sinsurtypes": {
                if (this.isChangeStd()) {
                    DynamicObject sinsurstd = this.getModel().getDataEntity().getDynamicObject(KEY_SINSURSTD);
                    if (sinsurstd == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u53c2\u4fdd\u6807\u51c6\u518d\u9009\u62e9\u9669\u79cd\u3002", (String)"GenBasePrePagePlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                        return;
                    }
                    DynamicObjectCollection stdentryentity = sinsurstd.getDynamicObjectCollection("stdentryentity");
                    List insurtypeIds = stdentryentity.stream().map(o -> o.getLong("insurtype.id")).collect(Collectors.toList());
                    beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", insurtypeIds));
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setShowApproved(false);
                showParameter.setShowUsed(false);
                break;
            }
            case "sinsurstd": {
                if (!this.isByCompany()) break;
                DynamicObjectCollection welfarepayers = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_WELFAREPAYERS);
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                if (welfarepayers == null || welfarepayers.isEmpty() || bsed == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u53c2\u4fdd\u5355\u4f4d\u3001\u57fa\u6570\u751f\u6548\u65e5\u671f\u518d\u9009\u62e9\u53c2\u4fdd\u6807\u51c6\u3002", (String)"GenBasePrePagePlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                this.filterStd(beforeF7SelectEvent, welfarepayers, bsed);
                break;
            }
        }
    }

    private void filterStd(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObjectCollection welfarepayers, Date bsed) {
        HashSet stdIds = new HashSet(16);
        HRBaseServiceHelper companyStdRefHelper = new HRBaseServiceHelper("sitbs_coanddimref");
        QFilter filter = new QFilter("welfarepayer", "in", welfarepayers.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        filter.and("bsed", "<=", (Object)bsed);
        filter.and("bsled", ">=", (Object)bsed);
        filter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("datastatus", "in", Arrays.asList("1", "2", NEW_OR_CHANGGE_STD));
        DynamicObject[] refs = companyStdRefHelper.query("welfarepayer.id,mulsinsurstd", filter.toArray());
        if (refs != null) {
            for (DynamicObject ref : refs) {
                DynamicObjectCollection mulStdDys = ref.getDynamicObjectCollection("mulsinsurstd");
                mulStdDys.forEach(o -> stdIds.add(o.getLong("fbasedataid.id")));
            }
        }
        beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", stdIds));
    }

    private void addFileAuthorFilter(QFilter filter) {
        List authorFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"donothing_genbasebyrule");
        if (authorFilters == null) {
            filter.and(new QFilter("1", "=", (Object)2));
        } else {
            authorFilters.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"4==10P+LJ/DJ");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            filter.and(new QFilter("org", "in", (Object)hasPermOrgs));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        DynamicObject obj = this.getModel().getDataEntity(true);
        switch (key) {
            case "caltype": {
                this.setSinsurStdVisable();
                break;
            }
            case "rangetype": {
                this.setRangtypeVisable();
                break;
            }
            case "sinsurtypes": 
            case "welfarepayers": 
            case "sinsurfiles": {
                BizChangedHelper.operateBizChangedSet((DynamicObject)obj, Collections.singletonList(key), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.ADD);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && CALLBACKID_CONTINUE_CLOSE.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getPageCache().put(CALLBACKID_CONTINUE_CLOSE, "1");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (SITStringUtils.isEmpty((String)this.getPageCache().get(CALLBACKID_CONTINUE_CLOSE)) && this.getModel().getDataChanged()) {
            e.setCancel(true);
            BizChangedHelper.showConfirm((AbstractFormPlugin)this, (String)this.getModel().getChangeDesc(), (String)CALLBACKID_CONTINUE_CLOSE, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_cal": {
                QFilter qFilter;
                if (SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
                    return;
                }
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                HashMap<Long, List> welfarepayerFileMap = new HashMap<Long, List>(16);
                if (this.isByCompany()) {
                    DynamicObjectCollection welfarepayers = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_WELFAREPAYERS);
                    ArrayList<Long> welfarepayerIds = new ArrayList<Long>(welfarepayers.size());
                    for (DynamicObject welfarepayer : welfarepayers) {
                        welfarepayerIds.add(welfarepayer.getLong("fbasedataid_id"));
                    }
                    Map welfarepayerRulevRel = BaseCalHelper.getWelfarepayerRulevRelByBsed(welfarepayerIds, (Date)bsed);
                    if (welfarepayerRulevRel.size() == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u53c2\u4fdd\u5355\u4f4d\u627e\u4e0d\u5230\u53ef\u7528\u7684\u57fa\u6570\u8ba1\u7b97\u89c4\u5219", (String)"GenBasePrePagePlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (welfarepayerRulevRel.size() < welfarepayerIds.size()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u6392\u9664\u627e\u4e0d\u5230\u57fa\u6570\u8ba1\u7b97\u89c4\u5219\u7684\u53c2\u4fdd\u5355\u4f4d/\u4eba\u5458\u793e\u4fdd\u6863\u6848", (String)"GenBasePrePagePlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    }
                    qFilter = new QFilter("welfarepayer.id", "in", welfarepayerRulevRel.keySet());
                    BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                    this.addFileAuthorFilter(qFilter);
                    if (this.isChangeStd()) {
                        qFilter.and("status", "in", Arrays.asList("C", "A"));
                    } else {
                        qFilter.and("status", "=", (Object)"C");
                    }
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurfile");
                    Iterator files = helper.queryOriginalCollection("id,welfarepayer.id", qFilter.toArray());
                    Iterator iterator = files.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject file = (DynamicObject)iterator.next();
                        long welfarepayerId = file.getLong("welfarepayer.id");
                        if (welfarepayerId == 0L) continue;
                        List filegroup = welfarepayerFileMap.computeIfAbsent(welfarepayerId, o -> new ArrayList(10));
                        filegroup.add(file.getLong("id"));
                    }
                } else {
                    DynamicObjectCollection sinsurfiles = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_SINSURFILES);
                    ArrayList<Long> fileIds = new ArrayList<Long>(sinsurfiles.size());
                    for (DynamicObject sinsurfile : sinsurfiles) {
                        fileIds.add(sinsurfile.getLong("fbasedataid_id"));
                    }
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurfile");
                    qFilter = new QFilter("id", "in", fileIds);
                    DynamicObjectCollection files = helper.queryOriginalCollection("id,welfarepayer.id", qFilter.toArray());
                    welfarepayerFileMap = new HashMap(16);
                    for (DynamicObject file : files) {
                        long welfarepayerId = file.getLong("welfarepayer.id");
                        if (welfarepayerId == 0L) continue;
                        List filegroup = welfarepayerFileMap.computeIfAbsent(welfarepayerId, o -> new ArrayList(10));
                        filegroup.add(file.getLong("id"));
                    }
                    Map welfarepayerRulevRel = BaseCalHelper.getWelfarepayerRulevRelByBsed(welfarepayerFileMap.keySet(), (Date)bsed);
                    if (welfarepayerRulevRel.size() == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u53c2\u4fdd\u5355\u4f4d\u627e\u4e0d\u5230\u53ef\u7528\u7684\u57fa\u6570\u8ba1\u7b97\u89c4\u5219", (String)"GenBasePrePagePlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (welfarepayerRulevRel.size() < welfarepayerFileMap.size()) {
                        this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u6392\u9664\u627e\u4e0d\u5230\u57fa\u6570\u8ba1\u7b97\u89c4\u5219\u7684\u53c2\u4fdd\u5355\u4f4d/\u4eba\u5458\u793e\u4fdd\u6863\u6848", (String)"GenBasePrePagePlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    }
                    HashSet<Long> withRuleWelfareIds = new HashSet<Long>(welfarepayerFileMap.size());
                    for (Long welfarepayerId : welfarepayerFileMap.keySet()) {
                        if (welfarepayerRulevRel.containsKey(welfarepayerId)) continue;
                        withRuleWelfareIds.add(welfarepayerId);
                    }
                    withRuleWelfareIds.forEach(welfarepayerFileMap::remove);
                }
                String caltype = this.getModel().getDataEntity().getString(KEY_CALTYPE);
                int size = welfarepayerFileMap.values().stream().mapToInt(List::size).sum();
                if (size == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u8303\u56f4\u4e0b\u65e0\u53ef\u8ba1\u7b97\u7684\u793e\u4fdd\u4eba\u5458\u6863\u6848\u3002", (String)"GenBasePrePagePlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    return;
                }
                long baseCalRecordId = BaseCalHelper.createBaseCalRecord(welfarepayerFileMap, (Date)bsed, (String)caltype);
                DynamicObjectCollection sinsurtypes = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_SINSURTYPES);
                ArrayList<Long> sinsurtypeIds = new ArrayList<Long>(10);
                for (DynamicObject sinsurtype : sinsurtypes) {
                    sinsurtypeIds.add(sinsurtype.getLong("fbasedataid_id"));
                }
                long sinsurstdId = this.getModel().getDataEntity().getLong("sinsurstd.id");
                for (Map.Entry entry : welfarepayerFileMap.entrySet()) {
                    Long welfarepayerId = (Long)entry.getKey();
                    List fileIds = (List)entry.getValue();
                    List bathList = Lists.partition((List)fileIds, (int)2000);
                    for (List subList : bathList) {
                        HashMap<String, Object> params = new HashMap<String, Object>(16);
                        params.put("baseCalRecordId", baseCalRecordId);
                        params.put("fileIds", subList);
                        params.put("welfarepayerId", welfarepayerId);
                        params.put("sinsurtypeIds", sinsurtypeIds);
                        params.put("sinsurstdId", sinsurstdId);
                        BatchSocialBaseCalPublisher.publish(params);
                    }
                }
                BaseCalHelper.addCalLog();
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hcsi_basecalprogress");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("recordId", (Object)baseCalRecordId);
                this.getPageCache().put(CALLBACKID_CONTINUE_CLOSE, "1");
                this.getView().getParentView().showForm(showParameter);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                break;
            }
        }
    }
}

