/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.calbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.basecal.BaseCalHelper;
import kd.sit.sitbp.business.datachanged.BizChangedHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.BaseCalTypeEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class GenBasePreSinglePagePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String DONOTHING_CAL = "donothing_cal";
    private static final String CALLBACKID_CONTINUE_CLOSE = "continue_close";
    public static final String KEY_MATCHTYPE = "matchtype";
    public static final String KEY_SINSURTYPES = "sinsurtypes";
    public static final String KEY_BASECALRULE = "basecalrule";

    public void registerListener(EventObject e) {
        MulBasedataEdit sinsurtypeEdit = (MulBasedataEdit)this.getView().getControl(KEY_SINSURTYPES);
        sinsurtypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject file = this.queryFile();
        boolean isescrowstaff = file.getBoolean("isescrowstaff");
        if (!this.isChangeBase(file)) {
            Date sinsurstdBsed = this.getView().getParentView().getModel().getDataEntity().getDate("bsed");
            this.getModel().setValue("bsed", (Object)sinsurstdBsed);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bsed"});
            this.getModel().setDataChanged(false);
        }
        ComboEdit mathtypeEdit = (ComboEdit)this.getControl(KEY_MATCHTYPE);
        mathtypeEdit.setMustInput(isescrowstaff);
        this.getView().setVisible(Boolean.valueOf(isescrowstaff), new String[]{KEY_MATCHTYPE});
        this.setBaseRuleValue();
    }

    private DynamicObject queryFile() {
        Long sinSurFileId = (Long)this.getView().getFormShowParameter().getCustomParam("sinSurFileId");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurfile");
        DynamicObject file = helper.queryOne((Object)sinSurFileId);
        return file;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && CALLBACKID_CONTINUE_CLOSE.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getPageCache().put(CALLBACKID_CONTINUE_CLOSE, "1");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (SITStringUtils.isEmpty((String)this.getPageCache().get(CALLBACKID_CONTINUE_CLOSE)) && this.getModel().getDataChanged()) {
            e.setCancel(true);
            BizChangedHelper.showConfirm((AbstractFormPlugin)this, (String)this.getModel().getChangeDesc(), (String)CALLBACKID_CONTINUE_CLOSE, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_cal": {
                Map welfarepayerRulevRel;
                if (SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
                    return;
                }
                Date bsed = this.getModel().getDataEntity().getDate("bsed");
                DynamicObject file = this.queryFile();
                if (file == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6863\u6848\u4e0d\u5b58\u5728\u3002", (String)"GenBasePreSinglePagePlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    return;
                }
                String matchType = this.getModel().getDataEntity().getString(KEY_MATCHTYPE);
                long welfarepayerId = file.getLong("welfarepayer.id");
                if (SITStringUtils.equals((String)matchType, (String)"1")) {
                    welfarepayerId = file.getLong("welfarepayertheory.id");
                }
                if ((welfarepayerRulevRel = BaseCalHelper.getWelfarepayerRulevRelByBsed(Collections.singletonList(welfarepayerId), (Date)bsed)).size() < 1) {
                    if (SITStringUtils.equals((String)matchType, (String)"1")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5728\u57fa\u6570\u751f\u6548\u65e5\u671f\u65f6\u70b9\uff0c\u6839\u636e\u201c\u6309\u7406\u8bba\u53c2\u4fdd\u5355\u4f4d\u5339\u914d\u201d\u65e0\u6cd5\u627e\u5230\u57fa\u6570\u8ba1\u7b97\u89c4\u5219\u3002", (String)"GenBasePreSinglePagePlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5728\u57fa\u6570\u751f\u6548\u65e5\u671f\u65f6\u70b9\uff0c\u6839\u636e\u201c\u6309\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u5339\u914d\u201d\u65e0\u6cd5\u627e\u5230\u57fa\u6570\u8ba1\u7b97\u89c4\u5219\u3002", (String)"GenBasePreSinglePagePlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                long fileId = file.getLong("id");
                String caltype = BaseCalTypeEnum.ADD_OR_CHANGE_STD.getCode();
                Long sinsurstdId = (Long)this.getView().getFormShowParameter().getCustomParam("sinsurstdId");
                Date sinsurstdBsed = this.getView().getParentView().getModel().getDataEntity().getDate("bsed");
                if (this.isChangeBase(file)) {
                    caltype = BaseCalTypeEnum.CHANGE_BASE.getCode();
                    Date sinsurstdBlsed = this.getView().getParentView().getModel().getDataEntity().getDate("bsled");
                    if (bsed.after(sinsurstdBlsed) || bsed.before(sinsurstdBsed)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u8c03\u6574\u57fa\u6570\u65f6\uff0c\u57fa\u6570\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5728\u53c2\u4fdd\u6807\u51c6\u7684\u751f\u5931\u6548\u65e5\u671f\u4e4b\u95f4\u3002", (String)"GenBasePreSinglePagePlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (SITStringUtils.equals((String)file.getString("status"), (String)"A") && !SITDateTimeUtils.dayEquals((Date)sinsurstdBsed, (Date)bsed)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u6570\u751f\u6548\u65e5\u671f\u5fc5\u987b\u4e3a\u3010{0}\u3011\u3002", (String)"GenBasePreSinglePagePlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[]{SITDateTimeUtils.formatDate((Date)sinsurstdBsed)}));
                    return;
                }
                long baseCalRecordId = BaseCalHelper.createBaseCalRecord(null, (Date)bsed, (String)caltype);
                DynamicObjectCollection sinsurtypes = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_SINSURTYPES);
                ArrayList<Long> sinsurtypeIds = new ArrayList<Long>(10);
                for (DynamicObject sinsurtype : sinsurtypes) {
                    sinsurtypeIds.add(sinsurtype.getLong("fbasedataid_id"));
                }
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("baseCalRecordId", baseCalRecordId);
                params.put("fileIds", Collections.singletonList(fileId));
                params.put("welfarepayerId", welfarepayerId);
                params.put("sinsurtypeIds", sinsurtypeIds);
                params.put("sinsurstdId", sinsurstdId);
                params.put("stdBsed", sinsurstdBsed);
                params.put("isFileEdit", Boolean.TRUE);
                params.put("isSync", Boolean.TRUE);
                BaseCalHelper.addCalLog();
                Map result = (Map)SITMServiceUtils.invokeSITService((String)"sitcs", (String)"SocInsuranceCalService", (String)"baseCalService", (Object[])new Object[]{params});
                this.getView().returnDataToParent((Object)result);
                this.getPageCache().put(CALLBACKID_CONTINUE_CLOSE, "1");
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "sinsurtypes": {
                DynamicObject sinsurstd = this.getView().getParentView().getModel().getDataEntity().getDynamicObject("sinsurstd");
                DynamicObjectCollection stdentryentity = sinsurstd.getDynamicObjectCollection("stdentryentity");
                List insurtypeIds = stdentryentity.stream().map(o -> o.getLong("insurtype.id")).collect(Collectors.toList());
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", insurtypeIds));
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setShowApproved(false);
                showParameter.setShowUsed(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "bsed": 
            case "matchtype": {
                this.setBaseRuleValue();
                break;
            }
            case "sinsurtypes": {
                BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), Collections.singletonList(key), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.ADD);
                break;
            }
        }
    }

    private void setBaseRuleValue() {
        Map welfarepayerRulevRel;
        Long ruleId;
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        if (bsed == null) {
            return;
        }
        DynamicObject file = this.queryFile();
        long welfarepayerId = file.getLong("welfarepayer.id");
        String matchType = this.getModel().getDataEntity().getString(KEY_MATCHTYPE);
        if (SITStringUtils.equals((String)matchType, (String)"1")) {
            welfarepayerId = file.getLong("welfarepayertheory.id");
        }
        if ((ruleId = (Long)(welfarepayerRulevRel = BaseCalHelper.getWelfarepayerRulevRelByBsed(Collections.singletonList(welfarepayerId), (Date)bsed)).get(welfarepayerId)) != null && ruleId != 0L) {
            this.getModel().setValue(KEY_BASECALRULE, (Object)ruleId);
        } else {
            this.getModel().setValue(KEY_BASECALRULE, null);
        }
        BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), Collections.singletonList(KEY_BASECALRULE), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
    }

    private DynamicObject getRefStd(Long fileId, Date bsed) {
        QFilter refFilter = new QFilter("sinsurfile", "=", (Object)fileId);
        refFilter.and("bsed", "<=", (Object)bsed);
        refFilter.and("bsled", ">=", (Object)bsed);
        refFilter.and("iscurrentversion", "=", (Object)Boolean.FALSE);
        refFilter.and("datastatus", "in", Arrays.asList("1", "2", "0"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_sinsurfilestd");
        return helper.queryOne("bsed,sinsurstd.id", new QFilter[]{refFilter});
    }

    private boolean isChangeBase(DynamicObject file) {
        Long sinsurstdId = (Long)this.getView().getFormShowParameter().getCustomParam("sinsurstdId");
        Date sinsurstdBsed = this.getView().getParentView().getModel().getDataEntity().getDate("bsed");
        long fileId = file.getLong("id");
        if (SITStringUtils.equals((String)file.getString("status"), (String)"C")) {
            DynamicObject refStd = this.getRefStd(fileId, sinsurstdBsed);
            return refStd != null && sinsurstdBsed.equals(refStd.getDate("bsed")) && sinsurstdId.longValue() == refStd.getLong("sinsurstd.id");
        }
        return false;
    }
}

