/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclperson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.CardListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.VoucherNoListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.service.InsuranceStandardService;
import kd.sit.hcsi.business.declare.dto.DclPersonCacheDTO;
import kd.sit.hcsi.business.declare.dto.DclPersonFieldDTO;
import kd.sit.hcsi.business.declare.enums.DclModifyTypeEnum;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.DclPersonService;
import kd.sit.sitbp.business.helper.qfilter.UpdateQFilterHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.tab.UpdateTabNameHelper;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.model.SitEntityTypeBillList;

public class DclPersonBaseList
extends AbstractListPlugin
implements FilterContainerInitListener {
    private final Log log = LogFactory.getLog(DclPersonBaseList.class);
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String CURRENCY_KEY = "salarydetailcurrency_c";
    private static final List<String> LB_LIST = Arrays.asList("dcl_record_name_val", "insured_company_name_val", "sinsur_period_val", "modify_type_val");
    private SitEntityTypeBillList billList;

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        this.getView().addCustomControls(new String[]{KEY_BILL_LIST_AP});
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(LB_LIST.toArray(new String[0]));
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        args.setNewEntityType(this.getEntityType());
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)"hcsi_dclperson");
        List columns = args.getListColumns();
        this.log.info("DclPersonBaseList.beforeCreateList begin.");
        long startTime = System.currentTimeMillis();
        List<IListColumn> newColumns = this.loadDclResultDetailInfo(columns);
        args.setListColumns(newColumns);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        billList.setOrderBy("sinsurfilev.number asc");
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("DclPersonBaseList.beforeCreateList end,cost time {}", (Object)costTime);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.log.info("DclPersonBaseList.beforeCreateListDataProvider begin");
        long startTime = System.currentTimeMillis();
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DclDetailResultLoadDataImpl());
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("DclPersonBaseList.beforeCreateListDataProvider end,cost time {}", (Object)costTime);
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        this.log.info("DclPersonBaseList.filterContainerInit begin");
        long startTime = System.currentTimeMillis();
        Map<String, String> fieldKeyAndRefName = this.getFieldKeyAndRefNameMap();
        if (fieldKeyAndRefName == null) {
            return;
        }
        List schemeFilterColumns = filterContainerInitEvent.getSchemeFilterColumns();
        Map<String, FilterColumn> schemeFilterColumnMap = schemeFilterColumns.stream().collect(Collectors.toMap(FilterColumn::getFieldName, filterColumn -> filterColumn, (oldVal, newVal) -> oldVal));
        ArrayList<FilterColumn> newFilterColumns = new ArrayList<FilterColumn>(schemeFilterColumns.size());
        for (Map.Entry<String, String> fieldKeyEntry : fieldKeyAndRefName.entrySet()) {
            FilterColumn filterColumn2 = schemeFilterColumnMap.get(fieldKeyEntry.getKey());
            if (filterColumn2 == null) continue;
            if (fieldKeyEntry.getValue() != null) {
                filterColumn2.setCaption(new LocaleString(fieldKeyEntry.getValue()));
            }
            newFilterColumns.add(filterColumn2);
        }
        schemeFilterColumns.clear();
        schemeFilterColumns.addAll(newFilterColumns);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        Optional permOrgs = DclRecordHelper.getDclPersonPermOrgs();
        switch (fieldName) {
            case "insuredcompany.name": 
            case "insuredcompany.id": 
            case "sinsurfilev.id": 
            case "sinsurfilev.name": 
            case "sinsurfilev.number": 
            case "sinsurfile.id": 
            case "sinsurfile.name": 
            case "sinsurfilev.welfarepayertheory.id": 
            case "sinsurfilev.welfarepayertheory.name": 
            case "sinsurpersonv.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("org", "in", orgs)));
                break;
            }
            case "sinsurfilev.org.name": 
            case "sinsurfilev.org.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("id", "in", orgs)));
                break;
            }
            case "sinsurfilev.empgroup.name": 
            case "sinsurfilev.empgroup.id": {
                List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
                QFilter empGroupFilter = new QFilter("id", "in", (Object)empgoupIds);
                filters.add(empGroupFilter);
                break;
            }
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String entityId = this.getView().getEntityId();
        if (entityId.contains("bos_listf7")) {
            return;
        }
        this.setLabelContext();
    }

    public void setFilter(SetFilterEvent event) {
        UpdateQFilterHelper.updateQFilter((List)event.getQFilters(), (String)"mulsinsurstd.fbasedataid.id", (String)"mulsinsurstd.fbasedataid.name", (String)"sitbs_sinsurstd");
        DclPersonCacheDTO dclPersonCacheDTO = InsuranceStandardService.getDclPersonCacheDTO((Map)this.getView().getFormShowParameter().getCustomParams());
        QFilter filter = new QFilter("dclrecord", "=", (Object)dclPersonCacheDTO.getDclRecordId());
        filter.and(DclRecordHelper.getAuthorizedDataRuleQFilter());
        event.getQFilters().add(filter);
        event.setOrderBy("sinsurfilev.number asc");
    }

    private MainEntityType getEntityType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hcsi_dclperson");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.error("DeclarePersonBaseList.getEntityType(): ", (Throwable)e);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        long startTime = System.currentTimeMillis();
        List<DclPersonFieldDTO> extendFieldInfoList = this.getExtendFieldInfoList();
        long endTime = System.currentTimeMillis();
        this.log.info("DclPersonBaseList.getEntityType, extendFieldInfoList use time: {}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        this.addItemProp(extendFieldInfoList, (DynamicObjectType)mainEntityType);
        endTime = System.currentTimeMillis();
        this.log.info("DclPersonBaseList.getEntityType, addItemProp use time: {}", (Object)(endTime - startTime));
        return mainEntityType;
    }

    private BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new SitEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("hcsi_dclrecord");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        long startTime = System.currentTimeMillis();
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        long endTime = System.currentTimeMillis();
        this.log.info("createBillList replaceBillList use time:" + (endTime - startTime));
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private List<DclPersonFieldDTO> getExtendFieldInfoList() {
        DclPersonCacheDTO dclPersonCacheDTO = this.getDclPersonCacheDTO();
        return DclPersonService.getInstance().getExtendFieldInfoList(this.getView(), dclPersonCacheDTO);
    }

    private void addItemProp(List<DclPersonFieldDTO> insuredStandardList, DynamicObjectType mainEntityType) {
        for (DclPersonFieldDTO insuredStandard : insuredStandardList) {
            TextProp property;
            String insuredItemName = insuredStandard.getInsuredItemName();
            Long dataTypeId = insuredStandard.getDataTypeId();
            dataTypeId = SitDataTypeEnum.TEXT.getId();
            int dataLength = insuredStandard.getDataLength();
            int scale = insuredStandard.getScale();
            String columnKey = insuredStandard.getFieldKey();
            if (dataTypeId.equals(SitDataTypeEnum.TEXT.getId())) {
                property = this.getTextProp(dataLength, insuredItemName, columnKey);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (!dataTypeId.equals(SitDataTypeEnum.NUMBER.getId()) && !dataTypeId.equals(SitDataTypeEnum.AMOUNT.getId())) continue;
            property = this.getDecimalProp(scale, insuredItemName, columnKey);
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    private List<IListColumn> loadDclResultDetailInfo(List<IListColumn> columns) {
        long startTime = System.currentTimeMillis();
        LinkedHashMap<String, IListColumn> columnMap = new LinkedHashMap<String, IListColumn>(columns.size());
        ArrayList<IListColumn> otherColumns = new ArrayList<IListColumn>(10);
        for (IListColumn listColumn : columns) {
            boolean isInvalidListColumnType;
            boolean bl = isInvalidListColumnType = listColumn instanceof CardListColumn || listColumn instanceof ListOperationColumn || listColumn instanceof VoucherNoListColumn || listColumn instanceof TemplateTextListColumn || listColumn instanceof DynamicTextListColumn || listColumn.getClass().getName().contains("PictureListColumn") || listColumn.getClass().getName().contains("AvatarListColumn") || HRStringUtils.isEmpty((String)listColumn.getListFieldKey());
            if (!isInvalidListColumnType) {
                columnMap.put(listColumn.getListFieldKey(), listColumn);
                continue;
            }
            otherColumns.add(listColumn);
        }
        ArrayList<IListColumn> newListColumns = new ArrayList<IListColumn>(columnMap.size());
        newListColumns.addAll(otherColumns);
        Map<String, String> fieldKeyAndRefName = this.getFieldKeyAndRefNameMap();
        if (fieldKeyAndRefName != null) {
            for (Map.Entry<String, String> fieldKeyEntry : fieldKeyAndRefName.entrySet()) {
                IListColumn iListColumn = (IListColumn)columnMap.get(fieldKeyEntry.getKey());
                if (iListColumn == null) continue;
                if (fieldKeyEntry.getValue() != null) {
                    iListColumn.setCaption(new LocaleString(fieldKeyEntry.getValue()));
                }
                newListColumns.add(iListColumn);
            }
        }
        List<DclPersonFieldDTO> extendFieldInfoList = this.getExtendFieldInfoList();
        this.addItemColumn(extendFieldInfoList, newListColumns);
        long endTime = System.currentTimeMillis();
        this.log.info("DclPersonBaseList.loadDclResultDetailInfo, addItemColumn use time: {}", (Object)(endTime - startTime));
        return newListColumns;
    }

    private ListColumn createListColumn(String key, String caption) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        return col;
    }

    private void addItemColumn(List<DclPersonFieldDTO> extendFieldInfoList, List<IListColumn> columns) {
        for (DclPersonFieldDTO insuredStandard : extendFieldInfoList) {
            Long insuredItemId = insuredStandard.getInsuredItemId();
            String insuredItemName = insuredStandard.getInsuredItemName();
            Long dataTypeId = insuredStandard.getDataTypeId();
            String columnKey = insuredStandard.getSpecifyInsurItem() != false ? String.valueOf(insuredItemId) : insuredStandard.getFieldKey();
            dataTypeId = SitDataTypeEnum.TEXT.getId();
            if (dataTypeId.equals(SitDataTypeEnum.NUMBER.getId()) || dataTypeId.equals(SitDataTypeEnum.AMOUNT.getId())) {
                DecimalListColumn decimalCol = this.getDecimalListColumn(insuredItemName, columnKey);
                columns.add((IListColumn)decimalCol);
                continue;
            }
            ListColumn column = this.createListColumn(columnKey, insuredItemName);
            if (insuredStandard.getSpecifyInsurItem().booleanValue()) {
                column.setTextAlign("right");
            }
            columns.add((IListColumn)column);
        }
    }

    private DecimalListColumn getDecimalListColumn(String name, String columnKey) {
        DecimalListColumn decimalCol = new DecimalListColumn();
        decimalCol.setCaption(new LocaleString(name));
        decimalCol.setKey(columnKey);
        decimalCol.setListFieldKey(columnKey);
        decimalCol.setZeroShow(true);
        return decimalCol;
    }

    private AmountProp getAmountProp(int scale, String name, String columnKey) {
        AmountProp property = new AmountProp();
        property.setName(columnKey);
        property.setDisplayName(new LocaleString(name));
        property.setPrecision(23);
        property.setScale(scale);
        property.setZeroShow(true);
        property.setEnableNull(true);
        property.setControlPropName(CURRENCY_KEY);
        return property;
    }

    private DecimalProp getDecimalProp(int scale, String name, String columnKey) {
        DecimalProp property = new DecimalProp();
        property.setName(columnKey);
        property.setDisplayName(new LocaleString(name));
        property.setPrecision(23);
        property.setScale(scale);
        property.setZeroShow(true);
        property.setEnableNull(true);
        return property;
    }

    private TextProp getTextProp(int dataLength, String name, String columnKey) {
        TextProp property = new TextProp();
        property.setName(columnKey);
        property.setDisplayName(new LocaleString(name));
        property.setMaxLenth(dataLength);
        return property;
    }

    protected DclPersonCacheDTO getDclPersonCacheDTO() {
        return InsuranceStandardService.getDclPersonCacheDTO((Map)this.getView().getFormShowParameter().getCustomParams());
    }

    private Tips getTips(String content) {
        Tips tips = new Tips();
        tips.setType("text");
        tips.setIsConfirm(false);
        tips.setShowIcon(true);
        tips.setTriggerType("hover");
        tips.setContent(new LocaleString(content));
        return tips;
    }

    private Map<String, String> getFieldKeyAndRefNameMap() {
        Long dclDisplayScmVId = this.getDclPersonCacheDTO().getDclDisplayScmVId();
        if (dclDisplayScmVId == null || Long.valueOf(0L).equals(dclDisplayScmVId)) {
            return Collections.emptyMap();
        }
        SITPageCache pageCache = new SITPageCache(this.getView());
        String cacheKey = this.getView().getPageId() + dclDisplayScmVId;
        String itemString = (String)pageCache.get(cacheKey, String.class);
        Map fieldKeyAndRefName = null;
        if (itemString != null) {
            fieldKeyAndRefName = (Map)SerializationUtils.deSerializeFromBase64((String)itemString);
        }
        if (fieldKeyAndRefName == null || fieldKeyAndRefName.isEmpty()) {
            fieldKeyAndRefName = (Map)DclPersonService.getFieldKeysOfScm(Collections.singletonList(dclDisplayScmVId)).get(dclDisplayScmVId);
        }
        return fieldKeyAndRefName;
    }

    private void setLabelContext() {
        DclPersonCacheDTO dclPersonCacheDTO = this.getDclPersonCacheDTO();
        this.setTipsOfModifyType(dclPersonCacheDTO.getModifyType());
        Label recordNameLb = (Label)this.getControl("dcl_record_name_val");
        recordNameLb.setText(dclPersonCacheDTO.getDclRecordName());
        Label companyNameLb = (Label)this.getControl("insured_company_name_val");
        companyNameLb.setText(dclPersonCacheDTO.getInsuredCompanyName());
        Label periodNameLb = (Label)this.getControl("sinsur_period_val");
        periodNameLb.setText(dclPersonCacheDTO.getPeriodName());
        UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)dclPersonCacheDTO.getDclRecordName());
    }

    private void setTipsOfModifyType(String modifyType) {
        Label lbControl = (Label)this.getControl("modify_type_val");
        String modifyTypeName = (String)DclRecordHelper.getComboPropAndNameMap((String)"hcsi_dclrecord", (String)"modifytype").get(modifyType);
        lbControl.setText(modifyTypeName);
        String tipsOfModifyType = DclModifyTypeEnum.getDclModifyTypeEnumByCode((String)modifyType).getTipsEnumOfModifyType().getErrInfo();
        Tips tips = this.getTips(tipsOfModifyType);
        lbControl.addTips(tips);
    }

    public class DclDetailResultLoadDataImpl
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection detailDataCol = super.getData(start, limit);
            if (this.getQueryBuilder().isSelectedAllRows()) {
                return detailDataCol;
            }
            List extendFieldInfoList = DclPersonBaseList.this.getExtendFieldInfoList();
            DclPersonBaseList.this.addItemProp(extendFieldInfoList, detailDataCol.getDynamicObjectType());
            DclPersonService.getInstance().inputDetailResultToDetailCol(detailDataCol, extendFieldInfoList);
            return detailDataCol;
        }
    }
}

