/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclperson;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.cal.service.InsuranceStandardService;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.dto.DclPersonCacheDTO;
import kd.sit.hcsi.business.declare.export.DclPersonDownLoadTask;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.DclRecordService;
import kd.sit.hcsi.business.declare.service.type.IDclRecordType;
import kd.sit.hcsi.formplugin.web.declare.dclrecord.AbsDclRecordOpList;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.formplugin.web.SITOpBatchExecutePlugin;

public class DclPersonOpList
extends AbsDclRecordOpList {
    private static final String IS_CONFIRM_DECLARE = "isConfirmDeclare";
    private static final String CONFIRM_CALBACKID_DECLARE = "confirm_calbackid_declare";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DclPersonCacheDTO dclPersonCacheDTO = this.getDclPersonCacheDTO();
        Long dclRecordId = dclPersonCacheDTO.getDclRecordId();
        List dclRecordIds = (List)SerializationUtils.deSerializeFromBase64((String)formOperate.getOption().getVariableValue("dclRecordIds"));
        String isMutexOp = formOperate.getOption().getVariableValue("isMutexOp", "0");
        if ("1".equals(isMutexOp) && CollectionUtils.isEmpty((Collection)dclRecordIds)) {
            return;
        }
        switch (operateKey) {
            case "donothing_export_person": {
                ListSelectedRowCollection listSelectedData = this.getSelectedRows();
                List<Long> socialDetailIds = listSelectedData.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
                this.exportDclPerson(socialDetailIds);
                break;
            }
            case "donothing_mark_declare": {
                formOperate.getOption().setVariableValue("dclRecordId", String.valueOf(dclRecordId));
                if (!this.getSelectedRows().isEmpty()) {
                    ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
                    args.setListSelectedData(listSelectedRows);
                    SITOpBatchExecutePlugin.invokeBatchOp((BeforeDoOperationEventArgs)args);
                    return;
                }
                boolean batchOpCompleted = SocialInsuranceCalHelper.isBatchOpCompleted((OperateOption)formOperate.getOption());
                if (batchOpCompleted) {
                    return;
                }
                if (formOperate.getOption().tryGetVariableValue(IS_CONFIRM_DECLARE, new RefObject())) {
                    ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
                    Map<Object, String> pkIdAndFileNumberMap = this.queryCurrentPageData();
                    if (pkIdAndFileNumberMap.size() == 0) {
                        this.getView().showTipNotification(HCSIErrInfoEnum.DCL_PERSON_NOTHING_NEED_MARK_DCL_LABEL.getErrInfo());
                        this.releaseDclRecordMutexLock(dclRecordIds, operateKey);
                        args.setCancel(true);
                        return;
                    }
                    pkIdAndFileNumberMap.forEach((pkId, billNo) -> {
                        ListSelectedRow selectedRow = new ListSelectedRow(pkId, Boolean.TRUE);
                        selectedRow.setBillNo(billNo);
                        selectedRows.add((Object)selectedRow);
                    });
                    args.setListSelectedData(selectedRows);
                    SITOpBatchExecutePlugin.invokeBatchOp((BeforeDoOperationEventArgs)args);
                    return;
                }
                this.getView().showConfirm(HCSIErrInfoEnum.DCL_PERSON_MARK_DCL_LABEL.getErrInfo(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALBACKID_DECLARE));
                this.releaseDclRecordMutexLock(dclRecordIds, operateKey);
                args.setCancel(true);
                break;
            }
            case "donothing_undeclare": {
                formOperate.getOption().setVariableValue("dclRecordId", String.valueOf(dclRecordId));
                SITOpBatchExecutePlugin.invokeBatchOp((BeforeDoOperationEventArgs)args);
                break;
            }
            case "donothing_update_person": {
                if (!"D".equals(dclPersonCacheDTO.getDclStatus())) break;
                this.getView().showTipNotification(HCSIErrInfoEnum.DCL_PERSON_IS_LOCKED_OR_ABANDONMENT.getErrInfo());
                args.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "donothing_mark_declare": 
            case "donothing_undeclare": {
                if (args.getOperationResult().getSuccessPkIds() == null || args.getOperationResult().getSuccessPkIds().size() <= 0) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_update_person": {
                DclPersonCacheDTO dclPersonCacheDTO = this.getDclPersonCacheDTO();
                Optional iDclRecordTypeOp = DclRecordService.getDclPersonListView((String)this.getView().getPageId(), (DclPersonCacheDTO)dclPersonCacheDTO);
                iDclRecordTypeOp.ifPresent(IDclRecordType::generateRecord);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "confirm_calbackid_declare": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                OperateOption declareOp = OperateOption.create();
                declareOp.setVariableValue(IS_CONFIRM_DECLARE, Boolean.TRUE.toString());
                this.getView().invokeOperation("donothing_mark_declare", declareOp);
                break;
            }
        }
    }

    @Override
    protected Set<String> getNetCtrlOpKeys() {
        Set<String> netCtrlOpKeys = super.getNetCtrlOpKeys();
        netCtrlOpKeys.remove("donothing_update_person");
        return netCtrlOpKeys;
    }

    private void exportDclPerson(List<Long> dclPersonIds) {
        boolean hasData;
        DclPersonCacheDTO dclPersonCacheDTO = this.getDclPersonCacheDTO();
        LinkedHashMap<Long, Long> recordIdAndScmIdMap = new LinkedHashMap<Long, Long>(1);
        recordIdAndScmIdMap.put(dclPersonCacheDTO.getDclRecordId(), dclPersonCacheDTO.getDclDisplayScmVId());
        DclPersonDownLoadTask task = new DclPersonDownLoadTask(recordIdAndScmIdMap, this.getView());
        boolean bl = hasData = !CollectionUtils.isEmpty(dclPersonIds);
        if (hasData) {
            task.addData(String.valueOf(dclPersonCacheDTO.getDclRecordId()), 100, dclPersonIds, 1);
        } else {
            QFilter filter = new QFilter("dclrecord", "=", (Object)dclPersonCacheDTO.getDclRecordId());
            this.addListQFilter(filter);
            List dclPersons = DclRecordHelper.queryDclPersonsByQFilter((String)"id", (QFilter)filter, (String)"sinsurfilev.number asc");
            if (!CollectionUtils.isEmpty((Collection)dclPersons)) {
                hasData = true;
                task.addData(String.valueOf(dclPersonCacheDTO.getDclRecordId()), 100, dclPersons.stream().map(data -> data.getLong("id")).collect(Collectors.toList()), 1);
            }
        }
        if (!hasData) {
            this.releaseDclRecordMutexLock(recordIdAndScmIdMap.keySet(), "donothing_export_person");
            this.getView().showTipNotification(HCSIErrInfoEnum.COMMON_EXPORT_NOTHING.getErrInfo());
            this.recordFailedOpLog("donothing_export_person");
            return;
        }
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.showErrorMsg(execute, HCSIErrInfoEnum.DCL_PERSON_EXPORT_DATA.getErrInfo(new Object[]{""}));
            this.recordFailedOpLog("donothing_export_person");
        } else {
            this.recordSuccessfulOpLog("donothing_export_person");
        }
    }

    private void showErrorMsg(BatchResult<?> result, String opString) {
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opString, (String)result.getMessage());
        this.getView().showTipNotification(result.getMessage());
    }

    private Map<Object, String> queryCurrentPageData() {
        Long dclRecordId = this.getDclPersonCacheDTO().getDclRecordId();
        QFilter idFilter = new QFilter("dclrecord", "=", (Object)dclRecordId);
        Optional.ofNullable(((BillList)this.getView().getControl("billlistap")).generalFilterParameter().getQFilters()).ifPresent(qFilters -> qFilters.forEach(arg_0 -> ((QFilter)idFilter).and(arg_0)));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_dclperson");
        DynamicObject[] dclPersonDys = helper.queryOriginalArray("id,billno", idFilter.toArray());
        Map<Object, String> pkIdAndFileNumberMap = Collections.emptyMap();
        if (dclPersonDys != null && dclPersonDys.length > 0) {
            pkIdAndFileNumberMap = new LinkedHashMap<Object, String>(dclPersonDys.length);
            for (DynamicObject dclPersonDy : dclPersonDys) {
                pkIdAndFileNumberMap.put(dclPersonDy.get("id"), dclPersonDy.getString("billno"));
            }
        }
        return pkIdAndFileNumberMap;
    }

    private DclPersonCacheDTO getDclPersonCacheDTO() {
        return InsuranceStandardService.getDclPersonCacheDTO((Map)this.getView().getFormShowParameter().getCustomParams());
    }
}

