/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclperson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.CheckBoxListColumn;
import kd.bos.list.ComboListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DclPersonUpdatedPlugin
extends AbstractListPlugin
implements SetFilterListener,
SelectRowsEventListener,
SocialInsuranceDeclareConstants {
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final Log logger = LogFactory.getLog(DclPersonUpdatedPlugin.class);
    private static final Supplier<String> addPerson = () -> ResManager.loadKDString((String)"\u65b0\u589e\u4eba\u5458", (String)"DclPersonUpdatedPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
    private static final Supplier<String> delPerson = () -> ResManager.loadKDString((String)"\u5220\u9664\u4eba\u5458", (String)"DclPersonUpdatedPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
    private static final Supplier<String> updatePerson = () -> ResManager.loadKDString((String)"\u66f4\u65b0\u4eba\u5458", (String)"DclPersonUpdatedPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
    private static final String ADDBILL = "addbill";
    private static final String UPDATEBILL = "updatebill";
    private static final String DELBILL = "delbill";
    private static final String BTN_CLOSE = "btnclose";
    private static final String BTN_EXPORT = "btnexport";
    private static final String TIP_LABEL = "tiplabelap";
    private static final String TAB = "tabap";
    private static final String TAB_ADD = "tabaddap";
    private static final String TAB_UPDATE = "tabupdateap";
    private static final String TAB_DEL = "tabdelap";
    private static final String ADD_LIST_GRID_VIEW_AP = "addlistgridviewap";
    private static final String UPDATE_LIST_GRID_VIEW_AP = "updatelistgridviewap";
    private static final String DEL_LIST_GRID_VIEW_AP = "dellistgridviewap";
    private static final HRBaseServiceHelper SINSUR_FILE_HELPER = new HRBaseServiceHelper("hcsi_sinsurfile");

    public void initialize() {
        super.initialize();
        BillList addBill = (BillList)this.getControl(ADDBILL);
        BillList updateBill = (BillList)this.getControl(UPDATEBILL);
        BillList delBill = (BillList)this.getControl(DELBILL);
        addBill.addSetFilterListener((SetFilterListener)this);
        updateBill.addSetFilterListener((SetFilterListener)this);
        delBill.addSetFilterListener((SetFilterListener)this);
        addBill.addListRowClickListener((ListRowClickListener)this);
        updateBill.addListRowClickListener((ListRowClickListener)this);
        delBill.addListRowClickListener((ListRowClickListener)this);
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{BTN_CLOSE, BTN_EXPORT});
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        BillList addBill = (BillList)this.getControl(ADDBILL);
        BillList updateBill = (BillList)this.getControl(UPDATEBILL);
        BillList delBill = (BillList)this.getControl(DELBILL);
        addBill.setIndexMode(true);
        updateBill.setIndexMode(true);
        delBill.setIndexMode(true);
        ListGridView addGridView = (ListGridView)this.getControl(ADD_LIST_GRID_VIEW_AP);
        ListGridView updateGridView = (ListGridView)this.getControl(UPDATE_LIST_GRID_VIEW_AP);
        ListGridView delGridView = (ListGridView)this.getControl(DEL_LIST_GRID_VIEW_AP);
        addGridView.setPaginationHide(false);
        updateGridView.setPaginationHide(false);
        delGridView.setPaginationHide(false);
        addBill.setQueryType("0");
        updateBill.setQueryType("0");
        delBill.setQueryType("0");
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        BillList addBill = (BillList)this.getControl(ADDBILL);
        BillList updateBill = (BillList)this.getControl(UPDATEBILL);
        BillList delBill = (BillList)this.getControl(DELBILL);
        int addCount = addBill.queryBillDataCount();
        int updateCount = updateBill.queryBillDataCount();
        int delCount = delBill.queryBillDataCount();
        ((TabPage)this.getControl(TAB_ADD)).setText(this.numLabelText(addCount, TAB_ADD));
        ((TabPage)this.getControl(TAB_UPDATE)).setText(this.numLabelText(updateCount, TAB_UPDATE));
        ((TabPage)this.getControl(TAB_DEL)).setText(this.numLabelText(delCount, TAB_DEL));
    }

    public void setFilter(SetFilterEvent event) {
        String billKey;
        BillList billList = (BillList)event.getSource();
        switch (billKey = billList.getKey()) {
            case "addbill": {
                JSONArray addJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("addFiles");
                List addFileVIds = JSONObject.parseArray((String)addJsonArray.toJSONString(), Long.class);
                QFilter fileIdFilter = new QFilter("id", "in", (Object)addFileVIds);
                String addFilter = this.getView().getPageCache().get("addFiles");
                if (addFilter != null) {
                    QFilter qFilter = QFilter.of((String)addFilter, (Object[])new Object[0]);
                    event.getQFilters().add(qFilter);
                }
                event.getQFilters().add(fileIdFilter);
                break;
            }
            case "updatebill": {
                JSONArray updateJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("updateFiles");
                List updateFileVIds = JSONObject.parseArray((String)updateJsonArray.toJSONString(), Long.class);
                String updateFilters = this.getView().getPageCache().get("updateFiles");
                if (updateFilters != null) {
                    QFilter qFilter = QFilter.of((String)updateFilters, (Object[])new Object[0]);
                    event.getQFilters().add(qFilter);
                }
                QFilter updateFilter = new QFilter("id", "in", (Object)updateFileVIds);
                event.getQFilters().add(updateFilter);
                break;
            }
            case "delbill": {
                JSONArray delJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("deleteFiles");
                List delFileVIds = JSONObject.parseArray((String)delJsonArray.toJSONString(), Long.class);
                QFilter delFilter = new QFilter("id", "in", (Object)delFileVIds);
                String delFilters = this.getView().getPageCache().get("deleteFiles");
                if (delFilters != null) {
                    QFilter qFilter = QFilter.of((String)delFilters, (Object[])new Object[0]);
                    event.getQFilters().add(qFilter);
                }
                event.getQFilters().add(delFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String apKey = "0";
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            apKey = button.getKey();
        } else if (source instanceof Container) {
            Container container = (Container)source;
            apKey = container.getKey();
        }
        BillList addBill = (BillList)this.getControl(ADDBILL);
        BillList updateBill = (BillList)this.getControl(UPDATEBILL);
        BillList delBill = (BillList)this.getControl(DELBILL);
        switch (apKey) {
            case "btnexport": {
                String appNumber = AppHelper.getAppNumberById((String)this.getView().getFormShowParameter().getCheckRightAppId());
                if (!SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)"hcsi_dclrecord", (String)"4730fc9f000004ae")) {
                    this.getView().showErrorNotification(HCSIErrInfoEnum.DCL_RECORD_WITHOUT_FILE_EXP_EXPORT_PERM.getErrInfo());
                    SITLogServiceHelper.addLog((String)this.getView().getFormShowParameter().getCheckRightAppId(), (String)"hcsi_dclpersonupdated", (String)HCSIErrInfoEnum.COMMON_EXPORT_OP.getErrInfo(), (String)HCSIErrInfoEnum.DCL_RECORD_WITHOUT_FILE_EXP_EXPORT_PERM.getErrInfo());
                    return;
                }
                ArrayList<BillList> billLists = new ArrayList<BillList>(10);
                billLists.add(addBill);
                billLists.add(delBill);
                billLists.add(updateBill);
                ArrayList<String> sheetNames = new ArrayList<String>(10);
                sheetNames.add(addPerson.get());
                sheetNames.add(delPerson.get());
                sheetNames.add(updatePerson.get());
                this.doExport(billLists, sheetNames);
                break;
            }
        }
    }

    public void pageRelease(EventObject event) {
        super.pageRelease(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(List<BillList> billLists, List<String> sheetNames) {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        boolean isHaveData = false;
        for (int i = 0; i < billLists.size(); ++i) {
            BillList billList = billLists.get(i);
            SXSSFSheet sheet = wb.createSheet(sheetNames.get(i));
            Map<String, Tuple<String, Boolean>> fieldInfoMap = this.getListFieldKeyAndAndCaption(billList);
            this.writerHeader(sheet, wb, fieldInfoMap.values());
            List<QFilter> filters = this.getQFiltersBy(billList);
            String selectSql = String.join((CharSequence)",", fieldInfoMap.keySet());
            DynamicObject[] dynamicObjects = SINSUR_FILE_HELPER.query(selectSql, filters.toArray(new QFilter[0]));
            if (dynamicObjects == null || dynamicObjects.length <= 0) continue;
            isHaveData = true;
            this.writerContent(sheet, wb.createCellStyle(), dynamicObjects, fieldInfoMap);
        }
        if (!isHaveData) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error("hcsi_dclpersonupdated export wb close error", (Throwable)e);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"DclPersonUpdatedPlugin_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            return;
        }
        String exportUrl = null;
        try {
            exportUrl = this.writeFile(wb);
        }
        catch (IOException e) {
            logger.error("hcsi_dclpersonupdated export error", (Throwable)e);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error("hcsi_dclpersonupdated export wb close error", (Throwable)e);
            }
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (exportUrl != null) {
            clientViewProxy.addAction("download", (Object)exportUrl);
            String opName = ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"DclPersonUpdatedPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u66f4\u65b0\u5185\u5bb9\u6210\u529f", (String)"DclPersonUpdatedPlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            SITLogServiceHelper.addLog((IFormView)this.getView().getParentView(), (String)opName, (String)msg);
        }
    }

    private Map<String, Tuple<String, Boolean>> getListFieldKeyAndAndCaption(BillList billList) {
        ListGridView listGridView = (ListGridView)this.getControl(billList.getListGridViewKey());
        List items = listGridView.getItems();
        LinkedHashMap<String, Tuple<String, Boolean>> fieldKeyAndCaptionMap = new LinkedHashMap<String, Tuple<String, Boolean>>(items.size());
        for (Control control : items) {
            ListColumn listColumn = (ListColumn)control;
            if (HRStringUtils.equals((String)listColumn.getListFieldKey(), (String)"fseq")) continue;
            Boolean isComboListColumn = listColumn instanceof ComboListColumn || listColumn instanceof CheckBoxListColumn;
            Tuple captionAndIsColumn = new Tuple((Object)listColumn.getCaption().getLocaleValue(), (Object)isComboListColumn);
            fieldKeyAndCaptionMap.put(listColumn.getListFieldKey(), (Tuple<String, Boolean>)captionAndIsColumn);
        }
        return fieldKeyAndCaptionMap;
    }

    private List<QFilter> getQFiltersBy(BillList billList) {
        List<QFilter> qFilters;
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            qFilters = billList.generalFilterParameter().getQFilters();
        } else {
            List selectedRowIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            qFilters = Collections.singletonList(new QFilter("id", "in", selectedRowIds));
        }
        return qFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb) throws IOException {
        Object dclRecordId = this.getView().getFormShowParameter().getCustomParam("dclRecordId");
        DynamicObject dclRecordDy = HRBaseServiceHelper.create((String)"hcsi_dclrecord").queryOriginalOne("name", new QFilter("id", "=", dclRecordId).toArray());
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String dclRecordName = dclRecordDy == null ? "" : dclRecordDy.getString("name");
            SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
            String dateStr = format.format(new Date());
            String fileName = MessageFormat.format(ResManager.loadKDString((String)"{0}\u66f4\u65b0\u540d\u5355_{1}", (String)"DclPersonUpdatedPlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dclRecordName, dateStr) + EXCEL_SUFFIX;
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setWrapText(false);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    private void writerHeader(SXSSFSheet sheet, SXSSFWorkbook wb, Collection<Tuple<String, Boolean>> fieldInfo) {
        CellStyle cellStyle = this.getHeadColumnStyle(wb);
        SXSSFRow headRow = DclPersonUpdatedPlugin.getRow(sheet, 0);
        int index = 0;
        for (Tuple<String, Boolean> tuple : fieldInfo) {
            DclPersonUpdatedPlugin.createCell(headRow, index, cellStyle).setCellValue((String)tuple.item1);
            sheet.setColumnWidth(index, sheet.getColumnWidth(index) * 4);
            ++index;
        }
    }

    private static SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private void writerContent(SXSSFSheet sheet, CellStyle style, DynamicObject[] dynamicObjects, Map<String, Tuple<String, Boolean>> fieldInfoMap) {
        style.setWrapText(false);
        List props = fieldInfoMap.entrySet().stream().filter(entry -> Boolean.TRUE.equals(((Tuple)entry.getValue()).item2)).map(Map.Entry::getKey).collect(Collectors.toList());
        Map combMapMap = SitDataServiceHelper.resolveCombAndBooleanValues((String)"hcsi_sinsurfile", props, (boolean)true);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject entityDy = dynamicObjects[i];
            SXSSFRow contentRow = DclPersonUpdatedPlugin.getRow(sheet, i + 1);
            int index = 0;
            for (Map.Entry<String, Tuple<String, Boolean>> entry2 : fieldInfoMap.entrySet()) {
                String fieldKey = entry2.getKey();
                String value = entityDy.getString(fieldKey);
                Map combMap = (Map)combMapMap.get(fieldKey);
                if (combMap != null) {
                    value = (String)combMap.get(String.valueOf(value));
                }
                DclPersonUpdatedPlugin.createCell(contentRow, index, style).setCellValue(value);
                ++index;
            }
        }
    }

    private static SXSSFRow getRow(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    private LocaleString numLabelText(int total, String label) {
        switch (label) {
            case "tabaddap": {
                return new LocaleString(MessageFormat.format(ResManager.loadKDString((String)"\u65b0\u589e{0}\u4eba", (String)"DclPersonUpdatedPlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), total));
            }
            case "tabupdateap": {
                return new LocaleString(MessageFormat.format(ResManager.loadKDString((String)"\u66f4\u65b0{0}\u4eba", (String)"DclPersonUpdatedPlugin_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), total));
            }
            case "tabdelap": {
                return new LocaleString(MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664{0}\u4eba", (String)"DclPersonUpdatedPlugin_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), total));
            }
        }
        return new LocaleString(MessageFormat.format(ResManager.loadKDString((String)"\u65b0\u589e{0}\u4eba", (String)"DclPersonUpdatedPlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), total));
    }
}

