/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclrecord;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class AbsDclRecordOpList
extends AbstractListPlugin
implements SITBaseConstants {
    protected static final Log log = LogFactory.getLog(AbsDclRecordOpList.class);
    public static final String OP_LOCK_ERROR = "opLockError";
    public static final String DCL_RECORD_IDS = "dclRecordIds";
    public static final String IS_MUTEX_OP = "isMutexOp";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        String formId = ((IListView)this.getView()).getBillFormId();
        List<Long> dclRecordIdList = new ArrayList<Long>(10);
        ArrayList<String> msg = new ArrayList(10);
        if (this.getNetCtrlOpKeys().contains(operateKey)) {
            Map<Object, Object> result = new HashMap(16);
            int totalNum = 0;
            if ("hcsi_dclperson".equals(formId)) {
                Long dclRecordId = (Long)this.getView().getFormShowParameter().getCustomParam("dclRecordId");
                dclRecordIdList.add(dclRecordId);
                boolean isBatchOpCompleted = SocialInsuranceCalHelper.isBatchOpCompleted((OperateOption)option);
                if (!isBatchOpCompleted) {
                    result = this.addDclRecordMutexLock(dclRecordIdList, operateKey, false);
                    totalNum = 1;
                }
            }
            if ("hcsi_dclrecord".equals(formId)) {
                ListSelectedRowCollection listSelectedData = this.getSelectedRows();
                if (listSelectedData.isEmpty()) {
                    return;
                }
                dclRecordIdList = listSelectedData.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
                totalNum = dclRecordIdList.size();
                result = this.addDclRecordMutexLock(dclRecordIdList, operateKey, true);
                HashSet<Long> idSet = new HashSet<Long>(dclRecordIdList);
                listSelectedData.removeIf(row -> !idSet.contains((Long)row.getPrimaryKeyValue()));
                formOperate.setListSelectedData(listSelectedData);
            }
            Set entries = result.entrySet();
            msg = entries.stream().map(Map.Entry::getValue).collect(Collectors.toCollection(() -> new ArrayList(10)));
            if (CollectionUtils.isEmpty(dclRecordIdList)) {
                args.setCancel(true);
                this.showErrorMsg(msg, totalNum, 0, formOperate.getOperateName().getLocaleValue());
            }
            option.setVariableValue(IS_MUTEX_OP, "1");
        }
        option.setVariableValue(OP_LOCK_ERROR, SerializationUtils.serializeToBase64(msg));
        option.setVariableValue(DCL_RECORD_IDS, SerializationUtils.serializeToBase64(dclRecordIdList));
        this.recordMutexInfo(option, dclRecordIdList);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = args.getOperateKey();
        if (!this.getNetCtrlOpKeys().contains(operateKey)) {
            log.info("AbsDclRecordOpList.afterDoOperation: netCtrlOpKeys does not contain {}.", (Object)operateKey);
            return;
        }
        OperateOption option = formOperate.getOption();
        List dclRecordIds = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(DCL_RECORD_IDS, Collections.emptyList().toString()));
        List msg = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(OP_LOCK_ERROR, Collections.emptyList().toString()));
        this.releaseDclRecordMutexLock(dclRecordIds, operateKey);
        if (msg.isEmpty()) {
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            log.info("AbsDclRecordOpList.afterDoOperation: operationResult is empty.");
            return;
        }
        operationResult.setSuccess(operationResult.isSuccess() && msg.isEmpty());
        List errorInfoList = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo info : errorInfoList) {
            msg.add(info.getMessage());
        }
        int totalNum = operationResult.getBillCount();
        int successNum = operationResult.getSuccessPkIds().size();
        operationResult.setShowMessage(false);
        this.showErrorMsg(msg, totalNum, successNum, formOperate.getOperateName().getLocaleValue());
    }

    protected Map<Long, String> addDclRecordMutexLock(List<Long> dclRecordIdList, String operateKey, boolean isDclRecordForm) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        Map<Long, String> idNameMap = AbsDclRecordOpList.queryDclRecordById(dclRecordIdList);
        Iterator<Long> iterator = dclRecordIdList.iterator();
        while (iterator.hasNext()) {
            Long dclRecord = iterator.next();
            BaseResult lockInfo = MutexServiceHelper.getMutexLockInfo((String)"hcsi_dclrecord", (String)String.valueOf(dclRecord), (String)operateKey);
            Set allLockKeys = MutexServiceHelper.getDataEntityNetCtrlOperate((String)"hcsi_dclrecord");
            if (lockInfo.isSuccess()) {
                if (!allLockKeys.contains(((MutexLockInfo)lockInfo.getData()).getOpKey())) continue;
                String lockedOpName = this.getOperateName(((MutexLockInfo)lockInfo.getData()).getOpKey());
                String currOpName = this.getOperateName(operateKey);
                String errorMessage = isDclRecordForm ? HCSIErrInfoEnum.DCL_RECORD_LOCKED.getErrInfo(new Object[]{idNameMap.get(dclRecord), lockedOpName, currOpName}) : HCSIErrInfoEnum.DCL_PERSON_LOCKED.getErrInfo(new Object[]{lockedOpName, currOpName});
                result.put(dclRecord, errorMessage);
                iterator.remove();
                continue;
            }
            if (!this.getNetCtrlOpKeys().contains(operateKey)) continue;
            MutexServiceHelper.require((String)"hcsi_dclrecord", (String)String.valueOf(dclRecord), (String)operateKey);
        }
        return result;
    }

    protected boolean releaseDclRecordMutexLock(Collection<Long> dclRecordList, String opKey) {
        boolean isRelease = true;
        for (Long dclRecord : dclRecordList) {
            BaseResult baseResult = MutexServiceHelper.release((String)"hcsi_dclrecord", (String)String.valueOf(dclRecord), (String)opKey);
            isRelease = baseResult.isSuccess() && isRelease;
        }
        return isRelease;
    }

    private void showErrorMsg(List<String> msg, int totalNum, int successNum, String opName) {
        if (totalNum == 1 && msg.size() == 1) {
            this.getView().showTipNotification(msg.get(0));
            return;
        }
        String title = HCSIErrInfoEnum.DCL_RECORD_COMMON_SUM_ERROR.getErrInfo(new Object[]{totalNum, opName, successNum, totalNum - successNum});
        this.getView().showForm(SITShowFormServiceHelper.getOperationResultParameter((String)opName, (String)title, msg));
    }

    private static Map<Long, String> queryDclRecordById(List<Long> dclRecordIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcsi_dclrecord");
        QFilter filter = new QFilter("id", "in", dclRecordIdList);
        DynamicObjectCollection collection = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        return collection.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name"), (oldVal, newVal) -> oldVal));
    }

    protected Set<String> getNetCtrlOpKeys() {
        return MutexServiceHelper.getDataEntityNetCtrlOperate((String)"hcsi_dclrecord");
    }

    protected String getOperateName(String opKey) {
        return MutexServiceHelper.getOperateName((String)"hcsi_dclrecord", (String)opKey);
    }

    protected void addListQFilter(QFilter filter) {
        Optional.ofNullable(((BillList)this.getView().getControl("billlistap")).generalFilterParameter().getQFilters()).ifPresent(qFilters -> qFilters.forEach(arg_0 -> ((QFilter)filter).and(arg_0)));
    }

    protected void recordSuccessfulOpLog(String opKey) {
        String opDesc = this.getOperateName(opKey);
        SITLogServiceHelper.addLog((String)"hcsi", (String)((IListView)this.getView()).getBillFormId(), (String)opDesc, (String)HCSIErrInfoEnum.COMMON_OPERATE_SUCCESSFULLY.getErrInfo(new Object[]{opDesc}));
    }

    protected void recordFailedOpLog(String opKey) {
        String opDesc = this.getOperateName(opKey);
        SITLogServiceHelper.addLog((String)"hcsi", (String)((IListView)this.getView()).getBillFormId(), (String)opDesc, (String)HCSIErrInfoEnum.COMMON_OPERATE_FAILED.getErrInfo(new Object[]{opDesc}));
    }

    protected Collection<String> getOpKeys() {
        return Sets.newHashSet((Object[])new String[]{"donothing_mark_declare", "donothing_undeclare"});
    }

    protected void recordMutexInfo(OperateOption option, Collection<Long> dclRecordIds) {
        option.setVariableValue("NeedReleaseMutex", Boolean.TRUE.toString());
        option.setVariableValue("MutexEntityNumber", "hcsi_dclrecord");
        option.setVariableValue("MutexEntityPKIds", SerializationUtils.serializeToBase64(dclRecordIds));
    }
}

