/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclrecord;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.export.DclPersonDownLoadTask;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.DclRecordService;
import kd.sit.hcsi.business.declare.service.type.IDclRecordType;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;
import kd.sit.hcsi.formplugin.web.declare.dclrecord.AbsDclRecordOpList;
import kd.sit.sitbp.business.helper.SITLogServiceHelper;
import kd.sit.sitbp.business.helper.qfilter.UpdateQFilterHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;

public class DclRecordList
extends AbsDclRecordOpList
implements SocialInsuranceDeclareConstants {
    private static final String KEY_FILE_EXP = "fileexp";
    private static final String DONOTHING_UNLOCK = "donothing_unlock";
    private static final String DONOTHING_LOCK = "donothing_lock";
    private static final String DONOTHING_ABANDONMENT = "donothing_abandonment";
    private static final String CONFIRM_CAL_BACK_ID_DISCARD_DCl_RECORD = "donothing_abandonment";
    private static final String IS_CONFIRM_DISCARD = "isConfirmDiscard";

    public void packageData(PackageDataEvent evt) {
        String changeStatus;
        super.packageData(evt);
        ColumnDesc columnDesc = (ColumnDesc)evt.getSource();
        if (KEY_FILE_EXP.equals(columnDesc.getFieldKey()) && "0".equals(changeStatus = evt.getRowData().getString(KEY_FILE_EXP))) {
            evt.setFormatValue((Object)"");
        }
    }

    public void setFilter(SetFilterEvent event) {
        UpdateQFilterHelper.updateQFilter((List)event.getQFilters(), (String)"mulsinsurstd.fbasedataid.id", (String)"mulsinsurstd.fbasedataid.name", (String)"sitbs_sinsurstd");
        UpdateQFilterHelper.updateQFilter((List)event.getQFilters(), (String)"dcldisplayscmv.id", (String)"dcldisplayscmv.name", (String)"sitbs_sinsurstd");
        event.setOrderBy("period.name desc,number asc");
        if (!SITPermissionServiceHelper.isSuperUser()) {
            HasPermOrgResult hasPermOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_dclrecord", (String)"47150e89000000ac");
            if (hasPermOrgResult.hasAllOrgPerm()) {
                return;
            }
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("insuredcompany.org", "in", (Object)hasPermOrgs);
            event.getQFilters().add(orgFilter);
            Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)"2AXKDRPJUQ77", (String)"sitbs_welfarepayer", (String)"47150e89000000ac");
            if (countryIds == null) {
                return;
            }
            QFilter countryFilter = new QFilter("insuredcompany.country", "in", (Object)countryIds);
            event.getQFilters().add(countryFilter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        IListView listView = (IListView)this.getView();
        Long dclRecordId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
        switch (fieldName) {
            case "name": {
                args.setCancel(true);
                ListShowParameter showParameter = DclRecordService.getDclPersonListForm((Long)dclRecordId);
                String appId = this.getView().getFormShowParameter().getCheckRightAppId();
                String pageId = this.getView().getPageId() + appId + dclRecordId;
                showParameter.setPageId(pageId);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "fileexp": {
                args.setCancel(true);
                int fileExpCount = this.getFileExpCount(dclRecordId);
                if (fileExpCount > 0) {
                    this.showChangeTipsConfirm();
                    break;
                }
                HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hcsi_dclrecord");
                DynamicObject dclRecordDy = helper.queryOne("id,fileexp", (Object)dclRecordId);
                if ("1".equals(dclRecordDy.getString(KEY_FILE_EXP))) {
                    this.updateDclRecordDy(dclRecordId);
                } else {
                    this.getView().invokeOperation("refresh");
                }
                this.getView().showTipNotification(HCSIErrInfoEnum.DCL_RECORD_ERROR_CLEAR.getErrInfo());
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        Optional permOrgs = DclRecordHelper.getDclRecordPermOrgs();
        switch (fieldName) {
            case "insuredcompany.name": 
            case "insuredcompany.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("org", "in", orgs)));
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        Optional permOrgs = DclRecordHelper.getDclRecordPermOrgs();
        switch (fieldName) {
            case "insuredcompany.name": 
            case "insuredcompany.id": {
                permOrgs.ifPresent(orgs -> filters.add(new QFilter("org", "in", orgs)));
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        String isMutexOp = formOperate.getOption().getVariableValue("isMutexOp", "0");
        List afterMutexCheckRecordIds = SocialInsuranceCalHelper.getIdsBySelectedRows((ListSelectedRowCollection)formOperate.getListSelectedData());
        if ("1".equals(isMutexOp) && CollectionUtils.isEmpty((Collection)afterMutexCheckRecordIds)) {
            return;
        }
        switch (operateKey) {
            case "donothing_export_person": {
                args.setCancel(true);
                option.setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                this.exportDclPerson(afterMutexCheckRecordIds);
                break;
            }
            case "donothing_gendcrecord": 
            case "donothing_lock": 
            case "donothing_unlock": {
                option.setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                break;
            }
            case "donothing_abandonment": {
                option.setVariableValue("ignoreValidation", Boolean.TRUE.toString());
                if (formOperate.getOption().tryGetVariableValue(IS_CONFIRM_DISCARD, new RefObject())) {
                    return;
                }
                this.getView().showConfirm(HCSIErrInfoEnum.DCL_RECORD_CONFIRM_TO_DELETE_ABANDONMENT_DATA.getErrInfo(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_abandonment"));
                args.setCancel(true);
                this.releaseDclRecordMutexLock(afterMutexCheckRecordIds, operateKey);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_gendcrecord": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                FormShowParameter formShowParameter = DclRecordService.getFormShowParam((String)DclRecordList.class.getName(), (String)"hcsi_generatedclrecord");
                this.getView().showForm(formShowParameter);
                break;
            }
            case "donothing_lock": 
            case "donothing_unlock": 
            case "donothing_abandonment": {
                Optional.ofNullable(args.getOperationResult()).map(AbstractOperationResult::getSuccessPkIds).map(pkIds -> !SITListUtil.isEmpty((List)pkIds)).ifPresent(key -> this.getView().invokeOperation("refresh"));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "donothing_abandonment": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                OperateOption discardOp = OperateOption.create();
                discardOp.setVariableValue(IS_CONFIRM_DISCARD, Boolean.TRUE.toString());
                this.getView().invokeOperation("donothing_abandonment", discardOp);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        Map returnData = (Map)event.getReturnData();
        switch (actionId = event.getActionId()) {
            case "hcsi_generatedclrecord": {
                if (returnData == null) break;
                String periodIdStr = (String)returnData.get("period");
                String companyIdStr = (String)returnData.get("insuredcompany");
                HashSet periodIds = Sets.newHashSet((Object[])new Long[]{Long.parseLong(periodIdStr)});
                Set companyIds = (Set)SerializationUtils.fromJsonString((String)companyIdStr, Set.class);
                IDclRecordType recordCreateFactory = DclRecordService.getDclRecordListView((String)this.getView().getPageId(), (Set)periodIds, (Set)companyIds, (String)"1", null);
                recordCreateFactory.generateRecord();
                if (!recordCreateFactory.isDclRecordExists()) break;
                String recordCreateFactoryStr = SerializationUtils.serializeToBase64((Object)recordCreateFactory);
                this.getPageCache().put("hcsi_dcrecordconfirm", recordCreateFactoryStr);
                FormShowParameter formShowParameter = DclRecordService.getFormShowParam((String)DclRecordList.class.getName(), (String)"hcsi_dcrecordconfirm");
                this.getView().showForm(formShowParameter);
                this.recordSuccessfulOpLog("donothing_gendcrecord");
                break;
            }
            case "hcsi_dcrecordconfirm": {
                if (SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
                    this.recordFailedOpLog("donothing_gendcrecord");
                    return;
                }
                if (returnData == null) break;
                String updateType = (String)returnData.get("radiogroupfield");
                String recordCreateFactoryStr = this.getPageCache().get("hcsi_dcrecordconfirm");
                IDclRecordType recordCreateFactory = (IDclRecordType)SerializationUtils.deSerializeFromBase64((String)recordCreateFactoryStr);
                if (recordCreateFactory == null) {
                    return;
                }
                recordCreateFactory.setAddAndUpdateDclRecord(!"ignore".equals(updateType));
                recordCreateFactory.generateRecordAgain();
                this.getPageCache().remove("hcsi_dcrecordconfirm");
                this.recordSuccessfulOpLog("donothing_gendcrecord");
                break;
            }
            case "hcsi_dclrecordstdwarn": {
                if (SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
                    return;
                }
                BillList billList = (BillList)this.getView().getControl("billlistap");
                Long focusRowPkId = (Long)billList.getFocusRowPkId();
                if (focusRowPkId == null || returnData == null) {
                    this.getView().invokeOperation("refresh");
                    return;
                }
                if ("0".equals(returnData.get("opResult"))) {
                    HRBaseServiceHelper.create((String)"hcsi_dclfileexp").deleteByFilter(new QFilter("dclrecord", "=", (Object)focusRowPkId).toArray());
                    this.updateDclRecordDy(focusRowPkId);
                    break;
                }
                int fileExpCount = this.getFileExpCount(focusRowPkId);
                if (fileExpCount > 0) {
                    ListShowParameter listShowParameter = DclRecordHelper.showExpForm(Collections.singleton(focusRowPkId));
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.updateDclRecordDy(focusRowPkId);
                this.getView().showTipNotification(HCSIErrInfoEnum.DCL_RECORD_ERROR_CLEAR.getErrInfo());
                break;
            }
        }
    }

    @Override
    protected Set<String> getNetCtrlOpKeys() {
        Set<String> netCtrlOpKeys = super.getNetCtrlOpKeys();
        netCtrlOpKeys.remove("donothing_gendcrecord");
        return netCtrlOpKeys;
    }

    private void exportDclPerson(List<Long> dclRecords) {
        LinkedHashSet<Long> emptyDclRecordIds = new LinkedHashSet<Long>(dclRecords);
        Map<Long, Long> dclRecordIdAndRefScmVIdMap = this.getDclRecordIdAndRefScmVIdMap(emptyDclRecordIds);
        emptyDclRecordIds.removeAll(dclRecordIdAndRefScmVIdMap.keySet());
        DclPersonDownLoadTask task = new DclPersonDownLoadTask(dclRecordIdAndRefScmVIdMap, this.getView());
        Iterator<Map.Entry<Long, Long>> iterator = dclRecordIdAndRefScmVIdMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Long> entry = iterator.next();
            Long dclRecordId = entry.getKey();
            QFilter filter = new QFilter("dclrecord", "=", (Object)dclRecordId);
            filter.and(DclRecordHelper.getAuthorizedDataRuleQFilterOf((String)"hcsi_dclperson", (String)"1"));
            List dclPersons = DclRecordHelper.queryDclPersonsByQFilter((String)"id", (QFilter)filter, (String)"sinsurfilev.number asc");
            if (CollectionUtils.isEmpty((Collection)dclPersons)) {
                emptyDclRecordIds.add(dclRecordId);
                iterator.remove();
                continue;
            }
            task.addData(String.valueOf(dclRecordId), 500, dclPersons.stream().map(data -> data.getLong("id")).collect(Collectors.toList()), 1);
        }
        if (emptyDclRecordIds.size() > 0) {
            this.releaseDclRecordMutexLock(emptyDclRecordIds, "donothing_export_person");
        }
        if (dclRecordIdAndRefScmVIdMap.isEmpty() || emptyDclRecordIds.size() == dclRecords.size()) {
            this.getView().showTipNotification(HCSIErrInfoEnum.COMMON_EXPORT_NOTHING.getErrInfo());
            this.recordFailedOpLog("donothing_export_person");
            return;
        }
        BatchResult execute = MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        if (!execute.isSuccess()) {
            this.showErrorMsg(execute, HCSIErrInfoEnum.DCL_PERSON_EXPORT_DATA.getErrInfo(new Object[]{""}));
            this.recordFailedOpLog("donothing_export_person");
        } else {
            this.recordSuccessfulOpLog("donothing_export_person");
        }
    }

    private void showErrorMsg(BatchResult<?> result, String opString) {
        SITLogServiceHelper.addLog((IFormView)this.getView(), (String)opString, (String)result.getMessage());
        this.getView().showTipNotification(result.getMessage());
    }

    private void showChangeTipsConfirm() {
        FormShowParameter formShowParameter = DclRecordService.getFormShowParam((String)DclRecordList.class.getName(), (String)"hcsi_dclrecordstdwarn");
        this.getView().showForm(formShowParameter);
    }

    private Map<Long, Long> getDclRecordIdAndRefScmVIdMap(Collection<Long> dclRecords) {
        List authorizedDataRuleQFilters = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"2AXKDRPJUQ77", (String)"hcsi_dclrecord", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilters == null) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("id", "in", dclRecords);
        authorizedDataRuleQFilters.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        List dclRecordDys = DclRecordHelper.queryDclRecordsByQFilter((QFilter)filter);
        Map dclRecordIdAndRefScmVIdMap = dclRecordDys.stream().collect(Collectors.toMap(dclRecordDy -> dclRecordDy.getLong("id"), dclRecordDy -> dclRecordDy.getLong("dcldisplayscmv.id"), (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        if ((dclRecordDys.isEmpty() || dclRecords.size() > 0) && dclRecordDys.isEmpty()) {
            return Collections.emptyMap();
        }
        return dclRecordIdAndRefScmVIdMap;
    }

    private int getFileExpCount(Long dclRecordId) {
        return HRBaseServiceHelper.create((String)"hcsi_dclfileexp").count("hcsi_dclfileexp", new QFilter("dclrecord", "=", (Object)dclRecordId).toArray());
    }

    private void updateDclRecordDy(Long focusRowPkId) {
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"hcsi_dclrecord");
        DynamicObject dclRecordDy = helper.loadSingle((Object)focusRowPkId);
        dclRecordDy.set(KEY_FILE_EXP, (Object)"0");
        helper.updateOne(dclRecordDy);
        this.getView().invokeOperation("refresh");
    }
}

