/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclrecord;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.cal.SocialInsuranceCalHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.sitbp.business.datachanged.BizChangedHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;

public class GenerateDclRecordPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String CALLBACKID_CONTINUE_CLOSE = "continue_close";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("period");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit insuredCompanyEdit = (MulBasedataEdit)this.getControl("insuredcompany");
        insuredCompanyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs event) {
        super.preOpenForm(event);
        String parentPageId = event.getFormShowParameter().getParentPageId();
        if (HRStringUtils.isEmpty((String)parentPageId)) {
            event.setCancel(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "period": {
                QFilter qFilter = new QFilter("periodtype", "=", (Object)1010L);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "insuredcompany": {
                SocialInsuranceCalHelper.setWelfarePayerF7Filter((ListShowParameter)listShowParameter, (String)"hcsi_dclrecord");
                QFilter qFilter = new QFilter("sinsurdclrule.status", "=", (Object)"C");
                qFilter.and("sinsurdclrule.enable", "=", (Object)"1");
                Optional permOrgs = DclRecordHelper.getDclRecordPermOrgs();
                permOrgs.ifPresent(orgs -> qFilter.and(new QFilter("org", "in", orgs)));
                listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btncancel": {
                if (this.getModel().getDataChanged() && HRStringUtils.isNotEmpty((String)this.getModel().getChangeDesc())) {
                    BizChangedHelper.showConfirm((AbstractFormPlugin)this, (String)this.getModel().getChangeDesc(), (String)CALLBACKID_CONTINUE_CLOSE, null);
                    evt.setCancel(true);
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_OK.equals(key)) {
            Boolean setCancel = Boolean.FALSE;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject periodDy = dataEntity.getDynamicObject("period");
            DynamicObjectCollection dyColl = dataEntity.getDynamicObjectCollection("insuredcompany");
            if (HRObjectUtils.isEmpty((Object)periodDy)) {
                this.getView().showTipNotification(HCSIErrInfoEnum.COMMON_MUST_INPUT_PERIOD.getErrInfo());
                setCancel = Boolean.TRUE;
            }
            if (!setCancel.booleanValue() && CollectionUtils.isEmpty((Collection)dyColl)) {
                this.getView().showTipNotification(HCSIErrInfoEnum.COMMON_MUST_INPUT_COMPANY.getErrInfo());
                setCancel = Boolean.TRUE;
            }
            if (!setCancel.booleanValue() && SITPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false)) {
                setCancel = Boolean.TRUE;
            }
            if (setCancel.booleanValue()) {
                return;
            }
            LinkedHashSet<Long> insuredCompanyIds = new LinkedHashSet<Long>(dyColl.size());
            for (DynamicObject dyObj : dyColl) {
                insuredCompanyIds.add(dyObj.getLong("fbasedataid_id"));
            }
            long periodId = periodDy.getLong("id");
            Date periodEndDate = periodDy.getDate("enddate");
            Set<Long> invalidCompanyIds = this.getInvalidCompany(periodEndDate, insuredCompanyIds);
            if (invalidCompanyIds.isEmpty()) {
                this.getView().showErrorNotification(HCSIErrInfoEnum.DCL_RECORD_STANDARD_ALL_NOT_EXISTS.getErrInfo());
                return;
            }
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            returnData.put("period", String.valueOf(periodId));
            returnData.put("insuredcompany", SerializationUtils.toJsonString(insuredCompanyIds));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private Set<Long> getInvalidCompany(Date periodEndDate, Set<Long> insuredCompanyIds) {
        DynamicObject[] companyRefStdDys = SocialInsuranceCalHelper.getCompanyRefStdDy(insuredCompanyIds, (Date)periodEndDate);
        if (companyRefStdDys == null || companyRefStdDys.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.stream(companyRefStdDys).map(companyRefStdVDy -> companyRefStdVDy.getLong("welfarepayer.id")).collect(Collectors.toSet());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && CALLBACKID_CONTINUE_CLOSE.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
    }
}

