/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.dclrecord;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.service.DclRecordService;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.entity.social.CalTaskProgressInfoDTO;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import org.apache.commons.lang.StringUtils;

public class LoadingDclRecordPlugin
extends AbstractBasePlugIn
implements ProgresssListener {
    private static final String LABEL_TITLE = "title";
    private static final String LABEL_PROGRESS_TIPS = "tipslb";
    private static final String LABEL_SUM_DCL_RECORD_NUM = "sumdclrecordnumlb";
    private static final String BTN_KNOW = "btn_know";
    private static final String BTN_RUN_IN_BACK = "btn_run_in_back";
    private static final String FAIL_DETAIL_HYPER = "viewexpfiile";
    private static final String VIEW_REPORT = "viewreport";
    private static final String KEY_PANEL_FINISH = "panelfinish";
    private static final String KEY_PANEL_SUSSESS = "successbarflex";
    private static final String KEY_PROGRESS_FLEX = "progressflex";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";
    private static final String KEY_PROGRESSBARAP = "progressbarap";
    private static final String KEY_SUCCESSBARAP = "successbarap";
    private static final String WIDTH = "960px";
    private static final String HEIGHT = "580px";
    private static final String BILL_FORM_ID = "hcsi_sinsurgendetailf7";
    private static final String BILL_LIST_F7 = "hcsi_sinsurgendetaillist";
    private static final String BTN_OK = "btnok";
    private static final String KEY_PANEL_HANDLING = "panelhandling";
    private static final String KEY_TIMELABEL = "timelabel";
    private static final String CACHE_KEY = "cacheKey";
    private static final String IS_DCL_RECORD_LIST_VIEW = "isDclRecordListView";
    private static final String KEY_DCL_RECORD_PROGRESS = "DclRecordProgress_%s";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
        Label label = (Label)this.getControl(FAIL_DETAIL_HYPER);
        label.addClickListener((ClickListener)this);
        Label viewReport = (Label)this.getControl(VIEW_REPORT);
        viewReport.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        this.initView();
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        CalTaskProgressInfoDTO calTaskProgressInfoDTO = this.getCalTaskProgressInfoDTO();
        this.setFormInfo(calTaskProgressInfoDTO, null);
    }

    public void afterBindData(EventObject event) {
        if (Boolean.TRUE.toString().equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
            progressBar.setPercent(100);
            this.setProgressFlex(Boolean.TRUE);
            CalTaskProgressInfoDTO calTaskProgressInfoDTO = this.getCalTaskProgressInfoDTO();
            int fail = 0;
            if (calTaskProgressInfoDTO != null) {
                fail = calTaskProgressInfoDTO.getFail();
            }
            this.setFormInfo(calTaskProgressInfoDTO, null);
            this.setStopProgressFormInfo();
            return;
        }
        this.startTask();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SITStringUtils.equals((String)progressKey, (String)KEY_PROGRESSBARAP)) {
            CalTaskProgressInfoDTO calTaskProgressInfoDTO = this.getCalTaskProgressInfoDTO();
            this.setFormInfo(calTaskProgressInfoDTO, progressEvent);
        }
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        switch (itemKey = itemControl.getKey()) {
            case "viewexpfiile": {
                List<Long> warnDclRecordList = this.getWarnDclRecordIds();
                int fileExpCount = HRBaseServiceHelper.create((String)"hcsi_dclfileexp").count("hcsi_dclfileexp", new QFilter("dclrecord", "in", warnDclRecordList).toArray());
                if (fileExpCount == 0) {
                    this.getView().showTipNotification(HCSIErrInfoEnum.DCL_RECORD_ERROR_CLEAR.getErrInfo());
                    return;
                }
                ListShowParameter listShowParameter = DclRecordHelper.showExpForm(warnDclRecordList);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "viewreport": {
                Map<String, List<Long>> changedDclRecords = this.getChangedDclRecords();
                long sum = changedDclRecords.values().stream().mapToLong(Collection::size).sum();
                Long dclRecordId = (Long)this.getAppCacheByCacheKey().get("dclRecordId", Long.class);
                if (sum > 0L && dclRecordId != null) {
                    FormShowParameter formShowParameter = DclRecordService.getFormShowParam((String)LoadingDclRecordPlugin.class.getName(), (String)"hcsi_dclpersonupdated");
                    formShowParameter.setCustomParam("addFiles", changedDclRecords.get("addFiles"));
                    formShowParameter.setCustomParam("updateFiles", changedDclRecords.get("updateFiles"));
                    formShowParameter.setCustomParam("deleteFiles", changedDclRecords.get("deleteFiles"));
                    formShowParameter.setCustomParam("dclRecordId", (Object)dclRecordId);
                    this.getView().showForm(formShowParameter);
                    break;
                }
                FormShowParameter formShowParameter = DclRecordService.getFormShowParam((String)LoadingDclRecordPlugin.class.getName(), (String)"hcsi_dclpersonempty");
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        CalTaskProgressInfoDTO calTaskProgressInfo = this.getCalTaskProgressInfoDTO();
        if (calTaskProgressInfo != null) {
            int status = calTaskProgressInfo.getStatus();
            String floatingDclRecordId = (String)this.getAppCacheByCacheKey().get("floatingDclRecordId", String.class);
            if (StringUtils.isEmpty((String)floatingDclRecordId)) {
                return;
            }
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getView().getMainView(), floatingDclRecordId);
            Boolean isBackground = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBackground");
            if (status != 2) {
                if (isBackground == null) {
                    HRBackgroundTaskHelper.getInstance().showBaskgroundTask(floatingDclRecordId);
                }
            } else {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingDclRecordId, "COMPLETED");
                this.getAppCacheByCacheKey().clear();
            }
        }
    }

    private void updateParentView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private CalTaskProgressInfoDTO getCalTaskProgressInfoDTO() {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY);
        ISITAppCache appCache = SITAppCache.get((String)recordId);
        return (CalTaskProgressInfoDTO)appCache.get(String.format(Locale.ROOT, KEY_DCL_RECORD_PROGRESS, recordId), CalTaskProgressInfoDTO.class);
    }

    private ISITAppCache getAppCacheByCacheKey() {
        String recordId = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY);
        return SITAppCache.get((String)recordId);
    }

    private void stopProgress(ProgressEvent progressEvent) {
        this.setStopProgressFormInfo();
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
        this.updateParentView();
    }

    private void setStopProgressFormInfo() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_RUN_IN_BACK, KEY_PANEL_HANDLING, KEY_PROGRESS_FLEX});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_KNOW, KEY_PANEL_FINISH, KEY_PANEL_SUSSESS});
        this.showFailAndDetailLabel();
        ISITAppCache appCache = SITAppCache.get((String)CACHE_KEY);
        appCache.put("isFinish", (Object)Boolean.TRUE.toString());
    }

    private void setFormInfo(CalTaskProgressInfoDTO progressInfoDTO, ProgressEvent progressEvent) {
        int total = 0;
        int success = 0;
        int fail = 0;
        int status = 2;
        Date startTime = new Date();
        Date endTime = new Date();
        if (progressInfoDTO != null) {
            status = progressInfoDTO.getStatus();
            total = progressInfoDTO.getTotal();
            success = progressInfoDTO.getSuccess();
            fail = progressInfoDTO.getFail();
            startTime = progressInfoDTO.getStartTime();
            endTime = progressInfoDTO.getEndTime();
        } else if (progressEvent != null) {
            this.stopProgress(progressEvent);
        }
        int finish = success + fail;
        Label labelTime = (Label)this.getView().getControl(KEY_TIMELABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SITDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        labelTime.setText(HCSIErrInfoEnum.COMMON_USING_TIME.getErrInfo(new Object[]{consumeTime}));
        int percentage = 0;
        if (Boolean.TRUE.toString().equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            this.setPercentageLabel(100);
            this.setProgressFlex(Boolean.TRUE);
            this.updateParentView();
            return;
        }
        if (status == 0) {
            this.setPercentageLabel(percentage);
            return;
        }
        if (status == 2 || total == finish) {
            percentage = 100;
            if (progressEvent != null) {
                this.stopProgress(progressEvent);
            }
            this.setPercentageLabel(percentage);
        } else if (total > 0) {
            percentage = new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
            this.setPercentageLabel(percentage);
            if (percentage == 100) {
                this.setProgressFlex(Boolean.TRUE);
                this.updateParentView();
            }
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        }
    }

    private void setProgressFlex(Boolean visible) {
        this.getView().setVisible(visible, new String[]{KEY_PANEL_SUSSESS, BTN_KNOW});
        this.getView().setVisible(Boolean.valueOf(visible == false), new String[]{KEY_PROGRESSBARAP, BTN_RUN_IN_BACK});
        if (visible.booleanValue()) {
            this.showFailAndDetailLabel();
        }
    }

    private boolean isDclRecordListView() {
        return Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam(IS_DCL_RECORD_LIST_VIEW));
    }

    private void initView() {
        Boolean isDclRecordListView = this.isDclRecordListView();
        Label title = (Label)this.getControl(LABEL_TITLE);
        Label sumDclRecordNumLb = (Label)this.getControl(LABEL_SUM_DCL_RECORD_NUM);
        int successfulDclRecordNum = (Integer)this.getView().getFormShowParameter().getCustomParams().get("successfulDclRecordNum");
        sumDclRecordNumLb.setText(String.valueOf(successfulDclRecordNum));
        if (isDclRecordListView.booleanValue()) {
            title.setText(HCSIErrInfoEnum.DCL_RECORD_PROGRESS_TITLE.getErrInfo());
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_REPORT});
        } else {
            title.setText(HCSIErrInfoEnum.DCL_PERSON_PROGRESS_TITLE.getErrInfo());
        }
        this.getView().setVisible(isDclRecordListView, new String[]{"dclrecordnumap"});
        this.getView().setVisible(Boolean.valueOf(isDclRecordListView == false), new String[]{"dclpersonnumap"});
        this.setPercentageLabel(0);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PANEL_FINISH, KEY_PANEL_SUSSESS, FAIL_DETAIL_HYPER, VIEW_REPORT, BTN_KNOW});
    }

    private void setPercentageLabel(int percentage) {
        Label labelPercentage = (Label)this.getView().getControl(LABEL_PROGRESS_TIPS);
        if (this.isDclRecordListView()) {
            labelPercentage.setText(HCSIErrInfoEnum.DCL_RECORD_PROGRESS_TIPS.getErrInfo(new Object[]{String.valueOf(percentage)}));
        } else {
            labelPercentage.setText(HCSIErrInfoEnum.DCL_PERSON_PROGRESS_TIPS.getErrInfo(new Object[]{String.valueOf(percentage)}));
        }
    }

    private void showFailAndDetailLabel() {
        Boolean isShowDetail = this.getWarnDclRecordIds().size() > 0;
        this.getView().setVisible(isShowDetail, new String[]{FAIL_DETAIL_HYPER});
        Boolean visible = !this.isDclRecordListView();
        this.getView().setVisible(visible, new String[]{VIEW_REPORT});
    }

    private List<Long> getWarnDclRecordIds() {
        ISITAppCache appCache = this.getAppCacheByCacheKey();
        List warnDclRecordList = (List)appCache.get("hcsi_dclfileexp", List.class);
        if (warnDclRecordList == null) {
            return Collections.emptyList();
        }
        return warnDclRecordList;
    }

    private Map<String, List<Long>> getChangedDclRecords() {
        ISITAppCache appCache = this.getAppCacheByCacheKey();
        HashMap<String, List<Long>> changedDclRecords = new HashMap<String, List<Long>>(4);
        this.initChangedDclRecords(appCache, changedDclRecords, "addFiles");
        this.initChangedDclRecords(appCache, changedDclRecords, "updateFiles");
        this.initChangedDclRecords(appCache, changedDclRecords, "deleteFiles");
        return changedDclRecords;
    }

    private void initChangedDclRecords(ISITAppCache appCache, Map<String, List<Long>> changedDclRecords, String key) {
        List addFiles = (List)appCache.get(key, List.class);
        if (addFiles == null) {
            addFiles = Collections.emptyList();
        }
        changedDclRecords.put(key, addFiles);
    }
}

