/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.rule;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.declare.helper.DclRecordHelper;
import kd.sit.hcsi.business.declare.helper.DclRuleHelper;
import kd.sit.hcsi.business.scheme.helper.DclScmHelper;
import kd.sit.hcsi.common.constants.SocialInsuranceDeclareConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;

public class DclRuleEdit
extends AbstractFormPlugin
implements SocialInsuranceDeclareConstants,
BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit decDisplayScm = (BasedataEdit)this.getControl("dcldisplayscm");
        decDisplayScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        decDisplayScm.addBeforeF7ViewDetailListener((Consumer)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.getInstructions(-1);
        this.updateLockedCells();
        this.getModel().setDataChanged(false);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        IPageCache pageCache = entryGrid.getView().getPageCache();
        if (pageCache != null) {
            pageCache.put("BOS.setRowDataByNumberDisable", Boolean.TRUE.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentry": {
                boolean hisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
                if (!hisPage) break;
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                Map<Integer, String> indexMap = entryEntity.stream().collect(Collectors.toMap(entry -> entry.getInt("seq"), entry -> entry.getString("dclbusinessname").trim(), (oldVal, newVal) -> oldVal));
                LinkedHashMap<String, Integer> bizNameAndRowMap = new LinkedHashMap<String, Integer>(selectRows.length);
                for (int selectRow : selectRows) {
                    int index2 = selectRow + 1;
                    String bizName = indexMap.get(index2);
                    if (bizName == null || bizName.trim().length() <= 0) continue;
                    bizNameAndRowMap.put(bizName, index2);
                }
                if (bizNameAndRowMap.isEmpty()) {
                    return;
                }
                long dclRuleBoId = this.getModel().getDataEntity(true).getLong("boid");
                QFilter filter = new QFilter("sinsurdclrule", "=", (Object)dclRuleBoId);
                filter.and("dclbusinessname", "in", bizNameAndRowMap.keySet());
                filter.and("dclstatus", "!=", (Object)"D");
                List dclRecordDys = DclRecordHelper.queryNormalDclRecordsByQFilter((QFilter)filter);
                Set usedBizNames = dclRecordDys.stream().map(dclRecordDy -> dclRecordDy.getString("dclbusinessname")).collect(Collectors.toSet());
                bizNameAndRowMap.keySet().retainAll(usedBizNames);
                bizNameAndRowMap.values().forEach(index -> this.getView().showErrorNotification(HCSIErrInfoEnum.DCL_RULE_ENT_BIZ_NAME_USED.getErrInfo(new Object[]{index})));
                if (bizNameAndRowMap.isEmpty()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        switch (operateKey) {
            case "newentry": {
                if (operationResult != null && !operationResult.isSuccess()) {
                    return;
                }
                QFilter filter = new QFilter("isdefaultscheme", "=", (Object)"1");
                filter.and("iscurrentversion", "=", (Object)"1");
                DynamicObject defaultScmDy = DclScmHelper.querySchemeByFilter((String)"hcsi_dcldisplayscm", (QFilter)filter);
                if (HRObjectUtils.isEmpty((Object)defaultScmDy)) break;
                this.updateDecDisplayScm(defaultScmDy.getLong("id"));
                this.updateLockedCells();
                break;
            }
            case "deleteentry": {
                this.updateLockedCells();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        ChangeData changeData;
        if (args.getChangeSet() == null || args.getChangeSet().length == 0 || (changeData = args.getChangeSet()[0]) == null) {
            return;
        }
        switch (propName = args.getProperty().getName()) {
            case "haswelfaretype": {
                this.updateWelfareTypeMulMustInput(changeData);
                break;
            }
            case "dclbusinessname": {
                this.checkRepeatDclBusinessName(changeData);
                break;
            }
            case "modifytype": 
            case "welfaretypemul": {
                this.getInstructions(changeData.getRowIndex());
                break;
            }
        }
        this.updateLockedCells();
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        String fieldKey = ((BasedataEdit)beforeF7ViewDetailEvent.getSource()).getFieldKey();
        if ("dcldisplayscm".equals(fieldKey)) {
            beforeF7ViewDetailEvent.setCancel(true);
            this.showDeclareDisplayScmBaseView(beforeF7ViewDetailEvent.getPkId(), OperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "dcldisplayscm": {
                event.setCancel(true);
                String decDisplayScmId = this.getCurrDecDisplayScmId();
                this.showDeclareDisplayScmBaseView(decDisplayScmId, OperationStatus.ADDNEW);
                break;
            }
        }
    }

    private void showDeclareDisplayScmBaseView(Object decDisplayScmId, OperationStatus operationStatus) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        if (decDisplayScmId != null && !Long.valueOf(0L).equals(decDisplayScmId)) {
            formShowParameter.setCustomParam("displaySchmId", (Object)("" + decDisplayScmId));
        }
        formShowParameter.setCustomParam("disable_control_title", (Object)Boolean.TRUE.toString());
        formShowParameter.setCustomParam("ue_param", (Object)Boolean.TRUE.toString());
        formShowParameter.setFormId("hcsi_dcldisplayscm");
        formShowParameter.setStatus(operationStatus);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setHasRight(true);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcsi_dcldisplayscm"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "hcsi_dcldisplayscm": {
                Map data = (Map)returnData;
                if (CollectionUtils.isEmpty((Map)data) || !HRStringUtils.isNotEmpty((String)((String)data.get("displaySchmId")))) break;
                this.updateDecDisplayScm(Long.parseLong((String)data.get("displaySchmId")));
                break;
            }
        }
    }

    private void updateWelfareTypeMulMustInput(ChangeData changeData) {
        DynamicObject changeEntry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(changeData.getRowIndex());
        String newValue = String.valueOf(changeData.getNewValue());
        if ("0".equals(newValue)) {
            this.clearWelfareTypeMul(changeEntry, changeData.getRowIndex());
        }
        this.getInstructions(changeData.getRowIndex());
    }

    private void clearWelfareTypeMul(DynamicObject changeEntry, int seq) {
        if (changeEntry == null) {
            return;
        }
        DynamicObjectCollection welfareTypeMul = changeEntry.getDynamicObjectCollection("welfaretypemul");
        if (!SITListUtil.isEmpty((List)welfareTypeMul)) {
            this.clearCellByField(seq, "welfaretypemul");
        }
    }

    private void updateLockedCells() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        IFormView view = this.getView();
        boolean hisPage = BaseDataHisHelper.isHisPage((IFormView)view);
        if (SITListUtil.isEmpty((List)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String hasWelfareType = ((DynamicObject)entryEntity.get(i)).getString("haswelfaretype");
            String dclBusinessName = ((DynamicObject)entryEntity.get(i)).getString("dclbusinessname");
            String modifyType = ((DynamicObject)entryEntity.get(i)).getString("modifytype");
            if (SITStringUtils.equals((String)"0", (String)hasWelfareType)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"welfaretypemul"});
            } else {
                view.setEnable(Boolean.TRUE, i, new String[]{"welfaretypemul"});
            }
            if (!hisPage || SITStringUtils.isEmpty((String)dclBusinessName) || SITStringUtils.isEmpty((String)modifyType)) continue;
            view.setEnable(Boolean.FALSE, i, new String[]{"dclbusinessname", "modifytype"});
        }
    }

    private void checkRepeatDclBusinessName(ChangeData changeData) {
        DynamicObjectCollection ruleEntries = this.getModel().getEntryEntity("entryentity");
        HashSet names = Sets.newHashSetWithExpectedSize((int)16);
        for (int i = 0; i < ruleEntries.size(); ++i) {
            String dclBusinessName;
            if (i == changeData.getRowIndex() || (dclBusinessName = ((DynamicObject)ruleEntries.get(i)).getString("dclbusinessname")) == null) continue;
            names.add(dclBusinessName.trim());
        }
        String dclBusinessName = String.valueOf(changeData.getNewValue());
        if (dclBusinessName != null && (dclBusinessName = dclBusinessName.trim()).length() > 0 && names.contains(dclBusinessName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"SocialInsuranceDeclareRuleEdit_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            this.clearCellByField(changeData.getRowIndex(), "dclbusinessname");
        }
    }

    private void clearCellByField(int seq, String field) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        switch (field) {
            case "welfaretypemul": {
                model.beginInit();
                model.setValue(field, null, seq);
                model.endInit();
                break;
            }
            case "dclbusinessname": {
                model.setValue(field, null, seq);
                break;
            }
        }
        this.getView().updateView("entryentity", seq);
    }

    private String getCurrDecDisplayScmId() {
        int currentRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        DynamicObject entryRowEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(currentRowIndex);
        return entryRowEntity.getString("dcldisplayscm.id");
    }

    private void updateDecDisplayScm(long displayScmId) {
        if (displayScmId == 0L) {
            return;
        }
        int currentRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        this.getModel().setValue("dcldisplayscm", (Object)displayScmId, currentRowIndex);
    }

    private void getInstructions(int rowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (rowIndex != -1 && i != rowIndex) continue;
            DynamicObject entryDy = (DynamicObject)entryEntity.get(i);
            String instructionsTxt = DclRuleHelper.getInstructionsTxt((String)entryDy.getString("modifytype"), (String)entryDy.getString("haswelfaretype"), (List)entryDy.getDynamicObjectCollection("welfaretypemul"));
            entryDy.set("instructionstxt", (Object)instructionsTxt);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }
}

