/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.scheme.constants.RptDisplayConstants;
import kd.sit.hcsi.business.scheme.dto.RptDisplayColumnEntity;
import kd.sit.hcsi.business.scheme.helper.AbsDisplayScmHelper;
import kd.sit.hcsi.business.scheme.helper.DclScmHelper;
import kd.sit.hcsi.business.scheme.service.AbsDisplayScmService;
import kd.sit.hcsi.formplugin.web.declare.scheme.DclDisplaySchemeHandler;
import kd.sit.hcsi.formplugin.web.declare.scheme.common.AbsDisplaySchemePlugin;
import kd.sit.hcsi.formplugin.web.declare.scheme.common.IDisplaySchemeHandler;
import kd.sit.sitbp.common.cache.SITPageCache;

public class DclDisplaySchemeEdit
extends AbsDisplaySchemePlugin {
    @Override
    public void registerListener(EventObject event) {
        super.registerListener(event);
        Search listColumnSearchView = (Search)this.getView().getControl("col_search_view");
        listColumnSearchView.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addClickListeners(new String[]{"btn_close", "btn_cancel", "btn_save"});
        this.addClickListeners(new String[]{"btn_addcolumn", "btn_removecolumn"});
        this.addClickListeners(new String[]{"cancel_icon", "cancel_lb"});
        Search treeColumnSearch = (Search)this.getView().getControl("treesearchap");
        treeColumnSearch.addEnterListener((SearchEnterListener)this);
        Search listColumnSearch = (Search)this.getView().getControl("col_search");
        listColumnSearch.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject event) {
        if (Boolean.TRUE.toString().equals(this.getPageCache().get("CACHE_IS_ADDNEW"))) {
            return;
        }
        String displaySchmIdStr = (String)this.getView().getFormShowParameter().getCustomParam("displaySchmId");
        if (HRStringUtils.isNotEmpty((String)displaySchmIdStr) && !this.isOpenHistoryDetailView()) {
            this.getSpecificNodeAndCacheIt(displaySchmIdStr);
            this.getView().setFormTitle(this.getModel().getDataEntityType().getDisplayName());
        }
    }

    @Override
    public void beforeBindData(EventObject event) {
        this.buildFieldTree();
        super.beforeBindData(event);
    }

    @Override
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        DynamicObjectCollection entryEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Map fieldValAndNameMap = AbsDisplayScmService.getFieldValAndNameMap((String)"sitbs_schemecol", (String)"1010_S");
        for (DynamicObject entry : entryEntity) {
            entry.set("fieldname", fieldValAndNameMap.get(entry.getString("fieldvalue")));
        }
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
        if (this.isOpenHistoryDetailView()) {
            this.openCustomView(Boolean.FALSE, false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap_view"});
            this.getView().updateView("flexpanelap_view");
        }
        this.addSpecialColumn();
        this.selectNeededNodesInFieldTree();
        this.addSpecialColumn();
        this.selectNeededNodesInFieldTree();
    }

    @Override
    public void search(SearchEnterEvent searchEnterEvent) {
        String key;
        String searchText = searchEnterEvent.getText();
        Search search = (Search)searchEnterEvent.getSource();
        switch (key = search.getKey()) {
            case "treesearchap": {
                AbsDisplayScmService.searchTreeNode((String)searchText, (IFormView)this.getView(), (boolean)true);
                this.selectNeededNodesInFieldTree();
                break;
            }
            case "col_search": {
                AbsDisplayScmService.searchFieldName((String)searchText, (IFormView)this.getView(), (String)"entryentity", (String)"fieldname");
                break;
            }
            case "col_search_view": {
                AbsDisplayScmService.searchFieldName((String)searchText, (IFormView)this.getView(), (String)"entryentityview", (String)"fieldnameview");
                break;
            }
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        List<TreeNode> allCheckNodes;
        TreeView fieldTreeView = (TreeView)evt.getSource();
        if ("treeviewap".equals(fieldTreeView.getKey()) && Boolean.FALSE.equals(evt.getChecked()) && !CollectionUtils.isEmpty(allCheckNodes = this.getAllCheckNodes(null))) {
            fieldTreeView.checkNodes(allCheckNodes);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cancel_icon": 
            case "cancel_lb": {
                if (!HRStringUtils.isEmpty((String)this.getPageCache().get("CACHE_SELECTED_NODE")) && this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_CANCEL", null)) break;
                this.cancelEditing();
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess()) {
            switch (args.getOperateKey()) {
                case "donothing_edit_scheme": {
                    this.clearColSearchView();
                    break;
                }
                case "do_addcolumn": {
                    if (!this.checkBeforeAddColumns()) break;
                    this.addColumn();
                    break;
                }
                case "do_removecolumn": {
                    if (!this.beforeRemoveColumns()) break;
                    AbsDisplayScmService.removeColumn((IFormView)this.getView(), this.getDefaultSelectedNodes());
                    break;
                }
                case "donothing_hisinfo": {
                    String currNodeId = this.getCurrNodeId();
                    if (currNodeId == null || !this.checkCurrNodeExists(currNodeId)) break;
                    long dclDisplayScmId = Long.parseLong(currNodeId);
                    this.openHistoryVersionOf(dclDisplayScmId);
                    return;
                }
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            switch (callBackId) {
                case "CALLBACK_CHECK_DATA_CHANGE_CANCEL": {
                    this.cancelEditing();
                    break;
                }
            }
        }
    }

    @Override
    protected List<RptDisplayColumnEntity> getLeftTreeDataList() {
        return this.getHandler().getLeftTreeDataList("1010_S");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        String currNodeId = null;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": {
                currNodeId = this.getCurrNodeId();
                if (currNodeId == null || !this.doValidBeforeSave(formOperate, Long.parseLong(currNodeId))) {
                    args.setCancel(true);
                    break;
                }
                if (!"save".equals(opKey) || Boolean.TRUE.toString().equals(this.getPageCache().get("CACHE_IS_ADDNEW"))) break;
                args.setCancel(true);
                if (!this.confirmChange()) break;
                this.updateViewAfterSaveData();
                break;
            }
            case "donothing_edit_scheme": {
                currNodeId = this.getCurrNodeId();
                if (currNodeId == null || this.checkSchemeEditing(currNodeId)) {
                    args.setCancel(true);
                    break;
                }
                if (!this.checkCurrNodeExists(currNodeId)) {
                    args.setCancel(true);
                    break;
                }
                this.refreshDisplayScm(currNodeId);
                this.openCustomView(Boolean.TRUE, true);
                this.selectNeededNodesInFieldTree();
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    @Override
    protected boolean beforeDoSaveOperation() {
        Map<String, List<String>> errMsgListMap = this.getHandler().beforeDoSaveOperation();
        boolean isValid = CollectionUtils.isEmpty(errMsgListMap);
        if (!isValid) {
            List<String> errMsgList = errMsgListMap.get("LEVEL_TIPS");
            if (!CollectionUtils.isEmpty(errMsgList)) {
                errMsgList.forEach(errMsg -> this.getView().showTipNotification(errMsg));
            }
            if (!CollectionUtils.isEmpty(errMsgList = errMsgListMap.get("LEVEL_ERROR"))) {
                errMsgList.forEach(errMsg -> this.getView().showErrorNotification(errMsg));
            }
        }
        return isValid;
    }

    @Override
    protected Map<String, Object> getExtendFieldValue(RptDisplayColumnEntity rowData) {
        return this.getHandler().getExtendFieldValue(rowData);
    }

    @Override
    protected void afterDeleteDisplaySchema(String schemaId) {
        this.getHandler().afterDeleteDisplaySchema(schemaId);
    }

    @Override
    protected boolean beforeAddColumns(List<RptDisplayColumnEntity> entities) {
        return this.getHandler().beforeAddColumns(entities);
    }

    @Override
    protected void openCustomView(Boolean isRightPageVisible, boolean isBottomBtnVisible) {
        super.openCustomView(isRightPageVisible, isBottomBtnVisible);
        this.getHandler().setCustomView(isRightPageVisible, isBottomBtnVisible);
        this.setEntryEntityView(Boolean.TRUE.equals(isRightPageVisible));
        this.lockViewForPreSysData();
    }

    @Override
    protected String getCurrentRptDisplayFormId() {
        return "hcsi_dcldisplayscm";
    }

    private void lockViewForPreSysData() {
        String currNodeId = this.getCurrNodeId();
        if (HRStringUtils.isEmpty((String)currNodeId)) {
            return;
        }
        Long currScmId = DclScmHelper.getScmId((Object)currNodeId);
        DynamicObject scmDy = DclScmHelper.querySchemeByFilter((String)this.getCurrentRptDisplayFormId(), (QFilter)new QFilter("id", "=", (Object)currScmId));
        Boolean isPreSysData = !HRObjectUtils.isEmpty((Object)scmDy) && scmDy.getBoolean("issyspreset");
        if (isPreSysData.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit_scheme_icon", "edit_scheme_lb"});
        }
        this.getView().setEnable(Boolean.valueOf(isPreSysData == false), new String[]{"edit_scheme_icon", "edit_scheme_lb"});
    }

    private IDisplaySchemeHandler getHandler() {
        return new DclDisplaySchemeHandler(this.getView());
    }

    private void clearColSearchView() {
        Search columnSearch = (Search)this.getView().getControl("col_search_view");
        columnSearch.setSearchKey("");
        this.hideFieldTipForName();
    }

    @Override
    protected List<String> getAllNeedShowFieldBorderList() {
        return Arrays.asList("fieldname", "displayname");
    }

    private boolean checkIsRef(long currPkId) {
        boolean isRef = DclScmHelper.isRef((BasedataEntityType)((BasedataEntityType)this.getModel().getDataEntity().getDataEntityType()), (long)currPkId);
        if (isRef) {
            this.getView().showErrorNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_REFERENCED.getErrInfo());
        }
        return isRef;
    }

    @Override
    protected Set<String> getDefaultSelectedNodes() {
        return RptDisplayConstants.FIXED_COLUMN_ADDED;
    }

    @Override
    protected boolean checkCurrNodeInvalid(String currNodeId) {
        long currPkId = Long.parseLong(currNodeId);
        if (this.checkIsSysPreData(currPkId)) {
            return true;
        }
        if (!Boolean.TRUE.toString().equals(this.getPageCache().get("CACHE_IS_ADDNEW"))) {
            return this.checkIsRef(currPkId);
        }
        return this.checkSchemeEditing(currNodeId);
    }

    protected void addSpecialColumn() {
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getHandler().addSpecialColumn(entryEntities);
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setDataChanged(false);
        }
        this.getView().updateView("entryentity");
    }

    private void setEntryEntityView(boolean isRightPageVisible) {
        if (isRightPageVisible) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentityview");
            this.getView().updateView("entryentityview");
        } else {
            DynamicObject currDyInDb = this.getCurrDataEntity();
            if (currDyInDb != null && !HRObjectUtils.isEmpty((Object)currDyInDb) && !CollectionUtils.isEmpty((Collection)currDyInDb.getDynamicObjectCollection("entryentity"))) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                DynamicObject currDyInView = this.getModel().getDataEntity(true);
                currDyInView.set("name", currDyInDb.get("name"));
                currDyInView.set("description", (Object)currDyInDb.getString("description"));
                currDyInView.set("isdefaultscheme", (Object)currDyInDb.getBoolean("isdefaultscheme"));
                currDyInView.set("isshowinbaseview", (Object)currDyInDb.getBoolean("isshowinbase"));
                DynamicObjectCollection entityView = currDyInView.getDynamicObjectCollection("entryentityview");
                entityView.clear();
                model.deleteEntryData("entryentityview");
                Map fieldValAndNameMap = AbsDisplayScmService.getFieldValAndNameMap((String)"sitbs_schemecol", (String)"1010_S");
                for (DynamicObject entryDy : currDyInDb.getDynamicObjectCollection("entryentity")) {
                    DynamicObject entryViewDy = entityView.addNew();
                    entryViewDy.set("fieldnameview", fieldValAndNameMap.get(entryDy.getString("fieldvalue")));
                    entryViewDy.set("displaynameview", entryDy.get("displayname"));
                    entryViewDy.set("seq", (Object)entryDy.getInt("seq"));
                }
                model.endInit();
                this.getView().updateView("entryentityview");
                this.getView().updateView("isshowinbaseview");
                this.getModel().setDataChanged(false);
            }
        }
    }

    private DynamicObject getCurrDataEntity() {
        DynamicObject currDyInDb = null;
        if (this.isOpenHistoryDetailView()) {
            currDyInDb = this.getModel().getDataEntity(true);
        } else {
            String currNodeId = this.getCurrNodeId();
            if (HRStringUtils.isNotEmpty((String)currNodeId)) {
                Long pkId = Long.parseLong(currNodeId);
                String currEntityName = this.getCurrentRptDisplayFormId();
                QFilter filter = new QFilter("boid", "=", (Object)pkId);
                filter.and("iscurrentversion", "=", (Object)"1");
                currDyInDb = new HRBaseServiceHelper(currEntityName).queryOne("id,name,description,isdefaultscheme,isshowinbase,entryentity.displayname,entryentity.fieldvalue,entryentity.seq", filter.toArray());
            }
        }
        return currDyInDb;
    }

    protected void cancelEditing() {
        this.releaseLock(null);
        String currNodeId = this.getCurrNodeId();
        this.getPageCache().remove("CACHE_SELECTED_NODE");
        if (HRStringUtils.isNotEmpty((String)currNodeId) && AbsDisplayScmHelper.isDisplayScmInDb((String)this.getCurrentRptDisplayFormId(), (Long)Long.parseLong(currNodeId))) {
            this.refreshDisplayScm(currNodeId);
        } else {
            this.buildScmTree();
            this.getPageCache().remove("CACHE_IS_ADDNEW");
        }
        this.getModel().setDataChanged(false);
        this.clearColSearchView();
    }

    @Override
    protected void clearSearchKey() {
        Search treeSearch = (Search)this.getView().getControl("treesearchap");
        treeSearch.setSearchKey("");
        SITPageCache pageCache = new SITPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get("CACHE_TREE_DATA", String.class);
        if (cacheTreeNodeStr != null) {
            Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
            ArrayList<String> nodeIds = new ArrayList<String>(nodeMap.size());
            for (Map.Entry node : nodeMap.entrySet()) {
                nodeIds.add(((TreeNode)node.getValue()).getId());
            }
            TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
            treeView.uncheckNodes(nodeIds);
        }
        Search columnSearch = (Search)this.getView().getControl("col_search");
        columnSearch.setSearchKey("");
    }

    private boolean checkIsSysPreData(Long currPkId) {
        QFilter filter = new QFilter("boid", "=", (Object)currPkId);
        filter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        DynamicObject sysScmDy = DclScmHelper.querySchemeByFilter((String)this.getCurrentRptDisplayFormId(), (QFilter)filter);
        if (sysScmDy != null && sysScmDy.getBoolean("issyspreset")) {
            this.getView().showTipNotification(HCSIErrInfoEnum.COMMON_CAN_NOT_DELETE_PRE_DATA.getErrInfo());
            return true;
        }
        return false;
    }

    private boolean checkBeforeAddColumns() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        return this.beforeAddColumns(this.getTreeDataByIds(checkedNodeIds));
    }

    private List<RptDisplayColumnEntity> getTreeDataByIds(List<String> ids) {
        boolean isEmpty;
        Map<String, RptDisplayColumnEntity> treeMap = this.getTreeMap();
        boolean bl = isEmpty = treeMap == null || treeMap.isEmpty();
        if (CollectionUtils.isEmpty(ids) || isEmpty) {
            return null;
        }
        ArrayList<RptDisplayColumnEntity> resultList = new ArrayList<RptDisplayColumnEntity>(10);
        for (String id : ids) {
            RptDisplayColumnEntity rptDisplayColumnEntity = treeMap.get(id);
            if (rptDisplayColumnEntity == null) continue;
            resultList.add(rptDisplayColumnEntity);
        }
        return resultList;
    }

    private Map<String, RptDisplayColumnEntity> getTreeMap() {
        List<TreeNode> treeRootNodeList = this.getTreeRootNodeList();
        if (CollectionUtils.isEmpty(treeRootNodeList)) {
            return null;
        }
        return this.flatTreeListToMap(treeRootNodeList);
    }

    private List<TreeNode> getTreeRootNodeList() {
        SITPageCache SITPageCache2 = new SITPageCache(this.getView());
        String rootNodeStr = (String)SITPageCache2.get("CACHE_ROOT_NODE", String.class);
        if (HRStringUtils.isEmpty((String)rootNodeStr)) {
            return null;
        }
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNodeStr);
        return rootNodes;
    }

    private Map<String, RptDisplayColumnEntity> flatTreeListToMap(List<TreeNode> treeRootNodeList) {
        HashMap<String, RptDisplayColumnEntity> treeNodeMap = new HashMap<String, RptDisplayColumnEntity>(16);
        for (TreeNode treeNode : treeRootNodeList) {
            List children = treeNode.getChildren();
            treeNodeMap.put(treeNode.getId(), (RptDisplayColumnEntity)treeNode.getData());
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            treeNodeMap.putAll(this.flatTreeListToMap(children));
        }
        return treeNodeMap;
    }

    @Override
    protected void selectNeededNodesInFieldTree() {
        Map<String, TreeNode> nodeMap = this.getNodeMap();
        List<TreeNode> checkNodes = this.getAllCheckNodes(nodeMap);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        if (!CollectionUtils.isEmpty(nodeMap)) {
            treeView.uncheckNodes(new ArrayList<String>(nodeMap.keySet()));
        }
        if (!CollectionUtils.isEmpty(checkNodes)) {
            treeView.checkNodes(checkNodes);
        }
    }

    public void addColumn() {
        IFormView formView = this.getView();
        TreeView treeView = (TreeView)formView.getControl("treeviewap");
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            formView.showTipNotification(HCSIErrInfoEnum.COMMON_SELECT_DATA_FIRST.getErrInfo());
            return;
        }
        Map<String, TreeNode> nodeMap = this.getNodeMap();
        Map treeNodeTableRowMap = AbsDisplayScmService.geTreeNodeBindTableRowMap((IFormView)formView);
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        int index = 0;
        int entrySeq = this.getDefaultSelectedNodes().size();
        for (String selectNodeId : selectNodeIds) {
            TreeNode selectNode = nodeMap.get(selectNodeId);
            if (selectNode == null || !selectNode.isLeaf() || treeNodeTableRowMap.containsKey(selectNodeId)) continue;
            RptDisplayColumnEntity rowData = (RptDisplayColumnEntity)selectNode.getData();
            if (this.getDefaultSelectedNodes().contains(selectNodeId) && CollectionUtils.isEmpty((Collection)rowData.getChildren())) continue;
            DynamicObject entry = entryEntities.addNew();
            entry.set("seq", (Object)entrySeq++);
            entry.set("fieldname", (Object)rowData.getFieldTreeNodeText());
            entry.set("fieldvalue", (Object)rowData.getFieldValue());
            this.setExtendFieldValue(entry, rowData);
            treeNodeTableRowMap.put(selectNodeId, index);
            ++index;
        }
        this.getView().updateView("entryentity");
    }

    private void setExtendFieldValue(DynamicObject entry, RptDisplayColumnEntity rowData) {
        boolean condition;
        Map<String, Object> extendFieldValue = this.getExtendFieldValue(rowData);
        boolean bl = condition = extendFieldValue != null && !extendFieldValue.isEmpty() && entry != null;
        if (condition) {
            extendFieldValue.forEach((arg_0, arg_1) -> ((DynamicObject)entry).set(arg_0, arg_1));
        }
    }

    private Map<String, TreeNode> getNodeMap() {
        SITPageCache pageCache = new SITPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get("CACHE_TREE_DATA", String.class);
        return (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
    }

    protected List<TreeNode> getAllCheckNodes(Map<String, TreeNode> nodeMap) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Map<String, TreeNode> currNodeMap = nodeMap == null ? this.getNodeMap() : nodeMap;
        return entryEntity.stream().map(entry -> entry.getString("fieldvalue")).map(currNodeMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void openHistoryVersionOf(Long dclDisplayScmId) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)this.getCurrentRptDisplayFormId(), (boolean)false, (int)0);
        showParameter.setCustomParam("hisinfolist", (Object)"hisinfolist");
        showParameter.setCustomParam("donothing_view_versions", (Object)"donothing_view_versions");
        showParameter.setCustomParam("boid", (Object)dclDisplayScmId);
        showParameter.setFormId("sitbp_dcldisplayscmf7");
        showParameter.setCaption(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_HISTORY_VERSION_LIST_NAME.getErrInfo());
        QFilter filter = new QFilter("boid", "=", (Object)dclDisplayScmId);
        showParameter.getListFilterParameter().getQFilters().add(filter);
        showParameter.setCustomParam("openHistoryVersionWithF7List", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean confirmChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long boid = dataEntity.getLong("boid");
        QFilter filter = new QFilter("boid", "=", (Object)boid);
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject sourceDy = HRBaseServiceHelper.create((String)"hcsi_dcldisplayscm").queryOne("sourcevid", filter);
        if (sourceDy == null) {
            return false;
        }
        long sourceId = sourceDy.getLong("sourcevid");
        DynamicObject instance = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"hcsi_dcldisplayscm").createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)instance);
        long pkId = DB.genLongId((String)"hcsi_dcldisplayscm");
        instance.set("id", (Object)pkId);
        instance.set("status", (Object)"A");
        instance.set("sourcevid", (Object)sourceId);
        OperationServiceImpl operationService = new OperationServiceImpl();
        dataEntity.set("sourcevid", (Object)sourceId);
        OperationResult tempOpResult = operationService.localInvokeOperation("confirmchange", new DynamicObject[]{instance}, OperateOption.create());
        List messages = tempOpResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(messages)) {
            String errMsg = String.join((CharSequence)",", messages);
            this.getView().showErrorNotification(errMsg);
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkCurrNodeExists(String currNodeId) {
        DynamicObject scmDy = this.getScmOf(currNodeId);
        if (HRObjectUtils.isEmpty((Object)scmDy)) {
            this.getView().showTipNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_DISPLAY_HAVE_BEEN_DELETE.getErrInfo());
            this.getPageCache().remove("CACHE_SELECTED_NODE");
            this.reBuildScmTrees(currNodeId);
            return false;
        }
        return true;
    }
}

