/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.scheme;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListOperationColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class DclDisplaySchemeList
extends HRDataBaseList {
    private static final String VIEW_HISTORY_VERSIONS = "donothing_view_versions";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IFormView view = this.getView();
        if (this.isHistoryList()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listoperatecol", "toolbarap"});
            Container toolBar = (Container)view.getControl("toolbarap");
            if (toolBar == null) {
                return;
            }
            this.getView().updateView("toolbarap");
            Set fieldKeySet = Stream.of("hisversion", "fseq", "name", "description", "datastatus", "creator.name", "createtime", "modifier", "modifier.name", "modifytime").collect(Collectors.toSet());
            List listColumns = args.getListColumns();
            listColumns.removeIf(iListColumn -> iListColumn instanceof ListOperationColumn || !fieldKeySet.contains(iListColumn.getListFieldKey()));
            this.setSpecifyColumns(listColumns);
        }
    }

    private void setSpecifyColumns(List<IListColumn> listColumns) {
        Map metaInfo;
        String billFormId = ((IListView)this.getView()).getBillFormId();
        if (HRStringUtils.isNotEmpty((String)billFormId) && (metaInfo = FormMetadataCache.getListMeta((String)billFormId)) != null && metaInfo.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)metaInfo.get(BillList.class.getSimpleName());
            BillList billList = (BillList)ControlTypes.fromJsonString((String)strBillList);
            List billListItems = billList.getItems();
            if (CollectionUtils.isEmpty((Collection)billListItems)) {
                return;
            }
            for (Control billListItem : billListItems) {
                if (!(billListItem instanceof Container) || !"gridview".equalsIgnoreCase(billListItem.getKey())) continue;
                HashMap<String, LocaleString> specColumns = new HashMap<String, LocaleString>(4);
                for (Control item : ((Container)billListItem).getItems()) {
                    if (!(item instanceof IListColumn)) continue;
                    IListColumn tmpListColumn = (IListColumn)item;
                    if ("viewdetail".equals(tmpListColumn.getListFieldKey())) {
                        listColumns.add(4, tmpListColumn);
                        continue;
                    }
                    if ("modifier.name".equals(tmpListColumn.getListFieldKey())) {
                        specColumns.put("modifier", tmpListColumn.getCaption());
                        continue;
                    }
                    if (!"modifytime".equals(tmpListColumn.getListFieldKey())) continue;
                    specColumns.put("modifytime", tmpListColumn.getCaption());
                }
                for (IListColumn listColumn : listColumns) {
                    LocaleString localeString = (LocaleString)specColumns.get(listColumn.getListFieldKey());
                    if (localeString == null) continue;
                    listColumn.setCaption(localeString);
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List fastFilterColumns;
        if (this.isHistoryList() && (fastFilterColumns = args.getFastFilterColumns()) != null) {
            fastFilterColumns.removeIf(filterColumn -> "number".equals(filterColumn.getFieldName()));
        }
    }

    public void setFilter(SetFilterEvent event) {
        QFilter filter = new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.DELETED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()});
        List qFilters = event.getQFilters();
        qFilters.removeIf(qFilter -> qFilter.getProperty().contains("datastatus"));
        qFilters.add(filter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("donothing_viewdetail".equals(formOperate.getOperateKey())) {
            ListSelectedRow listFocusRow = formOperate.getListFocusRow();
            if (listFocusRow.getPrimaryKeyValue() == null) {
                return;
            }
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.setPkId(listFocusRow.getPrimaryKeyValue());
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("disable_control_title", (Object)Boolean.TRUE.toString());
            formShowParameter.setCustomParam("ue_param", (Object)Boolean.TRUE.toString());
            formShowParameter.setFormId(((IListView)this.getView()).getBillFormId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private boolean isHistoryList() {
        String viewHistoryVersions = (String)this.getView().getFormShowParameter().getCustomParam(VIEW_HISTORY_VERSIONS);
        return HRStringUtils.equals((String)viewHistoryVersions, (String)VIEW_HISTORY_VERSIONS);
    }
}

