/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.scheme.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.scheme.constants.RptDisplayConstants;
import kd.sit.hcsi.business.scheme.dto.RptDisplayColumnEntity;
import kd.sit.hcsi.business.scheme.helper.DclScmHelper;
import kd.sit.hcsi.formplugin.web.declare.scheme.common.IDisplaySchemeHandler;
import kd.sit.sitbp.common.util.SITStringUtils;

public abstract class AbsDisplaySchemeHandler
implements IDisplaySchemeHandler,
RptDisplayConstants {
    protected IFormView formView;

    public AbsDisplaySchemeHandler(IFormView iFormView) {
        this.formView = iFormView;
    }

    @Override
    public void validDisplayName(DynamicObjectCollection entryEntity, Map<String, List<String>> errMsgListMap) {
        if (!CollectionUtils.isEmpty(errMsgListMap)) {
            return;
        }
        HashSet<String> displayNameSet = new HashSet<String>();
        HashSet<String> repeatDisplayNameSet = new HashSet<String>();
        for (DynamicObject dynamicObject : entryEntity) {
            String displayName = dynamicObject.getString("displayname");
            if (HRStringUtils.isEmpty((String)displayName) || displayNameSet.add(displayName)) continue;
            repeatDisplayNameSet.add(displayName);
        }
        if (!CollectionUtils.isEmpty(repeatDisplayNameSet)) {
            List errMsgList = errMsgListMap.computeIfAbsent("LEVEL_TIPS", key -> new ArrayList(entryEntity.size()));
            errMsgList.add(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_DISPLAY_NAME_REPEATED.getErrInfo(new Object[]{repeatDisplayNameSet}));
        }
    }

    @Override
    public List<RptDisplayColumnEntity> getLeftTreeDataList(String number) {
        return this.buildLeftTree(number);
    }

    private List<RptDisplayColumnEntity> buildLeftTree(String number) {
        ArrayList<RptDisplayColumnEntity> treeList = new ArrayList<RptDisplayColumnEntity>();
        DynamicObject schemeColumnInfo = DclScmHelper.querySchemeColumnInfo((String)"sitbs_schemecol", (String)number);
        if (HRObjectUtils.isEmpty((Object)schemeColumnInfo)) {
            return treeList;
        }
        DynamicObjectCollection schemeColumnInfoColl = schemeColumnInfo.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)schemeColumnInfoColl)) {
            return treeList;
        }
        HashMap<String, RptDisplayColumnEntity> tmpFieldValAndRptMap = new HashMap<String, RptDisplayColumnEntity>(schemeColumnInfoColl.size());
        LinkedHashMap<String, String> fieldValAndParentValMap = new LinkedHashMap<String, String>(schemeColumnInfoColl.size());
        for (DynamicObject schemeColumnInfoEntry : schemeColumnInfoColl) {
            RptDisplayColumnEntity rptDisplayColumnEntity = new RptDisplayColumnEntity();
            String fieldVal = schemeColumnInfoEntry.getString("fieldvalue");
            rptDisplayColumnEntity.setDisplayName(schemeColumnInfoEntry.getString("nodename"));
            rptDisplayColumnEntity.setFieldName(schemeColumnInfoEntry.getLocaleString("nodename"));
            rptDisplayColumnEntity.setFieldTreeNodeText(schemeColumnInfoEntry.getString("nodename"));
            rptDisplayColumnEntity.setFieldValue(fieldVal);
            String nodeSite = schemeColumnInfoEntry.getString("nodesite");
            if ("1020_S".equals(number) && SITStringUtils.isNotEmpty((String)nodeSite)) {
                if (nodeSite.startsWith("1")) {
                    rptDisplayColumnEntity.setFieldSourceType("1");
                } else if (nodeSite.startsWith("2")) {
                    rptDisplayColumnEntity.setFieldSourceType("2");
                } else if (nodeSite.startsWith("3")) {
                    rptDisplayColumnEntity.setFieldSourceType("5");
                }
            }
            tmpFieldValAndRptMap.put(fieldVal, rptDisplayColumnEntity);
            String parentNodeValue = schemeColumnInfoEntry.getString("parentnodevalue");
            if (HRStringUtils.isEmpty((String)parentNodeValue)) {
                treeList.add(rptDisplayColumnEntity);
                continue;
            }
            fieldValAndParentValMap.put(fieldVal, parentNodeValue);
        }
        for (Map.Entry entry : fieldValAndParentValMap.entrySet()) {
            RptDisplayColumnEntity parentRptDisplayColumnEntity = (RptDisplayColumnEntity)tmpFieldValAndRptMap.get(entry.getValue());
            RptDisplayColumnEntity rptDisplayColumnEntity = (RptDisplayColumnEntity)tmpFieldValAndRptMap.get(entry.getKey());
            if (parentRptDisplayColumnEntity == null || rptDisplayColumnEntity == null) continue;
            ArrayList<RptDisplayColumnEntity> children = parentRptDisplayColumnEntity.getChildren();
            if (children == null) {
                children = new ArrayList<RptDisplayColumnEntity>(10);
            }
            children.add(rptDisplayColumnEntity);
            parentRptDisplayColumnEntity.setChildren(children);
        }
        return treeList;
    }

    public List<RptDisplayColumnEntity> getDefaultColumns(Collection<String> fixedColumns, Map<String, String> fieldValAndNameMap) {
        ArrayList<RptDisplayColumnEntity> defaultColumns = new ArrayList<RptDisplayColumnEntity>(fixedColumns.size());
        for (String fixedColumn : fixedColumns) {
            RptDisplayColumnEntity rptDisplayColumnEntity = new RptDisplayColumnEntity();
            String fieldTreeNodeText = fieldValAndNameMap.get(fixedColumn);
            rptDisplayColumnEntity.setFieldTreeNodeText(fieldTreeNodeText);
            rptDisplayColumnEntity.setFieldValue(fixedColumn);
            rptDisplayColumnEntity.setIsDefault(true);
            defaultColumns.add(rptDisplayColumnEntity);
        }
        return defaultColumns;
    }

    @Override
    public void addSpecialColumn(DynamicObjectCollection entryEntities) {
        HashSet<String> entityDataSet = new HashSet<String>(16);
        for (DynamicObject entity : entryEntities) {
            entityDataSet.add(entity.getString("fieldvalue"));
        }
        List<RptDisplayColumnEntity> specialList = this.getAllDefaultColumns();
        if (CollectionUtils.isEmpty(specialList)) {
            return;
        }
        int entrySeq = 0;
        for (RptDisplayColumnEntity rowData : specialList) {
            if (entityDataSet.contains(rowData.getFieldValue())) continue;
            DynamicObject entry = entryEntities.addNew();
            entry.set("seq", (Object)entrySeq++);
            entry.set("displayname", (Object)rowData.getDisplayName());
            entry.set("fieldname", (Object)rowData.getFieldTreeNodeText());
            entry.set("fieldvalue", (Object)rowData.getFieldValue());
            this.setExtendFieldValue(entry, rowData);
        }
    }

    @Override
    public void setExtendFieldValue(DynamicObject entry, RptDisplayColumnEntity rowData) {
    }

    @Override
    public void setCustomView(Boolean isRightPageVisible, boolean isBottomBtnVisible) {
        this.setRightPageBy(isRightPageVisible);
        this.setBottomButton(isBottomBtnVisible);
    }

    private void setRightPageBy(Boolean isRightPageVisible) {
        if (isRightPageVisible == null) {
            this.formView.setVisible(Boolean.FALSE, new String[]{"save_icon", "save_lb", "cancel_icon", "cancel_lb", "edit_scheme_icon", "edit_scheme_lb", "view_versions_icon", "view_versions_lb", "edit_flex_panel_ap"});
            this.formView.setVisible(Boolean.TRUE, new String[]{"view_flex_panel_ap"});
            this.formView.setEnable(Boolean.FALSE, new String[]{"name", "description", "isdefaultscheme", "isshowinbaseview"});
            AbstractFormDataModel model = (AbstractFormDataModel)this.formView.getModel();
            model.beginInit();
            model.deleteEntryData("entryentityview");
            model.endInit();
            this.formView.updateView("entryentityview");
        } else {
            this.formView.setEnable(Boolean.valueOf(isRightPageVisible == false), new String[]{"view_flex_panel_ap"});
            this.formView.setVisible(Boolean.valueOf(isRightPageVisible == false), new String[]{"edit_scheme_icon", "edit_scheme_lb", "view_versions_icon", "view_versions_lb", "view_flex_panel_ap"});
            this.formView.setEnable(Boolean.FALSE, new String[]{"fieldnameview", "displaynameview", "isdefaultview", "isshowinbaseview"});
            this.formView.setEnable(isRightPageVisible, new String[]{"edit_flex_panel_ap"});
            this.formView.setEnable(isRightPageVisible, new String[]{"name", "description", "isdefaultscheme", "isshowinbase"});
            this.formView.setVisible(isRightPageVisible, new String[]{"save_icon", "save_lb", "cancel_icon", "cancel_lb", "edit_flex_panel_ap"});
        }
    }

    private void setBottomButton(Boolean isVisible) {
        if (!isVisible.booleanValue()) {
            this.formView.setVisible(Boolean.FALSE, new String[]{"btn_save", "btn_cancel", "edit_scheme_icon", "edit_scheme_lb", "btn_add_scm", "btn_delete_scm"});
            this.formView.setEnable(Boolean.FALSE, new String[]{"btn_save", "btn_cancel", "edit_scheme_icon", "edit_scheme_lb", "btn_add_scm", "btn_delete_scm"});
            this.formView.setVisible(Boolean.TRUE, new String[]{"view_versions_icon", "view_versions_lb"});
            this.formView.setEnable(Boolean.TRUE, new String[]{"view_versions_icon", "view_versions_lb"});
        }
        this.formView.setVisible(isVisible, new String[]{"btn_save", "btn_cancel"});
        this.formView.setEnable(isVisible, new String[]{"btn_save", "btn_cancel"});
        this.formView.setVisible(Boolean.valueOf(isVisible == false), new String[]{"btn_close"});
        this.formView.setEnable(Boolean.valueOf(isVisible == false), new String[]{"btn_close"});
    }
}

