/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.declare.scheme.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.hcsi.business.caladjust.errinfo.HCSIErrInfoEnum;
import kd.sit.hcsi.business.scheme.constants.RptDisplayConstants;
import kd.sit.hcsi.business.scheme.dto.RptDisplayColumnEntity;
import kd.sit.hcsi.business.scheme.helper.AbsDisplayScmHelper;
import kd.sit.hcsi.business.scheme.helper.DclScmHelper;
import kd.sit.sitbp.business.datachanged.BizChangedHelper;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.util.BaseResult;

public abstract class AbsDisplaySchemePlugin
extends HRDataBaseEdit
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener,
RptDisplayConstants {
    protected static final String SITBP_DCLDISPLAYSCMF7 = "sitbp_dcldisplayscmf7";
    protected static final String CACHE_IS_ADDNEW = "CACHE_IS_ADDNEW";
    private static final Set<String> DEFAULT_SELECTED_NODES = new HashSet<String>(16);

    public void registerListener(EventObject event) {
        super.registerListener(event);
        TreeView scmTreeView = (TreeView)this.getView().getControl("schm_tree_view");
        scmTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btn_add_scm", "btn_delete_scm"});
    }

    public void preOpenForm(PreOpenFormEventArgs event) {
        FormShowParameter showParameter = event.getFormShowParameter();
        showParameter.setCaption(showParameter.getFormConfig().getCaption().getLocaleValue());
        showParameter.setCustomParam("disable_control_title", (Object)Boolean.TRUE.toString());
        showParameter.setCustomParam("ue_param", (Object)Boolean.TRUE.toString());
    }

    public void afterCreateNewData(EventObject event) {
        if (this.isAddNew() || this.isOpenHistoryDetailView()) {
            return;
        }
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object pkId = showParameter.getPkId();
        this.getSpecificNodeAndCacheIt("" + pkId);
    }

    public void beforeBindData(EventObject event) {
        if (!this.isOpenHistoryDetailView()) {
            this.buildScmTree();
        }
        this.getView().setFormTitle(this.getModel().getDataEntityType().getDisplayName());
    }

    public void afterBindData(EventObject event) {
        if (this.isOpenHistoryDetailView()) {
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.left, true);
        }
        this.getView().setFormTitle(this.getModel().getDataEntityType().getDisplayName());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        String currNodeId = null;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "donothing_delete_scm": {
                this.deleteDisplayScheme(args);
                break;
            }
            case "new": {
                if (formOperate.getOption().tryGetVariableValue("btn_delete_scm", new RefObject())) {
                    this.getModel().setDataChanged(false);
                    return;
                }
                if (formOperate.getOption().tryGetVariableValue("btn_add_scm", new RefObject()) || this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_ADD", null)) break;
                this.addNewNode();
                break;
            }
            case "donothing_make_sure": {
                currNodeId = this.getCurrNodeId();
                if (this.isNodeEditing(currNodeId)) {
                    this.getView().showTipNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_HAD_NOT_BEEN_SAVED.getErrInfo());
                    args.setCancel(true);
                    break;
                }
                if (!HRStringUtils.isNotEmpty((String)currNodeId) || this.checkCurrNodeExists(currNodeId)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess()) {
            String currNodeId = null;
            switch (args.getOperateKey()) {
                case "donothing_delete_scm": {
                    currNodeId = this.getCurrNodeId();
                    if (HRStringUtils.isEmpty((String)currNodeId)) {
                        return;
                    }
                    if (this.checkCurrNodeInvalid(currNodeId)) {
                        return;
                    }
                    AbsDisplayScmHelper.deleteRptDisplaySchemeById((String)this.getCurrentRptDisplayFormId(), (Long)Long.valueOf(currNodeId));
                    this.getView().showSuccessNotification(HCSIErrInfoEnum.COMMON_DELETE_SUCCESSFULLY.getErrInfo());
                    this.reBuildScmTrees(currNodeId);
                    break;
                }
                case "donothing_add_scm": {
                    if (!HRStringUtils.isEmpty((String)this.getPageCache().get("CACHE_SELECTED_NODE")) && this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_ADD", null)) break;
                    this.addNewNode();
                    break;
                }
                case "save": {
                    this.updateViewAfterSaveData();
                    break;
                }
                case "donothing_make_sure": {
                    currNodeId = this.getCurrNodeId();
                    if (HRStringUtils.isNotEmpty((String)currNodeId)) {
                        HashMap<String, String> returnData = new HashMap<String, String>(1);
                        returnData.put("displaySchmId", currNodeId);
                        this.getView().returnDataToParent(returnData);
                    }
                    this.releaseLock(null);
                    break;
                }
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String lastNodeId;
        if (this.isOpenHistoryDetailView()) {
            evt.setCancel(true);
            return;
        }
        String nodeId = (String)evt.getNodeId();
        if (HRStringUtils.equals((String)nodeId, (String)(lastNodeId = this.getCurrNodeId())) && this.isNodeEditing(lastNodeId)) {
            evt.setCancel(true);
            return;
        }
        TreeView treeView = (TreeView)evt.getSource();
        if (HRStringUtils.equals((String)treeView.getKey(), (String)"schm_tree_view") && !this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_TREE", nodeId)) {
            this.switchNode(nodeId);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        evt.setCancel(true);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }

    protected void addNewNode() {
        this.releaseLock(null);
        long pkId = DB.genLongId((String)this.getCurrentRptDisplayFormId());
        TreeNode focusNode = new TreeNode("", String.valueOf(pkId), HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_DEFAULT_NEW_NAME.getErrInfo());
        this.getPageCache().put(CACHE_IS_ADDNEW, Boolean.TRUE.toString());
        this.getModel().setDataChanged(false);
        this.getPageCache().put("CACHE_SELECTED_NODE", SerializationUtils.serializeToBase64((Object)focusNode));
        OperateOption option = OperateOption.create();
        option.setVariableValue("btn_add_scm", Boolean.TRUE.toString());
        this.getModel().setDataChanged(false);
        this.getView().invokeOperation("new", option);
        this.markNodeIsEditing(focusNode.getId());
        this.getModel().setDataChanged(false);
    }

    protected abstract List<RptDisplayColumnEntity> getLeftTreeDataList();

    protected Map<String, Object> getExtendFieldValue(RptDisplayColumnEntity rowData) {
        return null;
    }

    protected boolean beforeRemoveColumns() {
        return true;
    }

    protected boolean beforeAddColumns(List<RptDisplayColumnEntity> entities) {
        return true;
    }

    protected boolean beforeDoSaveOperation() {
        return true;
    }

    protected void afterDeleteDisplaySchema(String schemaId) {
    }

    protected void buildScmTree() {
        this.buildScmTree(null);
    }

    private void buildScmTree(TreeNode focusNode) {
        boolean notExistsNode;
        focusNode = focusNode == null ? this.getFocusNode() : focusNode;
        Object[] displayScmsInDb = AbsDisplayScmHelper.queryPersonalScheme((String)this.getCurrentRptDisplayFormId());
        boolean bl = notExistsNode = ArrayUtils.isEmpty((Object[])displayScmsInDb) && focusNode == null && (focusNode = this.getFocusNode()) == null;
        if (notExistsNode) {
            this.openCustomView(null, true);
            TreeView scmTreeView = (TreeView)this.getView().getControl("schm_tree_view");
            scmTreeView.deleteAllNodes();
            this.getView().updateView("schm_tree_view");
            this.delCurrPageData();
            this.selectNeededNodesInFieldTree();
            return;
        }
        Boolean isRightPageVisible = Boolean.TRUE;
        boolean isBottomBtnVisible = true;
        boolean isCurrNodeIdNotInDb = true;
        ArrayList<TreeNode> scmNodes = new ArrayList<TreeNode>(displayScmsInDb.length);
        if (ArrayUtils.isEmpty((Object[])displayScmsInDb) && focusNode != null) {
            scmNodes.add(focusNode);
            this.getModel().setValue("name", (Object)focusNode.getText());
        } else if (!ArrayUtils.isEmpty((Object[])displayScmsInDb)) {
            Map idAndNameMap = Arrays.stream(displayScmsInDb).collect(Collectors.toMap(scm -> scm.getString("id"), scm -> scm.getString("name"), (oldVal, newVal) -> newVal, LinkedHashMap::new));
            boolean bl2 = isCurrNodeIdNotInDb = focusNode != null && focusNode.getId() != null && !idAndNameMap.containsKey(focusNode.getId());
            if (isCurrNodeIdNotInDb) {
                scmNodes.add(focusNode);
                this.getModel().setValue("name", (Object)focusNode.getText());
            }
            isRightPageVisible = isCurrNodeIdNotInDb;
            if (!isCurrNodeIdNotInDb) {
                focusNode = this.getFocusNodeAndCache(idAndNameMap, focusNode);
            }
            for (Object schm : displayScmsInDb) {
                String id = schm.getString("id");
                String name = schm.getString("name");
                TreeNode rootNode = new TreeNode("", id, name);
                scmNodes.add(rootNode);
            }
        }
        TreeView scmTreeView = (TreeView)this.getView().getControl("schm_tree_view");
        scmTreeView.deleteAllNodes();
        scmTreeView.addNodes(scmNodes);
        if (focusNode != null) {
            scmTreeView.focusNode(focusNode);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        isRightPageVisible = isRightPageVisible != false && !OperationStatus.VIEW.equals((Object)status);
        isBottomBtnVisible = isBottomBtnVisible && !OperationStatus.VIEW.equals((Object)status);
        this.openCustomView(isRightPageVisible, isBottomBtnVisible);
        this.getView().updateView("schm_tree_view");
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (focusNode != null && this.isPkIdChanged(isCurrNodeIdNotInDb, focusNode, showParameter.getPkId())) {
            this.refreshDisplayScm(focusNode.getId());
        }
    }

    protected boolean isPkIdChanged(boolean isCurrNodeIdNotInDb, TreeNode focusNode, Object pkId) {
        return !isCurrNodeIdNotInDb && focusNode != null && focusNode.getId() != null && !focusNode.getId().equals(String.valueOf(pkId));
    }

    protected TreeNode getFocusNodeAndCache(Map<String, String> idAndNameMap, TreeNode focusNode) {
        if (CollectionUtils.isEmpty(idAndNameMap)) {
            return null;
        }
        if (focusNode == null) {
            focusNode = new TreeNode("", "", "");
        }
        String focusNodeId = this.getFocusNodeId(idAndNameMap, focusNode.getId(), idAndNameMap.keySet().iterator().next());
        String focusNodeName = idAndNameMap.get(focusNodeId);
        if (!StringUtils.equals((CharSequence)focusNode.getId(), (CharSequence)focusNodeId) || !StringUtils.equals((CharSequence)focusNode.getText(), (CharSequence)focusNodeName)) {
            focusNode = new TreeNode("", focusNodeId, focusNodeName);
            this.cacheCurrNode(focusNode);
        }
        return focusNode;
    }

    protected TreeNode getFocusNode() {
        TreeNode focusNode = null;
        String currSelectedNode = this.getPageCache().get("CACHE_SELECTED_NODE");
        if (!HRStringUtils.isEmpty((String)currSelectedNode)) {
            focusNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)currSelectedNode);
        }
        return focusNode;
    }

    protected String getCurrNodeId() {
        TreeNode focusNode = this.getFocusNode();
        if (focusNode != null) {
            return focusNode.getId();
        }
        return null;
    }

    private String getFocusNodeId(Map<String, String> idAndNameMap, String currSelectNodeId, String defaultSchmId) {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String requestId = (String)formShowParameter.getCustomParam("id");
        String focusNodeId = null;
        focusNodeId = idAndNameMap.containsKey(currSelectNodeId) ? currSelectNodeId : (idAndNameMap.containsKey(requestId) ? requestId : defaultSchmId);
        return focusNodeId;
    }

    protected void openCustomView(Boolean isRightPageVisible, boolean isBottomBtnVisible) {
    }

    protected void buildFieldTree() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.buildBillTreeNodes(treeView);
        this.getView().updateView("treeviewap");
        this.getModel().setDataChanged(false);
    }

    private void buildBillTreeNodes(TreeView treeView) {
        List<RptDisplayColumnEntity> treeData = this.getLeftTreeDataList();
        if (!this.validTreeDataList(treeData)) {
            throw new IllegalArgumentException("AbsDisplaySchemePlugin.buildBillTreeNodes, data build error,treeData = " + treeData);
        }
        List<TreeNode> rootNodes = this.convertToTreeNode(treeData, null);
        SITPageCache pageCache = new SITPageCache(this.getView());
        Map<String, TreeNode> treeNodeMap = this.getTreeNodeMap(rootNodes);
        pageCache.put("CACHE_TREE_DATA", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        pageCache.put("CACHE_ROOT_NODE", (Object)SerializationUtils.serializeToBase64(rootNodes));
        treeView.addNodes(rootNodes);
    }

    private boolean validTreeDataList(List<RptDisplayColumnEntity> treeData) {
        HashSet<String> validSet = new HashSet<String>();
        return this.doCheckTreeDataList(treeData, validSet);
    }

    private boolean doCheckTreeDataList(List<RptDisplayColumnEntity> treeData, Set<String> validSet) {
        if (CollectionUtils.isEmpty(treeData)) {
            return true;
        }
        for (RptDisplayColumnEntity data : treeData) {
            if (!validSet.add(data.getFieldValue())) {
                return false;
            }
            if (this.doCheckTreeDataList(data.getChildren(), validSet)) continue;
            return false;
        }
        return true;
    }

    private List<TreeNode> convertToTreeNode(List<RptDisplayColumnEntity> treeData, String parentId) {
        if (CollectionUtils.isEmpty(treeData)) {
            return null;
        }
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (RptDisplayColumnEntity entity : treeData) {
            TreeNode treeNode = new TreeNode();
            treeNode.setData((Object)entity);
            treeNode.setId(entity.getFieldValue());
            treeNode.setText(entity.getFieldTreeNodeText());
            treeNode.setLeaf(!entity.hasChild());
            treeNode.setChildren(this.convertToTreeNode(entity.getChildren(), entity.getFieldValue()));
            if (!HRStringUtils.isEmpty((String)parentId)) {
                treeNode.setParentid(parentId);
            }
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private Map<String, TreeNode> getTreeNodeMap(List<TreeNode> rootNodes) {
        HashMap<String, TreeNode> result = new HashMap<String, TreeNode>(16);
        if (CollectionUtils.isEmpty(rootNodes)) {
            return result;
        }
        for (TreeNode treeNode : rootNodes) {
            result.put(treeNode.getId(), treeNode);
            List children = treeNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            result.putAll(this.getTreeNodeMap(treeNode.getChildren()));
        }
        return result;
    }

    protected void refreshDisplayScm(Object scmId) {
        BaseView view = (BaseView)this.getView();
        BaseShowParameter showParameter = (BaseShowParameter)view.getFormShowParameter();
        showParameter.setPkId(scmId);
        BillOperationStatus billOperationStatus = showParameter.getStatus() == OperationStatus.VIEW ? BillOperationStatus.VIEW : BillOperationStatus.EDIT;
        showParameter.setBillStatus(billOperationStatus);
        showParameter.setCustomParam("disable_control_title", (Object)Boolean.TRUE.toString());
        showParameter.setCustomParam("ue_param", (Object)Boolean.TRUE.toString());
        view.cacheFormShowParameter();
        view.load(scmId);
        this.clearSearchKey();
        this.getModel().setDataChanged(false);
    }

    protected void clearSearchKey() {
    }

    private void deleteDisplayScheme(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOption().tryGetVariableValue("CALLBACK_DELETE", new RefObject((Object)Boolean.TRUE.toString()))) {
            return;
        }
        args.setCancel(true);
        if (!this.checkSelectedScm()) {
            return;
        }
        this.getView().showConfirm(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_DELETEE_SCM.getErrInfo(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CALLBACK_DELETE"));
    }

    private boolean checkSelectedScm() {
        String currNodeId = ((TreeView)this.getView().getControl("schm_tree_view")).getTreeState().getFocusNodeId();
        if (currNodeId == null) {
            this.getView().showTipNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_SELECT_OR_ADD_FIRST.getErrInfo());
            return false;
        }
        return true;
    }

    protected boolean doValidBeforeSave(FormOperate formOperate, long currNodeId) {
        return this.beforeDoSaveOperation() && this.confirmResetDefaultScheme(formOperate, currNodeId);
    }

    private boolean confirmResetDefaultScheme(FormOperate formOperate, long currNodeId) {
        DynamicObject defaultSchemeObj;
        boolean confirm = formOperate.getOption().tryGetVariableValue("CALLBACK_RESET_DEFAULT_SCHEME", new RefObject());
        boolean currScmIsDefaultScm = this.getModel().getDataEntity(true).getBoolean("isdefaultscheme");
        if (currScmIsDefaultScm && !confirm && !HRObjectUtils.isEmpty((Object)(defaultSchemeObj = AbsDisplayScmHelper.querySchemeByFilter((String)this.getCurrentRptDisplayFormId(), (QFilter)AbsDisplayScmHelper.getDefaultScmWithoutCurrScmId((Object)currNodeId))))) {
            this.getView().showConfirm(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_MAKE_SURE_DELETE_LAST.getErrInfo(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CALLBACK_RESET_DEFAULT_SCHEME"));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            OperateOption operateOption = OperateOption.create();
            switch (callBackId) {
                case "CALLBACK_RESET_DEFAULT_SCHEME": {
                    operateOption.setVariableValue("CALLBACK_RESET_DEFAULT_SCHEME", Boolean.TRUE.toString());
                    this.getView().invokeOperation("save", operateOption);
                    break;
                }
                case "CALLBACK_DELETE": {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("CALLBACK_DELETE", Boolean.TRUE.toString());
                    this.getView().invokeOperation("donothing_delete_scm", option);
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_TREE": {
                    String customValue = evt.getCustomVaule();
                    if (!HRStringUtils.isNotEmpty((String)customValue)) break;
                    this.switchNode(customValue);
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_CLOSE": {
                    this.checkNewDisplaySchm();
                    this.getView().getModel().setDataChanged(false);
                    operateOption.setVariableValue("btn_close", Boolean.TRUE.toString());
                    this.getPageCache().remove(CACHE_IS_ADDNEW);
                    this.getView().invokeOperation("close", operateOption);
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_ADD": {
                    this.addNewNode();
                    break;
                }
            }
        } else {
            switch (callBackId) {
                case "CALLBACK_CHECK_DATA_CHANGE_TREE": 
                case "CALLBACK_CHECK_DATA_CHANGE_CLOSE": {
                    TreeNode focusNode = this.getFocusNode();
                    if (focusNode == null) break;
                    TreeView treeView = (TreeView)this.getView().getControl("schm_tree_view");
                    treeView.focusNode(focusNode);
                    break;
                }
            }
        }
    }

    protected boolean checkSchemeEditing(String currNodeId) {
        if (HRStringUtils.isEmpty((String)currNodeId)) {
            return false;
        }
        this.markNodeIsEditing(currNodeId);
        BaseResult require = MutexServiceHelper.require((String)this.getCurrentRptDisplayFormId(), (String)currNodeId, (String)"donothing_edit_scheme_for_lock");
        if (!require.isSuccess()) {
            Long userId = Long.parseLong(((MutexLockInfo)require.getData()).getUserId());
            String userName = new HRBaseServiceHelper("bos_user").loadSingle((Object)userId).getString("name");
            this.getView().showTipNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_EDITING.getErrInfo(new Object[]{userName}));
            return true;
        }
        return false;
    }

    protected void releaseLock(String nodeId) {
        String currNodeId;
        String string = currNodeId = nodeId != null ? nodeId : this.getCurrNodeId();
        if (this.isNodeEditing(currNodeId)) {
            MutexServiceHelper.release((String)this.getCurrentRptDisplayFormId(), (String)currNodeId, (String)"donothing_edit_scheme_for_lock");
            this.releaseCurrEditNode(currNodeId);
        }
    }

    protected void markNodeIsEditing(String currNodeId) {
        if (HRStringUtils.isNotEmpty((String)currNodeId)) {
            this.getPageCache().put("edit_scheme_lb" + currNodeId, Boolean.TRUE.toString());
        }
    }

    protected boolean isNodeEditing(String currNodeId) {
        return HRStringUtils.isNotEmpty((String)currNodeId) && Boolean.TRUE.toString().equals(this.getPageCache().get("edit_scheme_lb" + currNodeId));
    }

    protected void releaseCurrEditNode(String currNodeId) {
        this.getPageCache().remove("edit_scheme_lb" + currNodeId);
    }

    private void checkNewDisplaySchm() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        long pkId = 0L;
        if (showParameter.getPkId() != null) {
            pkId = Long.parseLong(String.valueOf(showParameter.getPkId()));
        }
        if (pkId == 0L) {
            return;
        }
        String isAddNew = this.getPageCache().get(CACHE_IS_ADDNEW);
        if (Boolean.TRUE.toString().equals(isAddNew)) {
            DclScmHelper.deleteRptDisplaySchemeById((String)this.getCurrentRptDisplayFormId(), (Long)pkId);
            this.getPageCache().remove(CACHE_IS_ADDNEW);
        }
    }

    protected boolean checkDataChange(String callBackId, String customValue) {
        String dataChangeContinue;
        this.clearNeededBizChanged();
        boolean isChange = this.getModel().getDataChanged();
        String isAddNew = this.getPageCache().get(CACHE_IS_ADDNEW);
        if (String.valueOf(Boolean.TRUE).equals(isAddNew)) {
            isChange = true;
        }
        if ((dataChangeContinue = (String)this.getView().getFormShowParameter().getCustomParam("dataChangeContinue")) != null) {
            isChange = false;
        }
        String changeDesc = this.getModel().getChangeDesc();
        boolean bl = isChange = isChange && StringUtils.isNotEmpty((CharSequence)changeDesc);
        if (isChange && StringUtils.isNotEmpty((CharSequence)changeDesc)) {
            BizChangedHelper.showConfirm((AbstractFormPlugin)this, (String)changeDesc, (String)callBackId, (String)customValue);
        }
        return isChange;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_CLOSE", Boolean.TRUE.toString())) {
            event.setCancel(true);
        }
    }

    public void pageRelease(EventObject event) {
        this.releaseLock(null);
    }

    protected void selectNeededNodesInFieldTree() {
    }

    protected String getCurrentRptDisplayFormId() {
        return this.getModel().getDataEntity(true).getDataEntityType().getName();
    }

    protected void delCurrPageData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set("name", null);
        dataEntity.set("description", null);
        dataEntity.set("isdefaultscheme", (Object)Boolean.FALSE);
        dataEntity.set("isshowinbase", (Object)Boolean.FALSE);
        dataEntity.set("isshowinbaseview", (Object)Boolean.FALSE);
        this.getView().updateView("schm_tree_view");
        this.getView().updateView("name");
        this.getView().updateView("description");
        this.getView().updateView("isdefaultscheme");
        this.getView().updateView("isshowinbase");
        this.getView().updateView("isshowinbaseview");
    }

    protected void switchNode(String nodeId) {
        this.releaseLock(null);
        TreeNode focusNode = this.getSpecificNodeAndCacheIt(nodeId);
        if (focusNode == null) {
            this.getView().showTipNotification(HCSIErrInfoEnum.DECLARE_DISPLAY_SCM_DISPLAY_HAVE_BEEN_DELETE.getErrInfo());
            this.getPageCache().remove("CACHE_SELECTED_NODE");
            this.reBuildScmTrees(nodeId);
            return;
        }
        this.buildScmTree(focusNode);
        this.getModel().setDataChanged(false);
        this.getPageCache().remove(CACHE_IS_ADDNEW);
    }

    protected void cacheCurrNode(TreeNode focusNode) {
        this.getPageCache().put("CACHE_SELECTED_NODE", SerializationUtils.serializeToBase64((Object)focusNode));
    }

    protected void clearNeededBizChanged() {
        IDataModel dataModel = this.getModel();
        List<String> allNeedShowFieldBorderList = this.getAllNeedShowFieldBorderList();
        DynamicObjectCollection entryEntity = dataModel.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            BizChangedHelper.operateBizChangedSet((DynamicObject)dynamicObject, allNeedShowFieldBorderList, (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.RETAIN);
        }
    }

    protected List<String> getAllNeedShowFieldBorderList() {
        return new ArrayList<String>(0);
    }

    protected TreeNode getSpecificNodeAndCacheIt(String nodeId) {
        DynamicObject scmDy = this.getScmOf(nodeId);
        TreeNode focusNode = null;
        if (!HRObjectUtils.isEmpty((Object)scmDy)) {
            focusNode = new TreeNode("", nodeId, scmDy.getString("name"));
            this.cacheCurrNode(focusNode);
        }
        return focusNode;
    }

    protected Set<String> getDefaultSelectedNodes() {
        return DEFAULT_SELECTED_NODES;
    }

    protected boolean checkCurrNodeInvalid(String currNodeId) {
        return false;
    }

    protected boolean isOpenHistoryDetailView() {
        IFormView parentView = this.getView().getParentView();
        return parentView instanceof IListView && SITBP_DCLDISPLAYSCMF7.equals(parentView.getEntityId());
    }

    protected void updateViewAfterSaveData() {
        Long boid = (Long)this.getModel().getValue("boid");
        Boolean isDefaultScheme = (Boolean)this.getModel().getValue("isdefaultscheme");
        if (Boolean.TRUE.equals(isDefaultScheme)) {
            AbsDisplayScmHelper.cancelOtherDefaultScheme((String)this.getCurrentRptDisplayFormId(), (Long)boid);
        } else {
            AbsDisplayScmHelper.cancelOtherDefaultScheme((String)this.getCurrentRptDisplayFormId(), (QFilter)new QFilter("boid", "=", (Object)boid));
        }
        this.releaseLock(null);
        if (this.isAddNew()) {
            this.getPageCache().remove("CACHE_SELECTED_NODE");
            this.getPageCache().remove(CACHE_IS_ADDNEW);
        }
        this.buildScmTree();
        this.hideFieldTipForName();
        this.getModel().setDataChanged(false);
    }

    protected boolean isAddNew() {
        return Boolean.TRUE.toString().equals(this.getPageCache().get(CACHE_IS_ADDNEW));
    }

    protected DynamicObject getScmOf(String nodeId) {
        return AbsDisplayScmHelper.queryDisplayScheme((String)this.getCurrentRptDisplayFormId(), (Long)Long.parseLong(nodeId), (boolean)this.isOpenHistoryDetailView());
    }

    protected void reBuildScmTrees(String currNodeId) {
        OperateOption operateOption = OperateOption.create();
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        showParameter.setPkId(null);
        this.getView().cacheFormShowParameter();
        this.getPageCache().remove("CACHE_SELECTED_NODE");
        this.afterDeleteDisplaySchema(currNodeId);
        if (!AbsDisplayScmHelper.isDisplayScmInDb((String)this.getCurrentRptDisplayFormId(), (Long)Long.parseLong(currNodeId))) {
            this.getPageCache().remove(CACHE_IS_ADDNEW);
            operateOption.setVariableValue("btn_delete_scm", Boolean.TRUE.toString());
            this.getView().invokeOperation("new", operateOption);
        } else {
            this.delCurrPageData();
            this.buildScmTree();
        }
        this.releaseLock(currNodeId);
    }

    protected boolean checkCurrNodeExists(String currNodeId) {
        return true;
    }

    protected void hideFieldTipForName() {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(true);
        fieldTip.setFieldKey("name");
        this.getView().showFieldTip(fieldTip);
    }
}

