/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.history.model.SITHisBaseConstants;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileBasePlugin
extends AbstractFormPlugin
implements SinsurFileConstants {
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_UNSUBMIT = "bar_unsubmit";
    private static final String BTN_VALIDATE = "validatemap";
    private static final String OP_SUBMIT = "donothing_submit";
    private static final String OP_UNSUBMIT = "donothing_unsubmit";
    private static final String OP_AUDIT = "donothing_validate";
    private static final String BTN_REFRESH = "donothing_refresh";
    private static final String OP_CLOSE = "donothing_close";
    private static final String[] ALL_EDIT_PAGES = new String[]{"hcsi_sinsurfile", "hcsi_sinsurperson", "hcsi_sinsurfilestd"};
    private static final Log log = LogFactory.getLog(SinsurFileBasePlugin.class);

    public void beforeBindData(EventObject args) {
        Long fileId = (Long)this.getView().getFormShowParameter().getCustomParam("sinsur_file_id");
        HRBaseServiceHelper salaryFileOrm = new HRBaseServiceHelper("hcsi_sinsurfile");
        DynamicObject fileDy = salaryFileOrm.queryOne((Object)fileId);
        String status = fileDy.getString("status");
        this.getView().getFormShowParameter().setCustomParam("status", (Object)status);
        this.getView().cacheFormShowParameter();
        this.setFieldVisibleBaseOnStatus(status);
        this.checkPrimayEmpposorgrel(fileDy);
    }

    private void checkPrimayEmpposorgrel(DynamicObject fileDy) {
        long employeeId = fileDy.getLong("employee.id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_empposorgrel");
        QFilter qFilter = new QFilter("employee.id", "=", (Object)employeeId);
        qFilter.and("isprimary", "=", (Object)"1");
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("datastatus", "in", (Object)SITHisBaseConstants.getValidStatus());
        DynamicObjectCollection empposorgrelColl = helper.queryOriginalCollection("employee.id,businessstatus,islatestrecord", qFilter.toArray());
        for (DynamicObject empposorgrel : empposorgrelColl) {
            String businessstatus = empposorgrel.getString("businessstatus");
            boolean islatestrecord = empposorgrel.getBoolean("islatestrecord");
            if (!SITStringUtils.equals((String)businessstatus, (String)"1") && (!islatestrecord || !SITStringUtils.equals((String)businessstatus, (String)"2"))) continue;
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6863\u6848\u5bf9\u5e94\u4eba\u5458\u65e0\u4e3b\u4efb\u804c\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SinsurFileBasePlugin_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
    }

    private void setFieldVisibleBaseOnStatus(String status) {
        switch (status) {
            case "A": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VALIDATE});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_VALIDATE});
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VALIDATE});
                break;
            }
            case "E": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VALIDATE});
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (!OP_SUBMIT.equals(operateKey)) {
            return;
        }
        Map<String, IFormView> childFormView = this.getChildFormView();
        List<String> unSavedPage = this.unSavedPage(childFormView);
        if (!CollectionUtils.isEmpty(unSavedPage)) {
            if ("1".equals(this.getView().getPageCache().get("confirm_continue_result"))) {
                this.getView().getPageCache().remove("confirm_continue_result");
            } else {
                args.setCancel(true);
                StringBuilder query = new StringBuilder();
                String split = ResManager.loadKDString((String)"\u3001", (String)"SinsurFileBasePlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                for (String page : unSavedPage) {
                    query.append(LocaleString.fromMap((Map)((Map)childFormView.get(page).getFormShowParameter().getCustomParam("pageName")))).append(split);
                }
                query.delete(query.length() - split.length(), query.length());
                if (OP_AUDIT.equals(operateKey) || OP_SUBMIT.equals(operateKey) || OP_UNSUBMIT.equals(operateKey)) {
                    this.getView().showTipNotification(this.getTipNotification(operateKey, query));
                } else {
                    String operateStr = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadEntityOperationMeta("hcsi_filebase", operateKey);
                    Map operateStrMap = (Map)SerializationUtils.fromJsonString((String)operateStr, Map.class);
                    Map operateNameMap = (Map)operateStrMap.get("name");
                    String opName = LocaleString.fromMap((Map)operateNameMap).toString();
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SinsurFileBasePlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5{0}", (String)"SinsurFileBasePlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[]{opName}));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ee5\u4e0b\u9875\u9762\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5{0}\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SinsurFileBasePlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[]{opName});
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm_continue:" + operateKey, (IFormPlugin)this);
                    msg = msg.replace("\\\\r\\\\n", "\r\n");
                    this.getView().showConfirm(msg, query.toString(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.startsWith("confirm_continue:")) {
            String operateKey = callBackId.substring("confirm_continue:".length());
            this.getView().getPageCache().put("confirm_continue_result", "1");
            this.getView().invokeOperation(operateKey);
        }
    }

    private String getTipNotification(String operateKey, StringBuilder query) {
        String msg = null;
        switch (operateKey) {
            case "donothing_validate": {
                msg = ResManager.loadKDString((String)"{0}\u9875\u9762\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"SinsurFileBasePlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[]{query});
                break;
            }
            case "donothing_submit": {
                msg = ResManager.loadKDString((String)"{0}\u9875\u9762\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"SinsurFileBasePlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[]{query});
                break;
            }
            case "donothing_unsubmit": {
                msg = ResManager.loadKDString((String)"{0}\u9875\u9762\u6ca1\u6709\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\u3002", (String)"SinsurFileBasePlugin_7", (String)"sit-hcsi-formplugin", (Object[])new Object[]{query});
                break;
            }
        }
        return msg;
    }

    private List<String> unSavedPage(Map<String, IFormView> childViewMap) {
        ArrayList<String> unsavedPages = new ArrayList<String>(10);
        childViewMap.forEach((pageNumber, view) -> {
            OperationStatus viewStatus = view.getFormShowParameter().getStatus();
            if (viewStatus != OperationStatus.VIEW) {
                unsavedPages.add((String)pageNumber);
            }
        });
        return unsavedPages;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        Map<String, IFormView> childViewMap = this.getChildFormView();
        switch (opKey) {
            case "donothing_submit": {
                this.invokeSalaryFileOp(childViewMap, "submit");
                break;
            }
            case "donothing_unsubmit": {
                this.invokeSalaryFileOp(childViewMap, "unsubmit");
                break;
            }
            case "donothing_validate": {
                this.invokeSalaryFileOp(childViewMap, "audit");
                break;
            }
            case "donothing_refresh": {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                long fileId = (Long)showParameter.getCustomParam("sinsur_file_id");
                HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
                QFilter qFilter = new QFilter("id", "=", (Object)fileId);
                DynamicObject fileDyObj = fileHelper.loadDynamicObject(qFilter);
                Map relateFileIds = SinsurFileServiceHelper.queryAllFileRelatedPkId((DynamicObject)fileDyObj);
                showParameter.setCustomParam("relateFileIds", (Object)relateFileIds);
                this.getView().cacheFormShowParameter();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_close": {
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private boolean commonCheck(Map<String, IFormView> childViewMap, String operateKey) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSalaryFileOp(Map<String, IFormView> childViewMap, String opName) {
        IFormView salaryFileView = childViewMap.get("hcsi_sinsurfile");
        if (null == salaryFileView) {
            return;
        }
        boolean isValidateSucess = true;
        try {
            OperationResult operationResult;
            Throwable throwable;
            TXHandle txHandle;
            block24: {
                block25: {
                    block26: {
                        txHandle = TX.required();
                        throwable = null;
                        operationResult = salaryFileView.invokeOperation(opName);
                        if (operationResult.isSuccess()) break block24;
                        isValidateSucess = false;
                        txHandle.markRollback();
                        this.getView().showOperationResult(operationResult);
                        if (txHandle == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block25;
                    }
                    txHandle.close();
                }
                return;
            }
            try {
                try {
                    if (operationResult.isShowMessage() && operationResult.getMessage() != null) {
                        this.getView().showOperationResult(operationResult);
                    }
                }
                catch (Exception e) {
                    log.info("failure of submit file -> error message : ", (Object)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"SinsurFileBasePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    isValidateSucess = false;
                    txHandle.markRollback();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (txHandle != null) {
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
        finally {
            if (isValidateSucess) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private Map<String, IFormView> getChildFormView() {
        SITPageCache pageCache = new SITPageCache(this.getView());
        Map pageIdMap = (Map)pageCache.get("pageids", Map.class);
        HashMap<String, IFormView> childViewMap = new HashMap<String, IFormView>();
        for (String pageNumber : ALL_EDIT_PAGES) {
            IFormView baseView = this.getView().getView((String)pageIdMap.get(pageNumber));
            if (baseView == null) continue;
            childViewMap.put(pageNumber, baseView);
        }
        return childViewMap;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

