/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.sit.hcsi.business.file.ImportDataConvert2DyObjHelper;
import kd.sit.hcsi.business.file.ImportRowEntity;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.SitDateUtil;
import org.apache.commons.lang3.StringUtils;

public class SinsurFileBatchImportPlugin
extends HisBatchImportPlugin
implements SinsurFileConstants {
    private static final Log LOG = LogFactory.getLog(SinsurFileBatchImportPlugin.class);
    private final HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
    private final HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
    private final List<DynamicObject> personWaitSave = new ArrayList<DynamicObject>(10);
    private final List<DynamicObject> personWaitModify = new ArrayList<DynamicObject>(10);
    private final List<DynamicObject> personWaitAudit = new ArrayList<DynamicObject>(10);
    private final List<DynamicObject> fileWaitSave = new ArrayList<DynamicObject>(10);
    private final List<DynamicObject> fileWaitModify = new ArrayList<DynamicObject>(10);
    private final List<DynamicObject> fileWaitAudit = new ArrayList<DynamicObject>(10);
    private final Map<Long, ImportRowEntity> fileMap = new HashMap<Long, ImportRowEntity>(16);
    private final Map<Long, ImportRowEntity> personMap = new HashMap<Long, ImportRowEntity>(16);
    private static Set<String> areadydealProps = new HashSet<String>(16);
    private final Map<String, Object> cachedAdminDivision = new LinkedHashMap<String, Object>(100, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> pEldest) {
            return this.size() > 1000;
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key);
        }
    };

    public String getDefaultKeyFields() {
        return "number";
    }

    public String getDefaultImportType() {
        return "new";
    }

    protected int getBatchImportSize() {
        return 500;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        LocaleString number = ResManager.getLocaleString((String)"\u6863\u6848\u7f16\u53f7", (String)"SinsurFileImportStartPlugin_0", (String)"sit-hcsi-formplugin");
        items.add(new ComboItem(number, "number"));
        LocaleString placeofwelfare = ResManager.getLocaleString((String)"\u4eba\u5458+\u53c2\u4fdd\u5730", (String)"SinsurFileImportStartPlugin_1", (String)"sit-hcsi-formplugin");
        items.add(new ComboItem(placeofwelfare, "placeofwelfare"));
        return items;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        ImportHelper.invalidBill(billDatas, (ImportLogger)logger, this.cachedAdminDivision);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.clearData();
        Map logCache = logger.getLogCache();
        HashMap logCacheBatch = new HashMap(10000);
        logger.setLogCache(logCacheBatch);
        String mainEntityType = this.mainEntityType.getName();
        LOG.info("Trace by Quinn: save by person {}", (Object)mainEntityType);
        switch (mainEntityType) {
            case "hcsi_sinsurfile_imp": {
                this.doSaveFileAndPerson(rowdatas, logger, true);
                break;
            }
            case "hcsi_sinsurfile": {
                this.doSaveFileAndPerson(rowdatas, logger, false);
                break;
            }
            case "hcsi_sinsurperson": {
                this.doSavePerson(rowdatas, logger);
                break;
            }
        }
        logCache.putAll(logCacheBatch);
        logger.setLogCache(logCache);
        logger.signTotalRow(rowdatas.size());
        return null;
    }

    private Map<String, QFilter> getPermissionFilterMap() {
        HashMap<String, QFilter> permissionFilterMap = new HashMap<String, QFilter>(16);
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult orgResult = SITPermissionServiceHelper.getPermOrgs((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"47156aff000000ac");
        if (!orgResult.hasAllOrgPerm()) {
            Set empgoupIds;
            QFilter orgFilter = new QFilter("id", "in", (Object)orgResult.getHasPermOrgs());
            permissionFilterMap.put("bos_org", orgFilter);
            Set welfarepayerIds = SITPermissionServiceHelper.getWelfarePayerSetByPermItem((Long)userId, (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"47156aff000000ac");
            if (!CollectionUtils.isEmpty((Collection)welfarepayerIds)) {
                QFilter welfarepayerFilter = new QFilter("id", "in", (Object)welfarepayerIds);
                permissionFilterMap.put("sitbs_welfarepayer", welfarepayerFilter);
            }
            if (!CollectionUtils.isEmpty((Collection)(empgoupIds = SITPermissionServiceHelper.getEmpgrpSetByPermItem((String)"hcsi", (String)"hcsi_sinsurfile", (String)"47156aff000000ac")))) {
                QFilter empgoupFilter = new QFilter("id", "in", (Object)empgoupIds);
                permissionFilterMap.put("hbss_empgroup", empgoupFilter);
            }
        }
        List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
        QFilter empgoupFilterAll = new QFilter("id", "in", (Object)empgoupIds);
        QFilter empgoupFilter = (QFilter)permissionFilterMap.get("hbss_empgroup");
        if (empgoupFilter == null) {
            permissionFilterMap.put("hbss_empgroup", empgoupFilterAll);
        } else {
            empgoupFilter.and(empgoupFilterAll);
        }
        return permissionFilterMap;
    }

    private void clearData() {
        this.fileWaitSave.clear();
        this.fileWaitModify.clear();
        this.fileWaitAudit.clear();
        this.fileMap.clear();
        this.personWaitSave.clear();
        this.personWaitModify.clear();
        this.personWaitAudit.clear();
        this.personMap.clear();
    }

    private ApiResult doSavePerson(List<ImportBillData> rowdatas, ImportLogger logger) {
        List<ImportRowEntity> rowInfoList = this.transferToImportRowEntity(rowdatas, logger);
        ArrayList<String> empNumbers = new ArrayList<String>(rowInfoList.size());
        for (ImportRowEntity importRowEntity : rowInfoList) {
            JSONObject data = importRowEntity.getData();
            JSONObject employee = data.getJSONObject("employee");
            if (employee == null) continue;
            String empNumber = employee.getString("empnumber");
            empNumbers.add(empNumber);
        }
        QFilter empNumberFilter = new QFilter("empnumber", "in", empNumbers);
        BaseDataHisHelper.addHisCurrFilter((QFilter)empNumberFilter);
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] employees = empHelper.query("id,name,number,status,enable, startdate,enddate,person.name", empNumberFilter.toArray(), "startdate desc");
        Map<String, List<DynamicObject>> empMap = Arrays.stream(employees).collect(Collectors.groupingBy(ele -> ele.getString("empnumber")));
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        String entityId = mainEntityType.getName();
        DynamicProperty property = mainEntityType.getProperty("person");
        block1: for (ImportRowEntity importRowEntity : rowInfoList) {
            JSONObject data = importRowEntity.getData();
            JSONObject employee = data.getJSONObject("employee");
            String empNumber = null;
            if (employee != null) {
                empNumber = employee.getString("empnumber");
            }
            DynamicObject entityDyObj = importRowEntity.getEntityDyobj(entityId);
            List<DynamicObject> dynamicObjects = empMap.get(empNumber);
            if (SITStringUtils.isEmpty((String)empNumber) || CollectionUtils.isEmpty(dynamicObjects)) {
                String errorMsg = ImportDataConvert2DyObjHelper.getBasedNoMatchMsg((int)importRowEntity.getRowIndex(), (DynamicProperty)property, (String)"number", (DynamicObject)entityDyObj, (String)"person");
                ImportDataConvert2DyObjHelper.log((int)importRowEntity.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            if (entityDyObj.getLong("person.id") != 0L) continue;
            entityDyObj.set("person", (Object)dynamicObjects.get(0).getDynamicObject("person"));
            Date bsed = entityDyObj.getDate("bsed");
            for (DynamicObject empObj : dynamicObjects) {
                Date startDate = empObj.getDate("startdate");
                Date endDate = empObj.getDate("enddate");
                if (startDate == null || !SitDateUtil.isCover((Date)bsed, (Date)startDate, (Date)endDate)) continue;
                entityDyObj.set("person", (Object)empObj.getDynamicObject("person"));
                continue block1;
            }
        }
        rowInfoList = SinsurFileBatchImportPlugin.filterImportableData(rowInfoList, logger);
        this.dealPerson(rowInfoList, logger, true);
        this.doValidateAll(rowInfoList, logger, false);
        this.filterDataAfterOPValidate(rowInfoList, logger);
        this.doSaveAll(rowInfoList, logger, true);
        return new ApiResult();
    }

    private ApiResult doSaveFileAndPerson(List<ImportBillData> rowdatas, ImportLogger logger, boolean isDealPerson) {
        long t1 = System.currentTimeMillis();
        List<ImportRowEntity> rowInfoList = this.transferToImportRowEntity(rowdatas, logger);
        DynamicObject[] fileDyObjs = this.queryFileByNumber(rowInfoList);
        this.setEmployeeAndPerson(logger, rowInfoList, fileDyObjs);
        this.checkFileNumberData(rowInfoList, logger);
        if (isDealPerson) {
            this.checkRepeatData(rowInfoList, logger);
            this.checkMultiEntryData(rowInfoList, logger);
        }
        rowInfoList = SinsurFileBatchImportPlugin.filterImportableData(rowInfoList, logger);
        long t2 = System.currentTimeMillis();
        LOG.info("transferData:{}ms", (Object)(t2 - t1));
        t1 = System.currentTimeMillis();
        this.dealFile(rowInfoList, logger, isDealPerson, fileDyObjs);
        t2 = System.currentTimeMillis();
        LOG.info("dealFile:{}ms", (Object)(t2 - t1));
        if (isDealPerson) {
            t1 = System.currentTimeMillis();
            this.dealPerson(rowInfoList, logger, false);
            t2 = System.currentTimeMillis();
            LOG.info("dealPerson:{}ms", (Object)(t2 - t1));
        }
        t1 = System.currentTimeMillis();
        this.doValidateAll(rowInfoList, logger, false);
        t2 = System.currentTimeMillis();
        LOG.info("doValidateAll:{}ms", (Object)(t2 - t1));
        t1 = System.currentTimeMillis();
        this.filterDataAfterOPValidate(rowInfoList, logger);
        t2 = System.currentTimeMillis();
        LOG.info("filterDataAfterOPValidate:{}ms", (Object)(t2 - t1));
        t1 = System.currentTimeMillis();
        this.doSaveAll(rowInfoList, logger, false);
        t2 = System.currentTimeMillis();
        LOG.info("doSaveAll:{}ms", (Object)(t2 - t1));
        return new ApiResult();
    }

    private void setEmployeeAndPerson(ImportLogger logger, List<ImportRowEntity> rowInfoList, DynamicObject[] fileDyObjs) {
        DynamicObject[] employees;
        ArrayList<String> empNumbers = new ArrayList<String>(rowInfoList.size());
        for (ImportRowEntity importRowEntity : rowInfoList) {
            JSONObject data = importRowEntity.getData();
            JSONObject employee = data.getJSONObject("employee");
            if (employee == null) continue;
            String empNumber = employee.getString("empnumber");
            empNumbers.add(empNumber);
        }
        if (CollectionUtils.isEmpty(empNumbers)) {
            employees = new DynamicObject[]{};
        } else {
            QFilter empNumberFilter = new QFilter("empnumber", "in", empNumbers);
            BaseDataHisHelper.addHisCurrFilter((QFilter)empNumberFilter);
            HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
            employees = empHelper.query("id,name,number,status,enable, startdate,enddate,person.name", empNumberFilter.toArray(), "startdate desc");
        }
        Map<String, List<DynamicObject>> empMap = Arrays.stream(employees).collect(Collectors.groupingBy(ele -> ele.getString("empnumber")));
        Map<String, List<DynamicObject>> numberFileMap = Arrays.stream(fileDyObjs).collect(Collectors.groupingBy(ele -> ele.getString("number")));
        String msgTpl = ResManager.loadKDString((String)"\u201c\u53c2\u4fdd\u72b6\u6001=\u6b63\u5e38\u7f34\u7eb3\u201d\u65f6\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u5e94\u5728\u4eba\u5458\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u02dc\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u8303\u56f4\u5185\uff0c\u901a\u8fc7\u67e5\u627e\u8be5\u4eba\u5458\u7684\u804c\u4e1a\u4fe1\u606f\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u53ef\u586b\u5165\u7684\u503c\u8303\u56f4\u662f\u201c{0}\u201d\u3002", (String)"SinsurFileBsedValidator_22", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String msgTpl2 = ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f\u5e94\u5728\u4eba\u5458\u7684[\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u02dc\u7528\u5de5\u7ed3\u675f\u65e5\u671f]\u8303\u56f4\u5185\uff0c\u901a\u8fc7\u67e5\u627e\u8be5\u4eba\u5458\u7684\u804c\u4e1a\u4fe1\u606f\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u53ef\u586b\u5165\u7684\u503c\u8303\u56f4\u662f\u201c{0}\u201d\u3002", (String)"SinsurFileBsedValidator_25", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        String msg3 = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e0e\u5de5\u53f7\u65e0\u6cd5\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u8be5\u4eba\u5458\u7684\u793e\u4fdd\u6863\u6848", (String)"SinsurFileBsedValidator_26", (String)"sit-hcsi-opplugin", (Object[])new Object[0]);
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        String entityId = mainEntityType.getName();
        for (ImportRowEntity importRowEntity : rowInfoList) {
            BaseResult result;
            JSONObject data = importRowEntity.getData();
            DynamicObject entityDyObj = importRowEntity.getEntityDyobj(entityId);
            String fileNumber = data.getString("number");
            JSONObject employee = data.getJSONObject("employee");
            String empNumber = employee == null ? null : employee.getString("empnumber");
            List<DynamicObject> empObjs = empMap.get(empNumber);
            if (CollectionUtils.isEmpty(empObjs)) {
                ImportDataConvert2DyObjHelper.log((int)importRowEntity.getRowIndex(), (String)msg3, (ImportLogger)logger);
                continue;
            }
            List<DynamicObject> files = numberFileMap.get(fileNumber);
            if (files != null) {
                entityDyObj.set("person", (Object)files.get(0).getDynamicObject("person"));
                if (HRStringUtils.equals((String)"normal", (String)entityDyObj.getString("sinsurstatus"))) {
                    result = SinsurFileServiceHelper.matchEmployee((DynamicObject)entityDyObj, empObjs, (boolean)false, (String)"IMPORT");
                    if (result.isSuccess()) continue;
                    if (SinsurFileServiceHelper.isNotValidator()) {
                        Date firstStartDate = null;
                        for (DynamicObject emp : employees) {
                            Date startdate = emp.getDate("startdate");
                            if (firstStartDate != null && !startdate.before(firstStartDate)) continue;
                            firstStartDate = startdate;
                        }
                        Date bsed = entityDyObj.getDate("bsed");
                        if (firstStartDate == null || !SITDateTimeUtils.dayBefore((Date)bsed, firstStartDate)) continue;
                        ImportDataConvert2DyObjHelper.log((int)importRowEntity.getRowIndex(), (String)ResManager.loadKDString((String)"\u6863\u6848\u57fa\u672c\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\uff1a{0}\u3002", (String)"SinsurFileSaveValidator_0", (String)"sit-hcsi-opplugin", (Object[])new Object[]{SITDateTimeUtils.format((Date)firstStartDate, (String)"yyyy-MM-dd")}), (ImportLogger)logger);
                        continue;
                    }
                    String dateRange = result.getMessage();
                    if (StringUtils.isEmpty((CharSequence)dateRange)) {
                        ImportDataConvert2DyObjHelper.log((int)importRowEntity.getRowIndex(), (String)msg3, (ImportLogger)logger);
                        continue;
                    }
                    ImportDataConvert2DyObjHelper.log((int)importRowEntity.getRowIndex(), (String)MessageFormat.format(msgTpl, dateRange), (ImportLogger)logger);
                    continue;
                }
                entityDyObj.set("employee", (Object)files.get(0).getDynamicObject("employee"));
                continue;
            }
            result = SinsurFileServiceHelper.matchEmployee((DynamicObject)entityDyObj, empObjs, (boolean)true, (String)"IMPORT");
            if (result.isSuccess()) continue;
            ImportDataConvert2DyObjHelper.log((int)importRowEntity.getRowIndex(), (String)MessageFormat.format(msgTpl2, result.getMessage()), (ImportLogger)logger);
        }
    }

    private DynamicObject[] queryFileByNumber(List<ImportRowEntity> rowInfoList) {
        ArrayList<String> numbers = new ArrayList<String>(rowInfoList.size());
        for (ImportRowEntity importRowEntity : rowInfoList) {
            JSONObject data = importRowEntity.getData();
            String fileNumber = data.getString("number");
            numbers.add(fileNumber);
        }
        QFilter numberFilter = new QFilter("number", "in", numbers);
        BaseDataHisHelper.addHisCurrFilter((QFilter)numberFilter);
        return this.fileHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurfile"), new QFilter[]{numberFilter});
    }

    private void checkRepeatData(List<ImportRowEntity> rowInfoList, ImportLogger logger) {
        String errorMsg = ResManager.loadKDString((String)"\u540c\u6279\u6b21\u4e0b\u4eba\u5458+\u53c2\u4fdd\u5355\u4f4d\u7f16\u53f7\u91cd\u590d\uff0c\u4ec5\u5904\u7406\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"SinsurFileBatchImportPlugin_10", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        this.checkMultiDataCore(rowInfoList, logger, errorMsg, "employee.id", "welfarepayer.id");
        errorMsg = ResManager.loadKDString((String)"\u540c\u6279\u6b21\u4e0b\u4eba\u5458+\u53c2\u4fdd\u5730\u7f16\u53f7\u91cd\u590d\uff0c\u4ec5\u5904\u7406\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"SinsurFileBatchImportPlugin_11", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        this.checkMultiDataCore(rowInfoList, logger, errorMsg, "employee.id", "welfarepayer.placeofwelfare.id");
    }

    private void checkFileNumberData(List<ImportRowEntity> rowInfoList, ImportLogger logger) {
        String errorMsg = ResManager.loadKDString((String)"\u540c\u6279\u6b21\u4e0b\u6863\u6848\u7f16\u53f7\u91cd\u590d\uff0c\u4ec5\u5904\u7406\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"SinsurFileBatchImportPlugin_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        this.checkMultiDataCore(rowInfoList, logger, errorMsg, "number", null);
    }

    private void checkMultiDataCore(List<ImportRowEntity> rowInfoList, ImportLogger logger, String errorMsg, String key1, String key2) {
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        String entityId = mainEntityType.getName();
        HashSet<String> set = new HashSet<String>(16);
        for (ImportRowEntity rowInfo : rowInfoList) {
            DynamicObject obj = rowInfo.getEntityDyobj(entityId);
            String value = obj.getString(key1);
            if (key2 != null) {
                value = obj.getString(key1) + obj.getString(key2);
            }
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            if (set.contains(value)) {
                ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            set.add(value);
        }
    }

    private void checkMultiEntryData(List<ImportRowEntity> rowInfoList, ImportLogger logger) {
        String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u91cd\u590d\u3002", (String)"SinsurFileBatchImportPlugin_12", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowInfo : rowInfoList) {
            DynamicObject obj = rowInfo.getEntityDyobj(entityId);
            DynamicObjectCollection personEntry = obj.getDynamicObjectCollection("hcsi_sinsurperson");
            if (CollectionUtils.isEmpty((Collection)personEntry) || personEntry.size() < 2) continue;
            ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
        }
    }

    private void filterDataAfterOPValidate(List<ImportRowEntity> rowInfos, ImportLogger logger) {
        Set errorRowIndexs = logger.getLogCache().keySet();
        HashSet<Long> errorFileIds = new HashSet<Long>(16);
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject dy = rowInfo.getFileDy();
            if (dy == null || !errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
            errorFileIds.add(dy.getLong("id"));
        }
        HashSet<Long> errorPersonIds = new HashSet<Long>(16);
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject dy = rowInfo.getPersonDy();
            if (dy == null || !errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
            errorPersonIds.add(dy.getLong("id"));
        }
        this.clearWaitList(errorFileIds, this.fileMap, this.fileWaitSave);
        this.clearWaitList(errorFileIds, this.fileMap, this.fileWaitModify);
        this.clearWaitList(errorFileIds, this.fileMap, this.fileWaitAudit);
        this.clearWaitList(errorPersonIds, this.personMap, this.personWaitSave);
        this.clearWaitList(errorPersonIds, this.personMap, this.personWaitModify);
        this.clearWaitList(errorPersonIds, this.personMap, this.personWaitAudit);
    }

    private void clearWaitList(Set<Long> errorIds, Map<Long, ImportRowEntity> dataMap, List<DynamicObject> waitList) {
        Iterator<DynamicObject> it = waitList.iterator();
        while (it.hasNext()) {
            Long id = it.next().getLong("id");
            if (!errorIds.contains(id)) continue;
            it.remove();
            dataMap.remove(id);
        }
    }

    private void doValidateAll(List<ImportRowEntity> rowInfoList, ImportLogger logger, boolean isOnlyPerson) {
        this.doValidate(this.fileWaitSave, this.fileWaitModify, this.fileWaitAudit, this.fileMap, logger);
        this.doValidate(this.personWaitSave, this.personWaitModify, this.personWaitAudit, this.personMap, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveAll(List<ImportRowEntity> rowInfoList, ImportLogger logger, boolean isOnlyPerson) {
        try (TXHandle txHandle = TX.required();){
            this.doSave(this.fileWaitSave, this.fileWaitModify, this.fileWaitAudit, this.fileMap, logger);
            this.doSave(this.personWaitSave, this.personWaitModify, this.personWaitAudit, this.personMap, (ImportLogger)(isOnlyPerson ? logger : null));
            txHandle.commit();
        }
    }

    private void dealFile(List<ImportRowEntity> rowInfoList, ImportLogger logger, boolean isDealPerson, DynamicObject[] fileDyObjs) {
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        String entityId = mainEntityType.getName();
        HashMap<String, DynamicObject> fileDyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dy : fileDyObjs) {
            String key = dy.getString("number");
            fileDyMap.put(key, dy);
        }
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("hcsi_sinsurfile", rowInfoList.size());
        for (int i = 0; i < rowInfoList.size(); ++i) {
            ImportRowEntity rowInfo = rowInfoList.get(i);
            DynamicObject obj = rowInfo.getEntityDyobj(entityId);
            DynamicObject fileExcelDy = this.getFileDy(obj);
            String fileKey = fileExcelDy.getString("number");
            DynamicObject fileDB = (DynamicObject)fileDyMap.get(fileKey);
            if (fileDB == null) {
                if (isDealPerson) {
                    fileExcelDy.set("id", (Object)ids[i]);
                    this.fileWaitSave.add(fileExcelDy);
                    this.fileMap.put(fileExcelDy.getLong("id"), rowInfo);
                    rowInfo.setFileDy(fileExcelDy);
                    continue;
                }
                String errorMsg = ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728", (String)"SinsurFileBatchImportPlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            String status = fileDB.getString("status");
            if ("A".equals(status)) {
                boolean isModify = this.verifyFixedFieldIsModified(fileExcelDy, fileDB, rowInfo, logger);
                if (isModify) continue;
                this.copyFileData(fileExcelDy, fileDB);
                this.fileWaitModify.add(fileDB);
                this.fileMap.put(fileDB.getLong("id"), rowInfo);
                rowInfo.setFileDy(fileDB);
                continue;
            }
            if ("C".equals(status)) {
                boolean isModify = this.verifyFixedFieldIsModified(fileExcelDy, fileDB, rowInfo, logger);
                if (isModify) continue;
                this.dealModify(ids[i], rowInfo, fileExcelDy, fileDB);
                continue;
            }
            String statusName = this.getStatusName(status);
            String errorMsg = ImportDataConvert2DyObjHelper.getFieldCanNotModifiedErrorMsg((String)statusName);
            ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
        }
    }

    private void dealModify(long id, ImportRowEntity rowInfo, DynamicObject fileExcelDy, DynamicObject fileDB) {
        fileExcelDy.set("id", (Object)id);
        fileExcelDy.set("boid", fileDB.get("boid"));
        fileExcelDy.set("employee", fileDB.get("employee"));
        fileExcelDy.set("person", fileDB.get("person"));
        fileExcelDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        fileExcelDy.set("createtime", (Object)new Date());
        fileExcelDy.set("status", (Object)"C");
        fileExcelDy.set("personindexid", fileDB.get("personindexid"));
        this.fileWaitAudit.add(fileExcelDy);
        this.fileMap.put(fileExcelDy.getLong("id"), rowInfo);
        rowInfo.setFileDy(fileExcelDy);
    }

    private String getStatusName(String status) {
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        String submit = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"SinsurFileBatchImportPlugin_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String abandon = ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"SinsurFileBatchImportPlugin_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        nameMap.put("B", submit);
        nameMap.put("E", abandon);
        return (String)nameMap.get(status);
    }

    private boolean verifyFixedFieldIsModified(DynamicObject fileExcelDy, DynamicObject fileDB, ImportRowEntity rowInfo, ImportLogger logger) {
        boolean isModified;
        boolean bl = isModified = fileExcelDy.getLong("person.id") != fileDB.getLong("person.id");
        if (isModified) {
            String propName = this.getPropName("person");
            String value = fileExcelDy.getString("person.name");
            String errorMsg = ImportDataConvert2DyObjHelper.getFixedFieldModifiedErrorMsg((String)propName, (String)value);
            ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
        }
        isModified = this.verifyFixedFieldIsModifiedCore("welfarepayer", fileExcelDy, fileDB, rowInfo, logger) || isModified;
        isModified = this.verifyFixedFieldIsModifiedCore("org", fileExcelDy, fileDB, rowInfo, logger) || isModified;
        return isModified;
    }

    private boolean verifyFixedFieldIsModifiedCore(String propkey, DynamicObject fileExcelDy, DynamicObject fileDB, ImportRowEntity rowInfo, ImportLogger logger) {
        Object obj = fileDB.get(propkey);
        String getStringKey = propkey;
        String getValueKey = propkey;
        if (obj instanceof DynamicObject) {
            getStringKey = getStringKey + ".id";
            getValueKey = getValueKey + ".name";
        }
        if (!fileDB.getString(getStringKey).equals(fileExcelDy.getString(getStringKey))) {
            String propName = this.getPropName(propkey);
            String value = fileExcelDy.getString(getValueKey);
            String errorMsg = ImportDataConvert2DyObjHelper.getFixedFieldModifiedErrorMsg((String)propName, (String)value);
            ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
            return true;
        }
        return false;
    }

    private String getPropName(String key) {
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"SinsurFileBatchImportPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String org = ResManager.loadKDString((String)"\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7", (String)"SinsurFileBatchImportPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String manageregion = ResManager.loadKDString((String)"\u793e\u4fdd\u7ba1\u7406\u5c5e\u5730", (String)"SinsurFileBatchImportPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String welfarepayer = ResManager.loadKDString((String)"\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d", (String)"SinsurFileBatchImportPlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String bsedp = ResManager.loadKDString((String)"\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u751f\u6548\u65e5\u671f", (String)"SinsurFileBatchImportPlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String person = ResManager.loadKDString((String)"\u4eba\u5458", (String)"SinsurFileBatchImportPlugin_13", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        nameMap.put("number", number);
        nameMap.put("org", org);
        nameMap.put("manageregion", manageregion);
        nameMap.put("welfarepayer", welfarepayer);
        nameMap.put("bsed", bsedp);
        nameMap.put("person", person);
        return (String)nameMap.get(key);
    }

    private void dealPerson(List<ImportRowEntity> rowInfoList, ImportLogger logger, boolean isSelf) {
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        String entityId = mainEntityType.getName();
        Map<String, DynamicObject> personDyMap = this.packagePersonDyMap(rowInfoList, isSelf, entityId);
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("hcsi_sinsurperson", rowInfoList.size());
        for (int i = 0; i < rowInfoList.size(); ++i) {
            String personKey;
            DynamicObject personDB;
            DynamicObject obj;
            ImportRowEntity rowInfo = rowInfoList.get(i);
            DynamicObject personExcelDy = obj = rowInfo.getEntityDyobj(entityId);
            if (!isSelf) {
                personExcelDy = this.getPersonDyFromImpDy(obj);
            }
            if ((personDB = personDyMap.get(personKey = personExcelDy.getString("person.id") + personExcelDy.getString("placeofwelfare.id"))) == null) {
                if (!isSelf) {
                    boolean isOK = this.verifyPersonMustField(personExcelDy, rowInfo, logger);
                    if (isOK) {
                        personExcelDy.set("employee", obj.get("employee"));
                        personExcelDy.set("id", (Object)ids[i]);
                        this.personWaitSave.add(personExcelDy);
                        this.personMap.put(personExcelDy.getLong("id"), rowInfo);
                        rowInfo.setPersonDy(personExcelDy);
                    }
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5728\u586b\u5165\u7684\u53c2\u4fdd\u5730\u65e0\u793e\u4fdd\u4eba\u5458\u4fe1\u606f", (String)"SinsurFileBatchImportPlugin_15", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                    ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                }
            } else {
                personExcelDy.set("employee", personDB.get("employee"));
            }
            if (personDB == null) continue;
            boolean isUpdate = true;
            if (!isSelf) {
                boolean isHasOne = this.verifyPersonIsHasOneValue(personExcelDy);
                isUpdate = isHasOne ? this.verifyPersonMustField(personExcelDy, rowInfo, logger) : false;
            }
            if (!isUpdate) continue;
            String status = personDB.getString("status");
            if ("A".equals(status)) {
                this.copyPersonData(personExcelDy, personDB);
                this.personWaitModify.add(personDB);
                this.personMap.put(personDB.getLong("id"), rowInfo);
                rowInfo.setPersonDy(personDB);
                continue;
            }
            if (!"C".equals(status)) continue;
            personExcelDy.set("id", (Object)ids[i]);
            personExcelDy.set("boid", personDB.get("boid"));
            personExcelDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            personExcelDy.set("createtime", (Object)new Date());
            this.personWaitAudit.add(personExcelDy);
            this.personMap.put(personExcelDy.getLong("id"), rowInfo);
            rowInfo.setPersonDy(personExcelDy);
        }
    }

    private Map<String, DynamicObject> packagePersonDyMap(List<ImportRowEntity> rowInfoList, boolean isSelf, String entityId) {
        DynamicObject[] personDyObjs;
        HashMap<String, DynamicObject> personDyMap = new HashMap<String, DynamicObject>(16);
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        ArrayList<Long> placeOfWelfareIds = new ArrayList<Long>(10);
        for (ImportRowEntity rowInfo : rowInfoList) {
            DynamicObject obj = rowInfo.getEntityDyobj(entityId);
            personIds.add(obj.getLong("person.id"));
            if (isSelf) {
                placeOfWelfareIds.add(obj.getLong("placeofwelfare.id"));
                continue;
            }
            placeOfWelfareIds.add(obj.getLong("welfarepayer.placeofwelfare.id"));
        }
        LOG.info("Trace by Quinn: packagePersonDyMap by person");
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter placeOfWelfareFilter = new QFilter("placeofwelfare", "in", placeOfWelfareIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
        for (DynamicObject dy : personDyObjs = this.personHelper.loadDynamicObjectArray(new QFilter[]{personFilter, placeOfWelfareFilter, statusFilter})) {
            String key = dy.getString("person.id") + dy.getString("placeofwelfare.id");
            personDyMap.put(key, dy);
        }
        return personDyMap;
    }

    private boolean verifyPersonIsHasOneValue(DynamicObject personExcelDy) {
        boolean isHasOne = false;
        if (personExcelDy.get("registertype") != null) {
            isHasOne = true;
        }
        if (personExcelDy.get("category") != null) {
            isHasOne = true;
        }
        if (!StringUtils.isEmpty((CharSequence)personExcelDy.getString("sinsuraccount"))) {
            isHasOne = true;
        }
        if (!StringUtils.isEmpty((CharSequence)personExcelDy.getString("housingfundac"))) {
            isHasOne = true;
        }
        if (!StringUtils.isEmpty((CharSequence)personExcelDy.getString("comment"))) {
            isHasOne = true;
        }
        if (personExcelDy.get("bsed") != null) {
            isHasOne = true;
        }
        return isHasOne;
    }

    private boolean verifyPersonMustField(DynamicObject personExcelDy, ImportRowEntity rowInfo, ImportLogger logger) {
        String propkey = "bsed";
        if (personExcelDy.get(propkey) == null) {
            String propName = this.getPropName(propkey);
            String errorMsg = ImportDataConvert2DyObjHelper.getMustFieldEmptyErrorMsg((String)propName);
            ImportDataConvert2DyObjHelper.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
            return false;
        }
        return true;
    }

    private void doValidate(List<DynamicObject> fileWaitSave, List<DynamicObject> fileWaitModify, List<DynamicObject> fileWaitAudit, Map<Long, ImportRowEntity> importRowMap, ImportLogger logger) {
        if (fileWaitSave != null && fileWaitSave.size() >= 1) {
            SinsurFileBatchImportPlugin.executeOp("donothing_savevalidator", fileWaitSave.toArray(new DynamicObject[0]), importRowMap, logger);
        }
        if (fileWaitModify != null && fileWaitModify.size() >= 1) {
            SinsurFileBatchImportPlugin.executeOp("donothing_savevalidator", fileWaitModify.toArray(new DynamicObject[0]), importRowMap, logger);
        }
        if (fileWaitAudit != null && fileWaitAudit.size() >= 1) {
            SinsurFileBatchImportPlugin.executeOp("donothing_saveafterauditvalidator", fileWaitAudit.toArray(new DynamicObject[0]), importRowMap, logger);
        }
    }

    private void doSave(List<DynamicObject> fileWaitSave, List<DynamicObject> fileWaitModify, List<DynamicObject> fileWaitAudit, Map<Long, ImportRowEntity> importRowMap, ImportLogger logger) {
        if (fileWaitSave != null && fileWaitSave.size() >= 1) {
            SinsurFileBatchImportPlugin.executeOp("save", fileWaitSave.toArray(new DynamicObject[0]), importRowMap, logger);
        }
        if (fileWaitModify != null && fileWaitModify.size() >= 1) {
            SinsurFileBatchImportPlugin.executeOp("save", fileWaitModify.toArray(new DynamicObject[0]), importRowMap, logger);
        }
        if (fileWaitAudit != null && fileWaitAudit.size() >= 1) {
            SinsurFileBatchImportPlugin.executeOp("saveafteraudit", fileWaitAudit.toArray(new DynamicObject[0]), importRowMap, logger);
        }
    }

    private static List<ImportRowEntity> filterImportableData(List<ImportRowEntity> rowInfos, ImportLogger logger) {
        Set errorRowIndexs = logger.getLogCache().keySet();
        ArrayList<ImportRowEntity> importableRowInfos = new ArrayList<ImportRowEntity>();
        for (ImportRowEntity rowInfo : rowInfos) {
            if (errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
            importableRowInfos.add(rowInfo);
        }
        return importableRowInfos;
    }

    public static void executeOp(String opName, DynamicObject[] dys, Map<Long, ImportRowEntity> importRowMap, ImportLogger logger) {
        if (dys == null || dys.length == 0) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isimport", "1");
        operateOption.setVariableValue("dataSrc", "IMPORT");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult operationResult = opImpl.localInvokeOperation(opName, dys, operateOption);
        SinsurFileBatchImportPlugin.dealOperationResult(opName, dys, operationResult, importRowMap, logger);
    }

    private static void dealOperationResult(String opName, DynamicObject[] dys, OperationResult operationResult, Map<Long, ImportRowEntity> importRowMap, ImportLogger logger) {
        HashSet<String> errorMsgs = new HashSet<String>();
        boolean isValidator = false;
        if (opName.contains("validator")) {
            isValidator = true;
        }
        if (operationResult.isSuccess()) {
            if (!isValidator && logger != null) {
                List delRows = logger.getDelRows();
                for (Object pkId : operationResult.getSuccessPkIds()) {
                    ImportRowEntity rowEntity = importRowMap.get(Long.parseLong(String.valueOf(pkId)));
                    delRows.add(new int[]{rowEntity.getRowIndex(), rowEntity.getEndRowIndex()});
                }
                logger.setDelRows(delRows);
            }
        } else {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (DynamicObject[] operateInfo : operateInfos) {
                ImportRowEntity importRow = importRowMap.get(Long.parseLong(String.valueOf(operateInfo.getPkValue())));
                ImportDataConvert2DyObjHelper.log((int)importRow.getRowIndex(), (String)operateInfo.getMessage(), (ImportLogger)logger);
                errorMsgs.add(operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                for (DynamicObject dy : dys) {
                    ImportRowEntity rowEntity = importRowMap.get(dy.getLong("id"));
                    ImportDataConvert2DyObjHelper.log((int)rowEntity.getRowIndex(), (String)operationResult.getMessage(), (ImportLogger)logger);
                }
                errorMsgs.add(msg);
            }
            if (!isValidator) {
                String withErrorMsg = ResManager.loadKDString((String)"\u540c\u6279\u6b21\u6570\u636e\u5b58\u5728\u5904\u7406\u5931\u8d25\u7684\u6570\u636e\uff0c\u5219\u6574\u6279\u6b21\u7686\u5931\u8d25\u3002", (String)"SinsurFileBatchImportPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                if (operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() >= 1) {
                    for (Object pkId : operationResult.getSuccessPkIds()) {
                        ImportRowEntity rowEntity = importRowMap.get(Long.parseLong(String.valueOf(pkId)));
                        ImportDataConvert2DyObjHelper.log((int)rowEntity.getRowIndex(), (String)withErrorMsg, (ImportLogger)logger);
                    }
                }
                throw new KDBizException(StringUtils.join((Object[])errorMsgs.toArray(), (String)";"));
            }
        }
    }

    private void copyFileData(DynamicObject fileExcelDy, DynamicObject fileDB) {
        Map fields = ((BasedataEntityType)fileExcelDy.getDynamicObjectType()).getFields();
        for (String key : fields.keySet()) {
            if (areadydealProps.contains(key)) continue;
            fileDB.set(key, fileExcelDy.get(key));
        }
        fileDB.set("empgroup", fileExcelDy.get("empgroup"));
        fileDB.set("isescrowstaff", fileExcelDy.get("isescrowstaff"));
        fileDB.set("welfarepayertheory", fileExcelDy.get("welfarepayertheory"));
        fileDB.set("sinsurstatus", fileExcelDy.get("sinsurstatus"));
        fileDB.set("bsed", fileExcelDy.get("bsed"));
        fileDB.set("comment", fileExcelDy.get("comment"));
        fileDB.set("modifier", (Object)RequestContext.get().getCurrUserId());
        fileDB.set("modifytime", (Object)new Date());
    }

    private void copyPersonData(DynamicObject personExcelDy, DynamicObject personDB) {
        personDB.set("registertype", personExcelDy.get("registertype"));
        personDB.set("category", personExcelDy.get("category"));
        personDB.set("sinsuraccount", personExcelDy.get("sinsuraccount"));
        personDB.set("housingfundac", personExcelDy.get("housingfundac"));
        personDB.set("bsed", personExcelDy.get("bsed"));
        personDB.set("comment", personExcelDy.get("comment"));
        Map fields = ((BasedataEntityType)personExcelDy.getDynamicObjectType()).getFields();
        for (String key : fields.keySet()) {
            if (areadydealProps.contains(key)) continue;
            personDB.set(key, personExcelDy.get(key));
        }
        personDB.set("modifier", (Object)RequestContext.get().getCurrUserId());
        personDB.set("modifytime", (Object)new Date());
    }

    private List<ImportRowEntity> transferToImportRowEntity(List<ImportBillData> rowdatas, ImportLogger logger) {
        ArrayList<ImportRowEntity> rowInfoList = new ArrayList<ImportRowEntity>(rowdatas.size());
        for (ImportBillData billData : rowdatas) {
            JSONObject obj = billData.getData();
            rowInfoList.add(new ImportRowEntity(billData.getStartIndex(), billData.getEndIndex(), obj));
        }
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        Map<String, QFilter> permissionFilterMap = this.getPermissionFilterMap();
        ImportDataConvert2DyObjHelper.assembleImportData((MainEntityType)mainEntityType, rowInfoList, (ImportLogger)logger, permissionFilterMap);
        return rowInfoList;
    }

    private DynamicObject getFileDy(DynamicObject obj) {
        DynamicObject fileDy = this.fileHelper.generateEmptyDynamicObject();
        SITBaseDataHelper.transferDynamicObject((DynamicObject)obj, (DynamicObject)fileDy, null, null);
        DynamicObject region = new HRBaseServiceHelper("bd_country").generateEmptyDynamicObject();
        region.set("id", (Object)MANAGEREGION_CHN);
        fileDy.set("manageregion", (Object)region);
        return fileDy;
    }

    private DynamicObject getPersonDyFromImpDy(DynamicObject obj) {
        DynamicObject personDy = this.personHelper.generateEmptyDynamicObject();
        personDy.set("person", obj.get("person"));
        personDy.set("placeofwelfare", obj.get("welfarepayer.placeofwelfare"));
        DynamicObjectCollection personEntry = obj.getDynamicObjectCollection("hcsi_sinsurperson");
        if (personEntry != null && !personEntry.isEmpty()) {
            Map fields = ((EntryType)personEntry.getDynamicObjectType()).getFields();
            DynamicObject personExcelEntryDy = (DynamicObject)personEntry.get(0);
            personDy.set("registertype", personExcelEntryDy.get("registertype"));
            personDy.set("category", personExcelEntryDy.get("category"));
            personDy.set("sinsuraccount", personExcelEntryDy.get("sinsuraccount"));
            personDy.set("housingfundac", personExcelEntryDy.get("housingfundac"));
            personDy.set("comment", personExcelEntryDy.get("commentp"));
            personDy.set("bsed", personExcelEntryDy.get("bsedp"));
            for (String key : fields.keySet()) {
                if (areadydealProps.contains(key)) continue;
                personDy.set(key, personExcelEntryDy.get(key));
            }
        }
        return personDy;
    }

    static {
        areadydealProps.add("registertype");
        areadydealProps.add("category");
        areadydealProps.add("sinsuraccount");
        areadydealProps.add("housingfundac");
        areadydealProps.add("commentp");
        areadydealProps.add("bsedp");
        areadydealProps.add("employee");
        areadydealProps.add("person");
        areadydealProps.add("name");
        areadydealProps.add("number");
        areadydealProps.add("status");
        areadydealProps.add("creator");
        areadydealProps.add("modifier");
        areadydealProps.add("enable");
        areadydealProps.add("createtime");
        areadydealProps.add("modifytime");
        areadydealProps.add("masterid");
        areadydealProps.add("index");
        areadydealProps.add("issyspreset");
        areadydealProps.add("disabler");
        areadydealProps.add("disabledate");
        areadydealProps.add("boid");
        areadydealProps.add("iscurrentversion");
        areadydealProps.add("datastatus");
        areadydealProps.add("sourcevid");
        areadydealProps.add("firstbsed");
        areadydealProps.add("changebsed");
        areadydealProps.add("bred");
        areadydealProps.add("brled");
        areadydealProps.add("brfd");
        areadydealProps.add("ismodify");
        areadydealProps.add("bsled");
        areadydealProps.add("bsed");
        areadydealProps.add("changedescription");
        areadydealProps.add("hisversion");
    }
}

