/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;

public class SinsurFileChangeStatusPlugin
extends AbstractFormPlugin
implements SinsurFileConstants {
    public void afterBindData(EventObject args) {
        SinsurFileServiceHelper.setTipsByHrcs((IFormView)this.getView(), (String)"bsed");
        this.setCustomParamValue();
    }

    private void setCustomParamValue() {
        String sinsurStatus = (String)this.getView().getFormShowParameter().getCustomParam("sinsurstatus");
        String bsed = (String)this.getView().getFormShowParameter().getCustomParam("bsed");
        if (sinsurStatus != null) {
            this.getModel().setValue("sinsurstatus", (Object)sinsurStatus);
            this.getView().updateView("sinsurstatus");
        }
        if (bsed != null) {
            this.getModel().setValue("bsed", (Object)bsed);
            this.getView().updateView("bsed");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "do_changesinsurstatus": {
                OperationResult operationResult = this.doChangeSinsurStatus();
                if (!operationResult.isSuccess()) {
                    args.setCancel(true);
                    this.getView().showOperationResult(operationResult);
                    if (operationResult.getSuccessPkIds().size() < 1) break;
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                this.getView().getParentView().showSuccessNotification(operationResult.getMessage());
                break;
            }
        }
    }

    private OperationResult doChangeSinsurStatus() {
        String fileIds = (String)this.getView().getFormShowParameter().getCustomParam("ids");
        List ids = SerializationUtils.fromJsonStringToList((String)fileIds, Long.class);
        DynamicObject[] fileDys = SinsurFileServiceHelper.queryFile((List)ids);
        String sinsurStatus = this.getModel().getDataEntity().getString("sinsurstatus");
        Date bsed = this.getModel().getDataEntity().getDate("bsed");
        String comment = this.getModel().getDataEntity().getString("comment");
        for (DynamicObject fileDy : fileDys) {
            fileDy.set("sinsurstatus", (Object)sinsurStatus);
            fileDy.set("bsed", (Object)bsed);
            fileDy.set("comment", (Object)comment);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("batchop_batchsize", "1000");
        option.setVariableValue("changeSinsurStatus", "true");
        option.setVariableValue("dataSrc", "PAGE");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"do_changesinsurstatusconfirm", (String)"hcsi_sinsurfile", (DynamicObject[])fileDys, (OperateOption)option);
        return operationResult;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "do_changesinsurstatus": {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                break;
            }
        }
    }
}

