/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.business.file.SinsurPersonServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.cache.SITPageCache;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileEdit
extends AbstractBasePlugIn
implements SinsurFileConstants,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(SinsurFileEdit.class);
    private static final String KEY_ADVYOOLBAR = "advtoolbar";
    private static final String KEY_BSED = "bsed";
    private static final String IS_SET_OLD_VALUE = "isSetEmployeeToOldValue";
    private static final String CALLBACKID_EMPLOYEECHANGED = "callbackid_employeeChanged";
    private static final String CALLBACKID_WELFAREPAYER = "callbackid_welfarepayerChanged";
    private static final String CALLBACK_REGION = "callbackRegion";
    private static final String CACHE_ISNOTSAVEPERSON = "isNotSavePersion";

    public void beforeBindData(EventObject eventObject) {
        this.setTipsByHrcs();
        this.opButtonControl();
        List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
        QFilter qFilter = new QFilter("id", "in", (Object)empgoupIds);
        BasedataEdit empgoupEdit = (BasedataEdit)this.getControl("empgroup");
        empgoupEdit.setQFilter(qFilter);
        this.getModel().setDataChanged(false);
    }

    private void setTipsByHrcs() {
        SinsurFileServiceHelper.setTipsByHrcs((IFormView)this.getView(), (String)KEY_BSED);
        SinsurFileServiceHelper.setTipsByHrcs((IFormView)this.getView(), (String)"bsled");
    }

    public void afterBindData(EventObject eventObject) {
        boolean isescrowstaff = this.getModel().getDataEntity().getBoolean("isescrowstaff");
        this.setForEscrowstaff(isescrowstaff, "afterBindData");
    }

    private void opButtonControl() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            BasedataEdit employeehr = (BasedataEdit)this.getView().getControl("employeehr");
            employeehr.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADVYOOLBAR});
            String customeStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cblxuJCB7XG7CoMKgbWFyZ2luOiAxMHB4ICFpbXBvcnRhbnQ7XG7CoH1cblxuwqAvKipcbiog5L+u5pS55b2T5YmN5YWD57SgaG92ZXLmlYjmnpxcbsKgICovXG4vKipcbiQ6aG92ZXIge1xuwqDCoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4qL1xuLyoqXG4gKiDkv67mlLnlvZPliY3lhYPntKDkuLpkaXbmoIfnrb7lrZDlhYPntKBcbiovXG4vKipcbiQgPiBkaXYge1xuwqBiYWNrZ3JvdW5kOnJlZDtcbsKgfVxuICovXG4ifQ==";
            this.setCustomCstyles("flexpanelap", customeStyle);
            this.embedPersonPage();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addtaxfileflex"});
            AdvContainer fileAdvconap = (AdvContainer)this.getView().getControl("advconap");
            fileAdvconap.setCollapseable(true);
        }
    }

    private void setCustomCstyles(String key, String cstyles) {
        HashMap<String, String> ctl = new HashMap<String, String>(2);
        ctl.put("id", key);
        ctl.put("cstyles", cstyles);
        this.getView().updateControlMetadata(key, ctl);
    }

    private void embedPersonPage() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("addtaxfileflex");
        showParameter.setFormId("hcsi_sinsurperson");
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().getPageCache().put("personPageId", showParameter.getPageId());
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{KEY_ADVYOOLBAR});
        BasedataEdit empgroup = (BasedataEdit)this.getControl("empgroup");
        empgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollRegion = (BasedataEdit)this.getControl("manageregion");
        payRollRegion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit welfarepayer = (BasedataEdit)this.getControl("welfarepayer");
        welfarepayer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit welfarepayertheory = (BasedataEdit)this.getControl("welfarepayertheory");
        welfarepayertheory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption opOption = operate.getOption();
        opOption.setVariableValue("dataSrc", "PAGE");
        switch (operate.getOperateKey()) {
            case "save": {
                OperateOption fileOption = OperateOption.create();
                fileOption.setVariableValue("dataSrc", "PAGE");
                OperationResult validatefileResult = this.getView().invokeOperation("donothing_savevalidator", fileOption);
                if (!validatefileResult.isSuccess()) {
                    LOG.info("SinsurFileEdit.beforeDoOperation.save.savefile.validator.result.getMessage()= {}", (Object)validatefileResult.getMessage());
                    args.setCancel(true);
                    return;
                }
                String isNotSavePersion = this.getPageCache().get(CACHE_ISNOTSAVEPERSON);
                IFormView personView = this.getView().getView(this.getView().getPageCache().get("personPageId"));
                if (isNotSavePersion != null || personView == null) break;
                OperateOption option = OperateOption.create();
                DynamicObject fileDy = this.getModel().getDataEntity();
                option.setVariableValue("dataSrc", "PAGE");
                option.setVariableValue("personId", fileDy.getString("person.id"));
                option.setVariableValue("placeofwelfare", fileDy.getString("welfarepayer.placeofwelfare.id"));
                personView.getModel().setValue("person", (Object)fileDy.getString("person.id"));
                personView.getModel().setValue("employee", (Object)fileDy.getString("employee.id"));
                personView.getModel().setValue("placeofwelfare", (Object)fileDy.getString("welfarepayer.placeofwelfare.id"));
                OperationResult validateResult = personView.invokeOperation("donothing_savevalidator", option);
                if (validateResult.isSuccess()) break;
                LOG.info("SinsurFileEdit.beforeDoOperation.save.saveperson.validator.result.getMessage()= {}", (Object)validateResult.getMessage());
                this.getView().showOperationResult(validateResult);
                args.setCancel(true);
                break;
            }
            case "showhisversion": {
                args.setCancel(true);
                SinsurFileServiceHelper.showRelatedPage((String)"20010s", (IFormView)this.getView());
                break;
            }
            case "saveafteraudit": {
                SinsurFileServiceHelper.checkModifyTime((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        switch (args.getOperateKey()) {
            case "edit": {
                break;
            }
            case "save": {
                if (null == operationResult || !operationResult.isSuccess()) break;
                this.afterSaveDoOperation();
                String customStatus = (String)this.getView().getFormShowParameter().getCustomParam("customStatus");
                if (!"ADDNEW".equals(customStatus)) break;
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity().getLong("id"));
                this.getView().getPageCache().put("afterconfirm", "true");
                this.getView().close();
                break;
            }
            case "modifyafteraudit": {
                this.setFieldEnable();
                break;
            }
            case "audit": {
                ValidateResultCollection validateResult;
                String message = operationResult.getMessage();
                if (!SITStringUtils.isNotEmpty((String)message) || !message.contains("sinsurfilecertwarn") || !(validateResult = args.getOperationResult().getValidateResult()).isSuccess()) break;
                String result = message.replace("sinsurfilecertwarn", "");
                operationResult.setMessage(result);
                break;
            }
        }
    }

    private void afterSaveDoOperation() {
        LOG.info("SalaryTaxFileRelViewHelper.afterSaveDoOperation...00000......");
        String isNotSavePersion = this.getPageCache().get(CACHE_ISNOTSAVEPERSON);
        IFormView personView = this.getView().getView(this.getView().getPageCache().get("personPageId"));
        if (isNotSavePersion == null && personView != null) {
            DynamicObject personEntity = personView.getModel().getDataEntity();
            SinsurPersonServiceHelper.savePerson((DynamicObject)personEntity);
        }
    }

    private void setFieldEnable() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bsled"});
    }

    private void updatePreview(Object salaryFileVidNew) {
        IFormView view = this.getView();
        OperateOption opParam = OperateOption.create();
        opParam.setVariableValue("afterSaveOrChange", "true");
        if (salaryFileVidNew != null) {
            opParam.setVariableValue("salaryFileVidNew", String.valueOf(salaryFileVidNew));
        }
        view.getParentView().invokeOperation("refresh", opParam);
        view.sendFormAction(view.getParentView());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (fieldKey) {
            case "employeehr": {
                this.setEmployee();
                if (this.getPageCache().get(IS_SET_OLD_VALUE) != null) {
                    this.getPageCache().remove(IS_SET_OLD_VALUE);
                } else {
                    this.employeePropertyChanged(newValue, oldValue);
                }
                IFormView personView = this.getView().getView(this.getView().getPageCache().get("personPageId"));
                if (personView == null || newValue == null) break;
                SinsurFileServiceHelper.setPersonViewPerCreByEmployeeId((IFormView)personView, (Long)((DynamicObject)newValue).getLong("id"));
                this.getView().sendFormAction(personView);
                break;
            }
            case "welfarepayer": {
                if (this.getPageCache().get(IS_SET_OLD_VALUE) != null) {
                    this.getPageCache().remove(IS_SET_OLD_VALUE);
                    break;
                }
                this.welfarepayerPropertyChanged(newValue, oldValue);
                break;
            }
            case "manageregion": {
                this.checkConfirmPage(oldValue);
                break;
            }
            case "isescrowstaff": {
                this.setForEscrowstaff(newValue, "propertyChanged");
                break;
            }
            case "bsed": {
                this.setPersonBsed(oldValue);
                break;
            }
        }
    }

    private void setPersonBsed(Object oldValue) {
        IFormView personView1 = this.getView().getView(this.getView().getPageCache().get("personPageId"));
        if (personView1 != null) {
            DynamicObject personDy = personView1.getModel().getDataEntity();
            DynamicObject fileDy = this.getModel().getDataEntity();
            if (personDy.get(KEY_BSED) == null || personDy.getDate(KEY_BSED).equals(oldValue)) {
                personView1.getModel().setValue(KEY_BSED, fileDy.get(KEY_BSED));
                this.getView().sendFormAction(personView1);
            }
        }
    }

    private void setForEscrowstaff(Object newValue, String callby) {
        if (((Boolean)newValue).booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"welfarepayertheory"});
            BasedataEdit employeehr = (BasedataEdit)this.getView().getControl("welfarepayertheory");
            employeehr.setMustInput(true);
            if ("propertyChanged".equals(callby)) {
                this.getModel().setValue("welfarepayertheory", null);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"welfarepayertheory"});
            DynamicObject dy = this.getModel().getDataEntity();
            if (dy.getLong("welfarepayertheory.id") != dy.getLong("welfarepayer.id")) {
                this.getModel().setValue("welfarepayertheory", this.getModel().getValue("welfarepayer"));
            }
        }
    }

    private void setEmployee() {
        this.getModel().beginInit();
        DynamicObject dy = this.getModel().getDataEntity().getDynamicObject("employeehr");
        if (dy != null) {
            this.getModel().setValue("employee", dy.getPkValue());
            this.getModel().setValue("person", (Object)dy.getLong("person.id"));
            DynamicObject fileDy = this.getModel().getDataEntity();
            String number = CodeRuleServiceHelper.readNumber((String)fileDy.getDynamicObjectType().getName(), (DynamicObject)fileDy, (String)fileDy.getString("org.id"));
            this.getModel().setValue("number", (Object)number);
            this.getView().updateView("number");
        } else {
            this.getModel().setValue("employee", null);
            this.getModel().setValue("person", null);
        }
        this.getModel().endInit();
    }

    private void refreshSinSurPersonInfo() {
        IFormView personView2 = this.getView().getView(this.getView().getPageCache().get("personPageId"));
        if (personView2 != null) {
            Long placeOfWelfareId;
            DynamicObject fileDy = this.getModel().getDataEntity();
            Long employeeId = fileDy.getLong("person.id");
            DynamicObject personDy = SinsurPersonServiceHelper.getSinsurPerson((Long)employeeId, (Long)(placeOfWelfareId = Long.valueOf(fileDy.getLong("welfarepayer.placeofwelfare.id"))));
            if (personDy != null) {
                personView2.getModel().setValue("registertype", personDy.get("registertype"));
                personView2.getModel().setValue("category", personDy.get("category"));
                personView2.getModel().setValue("sinsuraccount", personDy.get("sinsuraccount"));
                personView2.getModel().setValue("housingfundac", personDy.get("housingfundac"));
                personView2.getModel().setValue(KEY_BSED, personDy.get(KEY_BSED));
                personView2.getModel().setValue("comment", personDy.get("comment"));
                personView2.setEnable(Boolean.FALSE, new String[]{"fs_baseinfo"});
                this.getPageCache().put(CACHE_ISNOTSAVEPERSON, "true");
            } else {
                this.getPageCache().remove(CACHE_ISNOTSAVEPERSON);
                personView2.getModel().setValue("registertype", null);
                personView2.getModel().setValue("category", null);
                personView2.getModel().setValue("sinsuraccount", null);
                personView2.getModel().setValue("housingfundac", null);
                personView2.getModel().setValue("comment", null);
                personView2.getModel().setValue(KEY_BSED, fileDy.get(KEY_BSED));
                personView2.setEnable(Boolean.TRUE, new String[]{"fs_baseinfo"});
            }
            personView2.getModel().setDataChanged(false);
            this.getView().sendFormAction(personView2);
        }
    }

    private void checkConfirmPage(Object oldValue) {
        boolean condition;
        Object payrollgroup = this.getModel().getDataEntity().get("welfarepayer");
        boolean bl = condition = null == payrollgroup || null == oldValue;
        if (condition) {
            return;
        }
        Object regionId = ((DynamicObject)oldValue).get("id");
        String customValue = "";
        if (regionId != null) {
            customValue = String.valueOf(regionId);
        }
        String tips = ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u7a7a\u201c\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u201d\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5207\u6362\u3002", (String)"SinsurFileEdit_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(tips, "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CALLBACK_REGION), null, customValue);
    }

    private void employeePropertyChanged(Object newValue, Object oldValue) {
        if (oldValue != null) {
            SITPageCache pageCache = new SITPageCache(this.getView());
            pageCache.put("employeehr", (Object)((DynamicObject)oldValue).getLong("id"));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6362\u201c\u4eba\u5458/\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u201d\u540e\uff0c\u4f1a\u6839\u636e\u201c\u4eba\u5458+\u53c2\u4fdd\u5730\u201d\u91cd\u7f6e\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SinsurFileEdit_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_EMPLOYEECHANGED, (IFormPlugin)this));
        } else {
            this.refreshSinSurPersonInfo();
        }
    }

    private void welfarepayerPropertyChanged(Object newValue, Object oldValue) {
        if (oldValue != null) {
            SITPageCache pageCache = new SITPageCache(this.getView());
            pageCache.put("welfarepayer", (Object)((DynamicObject)oldValue).getLong("id"));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6362\u201c\u4eba\u5458/\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d\u201d\u540e\uff0c\u4f1a\u6839\u636e\u201c\u4eba\u5458+\u53c2\u4fdd\u5730\u201d\u91cd\u7f6e\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SinsurFileEdit_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_WELFAREPAYER, (IFormPlugin)this));
            return;
        }
        this.refreshSinSurPersonInfo();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "callbackid_employeeChanged": {
                this.confirmAfterChangePerson(messageBoxClosedEvent.getResult());
                break;
            }
            case "callbackid_welfarepayerChanged": {
                this.confirmAfterChangeWelfarepayer(messageBoxClosedEvent.getResult());
                break;
            }
            case "continue_close": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                SITPageCache pageCache = new SITPageCache(this.getView());
                pageCache.put("afterconfirm", (Object)Boolean.TRUE);
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("close");
                break;
            }
            case "callbackRegion": {
                this.confirmAfterModify(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void confirmAfterChangePerson(MessageBoxResult result) {
        if (result == MessageBoxResult.No) {
            this.getPageCache().put(IS_SET_OLD_VALUE, "true");
            SITPageCache pageCache = new SITPageCache(this.getView());
            this.getModel().setValue("employeehr", pageCache.get("employeehr", Long.class));
        } else {
            this.refreshSinSurPersonInfo();
        }
    }

    private void confirmAfterChangeWelfarepayer(MessageBoxResult result) {
        if (result == MessageBoxResult.No) {
            this.getPageCache().put(IS_SET_OLD_VALUE, "true");
            SITPageCache pageCache = new SITPageCache(this.getView());
            this.getModel().setValue("welfarepayer", pageCache.get("welfarepayer", Long.class));
        } else {
            this.refreshSinSurPersonInfo();
        }
    }

    private void confirmAfterModify(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue("manageregion", (Object)event.getCustomVaule());
            model.endInit();
            this.getView().updateView("manageregion");
        } else {
            this.getModel().getDataEntity().set("welfarepayer", null);
            this.getView().updateView("welfarepayer");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "manageregion": {
                this.addPayRollRegionFilter(arg);
                break;
            }
            case "welfarepayer": {
                this.addWelfarepayerFilter(arg);
                break;
            }
        }
    }

    private void addPayRollRegionFilter(BeforeF7SelectEvent arg) {
        Set countrySetByPermItem = SITPermissionServiceHelper.getCountrySetByPermItem((String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"47156aff000000ac");
        if (!SITPermissionServiceHelper.isSuperUser() && countrySetByPermItem != null) {
            arg.addCustomQFilter(new QFilter("id", "in", (Object)countrySetByPermItem));
        }
    }

    private void addWelfarepayerFilter(BeforeF7SelectEvent arg) {
        Long manageregionId = this.getModel().getDataEntity().getLong("manageregion.id");
        if (manageregionId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u793e\u4fdd\u7ba1\u7406\u5c5e\u5730\u3002", (String)"SinsurFileEdit_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            arg.setCancel(true);
        } else {
            arg.addCustomQFilter(new QFilter("country", "=", (Object)manageregionId));
        }
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"SinsurFileEdit_11", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            arg.setCancel(true);
        } else {
            arg.addCustomQFilter(new QFilter("org", "=", (Object)orgId));
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        IFormView view = this.getView();
        SITPageCache pageCache = new SITPageCache(view);
        Boolean isContinueClose = (Boolean)pageCache.get("afterconfirm", Boolean.class);
        if (null == isContinueClose || !isContinueClose.booleanValue()) {
            IFormView personView;
            IDataModel dataModel = this.getModel();
            StringBuilder query = new StringBuilder();
            String titleHeader = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"SinsurFileEdit_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            boolean dataChanged = view.getModel().getDataChanged();
            if (dataChanged) {
                String salaryTitleHeader = ResManager.loadKDString((String)"\u6863\u6848\u57fa\u672c\u4fe1\u606f", (String)"SinsurFileEdit_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                String changeDesc = dataModel.getChangeDesc().replace(titleHeader, salaryTitleHeader);
                changeDesc = this.dealChangeDescRemovePerson(changeDesc);
                query.append(changeDesc);
            }
            boolean taxChanged = (personView = view.getView(view.getPageCache().get("personPageId"))) != null && personView.getModel() != null && personView.getModel().isDataLoaded() && personView.getModel().getDataChanged();
            boolean bl = dataChanged = dataChanged || taxChanged;
            if (personView != null && taxChanged) {
                if (query.length() > 0) {
                    query.append("\r\n");
                }
                String taxTitleHeader = ResManager.loadKDString((String)"\u793e\u4fdd\u4eba\u5458\u4fe1\u606f", (String)"SinsurFileEdit_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                String changeDesc = personView.getModel().getChangeDesc().replace(titleHeader, taxTitleHeader);
                changeDesc = this.dealChangeDescRemovePerson(changeDesc);
                query.append(changeDesc);
            }
            if (event.isCheckDataChange() && dataChanged) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(4);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SinsurFileEdit_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SinsurFileEdit_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SinsurFileEdit_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                view.showConfirm(msg, query.toString(), options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
                event.setCancel(true);
            }
        }
    }

    private String dealChangeDescRemovePerson(String changeDesc) {
        int lastIndex;
        String personOne = ResManager.loadKDString((String)"\uff0c\u4eba\u5458", (String)"SinsurFileEdit_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String personTwo = ResManager.loadKDString((String)"\u4eba\u5458\uff0c\u4eba\u5458", (String)"SinsurFileEdit_10", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        if (changeDesc.indexOf(personOne) != changeDesc.lastIndexOf(personOne)) {
            lastIndex = changeDesc.lastIndexOf(personOne);
            changeDesc = changeDesc.substring(0, lastIndex) + changeDesc.substring(lastIndex + personOne.length());
        }
        if (changeDesc.indexOf(personOne) != changeDesc.lastIndexOf(personOne)) {
            lastIndex = changeDesc.lastIndexOf(personOne);
            changeDesc = changeDesc.substring(0, lastIndex) + changeDesc.substring(lastIndex + personOne.length());
        }
        changeDesc = changeDesc.replace(personTwo, personOne);
        return changeDesc;
    }

    public void beforePropertyChanged(PropertyChangedArgs event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "employeehr": {
                ArrayList<DynamicObject> fileList = new ArrayList<DynamicObject>(10);
                fileList.add(this.getModel().getDataEntity());
                SinsurFileServiceHelper.recycleNumbers(fileList);
                break;
            }
        }
    }
}

