/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import com.google.common.collect.HashBasedTable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileExportListPlugin
extends AbstractListPlugin
implements SinsurFileConstants {
    private static final Log LOGGER = LogFactory.getLog(SinsurFileExportListPlugin.class);
    private static final String CALLBACK_EXPORT = "callBack_export";
    private final HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
    private final HRBaseServiceHelper fileImpHelper = new HRBaseServiceHelper("hcsi_sinsurfile_imp");
    private final HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcsi_sinsurperson");
    private static final Map<String, String> TEMPLATEID_MAP = new HashMap<String, String>(16);
    public static final Map<String, String> PRIVACY_MAP = new HashMap<String, String>(16);
    public final Map<String, MainEntityType> mainEntityTypeMap = new HashMap<String, MainEntityType>(16);
    private static Set<String> areadydealProps = new HashSet<String>(16);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        long startTime = System.currentTimeMillis();
        super.beforeDoOperation(args);
        this.getView().getPageCache().remove("entitynumber");
        FormOperate fo = (FormOperate)args.getSource();
        switch (operateKey = fo.getOperateKey()) {
            case "exportlist": {
                args.setCancel(true);
                this.showPersonExportDataProgressView("hcsi_sinsurfile");
                break;
            }
            case "exportlistwithperson": {
                args.setCancel(true);
                this.showPersonExportDataProgressView("hcsi_sinsurfile_imp");
                break;
            }
            case "exportlistperson": {
                args.setCancel(true);
                this.showPersonExportDataProgressView("hcsi_sinsurperson");
                break;
            }
        }
        LOGGER.info(" SinsurFileExportListPlugin run time: {}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void showPersonExportDataProgressView(String entitynumber) {
        FormShowParameter formShowParameterv = this.getView().getFormShowParameter();
        FormShowParameter formShowParameterExport = new FormShowParameter();
        formShowParameterExport.setFormId("bos_exportdataprogress");
        formShowParameterExport.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameterExport.setCustomParam("ServiceAppId", (Object)formShowParameterv.getServiceAppId());
        formShowParameterExport.setCustomParam("fillparent", null);
        formShowParameterExport.setCustomParam("entitynumber", (Object)entitynumber);
        String entityName = EntityMetadataCache.getDataEntityType((String)entitynumber).getDisplayName().toString();
        formShowParameterExport.setCustomParam("entityname", (Object)entityName);
        formShowParameterExport.setCustomParam("templateId", (Object)TEMPLATEID_MAP.getOrDefault(entitynumber, "0"));
        formShowParameterExport.setCustomParam("byList", null);
        formShowParameterExport.setCustomParam("EXPORT_LIST_TYPE", (Object)"IMPT");
        formShowParameterExport.setCustomParam("billViewExport", (Object)Boolean.FALSE);
        formShowParameterExport.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EXPORT));
        this.getView().showForm(formShowParameterExport);
        this.getView().getPageCache().put("entitynumber", entitynumber);
        IListView listView = (IListView)this.getView();
        Object[] ids = listView.getSelectedRows().getPrimaryKeyValues();
        this.getView().getPageCache().putBigObject("selectedRowIds", SerializationUtils.toJsonString((Object)ids));
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent event) {
        IPageCache pageCache = this.getView().getPageCache();
        String entityNumber = pageCache.get("entitynumber");
        if ("hcsi_sinsurfile_imp".equals(entityNumber) || "hcsi_sinsurperson".equals(entityNumber)) {
            this.beforeQueryOfExportForPerson(event);
        }
    }

    private void beforeQueryOfExportForPerson(BeforeQueryOfExportEvent event) {
        String selectedRowIdStr;
        List selectedRowIds;
        QFilter[] filters = event.getFilters();
        IPageCache pageCache = this.getView().getPageCache();
        String entitynumber = pageCache.get("entitynumber");
        if (("hcsi_sinsurperson".equals(entitynumber) || "hcsi_sinsurfile_imp".equals(entitynumber)) && ((selectedRowIds = SerializationUtils.fromJsonStringToList((String)(selectedRowIdStr = pageCache.getBigObject("selectedRowIds")), Long.class)) == null || selectedRowIds.isEmpty())) {
            DynamicObjectCollection fileDys = this.fileHelper.queryOriginalCollection("id", filters);
            List ids = fileDys.stream().map(ele -> ele.getLong("id")).collect(Collectors.toList());
            pageCache.putBigObject("selectedRowIds", SerializationUtils.toJsonString(ids));
            pageCache.remove("batchs");
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent event) {
        IPageCache pageCache = this.getView().getPageCache();
        String entitynumber = pageCache.get("entitynumber");
        if ("hcsi_sinsurperson".equals(entitynumber)) {
            this.afterQueryOfExportForPerson(event);
        } else if ("hcsi_sinsurfile_imp".equals(entitynumber)) {
            this.afterQueryOfExportForWithPerson(event);
        } else if ("hcsi_sinsurfile".equals(entitynumber)) {
            DynamicObject[] fileDys;
            for (DynamicObject fileDy : fileDys = event.getQueryValues()) {
                String name = fileDy.getString("employee.person.name");
                if (StringUtils.isEmpty((String)name) || !fileDy.getDataEntityType().getProperties().containsKey((Object)"personname")) continue;
                fileDy.set("personname", (Object)name);
            }
        }
    }

    private void afterQueryOfExportForWithPerson(AfterQueryOfExportEvent event) {
        DynamicObject[] dys = event.getQueryValues();
        Map<String, DynamicObject> personMap = this.getPersonMap(dys);
        for (DynamicObject dy : dys) {
            this.setPersonData(dy, personMap);
        }
        event.setQueryValues(dys);
        event.setCustomOrder(true);
    }

    private void setPersonData(DynamicObject fileDy, Map<String, DynamicObject> personMap) {
        String key;
        DynamicObject personDy;
        String name = fileDy.getString("employee.person.name");
        if (!StringUtils.isEmpty((String)name) && fileDy.getDataEntityType().getProperties().containsKey((Object)"personname")) {
            fileDy.set("personname", (Object)name);
        }
        if ((personDy = personMap.get(key = fileDy.getString("employee.person.id") + fileDy.getString("welfarepayer.placeofwelfare.id"))) == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)name) && personDy.getDataEntityType().getProperties().containsKey((Object)"personname")) {
            personDy.set("personname", (Object)name);
        }
        DynamicObject personEntry = this.fileImpHelper.generateEmptyEntryDynamicObject("hcsi_sinsurperson");
        personEntry.set("registertype", personDy.get("registertype"));
        Object privacyValueCategory = this.getPrivacyValue(personDy.get("category"), "category", personDy);
        personEntry.set("category", privacyValueCategory);
        Object privacyValueSinsuraccount = this.getPrivacyValue(personDy.get("sinsuraccount"), "sinsuraccount", personDy);
        personEntry.set("sinsuraccount", privacyValueSinsuraccount);
        Object privacyValueHousingfundac = this.getPrivacyValue(personDy.get("housingfundac"), "housingfundac", personDy);
        personEntry.set("housingfundac", privacyValueHousingfundac);
        personEntry.set("bsedp", personDy.get("bsed"));
        personEntry.set("commentp", personDy.get("comment"));
        Map fields = ((EntryType)personEntry.getDynamicObjectType()).getFields();
        for (String field : fields.keySet()) {
            if (areadydealProps.contains(field)) continue;
            personEntry.set(field, personDy.get(field));
        }
        fileDy.getDynamicObjectCollection("hcsi_sinsurperson").add((Object)personEntry);
    }

    private Object getPrivacyValue(Object dataVal, String field, DynamicObject dataObj) {
        Object desensitizeValue = dataVal;
        String privacyInfo = PRIVACY_MAP.get(field);
        if (SITStringUtils.isNotEmpty((String)privacyInfo)) {
            IDataEntityProperty property;
            String[] privacyInfoArr = privacyInfo.split("\\.");
            String entityId = privacyInfoArr[0];
            String key = privacyInfoArr[1];
            MainEntityType mainEntityType = this.mainEntityTypeMap.get(entityId);
            if (mainEntityType == null) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                this.mainEntityTypeMap.put(entityId, mainEntityType);
            }
            if ((property = mainEntityType.findProperty(key)) instanceof BasedataProp && desensitizeValue != null) {
                desensitizeValue = ((DynamicObject)desensitizeValue).get(((BasedataProp)property).getDisplayProp());
            }
            desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)dataObj, (Object)desensitizeValue);
        }
        return desensitizeValue;
    }

    private Map<String, DynamicObject> getPersonMap(DynamicObject[] files) {
        DynamicObject[] dys;
        HashMap<String, DynamicObject> personMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dy : dys = this.queryPerson(files)) {
            String key = dy.getString("person.id") + dy.getString("placeofwelfare.id");
            personMap.put(key, dy);
        }
        return personMap;
    }

    private void afterQueryOfExportForPerson(AfterQueryOfExportEvent event) {
        DynamicObject[] personDys;
        for (DynamicObject personDy : personDys = this.queryPersonByBatch()) {
            String number;
            String name = personDy.getString("person.name");
            if (!StringUtils.isEmpty((String)name) && personDy.getDataEntityType().getProperties().containsKey((Object)"personname")) {
                personDy.set("personname", (Object)name);
            }
            if (StringUtils.isEmpty((String)(number = personDy.getString("person.number"))) || !personDy.getDataEntityType().getProperties().containsKey((Object)"employee")) continue;
            DynamicObject employee = personDy.getDynamicObject("employee");
            if (employee == null) {
                BasedataProp property = (BasedataProp)((DynamicObjectType)personDy.getDataEntityType()).getProperty("employee");
                employee = new DynamicObject((DynamicObjectType)property.getComplexType());
                employee.set("id", (Object)personDy.getLong("id"));
                personDy.set("employee", (Object)employee);
            }
            employee.set("empnumber", (Object)number);
        }
        event.setQueryValues(personDys);
        event.setCustomOrder(true);
    }

    private DynamicObject[] queryPerson(DynamicObject[] files) {
        List fileIds = Arrays.stream(files).map(ele -> ele.getLong("id")).collect(Collectors.toList());
        DynamicObject[] fileDys = this.fileHelper.query("person.id,welfarepayer.placeofwelfare.id", new QFilter("id", "in", fileIds).toArray());
        HashMap<Long, Set> personPlaceMap = new HashMap<Long, Set>(16);
        for (DynamicObject fileDy : fileDys) {
            Set placeSet = personPlaceMap.getOrDefault(fileDy.getLong("person.id"), new HashSet(16));
            placeSet.add(fileDy.getLong("welfarepayer.placeofwelfare.id"));
            personPlaceMap.put(fileDy.getLong("person.id"), placeSet);
        }
        QFilter employeeFilter = new QFilter("person", "in", personPlaceMap.keySet());
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
        DynamicObject[] persons = this.personHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurperson"), new QFilter[]{employeeFilter, statusFilter});
        return (DynamicObject[])Arrays.stream(persons).filter(ele -> {
            Set placeIds = (Set)personPlaceMap.get(ele.getLong("person.id"));
            return placeIds != null && placeIds.contains(ele.getLong("placeofwelfare.id"));
        }).toArray(DynamicObject[]::new);
    }

    private DynamicObject[] queryPersonByBatch() {
        IPageCache pageCache = this.getView().getPageCache();
        String selectedRowIdStr = pageCache.getBigObject("selectedRowIds");
        List selectedRowIds = SerializationUtils.fromJsonStringToList((String)selectedRowIdStr, Long.class);
        int batchNum = 0;
        String batchs = pageCache.get("batchs");
        if (SITStringUtils.isNotEmpty((String)batchs)) {
            batchNum = Integer.parseInt(batchs);
        }
        int startIndex = batchNum * 1000;
        int endIndex = (batchNum + 1) * 1000;
        endIndex = Math.min(endIndex, selectedRowIds.size());
        List batchIds = selectedRowIds.subList(startIndex, endIndex);
        DynamicObject[] fileDys = this.fileHelper.query("person.id,employee.id,employee.empnumber,welfarepayer.placeofwelfare.id", new QFilter("id", "in", batchIds).toArray());
        HashMap<Long, Set> personPlaceMap = new HashMap<Long, Set>(16);
        HashBasedTable employeeMap = HashBasedTable.create();
        for (DynamicObject fileDy : fileDys) {
            long personId = fileDy.getLong("person.id");
            long placeId = fileDy.getLong("welfarepayer.placeofwelfare.id");
            Set placeSet = personPlaceMap.getOrDefault(personId, new HashSet(16));
            placeSet.add(placeId);
            personPlaceMap.put(personId, placeSet);
            employeeMap.put((Object)personId, (Object)placeId, (Object)fileDy.getDynamicObject("employee"));
        }
        QFilter employeeFilter = new QFilter("person", "in", personPlaceMap.keySet());
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
        DynamicObject[] persons = this.personHelper.query(BaseDataHisHelper.getSelectProperties((String)"hcsi_sinsurperson"), new QFilter[]{employeeFilter, statusFilter});
        List<DynamicObject> personList = Arrays.stream(persons).filter(ele -> {
            boolean result;
            long personId = ele.getLong("person.id");
            long placeId = ele.getLong("placeofwelfare.id");
            Set placeIds = (Set)personPlaceMap.get(personId);
            boolean bl = result = placeIds != null && placeIds.contains(placeId);
            if (result) {
                ele.set("employee", employeeMap.get((Object)personId, (Object)placeId));
            }
            return result;
        }).collect(Collectors.toList());
        pageCache.put("batchs", String.valueOf(batchNum + 1));
        return personList.toArray(new DynamicObject[0]);
    }

    static {
        areadydealProps.add("registertype");
        areadydealProps.add("category");
        areadydealProps.add("sinsuraccount");
        areadydealProps.add("housingfundac");
        areadydealProps.add("commentp");
        areadydealProps.add("bsedp");
        TEMPLATEID_MAP.put("hcsi_sinsurfile_imp", "1492790074075512832");
        TEMPLATEID_MAP.put("hcsi_sinsurfile", "1492795595725733888");
        TEMPLATEID_MAP.put("hcsi_sinsurperson", "1492796983587373056");
        PRIVACY_MAP.put("category", "hcsi_sinsurperson.category");
        PRIVACY_MAP.put("sinsuraccount", "hcsi_sinsurperson.sinsuraccount");
        PRIVACY_MAP.put("housingfundac", "hcsi_sinsurperson.housingfundac");
    }
}

