/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sit.hcsi.common.constants.SinsurFileConstants;

public class SinsurFileImportListPlugin
extends HRDataBaseList
implements SinsurFileConstants {
    private static final Log LOGGER = LogFactory.getLog(SinsurFileImportListPlugin.class);
    private static final String VAL_OVERRIDE = "new";
    private static final String VAL_OVERRIDEFILE = "overridefile";
    private static final String VAL_OVERRIDEPERSON = "overrideperson";
    private static final String CALLBACK_IMPORT = "callBack_import";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        long startTime = System.currentTimeMillis();
        super.beforeDoOperation(args);
        FormOperate fo = (FormOperate)args.getSource();
        switch (operateKey = fo.getOperateKey()) {
            case "importdatafile": {
                args.setCancel(true);
                this.showSinsurfileImpView("hcsi_sinsurfile_imp");
                break;
            }
            case "donothing_importfile": {
                args.setCancel(true);
                this.showSinsurfileImpView("hcsi_sinsurfile");
                break;
            }
            case "donothing_importperson": {
                args.setCancel(true);
                this.showSinsurfileImpView("hcsi_sinsurperson");
                break;
            }
        }
        LOGGER.info(" SinsurFileImportListPlugin run time: {}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void showSinsurfileImpView(String formId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_file_importstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)formId);
        showParameter.setCustomParam("RealPermissionEntityId", (Object)formId);
        showParameter.setCustomParam("ListName", (Object)this.getView().getFormShowParameter().getCaption());
        showParameter.setCustomParam("ImportPlugin", (Object)"kd.sit.hcsi.formplugin.web.file.SinsurFileBatchImportPlugin");
        String keyfields = VAL_OVERRIDE;
        if ("hcsi_sinsurfile".equals(formId)) {
            keyfields = VAL_OVERRIDEFILE;
        } else if ("hcsi_sinsurperson".equals(formId)) {
            keyfields = VAL_OVERRIDEPERSON;
        }
        showParameter.setCustomParam("keyfields", (Object)keyfields);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_IMPORT));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CALLBACK_IMPORT)) {
            BillList billlist = (BillList)this.getView().getControl("billlistap");
            billlist.refresh();
        }
    }
}

