/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileList
extends AbstractListPlugin
implements SinsurFileConstants {
    public static final String OP_DONOTHING_SALARYFILEHIS = "donothing_salaryfilehis";
    private static final Log LOGGER = LogFactory.getLog(SinsurFileList.class);
    private static final String BTNOK = "btnok";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"deletehisbtn", "confirmchange", "listoperatecol"});
    }

    public void beforeBindData(EventObject eventObject) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operKey = formOperate.getOperateKey()) {
            case "new": {
                args.setCancel(true);
                this.openAddNewFile();
                break;
            }
            case "audit": {
                this.getProgressBar(formOperate);
                break;
            }
            case "donothing_delete": {
                this.getProgressBar(formOperate);
                break;
            }
            case "do_changesinsurstatus": {
                args.setCancel(true);
                this.openFileChangeStatusPage();
                break;
            }
            case "donothing_salaryfilehis": {
                break;
            }
        }
    }

    private void openFileChangeStatusPage() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        String sinsurStatus = null;
        Date bsed = null;
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (ListSelectedRow row : selectedRows) {
            ids.add(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())));
        }
        DynamicObject[] fileDys = SinsurFileServiceHelper.queryFile(ids);
        ids.clear();
        for (DynamicObject fileDy : fileDys) {
            if ("C".equals(fileDy.getString("status"))) {
                ids.add(fileDy.getLong("id"));
            }
            if (sinsurStatus == null) {
                sinsurStatus = fileDy.getString("sinsurstatus");
            }
            if (sinsurStatus == null || sinsurStatus.equals(fileDy.getString("sinsurstatus"))) continue;
            sinsurStatus = null;
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u8fdb\u884c\u53c2\u4fdd\u72b6\u6001\u53d8\u66f4\u3002", (String)"SinsurFileList_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids.size() == 1) {
            bsed = fileDys[0].getDate("bsed");
        }
        this.openFileChangeStatusPageCore(sinsurStatus, bsed, ids);
    }

    private void openFileChangeStatusPageCore(String sinsurStatus, Date bsed, List<Long> ids) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_filechangestatus");
        showParameter.setHasRight(false);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("sinsurstatus", (Object)sinsurStatus);
        showParameter.setCustomParam("bsed", bsed != null ? SITDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd") : null);
        showParameter.setCustomParam("ids", (Object)SerializationUtils.toJsonString(ids));
        this.getView().showForm(showParameter);
    }

    private void getProgressBar(FormOperate formOperate) {
        OperateOption option = formOperate.getOption();
        option.setVariableValue("batchop_batchsize", "1000");
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
        LOGGER.info("------------SinsurFileList.setFilter-----------------setFilterEvent.getQFilters\uff1a{}", (Object)setFilterEvent.getQFilters());
        LOGGER.info("------------SinsurFileList.setFilter-----------------empgoupIds\uff1a{}", (Object)empgoupIds);
        BaseDataHisHelper.removeDefaultHRQFilter((IFormView)this.getView(), (List)setFilterEvent.getQFilters());
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String type = (String)showParameter.getCustomParam("f7type");
        if (SITStringUtils.isNotEmpty((String)type)) {
            setFilterEvent.getQFilters().removeIf(filter -> filter != null && ("status".equals(filter.getProperty()) && !SITStringUtils.equals((String)filter.getCP(), (String)"in") || "datastatus".equals(filter.getProperty())));
            if (SITStringUtils.equals((String)"1", (String)type)) {
                setFilterEvent.getQFilters().add(new QFilter("status", "not in", Arrays.asList("B", "E")));
            } else {
                setFilterEvent.getQFilters().add(new QFilter("status", "=", (Object)"C"));
            }
            setFilterEvent.getQFilters().add(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2", "-3")));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operKey = args.getOperateKey()) {
            case "donothing_delete": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().showSuccessNotification(args.getOperationResult().getMessage());
                }
                ((IEntityOperate)formOperate).setCancelRefresh(false);
                break;
            }
            case "audit": {
                OperationResult operationResult = args.getOperationResult();
                String message = operationResult.getMessage();
                if (!SITStringUtils.isNotEmpty((String)message) || !message.contains("sinsurfilecertwarn")) break;
                ValidateResultCollection validateResult = args.getOperationResult().getValidateResult();
                if (validateResult.isSuccess()) {
                    operationResult.setShowMessage(false);
                }
                String result = message.replace("sinsurfilecertwarn", "");
                this.getView().showSuccessNotification(result);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
    }

    private void openAddNewFile() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hcsi_sinsurfile");
        StyleCss css = new StyleCss();
        css.setWidth("1180px");
        css.setHeight("550px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setPermissionItemId("47156aff000000ac");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        showParameter.setCustomParam("customStatus", (Object)OperationStatus.ADDNEW.name());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String colKey;
        switch (colKey = args.getFieldName()) {
            case "number": {
                LOGGER.info("SinsurFileList.billListHyperLinkClick.NUMBER begin...1");
                ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                if (listShowParameter.isLookUp()) break;
                LOGGER.info("SinsurFileList.billListHyperLinkClick.NUMBER begin...2");
                this.openSalaryFileFormView(args);
                break;
            }
        }
    }

    private void openSalaryFileFormView(HyperLinkClickArgs hyperLinkClickArgs) {
        hyperLinkClickArgs.setCancel(true);
        BillList list = (BillList)hyperLinkClickArgs.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)list.getFocusRowPkId();
        this.doShowFile(pkId);
    }

    private void doShowFile(Long fileId) {
        HRBaseServiceHelper fileHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        QFilter qFilter = new QFilter("id", "=", (Object)fileId);
        DynamicObject fileDyObj = fileHelper.loadDynamicObject(qFilter);
        SinsurFileServiceHelper.openFileBase((DynamicObject)fileDyObj, (IFormView)this.getView(), (boolean)false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        switch (closedCallBackEvent.getActionId()) {
            case "addnew": {
                Long pkId = (Long)closedCallBackEvent.getReturnData();
                if (null == pkId || pkId == 0L) break;
                this.doShowFile(pkId);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "empgroup.id": 
            case "empgroup.name": {
                List empGroupFilters = args.getQfilters();
                List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
                QFilter empGroupFilter = new QFilter("id", "in", (Object)empgoupIds);
                empGroupFilters.add(empGroupFilter);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "empgroup.name": {
                List empGroupFilters = args.getQFilters();
                List empgoupIds = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcsi");
                QFilter empGroupFilter = new QFilter("id", "in", (Object)empgoupIds);
                empGroupFilters.add(empGroupFilter);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        BillList bill;
        ListSelectedRowCollection selectedRows;
        super.beforeClick(evt);
        Button bt = (Button)evt.getSource();
        String key = bt.getKey();
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (BTNOK.equals(key) && SITStringUtils.isNotEmpty((String)parentFormId) && ("hcsi_genbasepre".equals(parentFormId) || "hcsi_surbaseimport".equals(parentFormId)) && (selectedRows = (bill = (BillList)this.getView().getControl(BILLLISTAP)).getSelectedRows()) != null && selectedRows.size() > 5000) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e95000\u6761\u6570\u636e\u3002", (String)"SinsurFileList_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
        }
    }
}

