/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.constants.SinsurFileConstants;
import kd.sit.sitbp.common.util.SITImageUrlUtil;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinsurFileSummaryPlugin
extends AbstractFormPlugin
implements SinsurFileConstants {
    private static final Log LOG = LogFactory.getLog(SinsurFileSummaryPlugin.class);
    private static final String SELECT_SALARY_FILE_PROPS = "person.name,person.id,employee.id,employee.empnumber,name,status,empgroup,org,manageregion,welfarepayer.name,welfarepayer.placeofwelfare.name";

    public void beforeBindData(EventObject eventObject) {
        this.setTipsForPerson();
        this.getView().setVisible(Boolean.FALSE, new String[]{"laborreltype", "laborrelstatus"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"vectorapcompany", "company", "vectorapadminorg", "adminorg", "vectorapworkplace", "workplacelabelap"});
        FormShowParameter params = this.getView().getFormShowParameter();
        Long fileId = (Long)params.getCustomParam("sinsur_file_vid");
        if (fileId == null || fileId == 0L) {
            fileId = (Long)params.getCustomParam("sinsur_file_id");
        }
        if (null != fileId) {
            DynamicObject fileDyObj = this.getFileObj(fileId);
            this.setFieldValue(fileDyObj);
            this.setStatusImg(fileDyObj.getString("status"));
        } else {
            Long employeeId = (Long)params.getCustomParam("employeeId");
            if (null != employeeId) {
                this.setFieldValueByEmployee(employeeId);
            }
        }
    }

    private void setTipsForPerson() {
        String sign = "vectorapcompany";
        this.setTips(sign, this.getControlName(sign));
        sign = "vectorapadminorg";
        this.setTips(sign, this.getControlName(sign));
        sign = "vectorapworkplace";
        this.setTips(sign, this.getControlName(sign));
    }

    private String getControlName(String key) {
        HashMap<String, String> controlNameMap = new HashMap<String, String>(16);
        String org = ResManager.loadKDString((String)"\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7", (String)"SinsurFileSummaryPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String welfarepayer = ResManager.loadKDString((String)"\u5b9e\u9645\u53c2\u4fdd\u5355\u4f4d", (String)"SinsurFileSummaryPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        String workplace = ResManager.loadKDString((String)"\u53c2\u4fdd\u5730", (String)"SinsurFileSummaryPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        controlNameMap.put("vectorapadminorg", org);
        controlNameMap.put("vectorapcompany", welfarepayer);
        controlNameMap.put("vectorapworkplace", workplace);
        return (String)controlNameMap.get(key);
    }

    private void setTips(String key, String content) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(key);
        Tips ctlTips = new Tips();
        ctlTips.setType("text");
        ctlTips.setContent(new LocaleString(content));
        ctlTips.setShowIcon(false);
        vectorAp.setCtlTips(ctlTips);
        this.getView().updateControlMetadata(key, vectorAp.createControl());
    }

    private void setStatusImg(String status) {
        if (null != status) {
            switch (status) {
                case "A": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"savelabelap"});
                    break;
                }
                case "B": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap"});
                    break;
                }
                case "C": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"auditlabelap"});
                    break;
                }
                case "E": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"obsoletelabelap"});
                    break;
                }
            }
        }
    }

    private DynamicObject getFileObj(Object fileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcsi_sinsurfile");
        return serviceHelper.queryOne(SELECT_SALARY_FILE_PROPS, fileId);
    }

    private void setFieldValue(DynamicObject fileDyObj) {
        if (null == fileDyObj) {
            return;
        }
        IFormView formView = this.getView();
        this.setLabelValue("name", fileDyObj.getString("name"), formView);
        this.setLabelValue("empnumber", String.valueOf(fileDyObj.get("employee.empnumber")), formView);
        this.setLabelValueGroup("vectorapadminorg", "adminorg", fileDyObj.getString("org.name"), formView);
        this.setLabelValueGroup("vectorapcompany", "company", fileDyObj.getString("welfarepayer.name"), formView);
        this.setLabelValueGroup("vectorapworkplace", "workplacelabelap", fileDyObj.getString("welfarepayer.placeofwelfare.name"), formView);
        this.setFieldValueByEmployee(fileDyObj.getLong("employee.id"));
    }

    private void setFieldValueByEmployee(long employeeId) {
        IFormView formView = this.getView();
        Map employeeMap = SinsurFileServiceHelper.queryEmployeeById((Long)employeeId);
        if (null != employeeMap) {
            Map empentrelObj;
            Map personMap = SinsurFileServiceHelper.queryPersonById((Long)((Long)employeeMap.get("person_id")));
            if (null != personMap) {
                this.setPortrait(String.valueOf(personMap.get("headsculpture")));
            }
            if (null != (empentrelObj = SinsurFileServiceHelper.queryPersonEmpentrelByEmployeeId((Long)employeeId))) {
                this.setLabelValue("laborreltype", String.valueOf(empentrelObj.get("laborreltype")), formView);
                this.setLabelValue("laborrelstatus", String.valueOf(empentrelObj.get("laborrelstatus")), formView);
            }
        }
    }

    private void setPortrait(String portraitUrl) {
        Image portrait = (Image)this.getControl("headsculpture");
        LOG.info("SinsurFileSummaryPlugin.setPortrait...{}...", (Object)portraitUrl);
        if (null != portraitUrl && !"".equals(portraitUrl.trim()) && !"/images/pc/emotion/default_person_82_82.png".equals(portraitUrl)) {
            portrait.setUrl(SITImageUrlUtil.getImageFullUrl((String)portraitUrl));
        } else {
            portrait.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
    }

    private void setLabelValue(String fieldKey, String value, IFormView formView) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SITStringUtils.isEmpty((String)value)) {
            label.setText(value);
            formView.setVisible(Boolean.TRUE, new String[]{fieldKey});
        }
    }

    private void setLabelValueGroup(String icon, String fieldKey, String value, IFormView formView) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SITStringUtils.isEmpty((String)value)) {
            label.setText(value);
            formView.setVisible(Boolean.TRUE, new String[]{icon, fieldKey});
        }
    }
}

