/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file.attach;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class SelectCoandDimRefPlugin
extends AbstractFormPlugin
implements SITBaseConstants {
    public static final String COAND_DIM_REF = "coanddimref";
    public static final String ENTRY_WELFARE_PAYER = "entrywelfarepayer";
    public static final String WELFARE_PAYER = "welfarepayer";
    public static final String SIN_SUR_STD = "sinsurstd";
    public static final String ENTRY_BSED = "entrybsed";
    public static final String ENTRY_BSLED = "entrybsled";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Date bsed = new Date();
        this.getModel().setValue("bsed", (Object)bsed);
        this.createEntry(bsed);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        Long sinSurStdId = (Long)this.getView().getFormShowParameter().getCustomParam(SIN_SUR_STD);
        if (sinSurStdId != null && sinSurStdId > 0L) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < entryEntity.size(); ++index) {
                if (sinSurStdId.longValue() != ((DynamicObject)entryEntity.get(index)).getLong("sinsurstd.id")) continue;
                AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
                grid.selectRows(index);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey;
        ChangeData[] changeSet = event.getChangeSet();
        switch (fieldKey = event.getProperty().getName()) {
            case "bsed": {
                Date newBsed = (Date)changeSet[0].getNewValue();
                if (newBsed != null) {
                    this.createEntry(newBsed);
                    break;
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.deleteEntryData("entryentity");
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)"btnok", (String)key)) {
            int currentRowIndex = this.getCurrentRowIndex();
            if (currentRowIndex >= 0) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
                DynamicObject sinSurStd = entryRowEntity.getDynamicObject(SIN_SUR_STD);
                DynamicObject coanddimRef = entryRowEntity.getDynamicObject(COAND_DIM_REF);
                HashMap<String, Object> returnData = new HashMap<String, Object>(16);
                returnData.put(COAND_DIM_REF, coanddimRef.getPkValue());
                returnData.put(SIN_SUR_STD, sinSurStd.getPkValue());
                this.getView().returnDataToParent(returnData);
            }
            this.getView().close();
        }
    }

    private int getCurrentRowIndex() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("entryentity").getSelectedRows();
        if (rowIndexs.length == 0) {
            return -1;
        }
        return rowIndexs[0];
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void createEntry(Date bsed) {
        Long welfarePayerId = (Long)this.getView().getFormShowParameter().getCustomParam(WELFARE_PAYER);
        DynamicObject dynamicObject = SinSurFileStdServiceHelper.queryCoandDimRef((Date)bsed, (Long)welfarePayerId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (dynamicObject == null) {
            model.endInit();
            this.getView().updateView("entryentity");
            return;
        }
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField(COAND_DIM_REF, new Object[0]);
        entry.addField(ENTRY_WELFARE_PAYER, new Object[0]);
        entry.addField(SIN_SUR_STD, new Object[0]);
        entry.addField(ENTRY_BSED, new Object[0]);
        entry.addField(ENTRY_BSLED, new Object[0]);
        entry.addField("datastatus", new Object[0]);
        entry.addField("creator", new Object[0]);
        entry.addField("createtime", new Object[0]);
        entry.addField("modifier", new Object[0]);
        entry.addField("modifytime", new Object[0]);
        DynamicObject welfarePayer = dynamicObject.getDynamicObject(WELFARE_PAYER);
        bsed = dynamicObject.getDate("bsed");
        Date bsled = dynamicObject.getDate("bsled");
        String dataStatus = dynamicObject.getString("datastatus");
        Long creator = dynamicObject.getLong("creator.id");
        Date createTime = dynamicObject.getDate("createtime");
        Long modifier = dynamicObject.getLong("modifier.id");
        Date modifyTime = dynamicObject.getDate("modifytime");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("mulsinsurstd");
        for (DynamicObject object : dynamicObjectCollection) {
            entry.addRow(new Object[]{dynamicObject.getPkValue(), welfarePayer.getPkValue(), object.getLong("fbasedataid.id"), bsed, bsled, dataStatus, creator, createTime, modifier, modifyTime});
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

