/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file.attach;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseHelper;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinSurBaseImportProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(SinSurBaseImportProcessPlugin.class);
    private static final String KEY_BTN_ERRORDETAIL = "errordetail";
    private static final String KEY_BTN_VIEWLOG = "viewlog";
    private static final String WAIT = "wait";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String KEY_PANEL_FINISH = "panelfinish";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";
    private static final String KEY_PROGRESSBARAP = "progressbarap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String KEY_PANEL_HANDLING = "panelhandling";
    private static final String KEY_TIMELABEL = "timelabel";

    public void afterBindData(EventObject event) {
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
            progressBar.setPercent(100);
            ISITAppCache appCache = this.getAppCache();
            int fail = (Integer)appCache.get("failCount", Integer.class);
            this.setFormInfo(null);
            this.setStopProgressFormInfo(fail);
            return;
        }
        this.startTask();
    }

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_ERRORDETAIL, KEY_BTN_VIEWLOG});
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PANEL_FINISH, BTN_CANCEL, KEY_BTN_VIEWLOG, KEY_BTN_ERRORDETAIL});
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SITStringUtils.equals((String)progressKey, (String)KEY_PROGRESSBARAP)) {
            this.setFormInfo(progressEvent);
        }
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if (KEY_BTN_ERRORDETAIL.equals(controlKey)) {
            ISITAppCache appCache = this.getAppCache();
            String errFilePath = (String)appCache.get("importErrorFilePath", String.class);
            if (StringUtils.isNotBlank((CharSequence)errFilePath)) {
                this.getView().download(errFilePath);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SinSurBaseImportingPlugin_8", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            }
        } else if (KEY_BTN_VIEWLOG.equals(controlKey)) {
            FormShowParameter params = this.getView().getFormShowParameter();
            Object logId = params.getCustomParam("logId");
            BaseShowParameter show = new BaseShowParameter();
            show.setFormId("hcsi_surbaseimportlog");
            show.setPkId(logId);
            show.setStatus(OperationStatus.VIEW);
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showForm((FormShowParameter)show);
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        ISITAppCache appCache = this.getAppCache();
        String sinSurBaseImportSuccess = (String)appCache.get("sinSurBaseImportSuccess", String.class);
        String floatingTaskId = (String)appCache.get("floatingTaskId", String.class);
        if (HRStringUtils.isEmpty((String)sinSurBaseImportSuccess)) {
            if (HRStringUtils.isNotEmpty((String)floatingTaskId)) {
                HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getView().getMainView(), floatingTaskId);
                HRBackgroundTaskHelper.getInstance().showBaskgroundTask(floatingTaskId);
            }
        } else {
            if (HRStringUtils.isNotEmpty((String)floatingTaskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "COMPLETED");
            }
            appCache.clear();
        }
    }

    private void setFormInfo(ProgressEvent progressEvent) {
        ISITAppCache appCache = this.getAppCache();
        Integer fail = (Integer)appCache.get("failCount", Integer.class);
        Integer total = (Integer)appCache.get("totalCount", Integer.class);
        Integer success = (Integer)appCache.get("successCount", Integer.class);
        Date startTime = (Date)appCache.get("startTime", Date.class);
        String sinSurBaseImportSuccess = (String)appCache.get("sinSurBaseImportSuccess", String.class);
        Date endTime = new Date();
        if (HRStringUtils.isNotEmpty((String)sinSurBaseImportSuccess)) {
            endTime = (Date)appCache.get("endTime", Date.class);
        }
        int finish = success + fail;
        int wait = total - finish;
        if (wait < 0) {
            wait = 0;
        }
        Label labelWait = (Label)this.getView().getControl(WAIT);
        labelWait.setText(String.valueOf(wait));
        Label labelSuccess = (Label)this.getView().getControl(SUCCESS);
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl(FAIL);
        labelFail.setText(String.valueOf(fail));
        Label labelTime = (Label)this.getView().getControl(KEY_TIMELABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SITDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u8017\u65f6{0}", (String)"LoadingCalculationPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), consumeTime);
        labelTime.setText(msg);
        int percentage = 0;
        Label labelPercentage = (Label)this.getView().getControl(PROGRESS_NUM_LABEL);
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            labelPercentage.setText("100");
            return;
        }
        if (HRStringUtils.isNotEmpty((String)sinSurBaseImportSuccess)) {
            labelPercentage.setText("100");
            percentage = 100;
        } else if (total > 0) {
            percentage = new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
            labelPercentage.setText(String.valueOf(percentage));
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
            if (percentage >= 100) {
                this.stopProgress(fail, progressEvent);
            }
        }
    }

    private void stopProgress(int fail, ProgressEvent progressEvent) {
        this.setStopProgressFormInfo(fail);
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
    }

    private void setStopProgressFormInfo(int fail) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_PANEL_HANDLING});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, KEY_PANEL_FINISH, KEY_BTN_VIEWLOG});
        if (fail > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_ERRORDETAIL});
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private ISITAppCache getAppCache() {
        FormShowParameter params = this.getView().getFormShowParameter();
        Object logId = params.getCustomParam("logId");
        return SITAppCache.get((String)SinSurFileBaseHelper.getAppCacheKey((Object)logId));
    }
}

