/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file.attach;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.url.UrlService;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseImportAddExcelColumnEvent;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.SinsurBaseImportService;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinSurBaseListImportPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
UploadListener {
    private static final Log log = LogFactory.getLog(SinSurBaseListImportPlugin.class);
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_DOWNLOAD = "btndownload";
    private static final String KEY_BTN_RESETFILE = "btnresetfile";
    private static final String KEY_BTN_UPLOAD = "btnupload";
    private static final String KEY_BTN_RADIOGROUPFIELD = "radiogroupfield";
    private static final String KEY_WELFAREPAYER = "welfarepayer";
    private static final String KEY_COANDDIMREF = "coanddimref";
    private static final String KEY_SIN_SUR_STD = "sinsurstd";
    private static final String KEY_SIN_SUR_FILE = "mulfile";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit welfarepayer = (BasedataEdit)this.getView().getControl(KEY_WELFAREPAYER);
        welfarepayer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit coanddimref = (BasedataEdit)this.getView().getControl(KEY_COANDDIMREF);
        coanddimref.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulfile = (BasedataEdit)this.getView().getControl(KEY_SIN_SUR_FILE);
        mulfile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_DOWNLOAD, KEY_BTN_RESETFILE});
        Image label = (Image)this.getControl(KEY_BTN_UPLOAD);
        label.addUploadListener((UploadListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "welfarepayer": {
                ListShowParameter param;
                if (SITPermissionServiceHelper.isSuperUser()) break;
                if (!SITPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)"47150e89000000ac")) {
                    ListShowParameter param2 = (ListShowParameter)event.getFormShowParameter();
                    param2.getListFilterParameter().setFilter(new QFilter("1", "!=", (Object)1));
                    return;
                }
                QFilter dataRuleForBdProp = SITPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurfile", (String)KEY_WELFAREPAYER, (String)"47150e89000000ac");
                HasPermOrgResult hasPermOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurbase", (String)"4730fc9f000003ae");
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    log.info("hasPermOrgResult:{}", (Object)hasPermOrgResult.getHasPermOrgs().toString());
                    if (dataRuleForBdProp != null) {
                        dataRuleForBdProp.and("org", "in", (Object)hasPermOrgResult.getHasPermOrgs());
                    } else {
                        param = (ListShowParameter)event.getFormShowParameter();
                        param.getListFilterParameter().setFilter(new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
                    }
                }
                log.info("welfarepayerIds:{}", (Object)dataRuleForBdProp);
                if (dataRuleForBdProp == null) break;
                param = (ListShowParameter)event.getFormShowParameter();
                param.getListFilterParameter().setFilter(dataRuleForBdProp);
                break;
            }
            case "coanddimref": {
                event.setCancel(true);
                Long welfarepayerId = this.getModel().getDataEntity().getLong("welfarepayer.id");
                if (welfarepayerId > 0L) {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId("hcsi_selectcoanddimfef");
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCustomParam(KEY_WELFAREPAYER, (Object)welfarepayerId);
                    long sinSurStdId = this.getModel().getDataEntity().getLong("sinsurstd.id");
                    if (sinSurStdId > 0L) {
                        formShowParameter.setCustomParam(KEY_SIN_SUR_STD, (Object)sinSurStdId);
                    }
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcsi_selectcoanddimfef"));
                    this.getView().showForm(formShowParameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u4fdd\u5355\u4f4d\u3002", (String)"SinSurBaseListImportPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mulfile": {
                HasPermOrgResult hasPermOrgResult;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String type = dataEntity.getString(KEY_BTN_RADIOGROUPFIELD);
                long choosedwelfarepayerId = dataEntity.getLong("welfarepayer.id");
                boolean check = this.checkWelfarePayerIdMustInput(choosedwelfarepayerId, this.getView(), type);
                if (!check) {
                    event.setCancel(true);
                    return;
                }
                List authorizedDataRuleQFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"hcsi", (String)"hcsi_sinsurfile", (String)"47150e89000000ac");
                if (authorizedDataRuleQFilter == null) {
                    event.addCustomQFilter(new QFilter("1", "!=", (Object)1));
                } else if (authorizedDataRuleQFilter.size() > 0) {
                    for (QFilter filter : authorizedDataRuleQFilter) {
                        if (filter == null) continue;
                        event.addCustomQFilter(filter);
                    }
                }
                if (choosedwelfarepayerId > 0L) {
                    event.addCustomQFilter(new QFilter("welfarepayer.id", "=", (Object)choosedwelfarepayerId));
                }
                if (!SITStringUtils.equals((String)"1", (String)type) && !(hasPermOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurbase", (String)"4730fc9f000003ae")).hasAllOrgPerm()) {
                    event.addCustomQFilter(new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
                }
                event.getFormShowParameter().setCustomParam("f7type", (Object)type);
                break;
            }
        }
    }

    public void afterBindData(EventObject event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap17", "filepanel"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "radiogroupfield": {
                String value = (String)this.getModel().getValue(propertyName);
                if (SITStringUtils.equals((String)"2", (String)value)) {
                    this.setTips(ResManager.loadKDString((String)"\u4ec5\u4e3a\u4eba\u5458\u793e\u4fdd\u6863\u6848\u66f4\u65b0\u9669\u79cd\u57fa\u6570\u3002", (String)"SinSurBaseListImportPlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    ((FieldEdit)this.getControl(KEY_WELFAREPAYER)).setMustInput(false);
                    ((FieldEdit)this.getControl(KEY_COANDDIMREF)).setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap17"});
                    this.getModel().setValue(KEY_WELFAREPAYER, null);
                    this.getModel().setValue(KEY_COANDDIMREF, null);
                    this.getModel().setValue(KEY_SIN_SUR_STD, null);
                    this.getModel().setValue(KEY_SIN_SUR_FILE, null);
                    break;
                }
                if (!SITStringUtils.equals((String)"1", (String)value)) break;
                this.setTips(ResManager.loadKDString((String)"\u4e3a\u6307\u5b9a\u7684\u53c2\u4fdd\u5355\u4f4d\u4e2d\u7684\u4eba\u5458\u793e\u4fdd\u6863\u6848\u65b0\u589e\u6216\u66f4\u65b0\u53c2\u4fdd\u6807\u51c6\u4ee5\u53ca\u9669\u79cd\u57fa\u6570\u8bbe\u7f6e\u3002", (String)"SinSurBaseListImportPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap9"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap17"});
                ((FieldEdit)this.getControl(KEY_WELFAREPAYER)).setMustInput(true);
                ((FieldEdit)this.getControl(KEY_COANDDIMREF)).setMustInput(true);
                break;
            }
            case "welfarepayer": {
                this.getModel().setValue(KEY_SIN_SUR_STD, null);
                this.getModel().setValue(KEY_COANDDIMREF, null);
                this.getModel().setValue(KEY_SIN_SUR_FILE, null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long welfarepayerId = dataEntity.getLong("welfarepayer.id");
        long coanddimrefId = dataEntity.getLong("coanddimref.id");
        long sinSurStdId = dataEntity.getLong("sinsurstd.id");
        IFormView view = this.getView();
        String type = dataEntity.getString(KEY_BTN_RADIOGROUPFIELD);
        switch (key) {
            case "btndownload": {
                String url;
                boolean check1;
                boolean check2 = this.checkWelfarePayerIdMustInput(welfarepayerId, view, type);
                if (!check2 || !(check1 = this.checkCoanddimrefIdMustInput(coanddimrefId, view, type))) break;
                SinsurBaseImportService service = new SinsurBaseImportService();
                ArrayList<Long> fileIds = new ArrayList<Long>(10);
                DynamicObjectCollection files = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_SIN_SUR_FILE);
                if (files != null) {
                    for (DynamicObject file : files) {
                        fileIds.add(file.getLong("fbasedataid_id"));
                    }
                }
                if (!SITStringUtils.isNotEmpty((String)(url = service.exportStdBaseExcelTemplate(fileIds, welfarepayerId, coanddimrefId, sinSurStdId, true, type)))) break;
                view.download(url);
                break;
            }
            case "btnresetfile": {
                this.resetFileInfo();
                break;
            }
            case "btnok": {
                this.importData(type, welfarepayerId, coanddimrefId, sinSurStdId);
                break;
            }
        }
    }

    private boolean checkWelfarePayerIdMustInput(long welfarepayerId, IFormView view, String type) {
        if (welfarepayerId == 0L && SITStringUtils.equals((String)"1", (String)type)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u4fdd\u5355\u4f4d\u3002", (String)"SinSurBaseListImportPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCoanddimrefIdMustInput(long coanddimrefId, IFormView view, String type) {
        if (coanddimrefId == 0L && SITStringUtils.equals((String)"1", (String)type)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u53c2\u4fdd\u6807\u51c6\u3002", (String)"SinSurBaseListImportPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void upload(UploadEvent evt) {
        Object[] urls;
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String type = dataEntity.getString(KEY_BTN_RADIOGROUPFIELD);
        long welfarepayerId = dataEntity.getLong("welfarepayer.id");
        long sinSurStdId = dataEntity.getLong("sinsurstd.id");
        if (SITStringUtils.equals((String)"1", (String)type)) {
            if (welfarepayerId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53c2\u4fdd\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SinSurBaseListImportPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                return;
            }
            if (sinSurStdId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53c2\u4fdd\u6807\u51c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SinSurBaseListImportPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ((urls = evt.getUrls()).length > 0) {
            String url = (String)urls[0];
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            String fullUrl = UrlService.getAttachmentFullUrl((String)url);
            model.setValue("filepath", (Object)url);
            model.setValue("fullpath", (Object)fullUrl);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hcsi_selectcoanddimfef": {
                Map coanddimRefReturnData = (Map)event.getReturnData();
                if (coanddimRefReturnData == null) break;
                this.getModel().setValue(KEY_COANDDIMREF, coanddimRefReturnData.get(KEY_COANDDIMREF));
                this.getModel().setValue(KEY_SIN_SUR_STD, coanddimRefReturnData.get(KEY_SIN_SUR_STD));
                this.getView().updateView(KEY_COANDDIMREF);
                break;
            }
        }
    }

    private void setTips(String msg) {
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(msg));
        Label control = (Label)this.getControl("labelap");
        control.addTips(tips);
    }

    private void resetFileInfo() {
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
    }

    private void importData(String type, long welfarepayerId, long coanddimrefId, long sinSurStdId) {
        if (!SITPermissionServiceHelper.hasPermByPermItemNum((long)RequestContext.get().getCurrUserId(), (String)"hcsi_sinsurbase", (String)"QXX0020")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u793e\u4fdd\u57fa\u6570\u8bbe\u7f6e\u7684\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7533\u8bf7\u6743\u9650\u3002", (String)"SinSurBaseImportingPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = this.getModel().getDataEntity().getString("filepath");
        String fullPath = (String)this.getModel().getValue("fullpath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c", (String)"SinSurBaseImportingPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String checkMsg = this.checkExcel(url, type, coanddimrefId, sinSurStdId);
        if (SITStringUtils.isNotEmpty((String)checkMsg)) {
            this.getView().showErrorNotification(checkMsg);
            return;
        }
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
        returnData.put("isOk", Boolean.TRUE);
        returnData.put("url", url);
        returnData.put("fullPath", fullPath);
        returnData.put("type", type);
        returnData.put("coanddimrefId", coanddimrefId);
        returnData.put("welfarepayerId", welfarepayerId);
        returnData.put("sinSurStdId", sinSurStdId);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    public String checkExcel(String url, final String type, long coanddimrefId, long sinSurStdId) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        final HashMap<String, Integer> typeHeaderRowMap = new HashMap<String, Integer>(2);
        typeHeaderRowMap.put("1", 6);
        typeHeaderRowMap.put("2", 4);
        final ArrayList dataHead = Lists.newArrayListWithCapacity((int)10);
        final ArrayList dataRow = Lists.newArrayListWithCapacity((int)10);
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    Map data = row.getData();
                    if (data != null && data.size() > 0) {
                        if (row.getRowNum() < (Integer)typeHeaderRowMap.get(type)) {
                            dataHead.add(data);
                        } else {
                            dataRow.add(data);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        if (dataHead.size() < (Integer)typeHeaderRowMap.get(type)) {
            return ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"SinSurBaseImportingPlugin_12", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        }
        if (dataRow.size() == 0) {
            return ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"SinSurBaseImportingPlugin_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        }
        SinsurBaseImportService importService = new SinsurBaseImportService();
        HashMap descMap = new HashMap(2);
        List headerList = importService.getHeaderListByType(coanddimrefId, sinSurStdId, type, descMap);
        String checkMsg = this.checkHeaderNumberAndName(dataHead, headerList, type);
        if (!SITStringUtils.isEmpty((String)checkMsg)) {
            return ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"SinSurBaseImportingPlugin_12", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkHeaderNumberAndName(List<Map<Integer, String>> excelHeaderList, List<List<Map<String, Object>>> headerDataList, String type) {
        Map<Integer, String> excelHeaderNameMap;
        Map<Integer, String> excelHeaderNumberMap;
        List<Map<String, Object>> headerNumberList = headerDataList.get(0);
        List<Map<String, Object>> headerNameList = headerDataList.get(1);
        if (SITStringUtils.equals((String)"1", (String)type)) {
            excelHeaderNumberMap = excelHeaderList.get(4);
            excelHeaderNameMap = excelHeaderList.get(5);
        } else {
            SinSurFileBaseImportAddExcelColumnEvent sinSurFileBaseImportAddExcelColumnEvent = new SinSurFileBaseImportAddExcelColumnEvent(headerDataList);
            SinSurFileStdServiceHelper.addExcelColumn((SinSurFileBaseImportAddExcelColumnEvent)sinSurFileBaseImportAddExcelColumnEvent);
            excelHeaderNumberMap = excelHeaderList.get(2);
            excelHeaderNameMap = excelHeaderList.get(3);
        }
        String errMsg = this.checkHeader(headerNumberList, excelHeaderNumberMap);
        if (!SITStringUtils.isEmpty((String)errMsg)) {
            return errMsg;
        }
        errMsg = this.checkHeader(headerNameList, excelHeaderNameMap);
        if (!SITStringUtils.isEmpty((String)errMsg)) {
            return errMsg;
        }
        return errMsg;
    }

    private String checkHeader(List<Map<String, Object>> headerDataList, Map<Integer, String> excelHeaderMap) {
        String errMsg = "";
        if (excelHeaderMap == null) {
            errMsg = ResManager.loadKDString((String)"\u8868\u5934\u4e3a\u7a7a\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"SinSurBaseImportingPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            return errMsg;
        }
        if (excelHeaderMap.size() != headerDataList.size()) {
            errMsg = ResManager.loadKDString((String)"\u6a21\u677f\u9519\u8bef\u3002", (String)"SinSurBaseImportingPlugin_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            return errMsg;
        }
        for (Map.Entry<Integer, String> entry : excelHeaderMap.entrySet()) {
            String name;
            Integer index = entry.getKey();
            String value = entry.getValue();
            String string = name = value.startsWith("*") ? value.substring(1) : value;
            if (index >= headerDataList.size()) {
                errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8868\u5934\u201c{0}\u201d\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"SinSurBaseImportingPlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), value);
                return errMsg;
            }
            Map<String, Object> dataMap = headerDataList.get(index);
            if (dataMap != null && SITStringUtils.equals((String)(dataMap.get("value") + ""), (String)name)) continue;
            errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8868\u5934\u201c{0}\u201d\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"SinSurBaseImportingPlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), value);
            return errMsg;
        }
        return errMsg;
    }
}

