/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file.attach;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.ComboProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseImportAddExcelColumnEvent;
import kd.sit.hcsi.business.file.HcsiSinsurBaseImportLogHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.SinsurBaseImportService;
import kd.sit.hcsi.business.file.attach.SinSurFileBaseHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.util.SITListUtil;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.datatype.DoubleConverter;

public class SinSurBaseListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(SinSurBaseListPlugin.class);
    private Map<Object, Map<String, String>> SIN_SUR_BASE_INSURENCE_PROP_VALUE = new HashMap<Object, Map<String, String>>(16);
    private static Map<String, Integer> typeHeaderRowMap = new HashMap<String, Integer>(2);

    public void setFilter(SetFilterEvent setFilterEvent) {
        List hasPermOrgs;
        HasPermOrgResult permOrgs;
        List qFilters = setFilterEvent.getQFilters();
        if (qFilters == null) {
            return;
        }
        BaseDataHisHelper.removeDefaultHRQFilter((IFormView)this.getView(), (List)qFilters);
        Long sinSurFileId = (Long)this.getView().getFormShowParameter().getCustomParam("sinsur_file_id");
        if (sinSurFileId != null && sinSurFileId != 0L) {
            qFilters.add(new QFilter("sinsurfile", "=", (Object)sinSurFileId));
        }
        if ((permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"31", (String)"2AXKDRPJUQ77", (String)"hcsi_sinsurbase", (String)"47150e89000000ac")) != null && !permOrgs.hasAllOrgPerm() && (hasPermOrgs = permOrgs.getHasPermOrgs()) != null && hasPermOrgs.size() > 0) {
            qFilters.add(new QFilter("sinsurfile.org", "in", (Object)hasPermOrgs));
        }
        setFilterEvent.setOrderBy("sinsurfile.number asc,welfaretype.name desc,hisversion desc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "sinsurfile.org.id": {
                HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)"hcsi", (String)"hcsi_sinsurfile");
                if (permOrgs.hasAllOrgPerm()) break;
                args.getQfilters().add(new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
                break;
            }
            case "sinsurfile.welfarepayer.id": {
                Set welfarePayerSetByPermItem = SITPermissionServiceHelper.getWelfarePayerSetByPermItem((String)"hcsi", (String)"hcsi_sinsurfile");
                if (welfarePayerSetByPermItem == null || welfarePayerSetByPermItem.size() <= 0) break;
                args.getQfilters().add(new QFilter("id", "in", (Object)welfarePayerSetByPermItem));
                break;
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        boolean isHisList;
        super.beforeCreateListColumns(args);
        if (!this.isLookup() && (isHisList = this.isHisList(this.getView()))) {
            this.removeOperationColumn(args);
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirmchange", "deletehisbtn"});
            if (BaseDataHisHelper.isHisList((IFormView)this.getView()) && this.getView().getFormShowParameter().getCustomParam("removeHrDatastatusFilter") != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tblclosehis"});
            }
        }
        List columnList = args.getListColumns();
        for (IListColumn iListColumn : columnList) {
            iListColumn.setOrder(SortType.NotOrder.name());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (HRStringUtils.equals((String)option, (String)"showhisversion") && BaseDataHisHelper.isHisList((IFormView)this.getView()) && this.getView().getFormShowParameter().getCustomParam("removeHrDatastatusFilter") == null) {
            List filterColumns = args.getCommonFilterColumns();
            filterColumns.clear();
            CommonFilterColumn filterColumn = new CommonFilterColumn();
            filterColumn.setFieldName("datastatus");
            filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7248\u672c\u72b6\u6001", (String)"HisLineTimeTplListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            ArrayList combos = new ArrayList(10);
            List valueMapItemList = ((ComboProp)EntityMetadataCache.getDataEntityType((String)parameter.getBillFormId()).getFields().get("datastatus")).getComboItems();
            valueMapItemList.forEach(valueMapItem -> {
                ComboItem item = new ComboItem();
                item.setCaption(valueMapItem.getName());
                item.setValue(valueMapItem.getValue());
                combos.add(item);
            });
            filterColumn.setComboItems(combos);
            ArrayList defaultValues = Lists.newArrayListWithCapacity((int)16);
            defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue());
            defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
            defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue());
            filterColumn.setDefaultValues((List)defaultValues);
            filterColumn.setMulti(true);
            filterColumn.setMustInput(false);
            filterColumn.setCustom(true);
            filterColumns.add(filterColumn);
            if (Objects.nonNull(this.getPageCache().get("customfilter"))) {
                this.getPageCache().remove("customfilter");
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection dynamicObjectCollection = event.getPageData();
        ArrayList<Object> sinSurBaseIds = new ArrayList<Object>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            sinSurBaseIds.add(dynamicObject.getLong("id"));
        }
        long startTime = System.currentTimeMillis();
        this.getInsurencePropValue(sinSurBaseIds);
        long endTime = System.currentTimeMillis();
        LOGGER.info("\u9669\u79cd\u57fa\u6570\u8bbe\u7f6e\u5217\u8868\u52a0\u8f7d\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
    }

    public void packageData(PackageDataEvent event) {
        String fieldKey;
        super.packageData(event);
        DynamicObject rowData = event.getRowData();
        Object pkValue = rowData.getPkValue();
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        switch (fieldKey = columnDesc.getFieldKey()) {
            case "personalcontribution": 
            case "companycontribution": {
                String insurencePropValue = this.SIN_SUR_BASE_INSURENCE_PROP_VALUE.get(pkValue).get(fieldKey);
                if (HRStringUtils.isEmpty((String)insurencePropValue)) {
                    event.setFormatValue(null);
                    break;
                }
                DoubleConverter doubleConverter = new DoubleConverter();
                event.setFormatValue((Object)doubleConverter.format(doubleConverter.convert((Object)insurencePropValue), "###,##0.00"));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_import": {
                this.openImportView();
                break;
            }
            case "donothing_importlog": {
                this.openImportLogView();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hcsi_surbaseimport": {
                Map returnData = (Map)event.getReturnData();
                if (event.getReturnData() == null || !((Boolean)returnData.get("isOk")).booleanValue()) break;
                String url = String.valueOf(returnData.get("url"));
                String fullPath = String.valueOf(returnData.get("fullPath"));
                String type = String.valueOf(returnData.get("type"));
                Long coanddimrefId = (Long)returnData.get("coanddimrefId");
                Long sinSurStdId = (Long)returnData.get("sinSurStdId");
                ArrayList dataHead = Lists.newArrayListWithCapacity((int)10);
                ArrayList dataRows = Lists.newArrayListWithCapacity((int)10);
                this.readExcelData(url, dataHead, dataRows, type);
                SinsurBaseImportService importService = new SinsurBaseImportService();
                HashMap<String, String> descMap = new HashMap<String, String>(2);
                HashMap columnWelfareTypeIdMap = new HashMap(16);
                HashMap<String, Long> sinsurWelfareDyMap = new HashMap(16);
                if (SITStringUtils.equals((String)"1", (String)type)) {
                    sinsurWelfareDyMap = importService.assembleSinsurWelfareDyMap(sinSurStdId, coanddimrefId, columnWelfareTypeIdMap);
                }
                List<Map<String, String>> errDataList = Collections.synchronizedList(new ArrayList(10));
                List headerList = importService.getHeaderListByType(coanddimrefId.longValue(), sinSurStdId.longValue(), type, descMap);
                boolean check = this.checkExcelTemplate(importService, dataHead, dataRows, descMap, headerList, type, errDataList);
                if (!check && !SITListUtil.isEmpty(errDataList)) {
                    this.getView().showErrorNotification(errDataList.get(0).get("errMsg"));
                    return;
                }
                this.doImport(fullPath, type, coanddimrefId, sinSurStdId, dataHead, dataRows, sinsurWelfareDyMap);
                break;
            }
        }
    }

    public void readExcelData(String url, final List<Map<Integer, String>> dataHead, final List<Map<Integer, String>> dataRow, final String type) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    Map data = row.getData();
                    if (data != null && data.size() > 0) {
                        if (row.getRowNum() <= (Integer)typeHeaderRowMap.get(type)) {
                            dataHead.add(data);
                        } else {
                            dataRow.add(data);
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            LOGGER.error(ex);
        }
    }

    private FormShowParameter openImportingView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_surbaseimportprocess");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    private void openImportView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hcsi_surbaseimport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hcsi_surbaseimport"));
        this.getView().showForm(showParameter);
    }

    private void openImportLogView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hcsi_surbaseimportlog");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean isHisList(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        return "hisinfolist".equals(params.get("hisinfolist")) || "showhisversion".equals(params.get("option"));
    }

    private void removeOperationColumn(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        Iterator iterator = columnList.iterator();
        while (iterator.hasNext()) {
            IListColumn next = (IListColumn)iterator.next();
            String listFieldKey = next.getListFieldKey();
            if (!"listoperatecol".equals(listFieldKey) && !"enable".equals(listFieldKey)) continue;
            iterator.remove();
        }
    }

    private void getInsurencePropValue(List<Object> sinSurBaseIds) {
        DynamicObject[] query;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hcsi_sinsurbase");
        for (DynamicObject dynamicObject : query = hrBaseServiceHelper.query("entryentity.insuranceprop,entryentity.numvalue", new QFilter[]{new QFilter("id", "in", sinSurBaseIds)})) {
            HashMap InsurencePropValue = new HashMap(16);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet().forEach(stringLongEntry -> {
                    if (((Long)stringLongEntry.getValue()).equals(entry.getLong("insuranceprop.id"))) {
                        InsurencePropValue.put(stringLongEntry.getKey(), entry.getString("numvalue"));
                    }
                });
            }
            this.SIN_SUR_BASE_INSURENCE_PROP_VALUE.put(dynamicObject.getPkValue(), InsurencePropValue);
        }
    }

    private boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    private String getBillNo(String formId, String pageid) {
        String cacheKey = String.format("IMPORT_%s_%s", formId, pageid);
        return cacheKey.substring(0, Math.min(cacheKey.length(), 50));
    }

    private boolean checkExcelTemplate(SinsurBaseImportService importService, List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, Map<String, String> descMap, List<List<Map<String, Object>>> headerList, String type, List<Map<String, String>> errDataList) {
        String errMsg;
        if (SITStringUtils.equals((String)"1", (String)type) && !SITStringUtils.isEmpty((String)(errMsg = this.checkExcelDesc(descMap, dataHead)))) {
            errDataList.add(importService.assembleErrMap(0, true, "", errMsg));
            return false;
        }
        String checkMsg = this.checkHeaderNumberAndName(dataHead, headerList, type);
        if (!SITStringUtils.isEmpty((String)checkMsg)) {
            errDataList.add(importService.assembleErrMap(0, true, "", checkMsg));
            return false;
        }
        return true;
    }

    private String checkExcelDesc(Map<String, String> descMap, List<Map<Integer, String>> dataHead) {
        String errMsg = "";
        if (dataHead.size() < 6 || dataHead.get(0) == null || SITStringUtils.isEmpty((String)dataHead.get(0).get(0)) || dataHead.get(1) == null || SITStringUtils.isEmpty((String)dataHead.get(1).get(0))) {
            errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"SinSurBaseImportingPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        } else {
            String welfareNameStr = dataHead.get(0).get(0);
            String sinsurStdNameStr = dataHead.get(1).get(0);
            String coanddimrefStr = dataHead.get(1).get(1);
            String welfareName = welfareNameStr.substring(welfareNameStr.indexOf(8220) + 1, welfareNameStr.indexOf(8221));
            String sinsurStdName = sinsurStdNameStr.substring(sinsurStdNameStr.indexOf(8220) + 1, sinsurStdNameStr.indexOf(8221));
            String coanddimref = coanddimrefStr.substring(coanddimrefStr.indexOf(8220) + 1, coanddimrefStr.indexOf(8221));
            if (!SITStringUtils.equals((String)welfareName, (String)descMap.get("welFarePayerName"))) {
                errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u53c2\u4fdd\u5355\u4f4d\uff1a\u201c{0}\u201d\u4e0e\u6240\u9009\u7684\u53c2\u4fdd\u5355\u4f4d\uff1a\u201c{1}\u201d\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"SinSurBaseImportingPlugin_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), welfareName, descMap.get("welFarePayerName"));
            }
            if (!SITStringUtils.equals((String)sinsurStdName, (String)descMap.get("sinSurStdName"))) {
                errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u53c2\u4fdd\u6807\u51c6\uff1a\u201c{0}\u201d\u4e0e\u6240\u9009\u7684\u53c2\u4fdd\u6807\u51c6\uff1a\u201c{1}\u201d\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"SinSurBaseImportingPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), sinsurStdName, descMap.get("sinSurStdName"));
            }
            if (!SITStringUtils.equals((String)coanddimref, (String)descMap.get("coanddimref"))) {
                errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u5173\u8054\u53c2\u4fdd\u6807\u51c6\uff1a\u201c{0}\u201d\u4e0e\u6240\u9009\u7684\u5173\u8054\u53c2\u4fdd\u6807\u51c6\uff1a\u201c{1}\u201d\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"SinSurBaseImportingPlugin_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), coanddimref, descMap.get("coanddimref"));
            }
            if (SITStringUtils.equals((String)"-2", (String)descMap.get("dataStatus"))) {
                errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u9009\u62e9\u7684\u53c2\u4fdd\u5355\u4f4d\u5173\u8054\u53c2\u4fdd\u6807\u51c6\u7248\u672c\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SinSurBaseImportingPlugin_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            }
        }
        return errMsg;
    }

    private String checkHeaderNumberAndName(List<Map<Integer, String>> excelHeaderList, List<List<Map<String, Object>>> headerDataList, String type) {
        Map<Integer, String> excelHeaderNameMap;
        Map<Integer, String> excelHeaderNumberMap;
        List<Map<String, Object>> headerNumberList = headerDataList.get(0);
        List<Map<String, Object>> headerNameList = headerDataList.get(1);
        if (SITStringUtils.equals((String)"1", (String)type)) {
            excelHeaderNumberMap = excelHeaderList.get(4);
            excelHeaderNameMap = excelHeaderList.get(5);
        } else {
            SinSurFileBaseImportAddExcelColumnEvent sinSurFileBaseImportAddExcelColumnEvent = new SinSurFileBaseImportAddExcelColumnEvent(headerDataList);
            SinSurFileStdServiceHelper.addExcelColumn((SinSurFileBaseImportAddExcelColumnEvent)sinSurFileBaseImportAddExcelColumnEvent);
            excelHeaderNumberMap = excelHeaderList.get(2);
            excelHeaderNameMap = excelHeaderList.get(3);
        }
        String errMsg = this.checkHeader(headerNumberList, excelHeaderNumberMap);
        if (!SITStringUtils.isEmpty((String)errMsg)) {
            return errMsg;
        }
        errMsg = this.checkHeader(headerNameList, excelHeaderNameMap);
        if (!SITStringUtils.isEmpty((String)errMsg)) {
            return errMsg;
        }
        return errMsg;
    }

    private String checkHeader(List<Map<String, Object>> headerDataList, Map<Integer, String> excelHeaderMap) {
        String errMsg = "";
        if (excelHeaderMap == null) {
            errMsg = ResManager.loadKDString((String)"\u8868\u5934\u4e3a\u7a7a\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"SinSurBaseImportingPlugin_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            return errMsg;
        }
        for (Map.Entry<Integer, String> entry : excelHeaderMap.entrySet()) {
            Integer index = entry.getKey();
            String value = entry.getValue();
            String name = value.startsWith("*") ? value.substring(1) : value;
            Map<String, Object> dataMap = headerDataList.get(index);
            if (dataMap != null && SITStringUtils.equals((String)(dataMap.get("value") + ""), (String)name)) continue;
            errMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8868\u5934\u201c{0}\u201d\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684\u6a21\u677f\u586b\u5199\u5e76\u5bfc\u5165\u3002", (String)"SinSurBaseImportingPlugin_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), value);
            return errMsg;
        }
        return errMsg;
    }

    private List<Map<String, Object>> doImport(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRows, String type, Map<String, Long> sinsurWelfareDyMap) {
        int dataIndex;
        Map<Integer, String> dataHeadKey;
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(dataRows.size());
        if (SITStringUtils.equals((String)"1", (String)type)) {
            dataHeadKey = dataHead.get(4);
            dataIndex = 7;
        } else {
            dataHeadKey = dataHead.get(2);
            dataIndex = 5;
        }
        for (Map<Integer, String> dataRow : dataRows) {
            Object key;
            HashMap<String, Object> param = new HashMap<String, Object>(dataHeadKey.size());
            for (Map.Entry<Integer, String> entry : dataHeadKey.entrySet()) {
                Integer column = entry.getKey();
                key = entry.getValue();
                param.put((String)key, dataRow.get(column));
            }
            if (SITStringUtils.equals((String)"1", (String)type)) {
                param.putAll(sinsurWelfareDyMap);
            } else {
                HashMap<String, String> attribute = new HashMap<String, String>(16);
                for (Map.Entry<Integer, String> integerStringEntry : dataHead.get(2).entrySet()) {
                    key = integerStringEntry.getKey();
                    if ((Integer)key <= 8) continue;
                    attribute.put(dataHead.get(2).get(key), dataRow.get(key));
                }
                param.put("attribute", attribute);
            }
            param.put("index", dataIndex);
            ++dataIndex;
            params.add(param);
        }
        return params;
    }

    private void genErrDataExcel(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, List<Map<String, String>> errDataList, String fullPath, Object logId, String type, Long coanddimrefId, long sinSurStdId) {
        SinsurBaseImportService importService = new SinsurBaseImportService();
        String errPath = "";
        if (errDataList.size() > 0) {
            errPath = importService.genErrDataExcel(dataHead, dataRow, errDataList, type, coanddimrefId, sinSurStdId);
        }
        ISITAppCache appCache = SITAppCache.get((String)SinSurFileBaseHelper.getAppCacheKey((Object)logId));
        appCache.put("importErrorFilePath", (Object)errPath);
        int successCnt = dataRow.size() - errDataList.size();
        int errSize = dataRow.size() - successCnt;
        HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>(16);
        HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
        String errMsg = this.assembleErrMsg(errDataList, errSize);
        infoMap.put("errFile", errPath);
        infoMap.put("srcFile", fullPath);
        infoMap.put("failed", errSize);
        infoMap.put("total", dataRow.size());
        infoMap.put("errMsg", errMsg);
        dataMap.put("complete", Boolean.TRUE);
        dataMap.put("info", infoMap);
        HcsiSinsurBaseImportLogHelper.logAll((Object)logId, (String)JSON.toJSONString(dataMap), (int)dataRow.size(), (int)errSize);
    }

    private String assembleErrMsg(List<Map<String, String>> errDataList, int errSize) {
        StringBuilder sb = new StringBuilder();
        String indexMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c ", (String)"SinSurBaseImportingPlugin_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        if (SITListUtil.isEmpty(errDataList)) {
            return sb.toString();
        }
        if (errDataList.size() == 1 && SITStringUtils.equals((String)"1", (String)errDataList.get(0).get("isAll"))) {
            String errMsg = errDataList.get(0).get("errMsg");
            int index = 4;
            for (int i = 0; i < errSize; ++i) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(MessageFormat.format(indexMsg, index)).append(errMsg);
                ++index;
            }
        } else {
            for (Map<String, String> map : errDataList) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(MessageFormat.format(indexMsg, map.get("dataIndex"))).append(map.get("errMsg"));
            }
        }
        return sb.toString();
    }

    private void doImport(String fullPath, String type, Long coanddimrefId, Long sinSurStdId, List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRows, Map<String, Long> sinsurWelfareDyMap) {
        FormShowParameter formShowParameter = this.openImportingView();
        String billFormName = ResManager.loadKDString((String)"\u793e\u4fdd\u57fa\u6570\u5bfc\u5165", (String)"SinSurBaseListPlugin_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
        Object logId = HcsiSinsurBaseImportLogHelper.create((String)this.getBillNo("hcsi_sinsurbase", formShowParameter.getPageId()), (String)billFormName);
        formShowParameter.setCustomParam("logId", logId);
        ISITAppCache isitAppCache = SITAppCache.get((String)SinSurFileBaseHelper.getAppCacheKey((Object)logId));
        isitAppCache.put("totalCount", (Object)dataRows.size());
        isitAppCache.put("failCount", (Object)0);
        isitAppCache.put("successCount", (Object)0);
        isitAppCache.put("startTime", (Object)new Date());
        String floatingTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("sit_hcsi_sinsurbase_import", billFormName, true, this.getView().getPageId(), formShowParameter.getCustomParams());
        isitAppCache.put("floatingTaskId", (Object)floatingTaskId);
        List<Map<String, Object>> params = this.doImport(dataHead, dataRows, type, sinsurWelfareDyMap);
        ThreadPool commonImportThreadpool = SITThreadPoolFactory.getCommonImportThreadpool();
        commonImportThreadpool.execute(() -> {
            List errDataList = SITStringUtils.equals((String)"1", (String)type) ? SinSurFileBaseHelper.importStdAndBases((Object)logId, (List)params) : SinSurFileBaseHelper.importSinSurBase((Object)logId, (List)params);
            LOGGER.info("import finish.errDataList.size:{}", (Object)errDataList.size());
            this.genErrDataExcel(dataHead, dataRows, errDataList, fullPath, logId, type, coanddimrefId, sinSurStdId);
            isitAppCache.put("sinSurBaseImportSuccess", (Object)"sinSurBaseImportSuccess");
            isitAppCache.put("endTime", (Object)new Date());
        });
        this.getView().showForm(formShowParameter);
    }

    static {
        typeHeaderRowMap.put("1", 5);
        typeHeaderRowMap.put("2", 3);
    }
}

