/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file.attach;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.InsuranceItemDto;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.SinSurFileBaseDto;
import kd.sdk.sit.hcsi.common.entity.sinsurbase.SinSurFileBaseEntDto;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseAddPageAttributeEvent;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseReplaceNumValueEvent;
import kd.sit.hcsi.business.common.helper.StandardCfgHelper;
import kd.sit.hcsi.business.file.SinSurFileStdImportServiceHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.common.vo.FileSinSurBaseVo;
import kd.sit.hcsi.common.vo.FileSinSurStdVo;
import kd.sit.hcsi.common.vo.SinSurBaseVo;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.enums.TruncationEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;

public abstract class SinSurFileStdEdit
extends HRDataBaseEdit
implements SITBaseConstants,
BeforeF7SelectListener {
    public static final String CALL_BACK = "callBack";
    public static final String CHANGE_BSED = "changeBsed";
    public static final String CHANGE_SIN_SUR_STD = "changeSinSurStd";
    public static final String HIS_CHANGE_SIN_SUR_STD = "hisChangeSinSurStd";
    public static final String DELETE_SIN_SUR_STD = "deleteSinSurStd";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit welfarePayer = (BasedataEdit)this.getControl("sinsurstd");
        welfarePayer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        Long fileId = (Long)this.getView().getFormShowParameter().getCustomParam("sinsur_file_id");
        this.getModel().setValue("sinsurfile", (Object)fileId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"saveafteraudit")) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult.isSuccess() && HRStringUtils.equals((String)operateKey, (String)"save")) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    Map relateFileIds = (Map)parentView.getFormShowParameter().getCustomParam("relateFileIds");
                    relateFileIds.put("hcsi_sinsurfilestd", String.valueOf(operationResult.getSuccessPkIds().get(0)));
                    this.getView().getParentView().getFormShowParameter().setCustomParam("relateFileIds", (Object)relateFileIds);
                    this.getView().getParentView().cacheFormShowParameter();
                    this.getView().getFormShowParameter().setCustomParam("relateFileIds", (Object)relateFileIds);
                }
                this.getView().invokeOperation("refresh");
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"modifyafteraudit") || HRStringUtils.equals((String)operateKey, (String)"edit")) {
            DynamicObject fileSinSurStd = this.getModel().getDataEntity();
            DynamicObject sinSurFile = fileSinSurStd.getDynamicObject("sinsurfile");
            Long placeOfWelfareId = SinSurFileStdServiceHelper.queryPlaceOfWelfareId((Long)sinSurFile.getLong("welfarepayer.id"));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long personId = sinSurFile.getLong("person.id");
            DynamicObject sinSurStd = dataEntity.getDynamicObject("sinsurstd");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long welfareTypeId = dynamicObject.getLong("welfaretypeid");
                ArrayList<Long> welfareTypeIds = new ArrayList<Long>(10);
                welfareTypeIds.add(welfareTypeId);
                Date entryBsed = dynamicObject.getDate("entrybsed");
                DynamicObject sinSurStdVersion = SinSurFileStdServiceHelper.querySinSurStdVersion((Date)entryBsed, (Long)sinSurStd.getLong("id"));
                Map welfareTypeInsuranceTypeSystemValueMap = SinSurFileStdServiceHelper.parseSinSurStd(welfareTypeIds, (Map)SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP, (DynamicObject)sinSurStdVersion, (long)personId, (Long)placeOfWelfareId, (Date)entryBsed);
                dynamicObject.set("personalupperlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")));
                dynamicObject.set("personallowerlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")));
                dynamicObject.set("companyupperlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")));
                dynamicObject.set("companylowerlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit")));
            }
            this.getView().updateView("entryentity");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "changeBsed": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.getPageCache().put(CHANGE_BSED, CHANGE_BSED);
                    this.clearData();
                } else {
                    this.setTimeFieldOldValue(customValue);
                }
                this.getPageCache().remove("propertyChangedConfirm");
            }
        }
    }

    public void clearData() {
        this.getModel().setValue("sinsurstd", null);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        this.getView().updateView("sinsurstd");
        model.deleteEntryData("entryentity");
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setTimeFieldOldValue(String customValue) {
        if (HRStringUtils.isEmpty((String)customValue)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue("bsed", (Object)new Date(Long.parseLong(customValue)));
        this.getModel().endInit();
        this.getView().updateView("bsed");
    }

    public void validateOtherFileInsured(DynamicObject sinSurFile, DynamicObject dynamicObject, int index, List<String> errorMessage) {
        long personIndexId = sinSurFile.getLong("personindexid");
        long sinSurFileId = sinSurFile.getLong("id");
        DynamicObject welfareTypeInsuredFile = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFileId, (Long)personIndexId, (Long)dynamicObject.getLong("welfaretypeid"), (Date)dynamicObject.getDate("entrybsed"), (Date)dynamicObject.getDate("entrybsled"));
        if (welfareTypeInsuredFile != null) {
            errorMessage.add(MessageFormat.format(ResManager.loadKDString((String)"\u540c\u65f6\u95f4\u6bb5\u5185\uff0c{0}\u5728\u4eba\u5458\u793e\u4fdd\u6863\u6848\uff1a{1}\u4e2d\u5df2\u53c2\u4fdd\uff0c\u8bf7\u5c06\u53c2\u4fdd\u5f00\u5173\u5173\u95ed\u3002", (String)"SinSurFileStdEdit_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype"), welfareTypeInsuredFile.getString("number")));
        }
    }

    public void setEntryUpperLowerLimit(Date newBesd, int currentIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        Long placeOfWelfareId = SinSurFileStdServiceHelper.queryPlaceOfWelfareId((Long)sinSurFile.getLong("welfarepayer.id"));
        long personId = sinSurFile.getLong("person.id");
        DynamicObject sinSurStd = dataEntity.getDynamicObject("sinsurstd");
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(10);
        DynamicObject sinSurStdVersion = SinSurFileStdServiceHelper.querySinSurStdVersion((Date)newBesd, (Long)sinSurStd.getLong("id"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentIndex);
        welfareTypeIds.add(entryRowEntity.getLong("welfaretypeid"));
        Map welfareTypeInsuranceTypeSystemValueMap = SinSurFileStdServiceHelper.parseSinSurStd(welfareTypeIds, (Map)SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP, (DynamicObject)sinSurStdVersion, (long)personId, (Long)placeOfWelfareId, (Date)newBesd);
        if (currentIndex < 0) {
            int index = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                long welfareTypeId = dynamicObject.getLong("welfaretypeid");
                this.getModel().setValue("personalupperlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")), index);
                this.getModel().setValue("personallowerlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")), index);
                this.getModel().setValue("companyupperlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeIds.get(0))).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")), index);
                this.getModel().setValue("companylowerlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeIds.get(0))).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit")), index);
                ++index;
            }
            this.getView().updateView("entryentity.personalupperlimit");
            this.getView().updateView("entryentity.personallowerlimit");
            this.getView().updateView("entryentity.companyupperlimit");
            this.getView().updateView("entryentity.companylowerlimit");
        } else {
            this.getModel().setValue("personalupperlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeIds.get(0))).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")), currentIndex);
            this.getModel().setValue("personallowerlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeIds.get(0))).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")), currentIndex);
            this.getModel().setValue("companyupperlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeIds.get(0))).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")), currentIndex);
            this.getModel().setValue("companylowerlimit", ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeIds.get(0))).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit")), currentIndex);
            this.getView().updateView("entryentity.personalupperlimit", currentIndex);
            this.getView().updateView("entryentity.personallowerlimit", currentIndex);
            this.getView().updateView("entryentity.companyupperlimit", currentIndex);
            this.getView().updateView("entryentity.companylowerlimit", currentIndex);
        }
    }

    public void setEntryBsled(Date newEntryBesd, int currentRowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        DynamicObject sinSurFileBaseVersion = SinSurFileStdImportServiceHelper.querySinSurFileBases((Date)newEntryBesd, (Long)entryRowEntity.getLong("welfaretypeid"), (DynamicObject)sinSurFile);
        if (sinSurFileBaseVersion != null) {
            this.getModel().setValue("entrybsled", (Object)sinSurFileBaseVersion.getDate("bsled"), currentRowIndex);
        }
        this.getView().updateView("entryentity.entrybsled", currentRowIndex);
    }

    public void insuredPropertyChanged(ChangeData changeData, DynamicObject sinSurFile) {
        Boolean insured = (Boolean)changeData.getNewValue();
        int currentRowIndex = this.getCurrentRowIndex();
        if (insured.booleanValue()) {
            DynamicObject insuredSinSurFile;
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
            long welfareTypeId = dynamicObject.getLong("welfaretypeid");
            boolean isAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea().contains(welfareTypeId);
            if (!isAllowedPayInMultipleArea && (insuredSinSurFile = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFile.getLong("id"), (Long)sinSurFile.getLong("personindexid"), (Long)welfareTypeId, (Date)dynamicObject.getDate("entrybsed"), (Date)dynamicObject.getDate("entrybsled"))) != null) {
                this.getPageCache().put("propertyChange", "false");
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540c\u65f6\u95f4\u6bb5\u5185\uff0c\u8be5\u9669\u79cd\u5728\u4eba\u5458\u793e\u4fdd\u6863\u6848\uff1a%s\u4e2d\u5df2\u53c2\u4fdd\uff0c\u4e0d\u53ef\u91cd\u590d\u53c2\u4fdd\u3002", (String)"SinSurFileStdEdit_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), insuredSinSurFile.getString("number")));
                this.getModel().beginInit();
                this.getModel().setValue("insured", (Object)Boolean.FALSE, currentRowIndex);
                this.getModel().endInit();
                this.getView().updateView("insured", currentRowIndex);
                return;
            }
            ArrayList<Long> welfareTypeIds = new ArrayList<Long>(10);
            welfareTypeIds.add(welfareTypeId);
            Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
            this.setWelfareTypeInsuranceTypeAttrEnable(insured, welfareTypeInsuranceTypeAttrMap, currentRowIndex, welfareTypeId);
        } else {
            this.getModel().setValue("personalcontribution", null, currentRowIndex);
            this.getModel().setValue("companycontribution", null, currentRowIndex);
            this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"personalcontribution", "companycontribution"});
        }
    }

    public void clearUpperLowerLimit(int currentRowIndex) {
        this.getModel().beginInit();
        this.getModel().setValue("personalupperlimit", null, currentRowIndex);
        this.getModel().setValue("personallowerlimit", null, currentRowIndex);
        this.getModel().setValue("companyupperlimit", null, currentRowIndex);
        this.getModel().setValue("companylowerlimit", null, currentRowIndex);
        this.getModel().endInit();
        this.getView().updateView("personalupperlimit", currentRowIndex);
        this.getView().updateView("personallowerlimit", currentRowIndex);
        this.getView().updateView("companyupperlimit", currentRowIndex);
        this.getView().updateView("companylowerlimit", currentRowIndex);
    }

    public void setOldValue(String filedKey, ChangeData changeData, int index) {
        this.getPageCache().put("propertyChange", "false");
        if (index < 0) {
            this.getModel().setValue(filedKey, changeData.getOldValue());
            this.getView().updateView(filedKey);
        } else {
            this.getModel().setValue(filedKey, changeData.getOldValue(), index);
            this.getView().updateView(filedKey, index);
        }
    }

    public int getCurrentRowIndex() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("entryentity").getSelectedRows();
        if (rowIndexs.length == 0) {
            return -1;
        }
        return rowIndexs[0];
    }

    public void roundContribution(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sinSurStd = dataEntity.getDynamicObject("sinsurstd");
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        Long placeOfWelfareId = SinSurFileStdServiceHelper.queryPlaceOfWelfareId((Long)sinSurFile.getLong("welfarepayer.id"));
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        HashMap<Date, DynamicObject> sinSurStdVersionMap = new HashMap<Date, DynamicObject>(dynamicObjectCollection.size());
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            welfareTypeIds.add(dynamicObject.getLong("welfaretypeid"));
        }
        Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        Map insuranceItemMap = SinSurFileStdImportServiceHelper.queryInsuranceItem(welfareTypeIds);
        boolean flag = false;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject sinSurStdVersion;
            if (!dynamicObject.getBoolean("insured") || (sinSurStdVersion = this.getSinSurStdVersion(sinSurStd, sinSurStdVersionMap, dynamicObject)) == null) continue;
            DynamicObject sinSurPersonVersion = SinSurFileStdServiceHelper.querySinSurPersonVersion((Date)dynamicObject.getDate("entrybsed"), (Long)sinSurFile.getLong("person.id"), (Long)placeOfWelfareId);
            long welfareTypeId = dynamicObject.getLong("welfaretypeid");
            for (Map.Entry mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                String truncationCode;
                Long insuranceTypeId = (Long)mapEntry.getValue();
                if (!((Boolean)((Map)welfareTypeInsuranceTypeAttrMap.get(welfareTypeId)).get(insuranceTypeId)).booleanValue() || insuranceItemMap.get(welfareTypeId) == null || ((Map)insuranceItemMap.get(welfareTypeId)).get(insuranceTypeId) == null) continue;
                long insuranceItemId = ((DynamicObject)((Map)insuranceItemMap.get(welfareTypeId)).get(insuranceTypeId)).getLong("id");
                if (!SinSurFileStdServiceHelper.isContainsTruncation((DynamicObject)sinSurStdVersion, (Long)welfareTypeId, (Long)insuranceItemId)) continue;
                if (SinSurFileStdServiceHelper.isStdDim((DynamicObject)sinSurStdVersion, (Long)welfareTypeId)) {
                    truncationCode = SinSurFileStdServiceHelper.getTruncationCode((DynamicObject)sinSurPersonVersion, (DynamicObject)sinSurStdVersion, (boolean)true, (Long)welfareTypeId, (Long)insuranceItemId);
                    if (HRStringUtils.isEmpty((String)truncationCode)) {
                        args.setCancel(true);
                        this.getView().showTipNotification(dynamicObject.getString("welfaretype") + "\uff1a" + ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5230\u552f\u4e00\u7684\u53c2\u4fdd\u6807\u51c6\u6570\u636e\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1.\u6863\u6848\u7684\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u4e2d\u672a\u51c6\u786e\u7ef4\u62a4\u53c2\u4fdd\u6807\u51c6\u4e2d\u542f\u7528\u7684\u6807\u51c6\u7ef4\u5ea6\u5b57\u6bb5\u503c  2.\u793e\u4fdd\u4eba\u5458\u4fe1\u606f\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e\u8be5\u9669\u79cd\u57fa\u6570\u5206\u5f55\u4e2d\u7684\u751f\u6548\u65e5\u671f", (String)"SinSurFileStdEdit_9", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    truncationCode = SinSurFileStdServiceHelper.getTruncationCode((DynamicObject)sinSurPersonVersion, (DynamicObject)sinSurStdVersion, (boolean)false, (Long)welfareTypeId, (Long)insuranceItemId);
                }
                if (!HRStringUtils.isNotEmpty((String)truncationCode)) continue;
                flag = true;
                BigDecimal bigDecimalValue = TruncationEnum.getBigDecimalValue((BigDecimal)dynamicObject.getBigDecimal((String)mapEntry.getKey()), (String)truncationCode);
                String[] split = bigDecimalValue.toString().split("\\.");
                if (split[0].length() > 11) {
                    args.setCancel(true);
                    String insuranceTypeName = insuranceTypeId == 1010L ? ResManager.loadKDString((String)"\u4e2a\u4eba\u7f34\u8d39\u57fa\u6570", (String)"SinSurFileStdEdit_11", (String)"sit-hcsi-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u4f4d\u7f34\u8d39\u57fa\u6570", (String)"SinSurFileStdEdit_12", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684{1}\u8d85\u51fa\u7cfb\u7edf\u9650\u5236\u6700\u5927\u957f\u5ea611\u4f4d\uff0c\u8f93\u5165\u5931\u8d25\u3002", (String)"SinSurFileStdEdit_10", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype"), insuranceTypeName));
                    return;
                }
                dynamicObject.set((String)mapEntry.getKey(), (Object)bigDecimalValue);
            }
        }
        if (flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6839\u636e\u53c2\u4fdd\u6807\u51c6\u4e2d\u8bbe\u7f6e\u7684\u820d\u4f4d\u65b9\u5f0f\u5904\u7406\u5404\u9669\u79cd\u57fa\u6570\u3002", (String)"SinSurFileStdEdit_6", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getSinSurStdVersion(DynamicObject sinSurStd, Map<Date, DynamicObject> sinSurStdVersionMap, DynamicObject dynamicObject) {
        DynamicObject sinSurStdVersion = sinSurStdVersionMap.get(dynamicObject.getDate("entrybsed"));
        if (sinSurStdVersion == null) {
            sinSurStdVersion = SinSurFileStdServiceHelper.querySinSurStdVersion((Date)dynamicObject.getDate("entrybsed"), (Long)sinSurStd.getLong("id"));
            sinSurStdVersionMap.put(dynamicObject.getDate("entrybsed"), sinSurStdVersion);
        }
        return sinSurStdVersion;
    }

    public boolean validate(BeforeDoOperationEventArgs args) {
        Object dynamicObject3;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getDate("bsled") != null && dataEntity.getDate("bsed").after(dataEntity.getDate("bsled"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"SinSurFileStdEdit_8", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject2 : dynamicObjectCollection) {
            welfareTypeIds.add(dynamicObject2.getLong("welfaretypeid"));
        }
        Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        Set insurTypeIdsAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea();
        ArrayList<String> errorMessage = new ArrayList<String>(10);
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            dynamicObject3 = (DynamicObject)dynamicObjectCollection.get(index);
            long insurTypeId = dynamicObject3.getLong("welfaretypeid");
            if (!dynamicObject3.getBoolean("insured") || this.validateMustInput(welfareTypeInsuranceTypeAttrMap, (DynamicObject)dynamicObject3, errorMessage) || insurTypeIdsAllowedPayInMultipleArea.contains(insurTypeId)) continue;
            this.validateOtherFileInsured(sinSurFile, (DynamicObject)dynamicObject3, index, errorMessage);
        }
        if (errorMessage.size() > 0) {
            if (errorMessage.size() > 1) {
                FormOperate formOperate = (FormOperate)args.getSource();
                FormShowParameter operationResultsParameter = SITShowFormServiceHelper.getOperationResultParameter((String)formOperate.getOperateName().getLocaleValue(), (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (String)"SinSurFileStdEdit_4", (String)"sit-sitbs-formplugin", (Object[])new Object[0]), errorMessage);
                this.getView().showForm(operationResultsParameter);
            } else {
                this.getView().showTipNotification((String)errorMessage.get(0));
            }
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                dynamicObject3 = (DynamicObject)dynamicObjectCollection.get(index);
                this.setWelfareTypeInsuranceTypeAttrEnable(dynamicObject3.getBoolean("insured"), welfareTypeInsuranceTypeAttrMap, index, dynamicObject3.getLong("welfaretypeid"));
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"entrybsed"});
            }
            this.getView().updateView("entryentity");
            return errorMessage.size() > 0;
        }
        for (Object dynamicObject3 : dynamicObjectCollection) {
            if (!dynamicObject3.getBoolean("insured")) continue;
            this.validateCompliance(welfareTypeInsuranceTypeAttrMap, (DynamicObject)dynamicObject3, errorMessage);
        }
        if (errorMessage.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String msg : errorMessage) {
                stringBuilder.append(msg).append('\n');
            }
            stringBuilder.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SinSurFileStdEdit_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            FormOperate formOperate = (FormOperate)args.getSource();
            String operateKey = formOperate.getOperateKey();
            this.getView().showConfirm("", stringBuilder.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
        return errorMessage.size() > 0;
    }

    private void validateCompliance(Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap, DynamicObject dynamicObject, List<String> errorMessage) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        long welfareTypeId = dynamicObject.getLong("welfaretypeid");
        Map<Long, Boolean> insuranceTypeAttrMap = welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
        for (Map.Entry mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
            IDataEntityProperty iDataEntityProperty;
            if (!insuranceTypeAttrMap.get(mapEntry.getValue()).booleanValue()) continue;
            String key = (String)mapEntry.getKey();
            String ppperLimit = "";
            String lowerLimit = "";
            String typeName = "";
            BigDecimal source = dynamicObject.getBigDecimal(key);
            BigDecimal bigDecimal = source = source == null ? BigDecimal.ZERO : source;
            if (HRStringUtils.equals((String)key, (String)"personalcontribution")) {
                ppperLimit = dynamicObject.getString("personalupperlimit");
                lowerLimit = dynamicObject.getString("personallowerlimit");
                typeName = ResManager.loadKDString((String)"\u4e2a\u4eba", (String)"SinSurFileStdEdit_14", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)key, (String)"companycontribution")) {
                ppperLimit = dynamicObject.getString("companyupperlimit");
                lowerLimit = dynamicObject.getString("companylowerlimit");
                typeName = ResManager.loadKDString((String)"\u5355\u4f4d", (String)"SinSurFileStdEdit_13", (String)"sit-hcsi-formplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.isNotEmpty((String)ppperLimit) && source.compareTo(new BigDecimal(ppperLimit)) > 0) {
                iDataEntityProperty = (IDataEntityProperty)properties.get((Object)key);
                errorMessage.add(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u8d85\u51fa{1}\u7f34\u8d39\u57fa\u6570\u4e0a\u9650\u3002", (String)"SinSurFileStdEdit_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype") + iDataEntityProperty.getDisplayName().getLocaleValue(), typeName));
            }
            if (!HRStringUtils.isNotEmpty((String)lowerLimit) || source.compareTo(new BigDecimal(lowerLimit)) >= 0) continue;
            iDataEntityProperty = (IDataEntityProperty)properties.get((Object)key);
            errorMessage.add(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u4f4e\u4e8e{1}\u7f34\u8d39\u57fa\u6570\u4e0b\u9650\u3002", (String)"SinSurFileStdEdit_7", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype") + iDataEntityProperty.getDisplayName().getLocaleValue(), typeName));
        }
    }

    private boolean validateMustInput(Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap, DynamicObject dynamicObject, List<String> errorMessage) {
        long welfareTypeId = dynamicObject.getLong("welfaretypeid");
        DataEntityPropertyCollection entityProperties = dynamicObject.getDynamicObjectType().getProperties();
        Map<Long, Boolean> insuranceTypeAttrMap = welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
        for (Map.Entry mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
            if (!insuranceTypeAttrMap.get(mapEntry.getValue()).booleanValue() || dynamicObject.getBigDecimal((String)mapEntry.getKey()) != null) continue;
            errorMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684{1}\u672a\u586b\u5199\u3002", (String)"SinSurFileStdEdit_0", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), dynamicObject.getString("welfaretype"), ((IDataEntityProperty)entityProperties.get(mapEntry.getKey())).getDisplayName().getLocaleValue()));
        }
        return errorMessage.size() > 0;
    }

    public void createEntryData(DynamicObject sinSurStd) {
        List changeSurFileBaseEntDtos;
        if (sinSurStd == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6863\u6848\u5728\u8be5\u751f\u6548\u65e5\u671f\u65e0\u53ef\u7528\u7684\u53c2\u4fdd\u6807\u51c6\uff0c\u8bf7\u5148\u7ef4\u62a4\u53c2\u4fdd\u5355\u4f4d\u5173\u8054\u7684\u53c2\u4fdd\u6807\u51c6\u3002", (String)"FileSinSurStdAddNewEdit_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
        Date entryDate = dataEntity.getDate("bsed");
        DynamicObject sinSurStdVersion = SinSurFileStdServiceHelper.querySinSurStdVersion((Date)entryDate, (Long)sinSurStd.getLong("id"));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter entry = this.getTableValueSetter();
        ArrayList<DynamicObject> welfareTypes = new ArrayList<DynamicObject>(stdentryentity.size());
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(stdentryentity.size());
        for (DynamicObject dynamicObject : stdentryentity) {
            DynamicObject welfareType = dynamicObject.getDynamicObject("insurtype");
            welfareTypes.add(welfareType);
            welfareTypeIds.add(welfareType.getLong("id"));
        }
        long personId = sinSurFile.getLong("person.id");
        long personIndexId = sinSurFile.getLong("personindexid");
        long sinSurFileId = sinSurFile.getLong("id");
        Long placeOfWelfareId = SinSurFileStdServiceHelper.queryPlaceOfWelfareId((Long)sinSurFile.getLong("welfarepayer.id"));
        Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        Map welfareTypeInsuranceTypeSystemValueMap = SinSurFileStdServiceHelper.parseSinSurStd(welfareTypeIds, (Map)SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP, (DynamicObject)sinSurStdVersion, (long)personId, (Long)placeOfWelfareId, (Date)entryDate);
        SinSurFileBaseReplaceNumValueEvent sinSurFileBaseReplaceNumValueEvent = this.generateSinSurFileBaseChangeValueEvent(null, welfareTypeInsuranceTypeAttrMap, welfareTypes, sinSurFileId, sinSurStd.getLong("id"), personIndexId, entryDate, "save");
        SinSurFileStdServiceHelper.replaceSinSurBaseNumValue((SinSurFileBaseReplaceNumValueEvent)sinSurFileBaseReplaceNumValueEvent);
        Map<Long, SinSurFileBaseEntDto> changeSinSurFileBaseEntDto = null;
        List sinSurFileBaseDto = sinSurFileBaseReplaceNumValueEvent.getSinSurFileBaseDtos();
        Map<Long, SinSurFileBaseDto> sinSurFileBaseDtoByFileId = sinSurFileBaseDto.stream().collect(Collectors.toMap(SinSurFileBaseDto::getSinSurFileId, o -> o));
        SinSurFileBaseDto changeSinSurFileBaseDto = sinSurFileBaseDtoByFileId.get(sinSurFileId);
        if (changeSinSurFileBaseDto != null && CollectionUtils.isNotEmpty((Collection)(changeSurFileBaseEntDtos = changeSinSurFileBaseDto.getSinSurFileBaseEntDtos()))) {
            changeSinSurFileBaseEntDto = changeSurFileBaseEntDtos.stream().collect(Collectors.toMap(SinSurFileBaseEntDto::getWelfareTypeId, o -> o, (k1, k2) -> k1));
        }
        int index = 0;
        for (DynamicObject welfareType : welfareTypes) {
            long welfareTypeId = welfareType.getLong("id");
            boolean insured = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFileId, (Long)personIndexId, (Long)welfareTypeId, (Date)entryDate, null) == null;
            String personalContribution = SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntDto, (long)welfareTypeId, (boolean)insured, (Long)((Long)SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.get("personalcontribution")), (Map)welfareTypeInsuranceTypeAttrMap);
            String companyContribution = SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntDto, (long)welfareTypeId, (boolean)insured, (Long)((Long)SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.get("companycontribution")), (Map)welfareTypeInsuranceTypeAttrMap);
            entry.addRow(new Object[]{welfareType.getString("name"), welfareTypeId, entryDate, SinSurFileStdServiceHelper.generateBsledDate(), insured, personalContribution, companyContribution, null, ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")), ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")), ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")), ((Map)welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId)).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit"))});
            this.setWelfareTypeInsuranceTypeAttrEnable(insured, welfareTypeInsuranceTypeAttrMap, index, welfareTypeId);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"entrybsed"});
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void createHisEntryData(String operationType) {
        List changeSurFileBaseEntEvents;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sinSurStd = dataEntity.getDynamicObject("sinsurstd");
        this.getPageCache().put("sinsurstdchange", "true");
        IDataModel model1 = this.getModel();
        DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        long sinSurFileId = sinSurFile.getLong("id");
        long personIndexId = sinSurFile.getLong("personindexid");
        FileSinSurStdVo originalData = this.getOriginalData();
        Date entryBsedDate = dataEntity.getDate("bsed");
        Date entryBsledDate = dataEntity.getDate("bsled");
        Boolean isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage");
        if (!originalData.getSinSurStdId().equals(sinSurStd.getLong("id")) && isHisPage != null && isHisPage.booleanValue()) {
            entryBsledDate = this.genEntryBsledDate(sinSurFile, sinSurStd, entryBsedDate, originalData);
            this.setBsled(entryBsledDate);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)model1;
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter entry = this.getTableValueSetter();
        entry.addField("entryboid", new Object[0]);
        entry.addField("entrypkvalue", new Object[0]);
        Map fileSinSurBaseMap = originalData.getFileSinSurBaseVos();
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(stdentryentity.size());
        ArrayList<DynamicObject> welfareTypes = new ArrayList<DynamicObject>(stdentryentity.size());
        for (DynamicObject dynamicObject : stdentryentity) {
            DynamicObject welfareType = dynamicObject.getDynamicObject("insurtype");
            welfareTypes.add(welfareType);
            welfareTypeIds.add(dynamicObject.getLong("insurtype.id"));
        }
        Long placeOfWelfareId = SinSurFileStdServiceHelper.queryPlaceOfWelfareId((Long)sinSurFile.getLong("welfarepayer.id"));
        Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        SinSurFileBaseReplaceNumValueEvent sinSurFileBaseReplaceNumValueEvent = this.generateSinSurFileBaseChangeValueEvent(fileSinSurBaseMap, welfareTypeInsuranceTypeAttrMap, welfareTypes, sinSurFileId, sinSurStd.getLong("id"), personIndexId, entryBsedDate, operationType);
        SinSurFileStdServiceHelper.replaceSinSurBaseNumValue((SinSurFileBaseReplaceNumValueEvent)sinSurFileBaseReplaceNumValueEvent);
        List sinSurFileBaseDto = sinSurFileBaseReplaceNumValueEvent.getSinSurFileBaseDtos();
        Map<Long, SinSurFileBaseDto> sinSurFileBaseEventByFileId = sinSurFileBaseDto.stream().collect(Collectors.toMap(SinSurFileBaseDto::getSinSurFileId, o -> o));
        Map<Long, SinSurFileBaseEntDto> changeSinSurFileBaseEntEvent = null;
        SinSurFileBaseDto changeSinSurFileBaseDto = sinSurFileBaseEventByFileId.get(sinSurFileId);
        if (changeSinSurFileBaseDto != null && CollectionUtils.isNotEmpty((Collection)(changeSurFileBaseEntEvents = changeSinSurFileBaseDto.getSinSurFileBaseEntDtos()))) {
            changeSinSurFileBaseEntEvent = changeSurFileBaseEntEvents.stream().collect(Collectors.toMap(SinSurFileBaseEntDto::getWelfareTypeId, o -> o));
        }
        int index = 0;
        for (DynamicObject dynamicObject : stdentryentity) {
            String companyContribution;
            String personalContribution;
            boolean insured;
            DynamicObject welfareType = dynamicObject.getDynamicObject("insurtype");
            long welfareTypeId = welfareType.getLong("id");
            Map<Long, Map<Long, String>> welfareTypeInsuranceTypeSystemValueMap = this.getWelfareTypeInsuranceTypeSystemValue(sinSurStd, dataEntity, welfareTypeId, sinSurFile.getLong("person.id"), placeOfWelfareId);
            FileSinSurBaseVo fileSinSurBaseVo = (FileSinSurBaseVo)fileSinSurBaseMap.get(welfareTypeId);
            if (fileSinSurBaseVo != null) {
                insured = fileSinSurBaseVo.getInsured();
                if (insured) {
                    insured = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFileId, (Long)personIndexId, (Long)welfareTypeId, (Date)entryBsedDate, (Date)entryBsledDate) == null;
                }
                personalContribution = SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntEvent, (long)welfareTypeId, (boolean)insured, (Long)((Long)SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.get("personalcontribution")), (Map)welfareTypeInsuranceTypeAttrMap);
                companyContribution = SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntEvent, (long)welfareTypeId, (boolean)insured, (Long)((Long)SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.get("companycontribution")), (Map)welfareTypeInsuranceTypeAttrMap);
                entry.addRow(new Object[]{welfareType.getString("name"), welfareTypeId, entryBsedDate, entryBsledDate, insured, insured ? personalContribution : null, insured ? companyContribution : null, insured ? fileSinSurBaseVo.getDescription() : null, welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit")), fileSinSurBaseVo.getPkValue(), fileSinSurBaseVo.getPkValue()});
                SinSurFileBaseAddPageAttributeEvent sinSurFileBaseAddPageAttributeEvent = new SinSurFileBaseAddPageAttributeEvent(entry, HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)SinSurFileStdImportServiceHelper.querySinSurFileBase((Long)welfareTypeId, (DynamicObject)sinSurFile)), index);
                SinSurFileStdServiceHelper.tableValueSetterAddAttribute((SinSurFileBaseAddPageAttributeEvent)sinSurFileBaseAddPageAttributeEvent);
                this.setWelfareTypeInsuranceTypeAttrEnable(insured, welfareTypeInsuranceTypeAttrMap, index, welfareTypeId);
            } else {
                insured = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFileId, (Long)personIndexId, (Long)welfareTypeId, (Date)entryBsedDate, null) == null;
                personalContribution = SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntEvent, (long)welfareTypeId, (boolean)insured, (Long)((Long)SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.get("personalcontribution")), (Map)welfareTypeInsuranceTypeAttrMap);
                companyContribution = SinSurFileStdServiceHelper.parseSinSurFileBaseEntEvent(changeSinSurFileBaseEntEvent, (long)welfareTypeId, (boolean)insured, (Long)((Long)SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.get("companycontribution")), (Map)welfareTypeInsuranceTypeAttrMap);
                entry.addRow(new Object[]{welfareType.getString("name"), welfareTypeId, entryBsedDate, entryBsledDate, insured, personalContribution, companyContribution, null, welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit"))});
                this.setWelfareTypeInsuranceTypeAttrEnable(insured, welfareTypeInsuranceTypeAttrMap, index, welfareTypeId);
            }
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"entrybsed"});
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        model.endInit();
        this.getView().updateView("entryentity");
        IPageCache pageCache = this.getPageCache();
        pageCache.put("originalData", SerializationUtils.toJsonString((Object)originalData));
    }

    private List<SinSurFileBaseEntDto> generateSinSurFileBaseEntDtos(Map<Long, FileSinSurBaseVo> fileSinSurBaseMap, Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap, List<DynamicObject> welfareTypes, long sinSurFileId, long personIndexId, Date entryBsedDate) {
        ArrayList<SinSurFileBaseEntDto> sinSurFileBaseEntDtos = new ArrayList<SinSurFileBaseEntDto>(welfareTypes.size());
        for (DynamicObject welfareType : welfareTypes) {
            boolean insured;
            long welfareTypeId = welfareType.getLong("id");
            Map<String, String> insuranceTypeAttrValueMap = null;
            if (fileSinSurBaseMap != null) {
                FileSinSurBaseVo fileSinSurBaseVo = fileSinSurBaseMap.get(welfareTypeId);
                insuranceTypeAttrValueMap = this.getInsuranceTypeAttrValue(fileSinSurBaseVo);
            }
            if (!(insured = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFileId, (Long)personIndexId, (Long)welfareTypeId, (Date)entryBsedDate, null) == null)) continue;
            ArrayList<InsuranceItemDto> insuranceItemDtos = new ArrayList<InsuranceItemDto>(10);
            Map<Long, Boolean> insuranceTypeAttrMap = welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
            for (Map.Entry MapEntry2 : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                if (!insuranceTypeAttrMap.get(MapEntry2.getValue()).booleanValue()) continue;
                InsuranceItemDto insuranceItemDto = new InsuranceItemDto((Long)MapEntry2.getValue());
                insuranceItemDto.setInsurancePropValue(insuranceTypeAttrValueMap != null ? insuranceTypeAttrValueMap.get(MapEntry2.getKey()) : null);
                insuranceItemDtos.add(insuranceItemDto);
            }
            SinSurFileBaseEntDto sinSurFileBaseEntDto = new SinSurFileBaseEntDto(Long.valueOf(welfareTypeId), Boolean.valueOf(insured), entryBsedDate, insuranceItemDtos);
            sinSurFileBaseEntDtos.add(sinSurFileBaseEntDto);
        }
        return sinSurFileBaseEntDtos;
    }

    protected SinSurFileBaseReplaceNumValueEvent generateSinSurFileBaseChangeValueEvent(Map<Long, FileSinSurBaseVo> fileSinSurBaseMap, Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap, List<DynamicObject> welfareTypes, long sinSurFileId, long sinSurStdId, long personIndexId, Date entryBsedDate, String operationType) {
        List<SinSurFileBaseEntDto> sinSurFileBaseEntDtos = this.generateSinSurFileBaseEntDtos(fileSinSurBaseMap, welfareTypeInsuranceTypeAttrMap, welfareTypes, sinSurFileId, personIndexId, entryBsedDate);
        SinSurFileBaseDto sinSurFileBaseDto = new SinSurFileBaseDto(Long.valueOf(sinSurFileId), Long.valueOf(sinSurStdId), sinSurFileBaseEntDtos);
        ArrayList<SinSurFileBaseDto> sinSurFileBaseDtos = new ArrayList<SinSurFileBaseDto>(10);
        sinSurFileBaseDtos.add(sinSurFileBaseDto);
        return new SinSurFileBaseReplaceNumValueEvent(sinSurFileBaseDtos, "page", operationType);
    }

    public TableValueSetter getTableValueSetter() {
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField("welfaretype", new Object[0]);
        entry.addField("welfaretypeid", new Object[0]);
        entry.addField("entrybsed", new Object[0]);
        entry.addField("entrybsled", new Object[0]);
        entry.addField("insured", new Object[0]);
        entry.addField("personalcontribution", new Object[0]);
        entry.addField("companycontribution", new Object[0]);
        entry.addField("entrydescription", new Object[0]);
        entry.addField("personalupperlimit", new Object[0]);
        entry.addField("personallowerlimit", new Object[0]);
        entry.addField("companyupperlimit", new Object[0]);
        entry.addField("companylowerlimit", new Object[0]);
        return entry;
    }

    public void setWelfareTypeInsuranceTypeAttrEnable(boolean insured, Map<Long, Map<Long, Boolean>> welfareTypeInsuranceTypeAttrMap, int index, long welfareTypeId) {
        Map<Long, Boolean> insuranceTypeAttrMap = welfareTypeInsuranceTypeAttrMap.get(welfareTypeId);
        for (Map.Entry MapEntry2 : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
            if (insured) {
                this.getView().setEnable(insuranceTypeAttrMap.get(MapEntry2.getValue()), index, new String[]{(String)MapEntry2.getKey()});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, index, new String[]{(String)MapEntry2.getKey()});
        }
    }

    public Map<Long, Map<Long, String>> getWelfareTypeInsuranceTypeSystemValue(DynamicObject sinSurStd, DynamicObject dynamicObject, long welfareTypeId, long personId, Long placeOfWelfareId) {
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(10);
        welfareTypeIds.add(welfareTypeId);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Date bsed = OperationStatus.VIEW.equals((Object)status) ? new Date() : dynamicObject.getDate("bsed");
        DynamicObject sinSurStdVersion = SinSurFileStdServiceHelper.querySinSurStdVersion((Date)bsed, (Long)sinSurStd.getLong("id"));
        return SinSurFileStdServiceHelper.parseSinSurStd(welfareTypeIds, (Map)SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP, (DynamicObject)sinSurStdVersion, (long)personId, (Long)placeOfWelfareId, (Date)bsed);
    }

    public FileSinSurStdVo getOriginalData() {
        IPageCache pageCache = this.getPageCache();
        String originalData = pageCache.get("originalData");
        if (HRStringUtils.isEmpty((String)originalData)) {
            return null;
        }
        return (FileSinSurStdVo)SerializationUtils.fromJsonString((String)originalData, FileSinSurStdVo.class);
    }

    public Date genEntryBsledDate(DynamicObject sinSurFile, DynamicObject sinsurstd, Date newBesd, FileSinSurStdVo originalData) {
        DynamicObject DBSinSurFileStdVersion = this.getSourceVersion(sinSurFile, newBesd);
        Date entryBsledDate = DBSinSurFileStdVersion != null ? (newBesd.compareTo(DBSinSurFileStdVersion.getDate("bsed")) < 0 ? (sinsurstd != null && sinsurstd.getLong("id") != DBSinSurFileStdVersion.getLong("sinsurstd.id") ? SITDateTimeUtils.addDay((Date)DBSinSurFileStdVersion.getDate("bsed"), (long)-1L) : DBSinSurFileStdVersion.getDate("bsled")) : DBSinSurFileStdVersion.getDate("bsled")) : SITDateTimeUtils.addDay((Date)originalData.getBsed(), (long)-1L);
        return entryBsledDate;
    }

    public DynamicObject getSourceVersion(DynamicObject sinSurFile, Date newBesd) {
        List sinSurFileStds = SinSurFileStdImportServiceHelper.querySinSurFileStds((DynamicObject)sinSurFile);
        if (sinSurFileStds != null) {
            return SinSurFileStdServiceHelper.getSourceVersion((Date)newBesd, (List)sinSurFileStds);
        }
        return null;
    }

    public void setBsled(Date bsled) {
        this.getModel().beginInit();
        this.getModel().setValue("bsled", (Object)bsled);
        this.getView().updateView("bsled");
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    public Map<String, String> getInsuranceTypeAttrValue(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        HashMap<String, String> insuranceTypeAttrValueMap = new HashMap<String, String>(SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.size());
        for (DynamicObject entryDynamicObject : dynamicObjectCollection) {
            for (Map.Entry mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                if (!((Long)mapEntry.getValue()).equals(entryDynamicObject.getDynamicObject("insuranceprop").getLong("id"))) continue;
                insuranceTypeAttrValueMap.put((String)mapEntry.getKey(), entryDynamicObject.getString("numvalue"));
            }
        }
        return insuranceTypeAttrValueMap;
    }

    public Map<String, String> getInsuranceTypeAttrValue(FileSinSurBaseVo fileSinSurBaseVo) {
        HashMap<String, String> insuranceTypeAttrValueMap = new HashMap<String, String>(SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.size());
        if (fileSinSurBaseVo != null) {
            List sinSurBases = fileSinSurBaseVo.getSinSurBases();
            for (SinSurBaseVo sinSurBase : sinSurBases) {
                for (Map.Entry mapEntry : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                    if (!((Long)mapEntry.getValue()).equals(sinSurBase.getInsurancePropId())) continue;
                    insuranceTypeAttrValueMap.put((String)mapEntry.getKey(), sinSurBase.getNumValue());
                }
            }
        }
        return insuranceTypeAttrValueMap;
    }

    public void beforeSinSurStdSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("propertyChangedConfirm"))) {
            this.getPageCache().remove("propertyChangedConfirm");
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date bsed = dataEntity.getDate("bsed");
        if (bsed == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u751f\u6548\u65e5\u671f\u3002", (String)"SinSurFileStdEdit_15", (String)"", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        } else {
            DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter orgQFilter = baseDataService.getBaseDataFilter("sitbs_sinsurstd", Long.valueOf(sinSurFile.getLong("org.id")));
            List sinSurStds = SinSurFileStdServiceHelper.querySinSurStd((Date)bsed, (Long)sinSurFile.getLong("welfarepayer.id"), (QFilter)orgQFilter);
            if (sinSurStds == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6863\u6848\u5728\u8be5\u751f\u6548\u65e5\u671f\u65e0\u53ef\u7528\u7684\u53c2\u4fdd\u6807\u51c6\uff0c\u8bf7\u5148\u7ef4\u62a4\u53c2\u4fdd\u5355\u4f4d\u5173\u8054\u7684\u53c2\u4fdd\u6807\u51c6\u3002", (String)"SinSurFileStdEdit_16", (String)"", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> sinSurStdIds = new ArrayList<Long>(sinSurStds.size());
            for (DynamicObject sinSurStd : sinSurStds) {
                sinSurStdIds.add(sinSurStd.getLong("id"));
            }
            QFilter sinSurStdIdsFilter = new QFilter("id", "in", sinSurStdIds);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(sinSurStdIdsFilter);
        }
    }

    public void showConfirm(String actionId, String title, String messages, String customValue) {
        if (HRStringUtils.isEmpty((String)customValue)) {
            this.getView().showConfirm(title, messages, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(actionId, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(title, messages, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(actionId, (IFormPlugin)this), new HashMap(2), customValue);
        }
    }

    public void propertyChangedBsed(ChangeData changeData, DynamicObject dataEntity) {
        Date newBsed = (Date)changeData.getNewValue();
        Date oldBsed = (Date)changeData.getOldValue();
        if (newBsed == null) {
            this.getPageCache().put("propertyChange", "false");
            this.getModel().setValue("bsed", (Object)oldBsed);
            this.getView().updateView("bsed");
            return;
        }
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        DynamicObject sinSurStd = dataEntity.getDynamicObject("sinsurstd");
        if (sinSurStd != null) {
            String oldBsedTime = oldBsed != null ? oldBsed.getTime() + "" : "";
            this.showConfirm(CHANGE_BSED, ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u671f\uff0c\u9700\u91cd\u65b0\u9009\u62e9\u53c2\u4fdd\u6807\u51c6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SinSurFileStdAddNewEdit_1", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), "", oldBsedTime);
            this.getPageCache().put("propertyChangedConfirm", "true");
            return;
        }
        Boolean isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage");
        if (isHisPage == null || !isHisPage.booleanValue()) {
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter orgQFilter = baseDataService.getBaseDataFilter("sitbs_sinsurstd", Long.valueOf(sinSurFile.getLong("org.id")));
            List sinSurStds = SinSurFileStdServiceHelper.querySinSurStd((Date)newBsed, (Long)sinSurFile.getLong("welfarepayer.id"), (QFilter)orgQFilter);
            if (sinSurStds != null && sinSurStds.size() == 1) {
                this.getModel().setValue("sinsurstd", sinSurStds.get(0));
                this.getView().updateView("sinsurstd");
            }
        }
    }

    public boolean propertyChangedSinSurStd(ChangeData changeData, String actionId) {
        DynamicObject oldSinSurStd = (DynamicObject)changeData.getOldValue();
        DynamicObject selectSinSurStd = (DynamicObject)changeData.getNewValue();
        if (selectSinSurStd != null) {
            if (oldSinSurStd != null) {
                this.showConfirm(actionId, ResManager.loadKDString((String)"\u5207\u6362\u53c2\u4fdd\u6807\u51c6\uff0c\u4f1a\u5237\u65b0\u9669\u79cd\u7ed3\u6784\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SinSurFileStdAddNewEdit_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), "", oldSinSurStd.getString("id"));
                return false;
            }
            if (HRStringUtils.equals((String)actionId, (String)HIS_CHANGE_SIN_SUR_STD)) {
                this.createHisEntryData("saveafteraudit");
            } else if (HRStringUtils.equals((String)actionId, (String)CHANGE_SIN_SUR_STD)) {
                this.createEntryData(selectSinSurStd);
            }
            return true;
        }
        if (HRStringUtils.isNotEmpty((String)this.getPageCache().get(CHANGE_BSED))) {
            this.getPageCache().remove(CHANGE_BSED);
            this.clearData();
            return true;
        }
        if (oldSinSurStd != null) {
            this.showConfirm(DELETE_SIN_SUR_STD, ResManager.loadKDString((String)"\u5220\u9664\u53c2\u4fdd\u6807\u51c6\uff0c\u4f1a\u6e05\u7a7a\u9669\u79cd\u57fa\u6570\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SinSurFileStdAddNewEdit_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), "", oldSinSurStd.getString("id"));
            return false;
        }
        return true;
    }

    public void deleteSinSurStd(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.clearData();
        } else {
            this.getPageCache().put("propertyChange", "false");
            this.getModel().setValue("sinsurstd", (Object)messageBoxClosedEvent.getCustomVaule());
            this.getView().updateView("sinsurstd");
        }
    }

    protected boolean validateExistSinSurFile() {
        DynamicObject fileSinSurStd = this.getModel().getDataEntity();
        DynamicObject sinSurFile = fileSinSurStd.getDynamicObject("sinsurfile");
        if (sinSurFile == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"SinSurFileStdEdit_17", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

