/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.hcsi.formplugin.web.file.attach;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sit.hcsi.common.events.sinsurfilebase.SinSurFileBaseAddPageAttributeEvent;
import kd.sit.hcsi.business.common.helper.StandardCfgHelper;
import kd.sit.hcsi.business.file.SinSurFileStdServiceHelper;
import kd.sit.hcsi.business.file.SinsurFileServiceHelper;
import kd.sit.hcsi.common.vo.FileSinSurBaseVo;
import kd.sit.hcsi.common.vo.FileSinSurStdVo;
import kd.sit.hcsi.common.vo.SinSurBaseVo;
import kd.sit.hcsi.formplugin.web.file.attach.SinSurFileStdEdit;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITEntityConstants;
import kd.sit.sitbp.common.enums.BaseCalTypeEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SITStringUtils;

public class SinSurFileStdHisChangeEdit
extends SinSurFileStdEdit
implements SITBaseConstants,
SITEntityConstants {
    private static final Log LOGGER = LogFactory.getLog(SinSurFileStdHisChangeEdit.class);
    private static final String OP_CREATE_BASE = "donothing_create_base";

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Boolean isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage");
        if (isHisPage == null || !isHisPage.booleanValue()) {
            return;
        }
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        if (StringUtils.equals((CharSequence)"sinsurstd", (CharSequence)key)) {
            if (this.validateExistSinSurFile()) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            this.beforeSinSurStdSelect(beforeF7SelectEvent);
        }
    }

    @Override
    public void beforeBindData(EventObject evt) {
        Boolean isHisPage;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (this.validateExistSinSurFile()) {
            return;
        }
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            Map relateFileIds = (Map)this.getView().getFormShowParameter().getCustomParam("relateFileIds");
            String fileSinSurStringId = (String)relateFileIds.get("hcsi_sinsurfile");
            String fileSinSurStdStringId = (String)relateFileIds.get("hcsi_sinsurfilestd");
            if (HRStringUtils.isNotEmpty((String)fileSinSurStdStringId) && HRStringUtils.isNotEmpty((String)fileSinSurStringId)) {
                long startTime = System.currentTimeMillis();
                DynamicObject[] sinSurBases = SinSurFileStdServiceHelper.querySinSurFileStdBase((Long)Long.valueOf(fileSinSurStringId), (Long)this.getModel().getDataEntity().getLong("sinsurstd.id"));
                long endTime = System.currentTimeMillis();
                LOGGER.info("\u67e5\u8be2\u793e\u4fdd\u57fa\u6570\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
                this.cacheOriginalData(sinSurBases);
                this.createAndDrawEntry(sinSurBases);
                this.getView().setVisible(Boolean.TRUE, new String[]{"bsled"});
            }
        }
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.setWelfareTypeInsuranceTypeAttrEnable();
        }
        if ((isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage")) == null || !isHisPage.booleanValue()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < entryEntity.size(); ++index) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"entrybsed"});
            }
        }
        Map promptMap = (Map)SITMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "hintap", this.getModel().getDataEntity()});
        Hint hintAp = (Hint)this.getControl("hintap");
        promptMap.forEach((key, value) -> hintAp.setContent(key, value));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("propertyChangedConfirm"))) {
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"saveafteraudit") && !args.cancel) {
            if (this.validateExistSinSurFile()) {
                args.setCancel(true);
                return;
            }
            boolean validate = false;
            if (!operateOption.tryGetVariableValue("callBack", new RefObject())) {
                validate = this.validate(args);
            }
            if (!validate) {
                this.roundContribution(args);
                if (!args.cancel) {
                    if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("sinsurstdchange"))) {
                        operateOption.setVariableValue("sinsurstdchange", "true");
                        this.getPageCache().remove("sinsurstdchange");
                    }
                    operateOption.setVariableValue("originalData", this.getPageCache().get("originalData"));
                }
            } else {
                args.setCancel(true);
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"showhisversion") && !args.cancel) {
            if (this.validateExistSinSurFile()) {
                args.setCancel(true);
                return;
            }
            args.setCancel(true);
            SinsurFileServiceHelper.showRelatedPage((String)"20013s", (IFormView)this.getView());
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        if ("modifyafteraudit".equals(operate.getOperateKey()) || "edit".equals(operate.getOperateKey())) {
            this.setWelfareTypeInsuranceTypeAttrEnable();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < entryEntity.size(); ++index) {
                this.getView().setEnable(Boolean.valueOf("modifyafteraudit".equals(operate.getOperateKey())), index, new String[]{"entrybsed"});
            }
        } else if (OP_CREATE_BASE.equals(operate.getOperateKey())) {
            Date bsedDate = this.getModel().getDataEntity().getDate("bsed");
            DynamicObject sinsurStd = this.getModel().getDataEntity().getDynamicObject("sinsurstd");
            if (bsedDate == null || sinsurStd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u548c\u201c\u53c2\u4fdd\u6807\u51c6\u201d\u3002", (String)"SinSurFileStdHisChangeEdit_4", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                return;
            }
            Long fileId = (Long)this.getView().getFormShowParameter().getCustomParam("sinsur_file_id");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("sinSurFileId", (Object)fileId);
            parameter.setCustomParam("sinsurstdId", (Object)sinsurStd.getLong("id"));
            parameter.setCustomParam("sinsurstd", (Object)sinsurStd);
            parameter.setFormId("hcsi_genbasesingle");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseCal"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (SITStringUtils.equals((String)"baseCal", (String)actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String errMsg = (String)returnData.get("errMsg");
            Map baseMap = (Map)returnData.get("data");
            Date bsed = (Date)returnData.get("bsed");
            String calType = (String)returnData.get("calType");
            IFormView parentView = this.getView().getParentView();
            if (SITStringUtils.isNotEmpty((String)errMsg)) {
                parentView.showErrorNotification(errMsg);
            } else if (baseMap != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f\u3002", (String)"SinSurFileStdHisChangeEdit_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                DynamicObjectCollection entryCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                ArrayList<Long> welfareTypeIds = new ArrayList<Long>(entryCollection.size());
                for (DynamicObject dynamicObject : entryCollection) {
                    welfareTypeIds.add(dynamicObject.getLong("welfaretypeid"));
                }
                Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
                for (int i = 0; i < entryCollection.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryCollection.get(i);
                    long welfaretypeId = entry.getLong("welfaretypeid");
                    Map attrValueMap = (Map)baseMap.get(welfaretypeId);
                    if (attrValueMap == null) continue;
                    BigDecimal personValue = (BigDecimal)attrValueMap.get(1010L);
                    BigDecimal companyValue = (BigDecimal)attrValueMap.get(1020L);
                    Map attrEnableMap = (Map)welfareTypeInsuranceTypeAttrMap.get(welfaretypeId);
                    boolean isChange = false;
                    if (attrEnableMap != null) {
                        if (attrEnableMap.get(1010L) != null && ((Boolean)attrEnableMap.get(1010L)).booleanValue()) {
                            this.getModel().setValue("personalcontribution", (Object)personValue, i);
                            isChange = true;
                        }
                        if (attrEnableMap.get(1020L) != null && ((Boolean)attrEnableMap.get(1020L)).booleanValue()) {
                            this.getModel().setValue("companycontribution", (Object)companyValue, i);
                            isChange = true;
                        }
                    }
                    if (!isChange) continue;
                    Date entryBsed = entry.getDate("entrybsed");
                    if (!SITDateTimeUtils.dayEquals((Date)entryBsed, (Date)bsed)) {
                        this.getModel().setValue("entrybsed", (Object)bsed, i);
                    }
                    this.getModel().setValue("insured", (Object)Boolean.TRUE, i);
                }
                model.endInit();
                this.getView().updateView("entryentity");
                this.setWelfareTypeInsuranceTypeAttrEnable();
                if (SITStringUtils.equals((String)calType, (String)BaseCalTypeEnum.ADD_OR_CHANGE_STD.getCode())) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    for (int index = 0; index < entryEntity.size(); ++index) {
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"entrybsed"});
                    }
                }
            }
            this.getView().sendFormAction(parentView);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Boolean isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage");
        if (isHisPage == null || !isHisPage.booleanValue()) {
            return;
        }
        if (this.validateExistSinSurFile()) {
            return;
        }
        if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("propertyChange"))) {
            this.getPageCache().remove("propertyChange");
            return;
        }
        ChangeData[] changeSet = args.getChangeSet();
        String fieldKey = args.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
        switch (fieldKey) {
            case "bsed": {
                this.propertyChangedBsed(changeSet[0], dataEntity);
                break;
            }
            case "sinsurstd": {
                FileSinSurStdVo originalData = this.getOriginalData();
                DynamicObject newSinSurStd = (DynamicObject)changeSet[0].getNewValue();
                Date bsed = dataEntity.getDate("bsed");
                if ((bsed.compareTo(originalData.getBsed()) > 0 && bsed.compareTo(originalData.getBsled()) < 0 || bsed.compareTo(originalData.getBsled()) > 0) && newSinSurStd != null && originalData.getSinSurStdId().equals(newSinSurStd.getLong("id"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u4fdd\u6807\u51c6\u672a\u66f4\u6362\uff0c\u65e0\u9700\u751f\u6210\u65b0\u7248\u672c\u3002", (String)"SinSurFileStdHisChangeEdit_3", (String)"sit-hcsi-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("propertyChange", "false");
                    this.getModel().setValue("sinsurstd", (Object)originalData.getSinSurStdId());
                    this.getModel().setValue("bsed", (Object)originalData.getBsed());
                    this.createHisEntryData("saveafteraudit");
                    this.setBsled(originalData.getBsled());
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    for (int index = 0; index < entryEntity.size(); ++index) {
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"entrybsed"});
                    }
                    return;
                }
                if (!this.propertyChangedSinSurStd(changeSet[0], "hisChangeSinSurStd")) break;
                Date entryBsedDate = dataEntity.getDate("bsed");
                Date entryBsledDate = this.genEntryBsledDate(sinSurFile, newSinSurStd, entryBsedDate, originalData);
                this.setBsled(entryBsledDate);
                break;
            }
            case "entrybsed": {
                DynamicObject insuredSinSurFile;
                Date newEntryBesd = (Date)changeSet[0].getNewValue();
                int currentRowIndex = this.getCurrentRowIndex();
                if (newEntryBesd == null) {
                    this.clearUpperLowerLimit(currentRowIndex);
                    return;
                }
                Date bsedDate = dataEntity.getDate("bsed");
                Date bsledDate = dataEntity.getDate("bsled");
                if (newEntryBesd.before(bsedDate) || newEntryBesd.after(bsledDate)) {
                    String bsedDateStr = HRInteDateTimeUtil.formatDate((String)"hcsi_sinsurfilestd", (String)"bsed", (Date)bsedDate);
                    String bsledDateStr = HRInteDateTimeUtil.formatDate((String)"hcsi_sinsurfilestd", (String)"bsled", (Date)bsledDate);
                    this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u8d85\u51fa\u672c\u6863\u6848\u53c2\u4fdd\u6807\u51c6\u7684\u751f\u5931\u6548\u65e5\u671f\uff1a[{0},{1}]", (String)"SinSurFileStdHisChangeEdit_2", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), bsedDateStr, bsledDateStr));
                    this.setOldValue("entrybsed", changeSet[0], currentRowIndex);
                    return;
                }
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
                long welfareTypeId = dynamicObject.getLong("welfaretypeid");
                boolean isAllowedPayInMultipleArea = StandardCfgHelper.filterInsurTypeIdsInMultipleArea().contains(welfareTypeId);
                if (!isAllowedPayInMultipleArea && ((Boolean)this.getModel().getValue("insured", currentRowIndex)).booleanValue() && (insuredSinSurFile = SinSurFileStdServiceHelper.welfareTypeInsuredFile((Long)sinSurFile.getLong("id"), (Long)sinSurFile.getLong("personindexid"), (Long)welfareTypeId, (Date)dynamicObject.getDate("entrybsed"), (Date)dynamicObject.getDate("entrybsled"))) != null) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540c\u65f6\u95f4\u6bb5\u5185\uff0c\u8be5\u9669\u79cd\u5728\u4eba\u5458\u793e\u4fdd\u6863\u6848\uff1a%s\u4e2d\u5df2\u53c2\u4fdd\uff0c\u4e0d\u53ef\u91cd\u590d\u53c2\u4fdd\u3002", (String)"SinSurFileStdEdit_5", (String)"sit-hcsi-formplugin", (Object[])new Object[0]), insuredSinSurFile.getString("number")));
                    this.setOldValue("entrybsed", changeSet[0], currentRowIndex);
                    this.getModel().beginInit();
                    this.getModel().setValue("insured", (Object)Boolean.FALSE, currentRowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("insured", currentRowIndex);
                    this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"personalcontribution", "companycontribution"});
                    return;
                }
                this.setEntryUpperLowerLimit(newEntryBesd, currentRowIndex);
                this.setEntryBsled(newEntryBesd, currentRowIndex);
                break;
            }
            case "insured": {
                this.insuredPropertyChanged(changeSet[0], sinSurFile);
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "hisChangeSinSurStd": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    DynamicObject sinSurFile = dataEntity.getDynamicObject("sinsurfile");
                    this.createHisEntryData("saveafteraudit");
                    DynamicObject sinsurstd = dataEntity.getDynamicObject("sinsurstd");
                    FileSinSurStdVo originalData = this.getOriginalData();
                    Date entryBsedDate = dataEntity.getDate("bsed");
                    if (sinsurstd != null && originalData.getSinSurStdId().equals(sinsurstd.getLong("id"))) {
                        this.setBsled(originalData.getBsled());
                        return;
                    }
                    Date entryBsledDate = this.genEntryBsledDate(sinSurFile, sinsurstd, entryBsedDate, originalData);
                    this.setBsled(entryBsledDate);
                    break;
                }
                this.getPageCache().put("propertyChange", "false");
                this.getModel().setValue("sinsurstd", (Object)messageBoxClosedEvent.getCustomVaule());
                this.getView().updateView("sinsurstd");
                break;
            }
            case "saveafteraudit": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("callBack", "true");
                operateOption.setVariableValue("originalData", this.getPageCache().get("originalData"));
                this.getView().invokeOperation("saveafteraudit", operateOption);
                break;
            }
            case "deleteSinSurStd": {
                this.deleteSinSurStd(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void setWelfareTypeInsuranceTypeAttrEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> welfareTypeIds = new ArrayList<Long>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            welfareTypeIds.add(dynamicObject.getLong("welfaretypeid"));
        }
        Map welfareTypeInsuranceTypeAttrMap = SinSurFileStdServiceHelper.queryInsuranceTypeAttrSetting(welfareTypeIds, SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.values());
        int index = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            if (dynamicObject.getBoolean("insured")) {
                long welfareTypeId = dynamicObject.getLong("welfaretypeid");
                this.setWelfareTypeInsuranceTypeAttrEnable(true, welfareTypeInsuranceTypeAttrMap, index, welfareTypeId);
            } else {
                for (Map.Entry MapEntry2 : SinSurFileStdServiceHelper.FILED_INSURANCE_TYPE_ATTR_MAP.entrySet()) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{(String)MapEntry2.getKey()});
                }
            }
            ++index;
        }
    }

    private void createAndDrawEntry(DynamicObject[] sinSurBases) {
        DynamicObject fileSinSurStd = this.getModel().getDataEntity();
        DynamicObject sinSurStd = fileSinSurStd.getDynamicObject("sinsurstd");
        DynamicObjectCollection stdentryentity = sinSurStd.getDynamicObjectCollection("stdentryentity");
        DynamicObject sinSurFile = fileSinSurStd.getDynamicObject("sinsurfile");
        Long placeOfWelfareId = SinSurFileStdServiceHelper.queryPlaceOfWelfareId((Long)sinSurFile.getLong("welfarepayer.id"));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter entry = this.getTableValueSetter();
        entry.addField("entryboid", new Object[0]);
        entry.addField("entrypkvalue", new Object[0]);
        Map<Long, DynamicObject> sinSurBaseMap = Arrays.stream(sinSurBases).collect(Collectors.toMap(base -> base.getLong("welfaretype.id"), base -> base, (oldVal, newVal) -> oldVal));
        for (int i = 0; i < stdentryentity.size(); ++i) {
            DynamicObject stdEntity = (DynamicObject)stdentryentity.get(i);
            long insurtypeId = stdEntity.getLong("insurtype.id");
            DynamicObject dynamicObject = sinSurBaseMap.get(insurtypeId);
            if (dynamicObject == null) continue;
            DynamicObject welfareType = dynamicObject.getDynamicObject("welfaretype");
            long welfareTypeId = welfareType.getLong("id");
            Map<Long, Map<Long, String>> welfareTypeInsuranceTypeSystemValueMap = this.getWelfareTypeInsuranceTypeSystemValue(fileSinSurStd.getDynamicObject("sinsurstd"), dynamicObject, welfareTypeId, sinSurFile.getLong("person.id"), placeOfWelfareId);
            Map<String, String> insuranceTypeAttrValueMap = this.getInsuranceTypeAttrValue(dynamicObject);
            entry.addRow(new Object[]{welfareType.getString("name"), welfareTypeId, dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled"), dynamicObject.getBoolean("insured"), HRStringUtils.isEmpty((String)insuranceTypeAttrValueMap.get("personalcontribution")) ? null : insuranceTypeAttrValueMap.get("personalcontribution"), HRStringUtils.isEmpty((String)insuranceTypeAttrValueMap.get("companycontribution")) ? null : insuranceTypeAttrValueMap.get("companycontribution"), dynamicObject.getString("description"), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personalupperlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("personallowerlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companyupperlimit")), welfareTypeInsuranceTypeSystemValueMap.get(welfareTypeId).get(SinSurFileStdServiceHelper.SYSTEM_WELFARE_TYPE_MAP.get("companylowerlimit")), dynamicObject.getLong("boid"), dynamicObject.getPkValue()});
            SinSurFileBaseAddPageAttributeEvent sinSurFileBaseAddPageAttributeEvent = new SinSurFileBaseAddPageAttributeEvent(entry, HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject), i);
            SinSurFileStdServiceHelper.tableValueSetterAddAttribute((SinSurFileBaseAddPageAttributeEvent)sinSurFileBaseAddPageAttributeEvent);
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void cacheOriginalData(DynamicObject[] sinSurBases) {
        DynamicObject fileSinSurStd = this.getModel().getDataEntity();
        FileSinSurStdVo fileSinSurStdVo = new FileSinSurStdVo();
        fileSinSurStdVo.setBsed(fileSinSurStd.getDate("bsed"));
        fileSinSurStdVo.setBsled(fileSinSurStd.getDate("bsled"));
        fileSinSurStdVo.setSinSurFileId(Long.valueOf(fileSinSurStd.getLong("sinsurfile.id")));
        fileSinSurStdVo.setSinSurStdId(Long.valueOf(fileSinSurStd.getLong("sinsurstd.id")));
        HashMap<Long, FileSinSurBaseVo> fileSinSurBaseVos = new HashMap<Long, FileSinSurBaseVo>(16);
        for (DynamicObject sinSurBase : sinSurBases) {
            FileSinSurBaseVo fileSinSurBaseVo = new FileSinSurBaseVo();
            fileSinSurBaseVo.setPkValue(Long.valueOf(sinSurBase.getLong("id")));
            fileSinSurBaseVo.setSinSurStdId(Long.valueOf(sinSurBase.getLong("sinsurstd.id")));
            fileSinSurBaseVo.setBsed(sinSurBase.getDate("bsed"));
            fileSinSurBaseVo.setBsled(sinSurBase.getDate("bsled"));
            fileSinSurBaseVo.setInsured(Boolean.valueOf(sinSurBase.getBoolean("insured")));
            fileSinSurBaseVo.setWelfareTypeId(Long.valueOf(sinSurBase.getLong("welfaretype.id")));
            fileSinSurBaseVo.setFileSinSurStdId(Long.valueOf(sinSurBase.getLong("sinsurfilestd.id")));
            fileSinSurBaseVo.setDescription(sinSurBase.getString("description"));
            fileSinSurBaseVo.setAttribute(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)sinSurBase));
            DynamicObjectCollection dynamicObjectCollection = sinSurBase.getDynamicObjectCollection("entryentity");
            ArrayList<SinSurBaseVo> sinSurBaseVos = new ArrayList<SinSurBaseVo>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                SinSurBaseVo sinSurBaseVo = new SinSurBaseVo();
                sinSurBaseVo.setInsuranceItemId(Long.valueOf(dynamicObject.getLong("insuranceitem.id")));
                sinSurBaseVo.setInsurancePropId(Long.valueOf(dynamicObject.getLong("insuranceprop.id")));
                sinSurBaseVo.setNumValue(dynamicObject.getString("numvalue"));
                sinSurBaseVo.setAttribute(HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject));
                sinSurBaseVos.add(sinSurBaseVo);
            }
            fileSinSurBaseVo.setSinSurBases(sinSurBaseVos);
            fileSinSurBaseVos.put(sinSurBase.getLong("welfaretype.id"), fileSinSurBaseVo);
        }
        fileSinSurStdVo.setFileSinSurBaseVos(fileSinSurBaseVos);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("originalData", SerializationUtils.toJsonString((Object)fileSinSurStdVo));
    }
}

